/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.ActivityTypePlugin;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.activity.ActivityStreamType;
import org.exoplatform.social.core.activity.ActivitySystemTypePlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.mockito.Mockito;

public class ActivityManagerRDBMSTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(ActivityManagerRDBMSTest.class);
    private org.exoplatform.social.core.identity.model.Identity rootIdentity;
    private org.exoplatform.social.core.identity.model.Identity johnIdentity;
    private org.exoplatform.social.core.identity.model.Identity maryIdentity;
    private org.exoplatform.social.core.identity.model.Identity demoIdentity;
    private org.exoplatform.social.core.identity.model.Identity ghostIdentity;
    private org.exoplatform.social.core.identity.model.Identity raulIdentity;
    private org.exoplatform.social.core.identity.model.Identity jameIdentity;
    private org.exoplatform.social.core.identity.model.Identity paulIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restartTransaction();
        CachedIdentityStorage identityStorage = (CachedIdentityStorage)this.getService(IdentityStorage.class);
        ((RDBMSIdentityStorageImpl)identityStorage.getStorage()).setProfileSearchConnector(this.mockProfileSearch);
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
        this.ghostIdentity = this.createIdentity("ghost");
        this.raulIdentity = this.createIdentity("raul");
        this.jameIdentity = this.createIdentity("jame");
        this.paulIdentity = this.createIdentity("paul");
    }

    public void testActivityEditable() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        ExoSocialActivity comment = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)comment.isComment()).thenReturn((Object)true);
        Mockito.when((Object)comment.getType()).thenReturn((Object)"exosocial:spaces");
        Mockito.when((Object)comment.getPosterId()).thenReturn((Object)"1");
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity admin = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)admin.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("2"));
        Mockito.when((Object)admin.getGroups()).thenReturn(new HashSet<String>(Arrays.asList("/platform/administrators")));
        Identity mary = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)mary.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("3"));
        ActivityManagerImpl manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, null);
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityEditable(comment, owner));
        Mockito.when((Object)comment.getType()).thenReturn((Object)"TestActivityType");
        InitParams params = new InitParams();
        ValuesParam param = new ValuesParam();
        param.setName("system.types");
        param.setValues(Collections.singletonList("TestActivityType"));
        params.addParameter((Parameter)param);
        ActivitySystemTypePlugin plugin = new ActivitySystemTypePlugin(params);
        manager.addSystemActivityDefinition(plugin);
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(comment, owner));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(activity, admin));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(activity, mary));
        params = (InitParams)Mockito.mock(InitParams.class);
        Mockito.when((Object)params.containsKey((Object)"exo.manager.edit.comment.enabled")).thenReturn((Object)true);
        Mockito.when((Object)params.containsKey((Object)"exo.edit.comment.enabled")).thenReturn((Object)true);
        ValueParam falseVal = new ValueParam();
        falseVal.setValue("false");
        Mockito.when((Object)params.getValueParam("exo.manager.edit.comment.enabled")).thenReturn((Object)falseVal);
        Mockito.when((Object)params.getValueParam("exo.edit.comment.enabled")).thenReturn((Object)falseVal);
        manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, params);
        Mockito.when((Object)comment.getType()).thenReturn((Object)"exosocial:spaces");
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(comment, admin));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(comment, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(activity, admin));
        Mockito.when((Object)params.containsKey((Object)"exo.manager.edit.activity.enabled")).thenReturn((Object)true);
        Mockito.when((Object)params.containsKey((Object)"exo.edit.activity.enabled")).thenReturn((Object)true);
        Mockito.when((Object)params.getValueParam("exo.manager.edit.activity.enabled")).thenReturn((Object)falseVal);
        Mockito.when((Object)params.getValueParam("exo.edit.activity.enabled")).thenReturn((Object)falseVal);
        manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, params);
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(activity, admin));
    }

    public void testActivityViewable() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        RelationshipManager relationshipManager = (RelationshipManager)Mockito.mock(RelationshipManager.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        ExoSocialActivity comment = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)comment.isComment()).thenReturn((Object)true);
        Mockito.when((Object)comment.getType()).thenReturn((Object)"exosocial:spaces");
        Mockito.when((Object)comment.getPosterId()).thenReturn((Object)"1");
        Mockito.when((Object)identityManager.getIdentity("1")).thenReturn((Object)this.rootIdentity);
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity admin = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)admin.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)this.johnIdentity);
        Mockito.when((Object)admin.getGroups()).thenReturn(Collections.singleton("/platform/administrators"));
        Mockito.when((Object)admin.getMemberships()).thenReturn(Collections.singleton(new MembershipEntry("/platform/administrators")));
        Mockito.when((Object)admin.isMemberOf(acl.getAdminGroups())).thenReturn((Object)true);
        Identity mary = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)mary.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)this.maryIdentity);
        ActivityManagerImpl manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, relationshipManager, acl, null);
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityViewable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityViewable(comment, owner));
        Mockito.when((Object)comment.getType()).thenReturn((Object)"TestActivityType");
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityViewable(comment, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityViewable(activity, admin));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityViewable(activity, mary));
        Mockito.when((Object)relationshipManager.getStatus(this.rootIdentity, this.maryIdentity)).thenReturn((Object)Relationship.Type.CONFIRMED);
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityViewable(activity, mary));
    }

    public void testActivityTypePlugin() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        final String specificActivityType = "SpecificActivityType";
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getType()).thenReturn((Object)specificActivityType);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        Mockito.when((Object)activity.getTitle()).thenReturn((Object)"Activity title");
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        ActivityManagerImpl manager = new ActivityManagerImpl(storage, identityManager, this.spaceService, this.relationshipManager, acl, null);
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityViewable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityDeletable(activity, owner));
        ActivityManagerRDBMSTest.assertEquals((String)"Activity title", (String)manager.getActivityTitle(activity));
        final AtomicBoolean viewwable = new AtomicBoolean(false);
        final AtomicBoolean editable = new AtomicBoolean(false);
        final AtomicBoolean deletable = new AtomicBoolean(false);
        manager.addActivityTypePlugin(new ActivityTypePlugin(this, null){

            public String getActivityType() {
                return specificActivityType;
            }

            public boolean isActivityEditable(ExoSocialActivity activity, Identity userAclIdentity) {
                return editable.get();
            }

            public boolean isActivityDeletable(ExoSocialActivity activity, Identity userAclIdentity) {
                return deletable.get();
            }

            public boolean isActivityViewable(ExoSocialActivity activity, Identity userAclIdentity) {
                return viewwable.get();
            }

            public String getActivityTitle(ExoSocialActivity activity) {
                return "Activity Plugin title";
            }
        });
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityEditable(activity, owner));
        editable.set(true);
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityEditable(activity, owner));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityViewable(activity, owner));
        viewwable.set(true);
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityViewable(activity, owner));
        ActivityManagerRDBMSTest.assertFalse((boolean)manager.isActivityDeletable(activity, owner));
        deletable.set(true);
        ActivityManagerRDBMSTest.assertTrue((boolean)manager.isActivityDeletable(activity, owner));
        ActivityManagerRDBMSTest.assertEquals((String)"Activity Plugin title", (String)manager.getActivityTitle(activity));
    }

    public void testActivityNotificationEnabling() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        RelationshipManager relationshipManager = (RelationshipManager)Mockito.mock(RelationshipManager.class);
        ActivityManagerImpl activityManager = new ActivityManagerImpl(storage, identityManager, this.spaceService, relationshipManager, null, null);
        String activityType = "TestActivityType";
        String activityType2 = "TestActivityType2";
        String activityType3 = "TestActivityType3";
        this.addActivityTypePlugin((ActivityManager)activityManager, activityType, false);
        this.addActivityTypePlugin((ActivityManager)activityManager, activityType2, true);
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isNotificationEnabled(null));
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isNotificationEnabled(null, null));
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, null));
        Mockito.when((Object)activity.getType()).thenReturn((Object)activityType);
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isNotificationEnabled(activity, null));
        Mockito.when((Object)activity.getType()).thenReturn((Object)activityType2);
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, null));
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isNotificationEnabled(activity, "root3"));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, "root2"));
        Mockito.when((Object)activity.getType()).thenReturn((Object)activityType3);
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isNotificationEnabled(activity, null));
        Mockito.when((Object)activity.isHidden()).thenReturn((Object)true);
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isNotificationEnabled(activity, null));
    }

    public void testActivityDeletable() {
        ActivityStorage storage = (ActivityStorage)Mockito.mock(ActivityStorage.class);
        IdentityManager identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        UserACL acl = (UserACL)Mockito.mock(UserACL.class);
        ActivityManagerImpl activityManager = new ActivityManagerImpl(storage, identityManager, spaceService, this.relationshipManager, acl, null);
        Mockito.when((Object)acl.getAdminGroups()).thenReturn((Object)"/platform/administrators");
        Mockito.when((Object)spaceService.isSuperManager((String)Mockito.eq((Object)"john"))).thenReturn((Object)true);
        Mockito.when((Object)spaceService.isSuperManager((String)Mockito.eq((Object)"mary"))).thenReturn((Object)false);
        Mockito.when((Object)spaceService.isSuperManager((String)Mockito.eq((Object)"james"))).thenReturn((Object)false);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)activity.isComment()).thenReturn((Object)false);
        Mockito.when((Object)activity.getPosterId()).thenReturn((Object)"1");
        ActivityStreamImpl activityStream = new ActivityStreamImpl();
        activityStream.setType(ActivityStream.Type.USER);
        activityStream.setPrettyId("demo");
        Mockito.when((Object)activity.getActivityStream()).thenReturn((Object)activityStream);
        ExoSocialActivity comment = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)comment.isComment()).thenReturn((Object)true);
        Mockito.when((Object)comment.getType()).thenReturn((Object)"exosocial:spaces");
        Mockito.when((Object)comment.getPosterId()).thenReturn((Object)"1");
        Identity owner = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)owner.getUserId()).thenReturn((Object)"demo");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("demo")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("1"));
        Identity admin = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)admin.getUserId()).thenReturn((Object)"john");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("john")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("2"));
        Mockito.when((Object)admin.getGroups()).thenReturn(new HashSet<String>(Arrays.asList("/platform/administrators")));
        Identity mary = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)mary.getUserId()).thenReturn((Object)"mary");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("mary")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("3"));
        Identity james = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)james.getUserId()).thenReturn((Object)"james");
        Mockito.when((Object)identityManager.getOrCreateUserIdentity("james")).thenReturn((Object)new org.exoplatform.social.core.identity.model.Identity("4"));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(comment, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isActivityDeletable(comment, mary));
        activityStream.setType(ActivityStream.Type.SPACE);
        activityStream.setPrettyId("demo_space");
        Space space = new Space();
        Mockito.when((Object)spaceService.getSpaceByPrettyName("demo_space")).thenReturn((Object)space);
        Mockito.when((Object)spaceService.canManageSpace(space, "john")).thenReturn((Object)true);
        Mockito.when((Object)spaceService.canManageSpace(space, "mary")).thenReturn((Object)true);
        Mockito.when((Object)spaceService.canManageSpace(space, "james")).thenReturn((Object)false);
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, james));
        HashMap<String, String> templateParams = new HashMap<String, String>();
        Mockito.when((Object)activity.getTemplateParams()).thenReturn(templateParams);
        templateParams.put("removable", "false");
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, james));
        templateParams.put("removable", "true");
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, owner));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, admin));
        ActivityManagerRDBMSTest.assertTrue((boolean)activityManager.isActivityDeletable(activity, mary));
        ActivityManagerRDBMSTest.assertFalse((boolean)activityManager.isActivityDeletable(activity, james));
    }

    public void testSaveActivityNoReturn() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        activity.setTemplateParams(templateParams);
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.isHidden(false);
        activity.isLocked(true);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        Map gotTemplateParams = activity.getTemplateParams();
        ActivityManagerRDBMSTest.assertEquals((String)"value 1", (String)((String)gotTemplateParams.get("key1")));
        ActivityManagerRDBMSTest.assertEquals((String)"value 2", (String)((String)gotTemplateParams.get("key2")));
        ActivityManagerRDBMSTest.assertEquals((String)"value 3", (String)((String)gotTemplateParams.get("key3")));
        ActivityManagerRDBMSTest.assertTrue((boolean)activity.isLocked());
        ActivityManagerRDBMSTest.assertFalse((boolean)activity.isHidden());
    }

    public void testSaveActivityNoReturnNotStreamOwner() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testGetParentActivity() {
        this.populateActivityMass(this.demoIdentity, 1);
        ExoSocialActivity demoActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        ActivityManagerRDBMSTest.assertNotNull((String)"demoActivity must be false", (Object)demoActivity);
        ActivityManagerRDBMSTest.assertNull((Object)this.activityManager.getParentActivity(demoActivity));
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment(demoActivity, (ExoSocialActivity)comment);
        ExoSocialActivity gotComment = ((ExoSocialActivity[])this.activityManager.getCommentsWithListAccess(demoActivity).load(0, 1))[0];
        ActivityManagerRDBMSTest.assertNotNull((String)"gotComment must not be null", (Object)gotComment);
        ExoSocialActivity parentActivity = this.activityManager.getParentActivity(gotComment);
        ActivityManagerRDBMSTest.assertNotNull((Object)parentActivity);
        ActivityManagerRDBMSTest.assertEquals((String)("parentActivity.getId() must return: " + demoActivity.getId()), (String)demoActivity.getId(), (String)parentActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)("parentActivity.getTitle() must return: " + demoActivity.getTitle()), (String)demoActivity.getTitle(), (String)parentActivity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)("parentActivity.getUserId() must return: " + demoActivity.getUserId()), (String)demoActivity.getUserId(), (String)parentActivity.getUserId());
    }

    public void testGetActivitiiesByUser() throws ActivityStorageException {
        String activityTitle = "title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(String.valueOf(activity.getId()));
        ActivityManagerRDBMSTest.assertNotNull((Object)activity);
        ActivityManagerRDBMSTest.assertEquals((String)activityTitle, (String)activity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)userId, (String)activity.getUserId());
        RealtimeListAccess activities = this.activityManager.getActivitiesWithListAccess(this.rootIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])activities.load(0, 10)).length);
        this.LOG.info((Object)"Create 100 activities...");
        for (int i = 0; i < 100; ++i) {
            activity = new ExoSocialActivityImpl();
            activity.setTitle(activityTitle + " " + i);
            activity.setUserId(userId);
            this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        }
        activities = this.activityManager.getActivitiesWithListAccess(this.rootIdentity);
        this.LOG.info((Object)"Loadding 20 activities...");
        ActivityManagerRDBMSTest.assertEquals((int)20, (int)((ExoSocialActivity[])activities.load(0, 20)).length);
        List<ExoSocialActivity> exoActivities = Arrays.asList((ExoSocialActivity[])activities.load(0, activities.getSize()));
        this.LOG.info((Object)"Loadding 101 activities...");
        ActivityManagerRDBMSTest.assertEquals((int)101, (int)exoActivities.size());
    }

    public void testUpdateActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        String newTitle = "new activity title";
        activity.setTitle(newTitle);
        this.activityManager.updateActivity((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getTitle() must return: " + newTitle), (String)newTitle, (String)activity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testDeleteActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testIsActivityExists() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerRDBMSTest.assertTrue((boolean)this.activityManager.isActivityExists(activity.getId()));
        activity = this.activityManager.getActivity(activity.getId());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
        ActivityManagerRDBMSTest.assertFalse((boolean)this.activityManager.isActivityExists(activity.getId()));
    }

    public void testDeleteActivityWithId() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity(activity.getId());
    }

    public void testSaveSubComment() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        String commentTitle = "Comment title";
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerRDBMSTest.assertEquals((String)activity.getId(), (String)comment.getParentId());
        ActivityManagerRDBMSTest.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)comment.getId()));
        ExoSocialActivityImpl subComment = new ExoSocialActivityImpl();
        subComment.setTitle(commentTitle);
        subComment.setUserId(this.maryIdentity.getId());
        subComment.setParentCommentId(comment.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)subComment);
        ActivityManagerRDBMSTest.assertEquals((String)activity.getId(), (String)subComment.getParentId());
        ActivityManagerRDBMSTest.assertEquals((String)comment.getId(), (String)subComment.getParentCommentId());
        ActivityManagerRDBMSTest.assertNotNull((Object)subComment.getId());
        List subComments = this.activityManager.getSubComments((ExoSocialActivity)comment);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)subComments.size());
        ActivityManagerRDBMSTest.assertEquals((String)subComment.getId(), (String)((ExoSocialActivity)subComments.get(0)).getId());
        ExoSocialActivity gotParentActivity = this.activityManager.getParentActivity((ExoSocialActivity)subComment);
        ActivityManagerRDBMSTest.assertNotNull((Object)gotParentActivity);
        ActivityManagerRDBMSTest.assertEquals((String)activity.getId(), (String)gotParentActivity.getId());
        String[] replyToIds = gotParentActivity.getReplyToId();
        ActivityManagerRDBMSTest.assertEquals((int)2, (int)replyToIds.length);
        for (String replyToId : replyToIds) {
            ActivityManagerRDBMSTest.assertTrue((replyToId.equals(comment.getId()) || replyToId.equals(subComment.getId()) ? 1 : 0) != 0);
        }
    }

    public void testGetCommentsWithListAccess() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
            maryComment.setUserId(this.maryIdentity.getId());
            maryComment.setTitle("mary comment");
            this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        }
        RealtimeListAccess maryComments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity);
        ActivityManagerRDBMSTest.assertNotNull((String)"maryComments must not be null", (Object)maryComments);
        ActivityManagerRDBMSTest.assertEquals((String)"maryComments.getSize() must return: 10", (int)total, (int)maryComments.getSize());
    }

    public void testGetCommentsAndSubCommentsWithListAccess() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        int total = 10;
        int totalWithSubComments = total + total * total;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
            maryComment.setUserId(this.maryIdentity.getId());
            maryComment.setTitle("mary comment");
            this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
            for (int j = 0; j < total; ++j) {
                ExoSocialActivityImpl johnComment = new ExoSocialActivityImpl();
                johnComment.setUserId(this.johnIdentity.getId());
                johnComment.setTitle("john comment" + i + j);
                johnComment.setParentCommentId(maryComment.getId());
                this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)johnComment);
            }
        }
        RealtimeListAccess maryComments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity);
        ActivityManagerRDBMSTest.assertNotNull((String)"maryComments must not be null", (Object)maryComments);
        ActivityManagerRDBMSTest.assertEquals((String)"maryComments.getSize() must return: 10", (int)total, (int)maryComments.getSize());
        RealtimeListAccess comments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity, true);
        ActivityManagerRDBMSTest.assertNotNull((String)"comments must not be null", (Object)comments);
        ActivityManagerRDBMSTest.assertEquals((String)"comments.getSize() must return: 10", (int)total, (int)comments.getSize());
        ExoSocialActivity[] commentsArray = (ExoSocialActivity[])comments.load(0, total);
        ActivityManagerRDBMSTest.assertEquals((String)"commentsArray.length must return: 110", (int)totalWithSubComments, (int)commentsArray.length);
        int index = 0;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivity maryComment = commentsArray[index++];
            ActivityManagerRDBMSTest.assertEquals((String)("Title of comment should be 'mary comment', iteration = " + i), (String)"mary comment", (String)maryComment.getTitle());
            for (int j = 0; j < total; ++j) {
                ExoSocialActivity johnComment = commentsArray[index++];
                ActivityManagerRDBMSTest.assertEquals((String)("Title of comment should be 'john comment " + i + j + "'"), (String)("john comment" + i + j), (String)johnComment.getTitle());
            }
        }
    }

    public void testGetCommentsAndSubCommentsWithListAccessDescending() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        int total = 10;
        int totalWithSubComments = total + total * total;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
            maryComment.setUserId(this.maryIdentity.getId());
            maryComment.setTitle("mary comment");
            this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
            for (int j = 0; j < total; ++j) {
                ExoSocialActivityImpl johnComment = new ExoSocialActivityImpl();
                johnComment.setUserId(this.johnIdentity.getId());
                johnComment.setTitle("john comment" + i + j);
                johnComment.setParentCommentId(maryComment.getId());
                this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)johnComment);
            }
        }
        RealtimeListAccess maryComments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity);
        ActivityManagerRDBMSTest.assertNotNull((String)"maryComments must not be null", (Object)maryComments);
        ActivityManagerRDBMSTest.assertEquals((String)"maryComments.getSize() must return: 10", (int)total, (int)maryComments.getSize());
        RealtimeListAccess comments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity, true, true);
        ActivityManagerRDBMSTest.assertNotNull((String)"comments must not be null", (Object)comments);
        ActivityManagerRDBMSTest.assertEquals((String)"comments.getSize() must return: 10", (int)total, (int)comments.getSize());
        ExoSocialActivity[] commentsArray = (ExoSocialActivity[])comments.load(0, total);
        ActivityManagerRDBMSTest.assertEquals((String)"commentsArray.length must return: 110", (int)totalWithSubComments, (int)commentsArray.length);
        int index = 0;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivity maryComment = commentsArray[index++];
            ActivityManagerRDBMSTest.assertEquals((String)("Title of comment should be 'mary comment', iteration = " + (total - i - 1)), (String)"mary comment", (String)maryComment.getTitle());
            for (int j = 0; j < total; ++j) {
                ExoSocialActivity johnComment = commentsArray[index++];
                ActivityManagerRDBMSTest.assertEquals((String)("Title of comment should be 'john comment " + (total - i - 1) + j + "'"), (String)("john comment" + (total - i - 1) + j), (String)johnComment.getTitle());
            }
        }
    }

    public void testSaveLike() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("&\"demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        ActivityManagerRDBMSTest.assertEquals((String)"&amp;&#34;demo activity", (String)demoActivity.getTitle());
    }

    public void testSaveLikeNotChangeTemplateParam() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        ActivityManagerRDBMSTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)likedActivity.getTemplateParams().get("link")));
    }

    public void testDeleteLike() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.maryIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.rootIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
    }

    public void testDeleteLikeNotChangeTemplateParam() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity deleteLikeActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)deleteLikeActivity.getLikeIdentityIds().length);
        ActivityManagerRDBMSTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)deleteLikeActivity.getTemplateParams().get("link")));
    }

    public void testGetActivitiesWithListAccess() throws Exception {
        int total = 10;
        for (int i = 0; i < total; ++i) {
            ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
            demoActivity.setTitle("demo activity");
            demoActivity.setUserId(demoActivity.getId());
            this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        }
        RealtimeListAccess demoListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertNotNull((String)"demoListAccess must not be null", (Object)demoListAccess);
        ActivityManagerRDBMSTest.assertEquals((String)"demoListAccess.getSize() must return: 10", (int)10, (int)demoListAccess.getSize());
    }

    public void testGetActivitiesOfUserSpacesWithListAccess() throws Exception {
        Space space = this.getSpaceInstance(this.spaceService, 0);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        int totalNumber = 10;
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        space = this.spaceService.getSpaceByDisplayName(space.getDisplayName());
        ActivityManagerRDBMSTest.assertNotNull((String)"space must not be null", (Object)space);
        ActivityManagerRDBMSTest.assertEquals((String)"space.getDisplayName() must return: my space 0", (String)"my space 0", (String)space.getDisplayName());
        ActivityManagerRDBMSTest.assertEquals((String)"space.getDescription() must return: add new space 0", (String)"add new space 0", (String)space.getDescription());
        RealtimeListAccess demoActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertNotNull((String)"demoActivities must not be null", (Object)demoActivities);
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivities.getSize() must return: 10", (int)10, (int)demoActivities.getSize());
        Space space2 = this.getSpaceInstance(this.spaceService, 1);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity2 = this.identityManager.getOrCreateIdentity("space", space2.getPrettyName(), false);
        for (int i = 0; i < totalNumber; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("activity title " + i);
            activity.setUserId(this.demoIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity2, (ExoSocialActivity)activity);
        }
        space2 = this.spaceService.getSpaceByDisplayName(space2.getDisplayName());
        ActivityManagerRDBMSTest.assertNotNull((String)"space2 must not be null", (Object)space2);
        ActivityManagerRDBMSTest.assertEquals((String)"space2.getDisplayName() must return: my space 1", (String)"my space 1", (String)space2.getDisplayName());
        ActivityManagerRDBMSTest.assertEquals((String)"space2.getDescription() must return: add new space 1", (String)"add new space 1", (String)space2.getDescription());
        demoActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertNotNull((String)"demoActivities must not be null", (Object)demoActivities);
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivities.getSize() must return: 20", (int)20, (int)demoActivities.getSize());
        demoActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.maryIdentity);
        ActivityManagerRDBMSTest.assertNotNull((String)"demoActivities must not be null", (Object)demoActivities);
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivities.getSize() must return: 0", (int)0, (int)demoActivities.getSize());
    }

    public void testGetActivityFeedWithListAccess() throws Exception {
        this.populateActivityMass(this.demoIdentity, 3);
        this.populateActivityMass(this.maryIdentity, 3);
        this.populateActivityMass(this.johnIdentity, 2);
        Space space = this.getSpaceInstance(this.spaceService, 0);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        this.populateActivityMass(spaceIdentity, 5);
        RealtimeListAccess demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivityFeed.getSize() must be 8", (int)8, (int)demoActivityFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)8, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        Relationship demoMaryConnection = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)8, (int)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).getSize());
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        this.populateActivityMass(this.demoIdentity, 1);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((String)"demoActivityFeed.getSize() must return 12", (int)12, (int)demoActivityFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)12, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 15)).length);
        ActivityManagerRDBMSTest.assertEquals((int)7, (int)((ExoSocialActivity[])demoActivityFeed.load(5, 15)).length);
        RealtimeListAccess maryActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerRDBMSTest.assertEquals((String)"maryActivityFeed.getSize() must return 7", (int)7, (int)maryActivityFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)7, (int)((ExoSocialActivity[])maryActivityFeed.load(0, 10)).length);
        this.createActivityToOtherIdentity(this.demoIdentity, spaceIdentity, 5);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)17, (int)demoActivityFeed.getSize());
        RealtimeListAccess demoActivitiesSpaceFeed = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)10, (int)demoActivitiesSpaceFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)10, (int)((ExoSocialActivity[])demoActivitiesSpaceFeed.load(0, 10)).length);
        maryActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)7, (int)maryActivityFeed.getSize());
        RealtimeListAccess johnSpaceActivitiesFeed = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((String)"johnSpaceActivitiesFeed.getSize() must return 10", (int)10, (int)johnSpaceActivitiesFeed.getSize());
        this.relationshipManager.delete(demoMaryConnection);
        this.spaceService.deleteSpace(space);
    }

    public void testGetActivityByStreamTypeWithListAccess() throws Exception {
        this.populateActivityMass(this.demoIdentity, 1);
        this.populateActivityMass(this.maryIdentity, 2);
        this.populateActivityMass(this.johnIdentity, 3);
        Space space = this.getSpaceInstance(this.spaceService, 1);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.populateActivityMass(spaceIdentity, 4);
        Space space1 = this.getSpaceInstance(this.spaceService, 2);
        org.exoplatform.social.core.identity.model.Identity space1Identity = this.identityManager.getOrCreateSpaceIdentity(space1.getPrettyName());
        this.populateActivityMass(space1Identity, 3);
        FavoriteService favoriteService = (FavoriteService)ExoContainerContext.getService(FavoriteService.class);
        Favorite favoriteSpace = new Favorite("space", space.getId(), null, Long.parseLong(this.demoIdentity.getId()));
        favoriteService.createFavorite(favoriteSpace);
        Favorite favoriteActivity = new Favorite("activity", "1", null, Long.parseLong(this.demoIdentity.getId()));
        favoriteService.createFavorite(favoriteActivity);
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.USER_STREAM);
        RealtimeListAccess streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])streamTypeActivities.load(0, 10)).length);
        activityFilter.setStreamType(ActivityStreamType.USER_FAVORITE_STREAM);
        streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)streamTypeActivities.getSize());
        activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.MANAGE_SPACES_STREAM);
        streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerRDBMSTest.assertEquals((int)7, (int)((ExoSocialActivity[])streamTypeActivities.load(0, 10)).length);
        activityFilter = new ActivityFilter();
        activityFilter.setStreamType(ActivityStreamType.FAVORITE_SPACES_STREAM);
        streamTypeActivities = this.activityManager.getActivitiesByFilterWithListAccess(this.demoIdentity, activityFilter);
        ActivityManagerRDBMSTest.assertEquals((int)4, (int)((ExoSocialActivity[])streamTypeActivities.load(0, 10)).length);
    }

    public void testLoadMoreActivities() throws Exception {
        this.populateActivityMass(this.demoIdentity, 30);
        RealtimeListAccess demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)30, (int)demoActivityFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)10, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        ActivityManagerRDBMSTest.assertEquals((int)20, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 20)).length);
        ActivityManagerRDBMSTest.assertEquals((int)10, (int)((ExoSocialActivity[])demoActivityFeed.load(20, 10)).length);
        ActivityManagerRDBMSTest.assertEquals((int)15, (int)((ExoSocialActivity[])demoActivityFeed.load(15, 20)).length);
    }

    public void testGetComments() throws ActivityStorageException {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("blah blah");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ArrayList<ExoSocialActivityImpl> comments = new ArrayList<ExoSocialActivityImpl>();
        for (int i = 0; i < 3; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
            ActivityManagerRDBMSTest.assertNotNull((String)"comment.getId() must not be null", (Object)comment.getId());
            comments.add(comment);
        }
        this.restartTransaction();
        RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)activity);
        ActivityManagerRDBMSTest.assertEquals((int)3, (int)listAccess.getSize());
        List listComments = listAccess.loadAsList(0, 5);
        ActivityManagerRDBMSTest.assertEquals((int)3, (int)listComments.size());
        ActivityManagerRDBMSTest.assertEquals((String)"comment 0", (String)((ExoSocialActivity)listComments.get(0)).getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)"comment 1", (String)((ExoSocialActivity)listComments.get(1)).getTitle());
        ActivityManagerRDBMSTest.assertEquals((String)"comment 2", (String)((ExoSocialActivity)listComments.get(2)).getTitle());
        ExoSocialActivity assertActivity = this.activityManager.getActivity(activity.getId());
        String[] commentIds = assertActivity.getReplyToId();
        for (int i = 1; i < commentIds.length; ++i) {
            ActivityManagerRDBMSTest.assertEquals((String)((ExoSocialActivity)comments.get(i - 1)).getId(), (String)commentIds[i - 1]);
        }
    }

    public void testGetActivitiesOfConnections() throws Exception {
        this.populateActivityMass(this.johnIdentity, 10);
        RealtimeListAccess demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 20)).length);
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)demoConnectionActivities.getSize());
        Relationship demoJohnRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.demoIdentity);
        this.populateActivityMass(this.johnIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)11, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 20)).length);
        ActivityManagerRDBMSTest.assertEquals((int)11, (int)demoConnectionActivities.getSize());
        this.populateActivityMass(this.maryIdentity, 10);
        Relationship demoMaryRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.maryIdentity, this.demoIdentity);
        this.populateActivityMass(this.maryIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)22, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 30)).length);
        ActivityManagerRDBMSTest.assertEquals((int)22, (int)demoConnectionActivities.getSize());
    }

    public void testGetActivitiesOfConnectionswithOffsetLimit() throws Exception {
        this.populateActivityMass(this.johnIdentity, 10);
        RealtimeListAccess demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertNotNull((String)"demoConnectionActivities must not be null", (Object)demoConnectionActivities.load(0, 20));
        ActivityManagerRDBMSTest.assertEquals((String)"demoConnectionActivities.size() must return: 0", (int)0, (int)demoConnectionActivities.getSize());
        Relationship demoJohnRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.johnIdentity);
        this.populateActivityMass(this.johnIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)11, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 20)).length);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((String)"demoConnectionActivities.size() must return: 11", (int)11, (int)demoConnectionActivities.getSize());
        this.populateActivityMass(this.maryIdentity, 10);
        Relationship demoMaryRelationship = this.relationshipManager.inviteToConnect(this.demoIdentity, this.maryIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.maryIdentity);
        this.populateActivityMass(this.maryIdentity, 1);
        demoConnectionActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)22, (int)((ExoSocialActivity[])demoConnectionActivities.load(0, 30)).length);
        ActivityManagerRDBMSTest.assertEquals((String)"demoConnectionActivities.size() must return: 22", (int)22, (int)demoConnectionActivities.getSize());
        this.relationshipManager.delete(demoJohnRelationship);
        this.relationshipManager.delete(demoMaryRelationship);
    }

    public void testRemoveLikeSubComment() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("demo comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
        commentReply.setTitle("mary comment reply");
        commentReply.setUserId(this.maryIdentity.getId());
        commentReply.setParentCommentId(comment.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)commentReply);
        RealtimeListAccess demoActivities = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        RealtimeListAccess maryActivities = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        maryActivities = this.activityManager.getActivitiesWithListAccess(this.maryIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        RealtimeListAccess johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)johnActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        this.activityManager.saveLike((ExoSocialActivity)commentReply, this.johnIdentity);
        johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        this.activityManager.deleteLike((ExoSocialActivity)commentReply, this.johnIdentity);
        johnActivities = this.activityManager.getActivitiesWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)johnActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
    }

    public void testGetActivitiesCount() throws Exception {
        int count = this.activityManager.getActivitiesWithListAccess(this.rootIdentity).getSize();
        ActivityManagerRDBMSTest.assertEquals((String)"count must be: 0", (int)0, (int)count);
        this.populateActivityMass(this.rootIdentity, 30);
        count = this.activityManager.getActivitiesWithListAccess(this.rootIdentity).getSize();
        ActivityManagerRDBMSTest.assertEquals((String)"count must be: 30", (int)30, (int)count);
    }

    public void testSaveManyComments() throws Exception {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl comment1 = new ExoSocialActivityImpl();
        comment1.setTitle("john comment 1");
        comment1.setUserId(this.johnIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)comment1);
        RealtimeListAccess listAccess = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)listAccess.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])listAccess.load(0, 10)).length);
        ExoSocialActivityImpl comment2 = new ExoSocialActivityImpl();
        comment2.setTitle("john comment 2");
        comment2.setUserId(this.johnIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)comment2);
        listAccess = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)listAccess.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])listAccess.load(0, 10)).length);
    }

    public void testGetLastIdenties() throws Exception {
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(this.paulIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId(), this.jameIdentity.getId(), this.raulIdentity.getId(), this.ghostIdentity.getId(), this.demoIdentity.getId()));
        List lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)lastIds.size());
        org.exoplatform.social.core.identity.model.Identity id1 = (org.exoplatform.social.core.identity.model.Identity)lastIds.get(0);
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)id1, lastIds.get(0));
        lastIds = this.identityManager.getLastIdentities(5);
        ActivityManagerRDBMSTest.assertEquals((int)5, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)id1, lastIds.get(0));
        OrganizationService os = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        User user1 = os.getUserHandler().createUserInstance("newId1");
        os.getUserHandler().createUser(user1, false);
        org.exoplatform.social.core.identity.model.Identity newId1 = this.identityManager.getOrCreateIdentity("organization", "newId1", false);
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(newId1.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId()));
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)newId1, lastIds.get(0));
        this.identityManager.deleteIdentity(newId1);
        ActivityManagerRDBMSTest.assertTrue((boolean)this.identityManager.getIdentity(newId1.getId(), false).isDeleted());
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)id1, lastIds.get(0));
        User user2 = os.getUserHandler().createUserInstance("newId2");
        os.getUserHandler().createUser(user2, false);
        org.exoplatform.social.core.identity.model.Identity newId2 = this.identityManager.getOrCreateIdentity("organization", "newId2", true);
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(newId2.getId(), this.paulIdentity.getId(), this.jameIdentity.getId(), this.raulIdentity.getId(), this.ghostIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId(), this.jameIdentity.getId(), this.raulIdentity.getId(), this.ghostIdentity.getId(), this.demoIdentity.getId()));
        lastIds = this.identityManager.getLastIdentities(5);
        ActivityManagerRDBMSTest.assertEquals((int)5, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)newId2, lastIds.get(0));
        this.identityManager.deleteIdentity(newId2);
        ActivityManagerRDBMSTest.assertTrue((boolean)this.identityManager.getIdentity(newId2.getId(), true).isDeleted());
        lastIds = this.identityManager.getLastIdentities(5);
        ActivityManagerRDBMSTest.assertEquals((int)5, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)id1, lastIds.get(0));
        newId1 = this.identityManager.getOrCreateIdentity("organization", "newId1", false);
        newId2 = this.identityManager.getOrCreateIdentity("organization", "newId2", true);
        Mockito.when((Object)this.mockProfileSearch.search((org.exoplatform.social.core.identity.model.Identity)Mockito.nullable(org.exoplatform.social.core.identity.model.Identity.class), (ProfileFilter)Mockito.nullable(ProfileFilter.class), (Relationship.Type)Mockito.nullable(Relationship.Type.class), Mockito.anyLong(), Mockito.anyLong())).thenReturn(Arrays.asList(newId2.getId())).thenReturn(Arrays.asList(newId2.getId(), newId1.getId())).thenReturn(Arrays.asList(newId2.getId())).thenReturn(Arrays.asList(newId2.getId(), this.paulIdentity.getId())).thenReturn(Arrays.asList(this.paulIdentity.getId()));
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)newId2, lastIds.get(0));
        lastIds = this.identityManager.getLastIdentities(2);
        ActivityManagerRDBMSTest.assertEquals((int)2, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)newId2, lastIds.get(0));
        ActivityManagerRDBMSTest.assertEquals((Object)newId1, lastIds.get(1));
        this.identityManager.deleteIdentity(newId1);
        os.getUserHandler().removeUser("newId1", false);
        ActivityManagerRDBMSTest.assertTrue((boolean)this.identityManager.getIdentity(newId1.getId(), true).isDeleted());
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)newId2, lastIds.get(0));
        lastIds = this.identityManager.getLastIdentities(2);
        ActivityManagerRDBMSTest.assertEquals((int)2, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)newId2, lastIds.get(0));
        ActivityManagerRDBMSTest.assertFalse((boolean)newId1.equals(lastIds.get(1)));
        this.identityManager.deleteIdentity(newId2);
        os.getUserHandler().removeUser("newId2", false);
        ActivityManagerRDBMSTest.assertTrue((boolean)this.identityManager.getIdentity(newId2.getId(), false).isDeleted());
        lastIds = this.identityManager.getLastIdentities(1);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)lastIds.size());
        ActivityManagerRDBMSTest.assertEquals((Object)id1, lastIds.get(0));
    }

    public void testMentionActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivity got = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)got.getMentionedIds().length);
        RealtimeListAccess demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)demoActivityFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("mary mention @demo @john");
        comment.setUserId(this.maryIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)2, (int)got.getMentionedIds().length);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)demoActivityFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
        this.activityManager.deleteComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)got.getMentionedIds().length);
        demoActivityFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)demoActivityFeed.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)((ExoSocialActivity[])demoActivityFeed.load(0, 10)).length);
    }

    public void testSpaceRoleMention() throws Exception {
        Space space = this.getSpaceInstance(this.spaceService, 0);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.restartTransaction();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @member:" + spaceIdentity.getId());
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        ExoSocialActivity got = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)space.getMembers().length, (int)got.getMentionedIds().length);
        ActivityManagerRDBMSTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"member"));
        ActivityManagerRDBMSTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@member"));
        activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @manager:" + spaceIdentity.getId());
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)space.getManagers().length, (int)got.getMentionedIds().length);
        ActivityManagerRDBMSTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"manager"));
        ActivityManagerRDBMSTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@manager"));
        activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @publisher:" + spaceIdentity.getId());
        activity.setUserId(this.maryIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)space.getPublishers().length, (int)got.getMentionedIds().length);
        ActivityManagerRDBMSTest.assertEquals((String)this.demoIdentity.getId(), (String)got.getMentionedIds()[0]);
        ActivityManagerRDBMSTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"publisher"));
        ActivityManagerRDBMSTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@publisher"));
        this.spaceService.addRedactor(space, "john");
        activity = new ExoSocialActivityImpl();
        activity.setTitle("hello @redactor:" + spaceIdentity.getId());
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        got = this.activityManager.getActivity(activity.getId());
        ActivityManagerRDBMSTest.assertEquals((int)space.getRedactors().length, (int)got.getMentionedIds().length);
        ActivityManagerRDBMSTest.assertEquals((String)this.johnIdentity.getId(), (String)got.getMentionedIds()[0]);
        ActivityManagerRDBMSTest.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"redactor"));
        ActivityManagerRDBMSTest.assertFalse((boolean)StringUtils.containsIgnoreCase((CharSequence)got.getTitle(), (CharSequence)"@redactor"));
    }

    public void testLikeCommentActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("demo comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        RealtimeListAccess demoActivities = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        this.activityManager.saveLike((ExoSocialActivity)comment, this.johnIdentity);
        RealtimeListAccess johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        johnActivities = this.activityManager.getActivitiesWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
    }

    public void testLikeSubCommentActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("hello");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("demo comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
        commentReply.setTitle("mary comment reply");
        commentReply.setUserId(this.maryIdentity.getId());
        commentReply.setParentCommentId(comment.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)commentReply);
        RealtimeListAccess demoActivities = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        RealtimeListAccess maryActivities = this.activityManager.getActivityFeedWithListAccess(this.maryIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)demoActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])demoActivities.load(0, 10)).length);
        maryActivities = this.activityManager.getActivitiesWithListAccess(this.maryIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)maryActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])maryActivities.load(0, 10)).length);
        RealtimeListAccess johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)johnActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)0, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
        this.activityManager.saveLike((ExoSocialActivity)commentReply, this.johnIdentity);
        johnActivities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)johnActivities.getSize());
        ActivityManagerRDBMSTest.assertEquals((int)1, (int)((ExoSocialActivity[])johnActivities.load(0, 10)).length);
    }

    private void populateActivityMass(org.exoplatform.social.core.identity.model.Identity user, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setUserId(user.getId());
            try {
                this.activityManager.saveActivityNoReturn(user, (ExoSocialActivity)activity);
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)"can not save activity.", (Throwable)e);
            }
        }
    }

    private void createActivityToOtherIdentity(org.exoplatform.social.core.identity.model.Identity posterIdentity, org.exoplatform.social.core.identity.model.Identity targetIdentity, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setUserId(posterIdentity.getId());
            try {
                this.activityManager.saveActivityNoReturn(targetIdentity, (ExoSocialActivity)activity);
                continue;
            }
            catch (Exception e) {
                this.LOG.error((Object)"can not save activity.", (Throwable)e);
            }
        }
    }

    private Space getSpaceInstance(SpaceService spaceService, int number) throws Exception {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{"demo", "john"};
        String[] members = new String[]{"raul", "ghost", "demo", "john"};
        String[] publishers = new String[]{"demo"};
        String[] redactors = new String[]{"john"};
        String[] invitedUsers = new String[]{"mary", "paul"};
        String[] pendingUsers = new String[]{"jame"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setRedactors(redactors);
        space.setPublishers(publishers);
        spaceService.saveSpace(space, true);
        return space;
    }

    private void addActivityTypePlugin(ActivityManager activityManager, String activityType, boolean enabled) {
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("type");
        param.setValue(activityType);
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("enableNotification");
        param.setValue(String.valueOf(enabled));
        params.addParameter((Parameter)param);
        activityManager.addActivityTypePlugin(new ActivityTypePlugin(this, params){

            public boolean isEnableNotification(ExoSocialActivity activity, String username) {
                return !StringUtils.equals((CharSequence)username, (CharSequence)"root3") && super.isEnableNotification();
            }
        });
    }
}

