/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.activity.ActivityStreamType;
import org.exoplatform.social.core.activity.ActivitySystemTypePlugin;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class ActivityManagerTest
extends AbstractCoreTest {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerTest.class);
    private List<ExoSocialActivity> tearDownActivityList;
    private List<Space> tearDownSpaceList;
    private org.exoplatform.social.core.identity.model.Identity rootIdentity;
    private org.exoplatform.social.core.identity.model.Identity johnIdentity;
    private org.exoplatform.social.core.identity.model.Identity maryIdentity;
    private org.exoplatform.social.core.identity.model.Identity demoIdentity;
    private org.exoplatform.social.core.identity.model.Identity ghostIdentity;
    private org.exoplatform.social.core.identity.model.Identity raulIdentity;
    private org.exoplatform.social.core.identity.model.Identity jamesIdentity;
    private org.exoplatform.social.core.identity.model.Identity paulIdentity;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private ActivityStorage activityStorage;
    private SpaceService spaceService;
    private UserACL userACL;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.activityStorage = (ActivityStorage)this.getContainer().getComponentInstanceOfType(ActivityStorage.class);
        this.userACL = (UserACL)this.getContainer().getComponentInstanceOfType(UserACL.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.tearDownSpaceList = new ArrayList<Space>();
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary");
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo");
        this.ghostIdentity = this.identityManager.getOrCreateIdentity("organization", "ghost");
        this.raulIdentity = this.identityManager.getOrCreateIdentity("organization", "raul");
        this.jamesIdentity = this.identityManager.getOrCreateIdentity("organization", "james");
        this.paulIdentity = this.identityManager.getOrCreateIdentity("organization", "paul");
        PropertyManager.setProperty((String)"exo.activity-type.cs-calendar:spaces.enabled", (String)"false");
        PropertyManager.setProperty((String)"exo.activity-type.MY_ACTIVITY.enabled", (String)"false");
        ((ActivityManagerImpl)this.activityManager).initActivityTypes();
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        this.begin();
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            try {
                this.activityManager.deleteActivity(activity.getId());
            }
            catch (Exception e) {
                LOG.warn((Object)("can not delete activity with id: " + activity.getId()));
            }
        }
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.identityManager.deleteIdentity(this.demoIdentity);
        this.identityManager.deleteIdentity(this.ghostIdentity);
        this.identityManager.deleteIdentity(this.jamesIdentity);
        this.identityManager.deleteIdentity(this.raulIdentity);
        this.identityManager.deleteIdentity(this.paulIdentity);
        for (Space space : this.tearDownSpaceList) {
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityManager.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        super.tearDown();
    }

    public void testSaveActivityNoReturn() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        LinkedHashMap<String, String> templateParams = new LinkedHashMap<String, String>();
        templateParams.put("key1", "value 1");
        templateParams.put("key2", "value 2");
        templateParams.put("key3", "value 3");
        activity.setTemplateParams(templateParams);
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.isHidden(false);
        activity.isLocked(true);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        Map gotTemplateParams = activity.getTemplateParams();
        ArrayList values = new ArrayList(gotTemplateParams.values());
        ActivityManagerTest.assertEquals((String)"value 1", (String)((String)values.get(0)));
        ActivityManagerTest.assertEquals((String)"value 2", (String)((String)values.get(1)));
        ActivityManagerTest.assertEquals((String)"value 3", (String)((String)values.get(2)));
        ActivityManagerTest.assertTrue((boolean)activity.isLocked());
        ActivityManagerTest.assertFalse((boolean)activity.isHidden());
    }

    public void testSaveActivityNoReturnNotStreamOwner() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testShouldNotEditActivityWhenHasJoinedComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        ExoSocialActivity comment = this.createComment(activity, "exosocial:spaces", "has_joined");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertFalse((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testShouldNotEditActivityWhenSpaceDescriptionEditedComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        ExoSocialActivity comment = this.createComment(activity, "exosocial:spaces", "space_description_edited");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertFalse((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testShouldEditActivityWhenPostComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        ExoSocialActivity comment = this.createComment(activity, "exosocial:spaces", "text comment");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertTrue((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testShouldNotEditActivityWhenWikiSpacePostedComment() throws Exception {
        Identity identity = new Identity("root");
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivity activity = this.createActivity();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(activity);
        activity = this.activityManager.getActivity(activity.getId());
        InitParams params = new InitParams();
        ValuesParam param = new ValuesParam();
        param.setName("system.types");
        param.setValues(Collections.singletonList("ks-wiki:spaces"));
        params.addParameter((Parameter)param);
        ActivitySystemTypePlugin plugin = new ActivitySystemTypePlugin(params);
        this.activityManager.addSystemActivityDefinition(plugin);
        ExoSocialActivity comment = this.createComment(activity, "ks-wiki:spaces", "text comment");
        boolean isEditable = this.activityManager.isActivityEditable(comment, identity);
        ActivityManagerTest.assertFalse((boolean)isEditable);
        this.activityManager.deleteComment(activity, comment);
        this.activityManager.deleteActivity(activity);
    }

    public void testCanPostOnStream() throws Exception {
        Identity rootACLIdentity = new Identity("root");
        Identity johnACLIdentity = new Identity("john", Collections.singleton(new MembershipEntry("/platform/administrators", "*")));
        Identity demoACLIdentity = new Identity("demo");
        Identity jamesACLIdentity = new Identity("james");
        Identity maryACLIdentity = new Identity("mary");
        ConversationState.setCurrent((ConversationState)new ConversationState(demoACLIdentity));
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("userStreamComposer.enabled");
        params.addParameter((Parameter)param);
        param.setValue("false");
        ActivityManagerImpl activityManager = new ActivityManagerImpl(this.activityStorage, this.identityManager, this.spaceService, this.userACL, params);
        ActivityManagerTest.assertFalse((boolean)activityManager.isEnableUserComposer());
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(demoACLIdentity, this.demoIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(rootACLIdentity, this.rootIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(rootACLIdentity, this.demoIdentity));
        param.setValue("true");
        activityManager = new ActivityManagerImpl(this.activityStorage, this.identityManager, this.spaceService, this.userACL, params);
        ActivityManagerTest.assertTrue((boolean)activityManager.isEnableUserComposer());
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(demoACLIdentity, this.demoIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(rootACLIdentity, this.demoIdentity));
        Space space = this.createSpace("spaceTest", "demo", new String[0]);
        space.setMembers(new String[]{"demo", "james"});
        this.spaceService.updateSpace(space);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = new org.exoplatform.social.core.identity.model.Identity("space", space.getPrettyName());
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(rootACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(johnACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(demoACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(jamesACLIdentity, spaceIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(maryACLIdentity, spaceIdentity));
        space.setMembers(new String[]{"demo", "james", "mary"});
        space.setRedactors(new String[]{"james"});
        this.spaceService.updateSpace(space);
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(rootACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(johnACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(demoACLIdentity, spaceIdentity));
        ActivityManagerTest.assertTrue((boolean)activityManager.canPostActivityInStream(jamesACLIdentity, spaceIdentity));
        ActivityManagerTest.assertFalse((boolean)activityManager.canPostActivityInStream(maryACLIdentity, spaceIdentity));
    }

    public void testShareActivity() throws Exception {
        Space originalSpace = this.createSpace("OriginalSpace", "john", "john", "demo");
        ExoSocialActivityImpl originalActivity = new ExoSocialActivityImpl();
        originalActivity.setTitle("Test original Activity");
        originalActivity.setUserId(this.johnIdentity.getId());
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(originalSpace.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)originalActivity);
        originalActivity = this.activityManager.getActivity(originalActivity.getId());
        ActivityManagerTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)originalActivity.getShareActions()));
        Space targetSpace = this.createSpace("TargetSpace", "james", "demo");
        String shareMessage = "share Message";
        String type = "sharedActivityTest";
        Identity johnSecurityIdentity = new Identity("john");
        Identity demoSecurityIdentity = new Identity("demo");
        Identity jamesSecurityIdentity = new Identity("james");
        Identity marySecurityIdentity = new Identity("mary");
        ExoSocialActivityImpl shareActivityTemplate = new ExoSocialActivityImpl();
        shareActivityTemplate.setTitle(shareMessage);
        shareActivityTemplate.setType(type);
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), marySecurityIdentity);
            ActivityManagerTest.fail((String)"Mary is not member of target space");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, "25556", Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Activity id shouldn't be found");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), jamesSecurityIdentity);
            ActivityManagerTest.fail((String)"James shouldn't be able to access original activity");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList("5496632"), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Fake space pretty name shouldn't be found");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList("5496632"), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Fake space pretty name shouldn't be found");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, null, Arrays.asList("5496632"), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Activity id should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), new ArrayList(), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Spaces should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList("5496632"), null);
            ActivityManagerTest.fail((String)"User identity is mandatory");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        originalActivity = this.activityManager.getActivity(originalActivity.getId());
        ActivityManagerTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)originalActivity.getShareActions()));
        List sharedActivities = this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
        ActivityManagerTest.assertNotNull((Object)sharedActivities);
        ActivityManagerTest.assertEquals((int)1, (int)sharedActivities.size());
        ExoSocialActivity sharedactivity = (ExoSocialActivity)sharedActivities.get(0);
        ActivityManagerTest.assertNotNull((Object)sharedactivity);
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getId());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)type, (String)sharedactivity.getType());
        ActivityManagerTest.assertEquals((String)shareMessage, (String)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)targetSpace.getPrettyName(), (String)sharedactivity.getStreamOwner());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTemplateParams());
        ActivityManagerTest.assertEquals((String)originalActivity.getId(), (String)((String)sharedactivity.getTemplateParams().get("originalActivityId")));
        sharedactivity = this.activityManager.getActivity(sharedactivity.getId());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)type, (String)sharedactivity.getType());
        ActivityManagerTest.assertEquals((String)shareMessage, (String)sharedactivity.getTitle());
        ActivityManagerTest.assertEquals((String)targetSpace.getPrettyName(), (String)sharedactivity.getStreamOwner());
        ActivityManagerTest.assertNotNull((Object)sharedactivity.getTemplateParams());
        ActivityManagerTest.assertEquals((String)originalActivity.getId(), (String)((String)sharedactivity.getTemplateParams().get("originalActivityId")));
        originalActivity = this.activityManager.getActivity(originalActivity.getId());
        Set shareActions = originalActivity.getShareActions();
        ActivityManagerTest.assertTrue((boolean)CollectionUtils.isNotEmpty((Collection)shareActions));
        ActivityManagerTest.assertEquals((int)1, (int)shareActions.size());
        ActivityShareAction shareAction = (ActivityShareAction)shareActions.iterator().next();
        ActivityManagerTest.assertEquals((String)originalActivity.getId(), (String)String.valueOf(shareAction.getActivityId()));
        ActivityManagerTest.assertEquals((String)this.demoIdentity.getId(), (String)String.valueOf(shareAction.getUserIdentityId()));
        ActivityManagerTest.assertEquals((String)shareMessage, (String)String.valueOf(shareAction.getMessage()));
        ActivityManagerTest.assertNotNull((Object)shareAction.getSharedActivityIds());
        ActivityManagerTest.assertEquals((int)1, (int)shareAction.getSharedActivityIds().size());
        ActivityManagerTest.assertEquals((String)sharedactivity.getId(), (String)String.valueOf(shareAction.getSharedActivityIds().iterator().next()));
        ActivityManagerTest.assertNotNull((Object)shareAction.getSpaceIds());
        ActivityManagerTest.assertEquals((int)1, (int)shareAction.getSpaceIds().size());
        ActivityManagerTest.assertEquals((String)targetSpace.getId(), (String)String.valueOf(shareAction.getSpaceIds().iterator().next()));
        sharedActivities = this.activityManager.shareActivity(null, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
        ActivityManagerTest.assertNotNull((Object)sharedActivities);
        ActivityManagerTest.assertEquals((int)1, (int)sharedActivities.size());
        targetSpace.setRedactors(new String[]{"james"});
        this.spaceService.updateSpace(targetSpace);
        try {
            this.activityManager.shareActivity((ExoSocialActivity)shareActivityTemplate, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
            ActivityManagerTest.fail((String)"Demo is not redactor of target space anymore");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        targetSpace.setRedactors(new String[]{"james", "demo"});
        this.spaceService.updateSpace(targetSpace);
        sharedActivities = this.activityManager.shareActivity(null, originalActivity.getId(), Arrays.asList(targetSpace.getPrettyName()), demoSecurityIdentity);
        ActivityManagerTest.assertNotNull((Object)sharedActivities);
        ActivityManagerTest.assertEquals((int)1, (int)sharedActivities.size());
    }

    public void testGetActivity() {
        String activityTitle = "title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testGetParentActivity() {
        this.populateActivityMass(this.demoIdentity, 1);
        RealtimeListAccess activitiesWithListAccess = this.activityManager.getActivitiesWithListAccess(this.demoIdentity);
        ActivityManagerTest.assertNotNull((Object)activitiesWithListAccess);
        ActivityManagerTest.assertTrue((activitiesWithListAccess.getSize() > 0 ? 1 : 0) != 0);
        ExoSocialActivity demoActivity = ((ExoSocialActivity[])activitiesWithListAccess.load(0, 1))[0];
        ActivityManagerTest.assertNotNull((String)"demoActivity must be false", (Object)demoActivity);
        ActivityManagerTest.assertNull((Object)this.activityManager.getParentActivity(demoActivity));
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle("comment");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment(demoActivity, (ExoSocialActivity)comment);
        ExoSocialActivity gotComment = ((ExoSocialActivity[])this.activityManager.getCommentsWithListAccess(demoActivity).load(0, 1))[0];
        ActivityManagerTest.assertNotNull((String)"gotComment must not be null", (Object)gotComment);
        ExoSocialActivity parentActivity = this.activityManager.getParentActivity(gotComment);
        ActivityManagerTest.assertNotNull((String)"parentActivity must not be null", (Object)parentActivity);
        ActivityManagerTest.assertEquals((String)("parentActivity.getId() must return: " + demoActivity.getId()), (String)demoActivity.getId(), (String)parentActivity.getId());
        ActivityManagerTest.assertEquals((String)("parentActivity.getTitle() must return: " + demoActivity.getTitle()), (String)demoActivity.getTitle(), (String)parentActivity.getTitle());
        ActivityManagerTest.assertEquals((String)("parentActivity.getUserId() must return: " + demoActivity.getUserId()), (String)demoActivity.getUserId(), (String)parentActivity.getUserId());
    }

    public void testUpdateActivity() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        String newTitle = "new activity title";
        activity.setTitle(newTitle);
        this.activityManager.updateActivity((ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + newTitle), (String)newTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
    }

    public void testDeleteActivity() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testDeleteActivityWithId() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        ActivityManagerTest.assertEquals((String)("activity.getTitle() must return: " + activityTitle), (String)activityTitle, (String)activity.getTitle());
        ActivityManagerTest.assertEquals((String)("activity.getUserId() must return: " + userId), (String)userId, (String)activity.getUserId());
        this.activityManager.deleteActivity(activity.getId());
    }

    public void testHideActivity() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"activity must not be null", (Object)activity);
        RealtimeListAccess activities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)1, (int)activities.getSize());
        this.activityManager.hideActivity(activity.getId());
        activities = this.activityManager.getActivityFeedWithListAccess(this.johnIdentity);
        ActivityManagerTest.assertEquals((int)0, (int)activities.getSize());
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((String)"Should be able to access activity even when hidden", (Object)activity);
    }

    public void testPinActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        Space space = this.createSpace("spaceTestPin", "john", new String[0]);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.activityManager.pinActivity(activity.getId(), this.johnIdentity.getId());
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setPinned(true);
        activityFilter.setStreamType(ActivityStreamType.USER_STREAM);
        RealtimeListAccess activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        List activities = activitiesListAccess.loadAsList(0, activitiesListAccess.getSize());
        ActivityManagerTest.assertEquals((int)1, (int)activities.size());
        ActivityManagerTest.assertTrue((boolean)((ExoSocialActivity)activities.get(0)).isPinned());
        this.activityManager.unpinActivity(activity.getId());
        activitiesListAccess = this.activityManager.getActivitiesByFilterWithListAccess(this.johnIdentity, activityFilter);
        activities = activitiesListAccess.loadAsList(0, activitiesListAccess.getSize());
        ActivityManagerTest.assertEquals((int)0, (int)activities.size());
    }

    public void testCanActivity() throws Exception {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        Space space = this.createSpace("spaceTestPin", "john", "demo", "james");
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        boolean maryCanPinActivity = this.activityManager.canPinActivity((ExoSocialActivity)activity, this.maryIdentity);
        boolean demoCanPinActivity = this.activityManager.canPinActivity((ExoSocialActivity)activity, this.demoIdentity);
        boolean jamesCanPinActivity = this.activityManager.canPinActivity((ExoSocialActivity)activity, this.jamesIdentity);
        ActivityManagerTest.assertFalse((boolean)maryCanPinActivity);
        ActivityManagerTest.assertFalse((boolean)demoCanPinActivity);
        ActivityManagerTest.assertFalse((boolean)jamesCanPinActivity);
        String[] managers = new String[]{"mary"};
        String[] redactors = new String[]{"demo"};
        String[] publishers = new String[]{"james"};
        space.setRedactors(redactors);
        space.setManagers(managers);
        space.setPublishers(publishers);
        this.spaceService.updateSpace(space);
        ActivityManagerTest.assertTrue((boolean)this.activityManager.canPinActivity((ExoSocialActivity)activity, this.maryIdentity));
        ActivityManagerTest.assertFalse((boolean)this.activityManager.canPinActivity((ExoSocialActivity)activity, this.demoIdentity));
        ActivityManagerTest.assertTrue((boolean)this.activityManager.canPinActivity((ExoSocialActivity)activity, this.jamesIdentity));
    }

    public void testDeleteComment() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        this.tearDownActivityList.add((ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
        maryComment.setTitle("mary comment");
        maryComment.setUserId(this.maryIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        this.activityManager.deleteComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        ActivityManagerTest.assertEquals((String)"activityManager.getComments(demoActivity).size() must return: 0", (int)0, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)demoActivity).getSize());
    }

    public void testGetActivityStreamOwnerIdentity() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        this.tearDownActivityList.add((ExoSocialActivity)demoActivity);
        org.exoplatform.social.core.identity.model.Identity streamOwnerIdentity = this.activityManager.getActivityStreamOwnerIdentity(demoActivity.getId());
        ActivityManagerTest.assertNotNull((Object)streamOwnerIdentity);
        ActivityManagerTest.assertEquals((String)this.demoIdentity.getId(), (String)streamOwnerIdentity.getId());
        ExoSocialActivityImpl maryComment = new ExoSocialActivityImpl();
        maryComment.setTitle("mary comment");
        maryComment.setUserId(this.maryIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)demoActivity, (ExoSocialActivity)maryComment);
        streamOwnerIdentity = this.activityManager.getActivityStreamOwnerIdentity(maryComment.getId());
        ActivityManagerTest.assertNotNull((Object)streamOwnerIdentity);
        ActivityManagerTest.assertEquals((String)this.demoIdentity.getId(), (String)streamOwnerIdentity.getId());
    }

    public void testSaveLike() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("&\"demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        this.tearDownActivityList.add((ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)"&amp;&#34;demo activity", (String)demoActivity.getTitle());
    }

    public void testSaveLikeNotChangeTemplateParam() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        this.tearDownActivityList.add((ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)likedActivity.getTemplateParams().get("link")));
    }

    public void testDeleteLike() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        demoActivity.setUserId(demoActivity.getId());
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        this.tearDownActivityList.add((ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds() must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 1", (int)1, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.maryIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.rootIdentity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((String)"demoActivity.getLikeIdentityIds().length must return: 0", (int)0, (int)demoActivity.getLikeIdentityIds().length);
    }

    public void testDeleteLikeNotChangeTemplateParam() {
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("title");
        demoActivity.setUserId(demoActivity.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("link", "http://exoplatform.com?test=<script>");
        demoActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        this.tearDownActivityList.add((ExoSocialActivity)demoActivity);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.saveLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity likedActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)1, (int)likedActivity.getLikeIdentityIds().length);
        demoActivity = this.activityManager.getActivity(demoActivity.getId());
        this.activityManager.deleteLike((ExoSocialActivity)demoActivity, this.johnIdentity);
        ExoSocialActivity deleteLikeActivity = this.activityManager.getActivity(demoActivity.getId());
        ActivityManagerTest.assertEquals((int)0, (int)deleteLikeActivity.getLikeIdentityIds().length);
        ActivityManagerTest.assertEquals((String)((String)templateParams.get("link")), (String)((String)deleteLikeActivity.getTemplateParams().get("link")));
    }

    public void testGetCommentWithHtmlContent() {
        String htmlString = "<span><strong>foo</strong>bar<script>zed</script></span>";
        String htmlRemovedString = "<strong>foo</strong>bar";
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("blah blah");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(htmlString);
        comment.setUserId(this.rootIdentity.getId());
        comment.setBody(htmlString);
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerTest.assertNotNull((String)"comment.getId() must not be null", (Object)comment.getId());
        List comments = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)activity).loadAsList(0, 1);
        ActivityManagerTest.assertEquals((int)1, (int)comments.size());
        ActivityManagerTest.assertEquals((String)htmlRemovedString, (String)((ExoSocialActivity)comments.get(0)).getBody());
        ActivityManagerTest.assertEquals((String)htmlRemovedString, (String)((ExoSocialActivity)comments.get(0)).getTitle());
        this.tearDownActivityList.add((ExoSocialActivity)activity);
    }

    public void testGetComments() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("blah blah");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ArrayList<ExoSocialActivityImpl> comments = new ArrayList<ExoSocialActivityImpl>();
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment blah blah");
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
            ActivityManagerTest.assertNotNull((String)"comment.getId() must not be null", (Object)comment.getId());
            comments.add(comment);
        }
        ExoSocialActivity assertActivity = this.activityManager.getActivity(activity.getId());
        String[] commentIds = assertActivity.getReplyToId();
        for (int i = 1; i < commentIds.length; ++i) {
            ActivityManagerTest.assertEquals((String)((ExoSocialActivity)comments.get(i - 1)).getId(), (String)commentIds[i - 1]);
        }
        this.tearDownActivityList.add((ExoSocialActivity)activity);
    }

    public void testDeleteCommentWithId() {
        int index1;
        String title = "Activity Title";
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setUserId(this.demoIdentity.getId());
        activity1.setTitle("Activity Title");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)activity1);
        int numberOfComments = 10;
        String commentTitle = "Activity Comment";
        for (int i = 0; i < 10; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setUserId(this.demoIdentity.getId());
            comment.setTitle("Activity Comment" + i);
            this.activityManager.saveComment((ExoSocialActivity)activity1, (ExoSocialActivity)comment);
        }
        RealtimeListAccess commentsWithListAccess = this.activityManager.getCommentsWithListAccess((ExoSocialActivity)activity1);
        List storedCommentList = commentsWithListAccess.loadAsList(0, commentsWithListAccess.getSize());
        ActivityManagerTest.assertEquals((String)"storedCommentList.size() must return: 10", (int)10, (int)storedCommentList.size());
        int index2 = index1 = new Random().nextInt(9);
        while (index2 == index1) {
            index2 = new Random().nextInt(9);
        }
        ExoSocialActivity tobeDeletedComment1 = (ExoSocialActivity)storedCommentList.get(index1);
        ExoSocialActivity tobeDeletedComment2 = (ExoSocialActivity)storedCommentList.get(index2);
        this.activityManager.deleteComment(activity1.getId(), tobeDeletedComment1.getId());
        this.activityManager.deleteComment(activity1.getId(), tobeDeletedComment2.getId());
        List afterDeletedCommentList = commentsWithListAccess.loadAsList(0, commentsWithListAccess.getSize());
        ActivityManagerTest.assertEquals((String)"afterDeletedCommentList.size() must return: 8", (int)8, (int)afterDeletedCommentList.size());
        this.tearDownActivityList.add((ExoSocialActivity)activity1);
    }

    public void testDisableActivityType() {
        String activityTitle = "activity title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.setType("cs-calendar:spaces");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNull((Object)activity.getId());
        activity.setType("MY_ACTIVITY");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNull((Object)activity.getId());
        activity.setType("DEFAULT_ACTIVITY");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNotNull((Object)activity.getId());
        activity = this.activityManager.getActivity(activity.getId());
        ActivityManagerTest.assertNotNull((Object)activity);
        this.tearDownActivityList.add((ExoSocialActivity)activity);
    }

    public void testCommentOnDisabledActivity() {
        String activityTitle = "disabled activity";
        String commentTitle = "Comment title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.setType("cs-calendar:spaces");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNull((Object)activity.getId());
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerTest.assertNull((Object)comment.getId());
    }

    public void testCommentWithDisabledCommentActivityType() {
        String activityTitle = "disabled activity";
        String commentTitle = "Comment title";
        String userId = this.johnIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        activity.setType("EnableType");
        this.activityManager.saveActivityNoReturn(this.johnIdentity, (ExoSocialActivity)activity);
        ActivityManagerTest.assertNotNull((Object)activity.getId());
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(commentTitle);
        comment.setType("cs-calendar:spaces");
        comment.setUserId(this.demoIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment);
        ActivityManagerTest.assertNull((Object)comment.getId());
    }

    private void populateActivityMass(org.exoplatform.social.core.identity.model.Identity user, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setUserId(user.getId());
            try {
                this.activityManager.saveActivityNoReturn(user, (ExoSocialActivity)activity);
                this.tearDownActivityList.add((ExoSocialActivity)activity);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"can not save activity.", (Throwable)e);
            }
        }
    }

    private ExoSocialActivity createActivity() {
        String activityTitle = "activity title";
        String userId = this.rootIdentity.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(activityTitle);
        activity.setUserId(userId);
        this.activityManager.saveActivityNoReturn((ExoSocialActivity)activity);
        return this.activityManager.getActivity(activity.getId());
    }

    private ExoSocialActivity createComment(ExoSocialActivity activity, String type, String titleId) {
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setUserId(this.rootIdentity.getId());
        comment.setTemplateParams(new HashMap());
        comment.setTitle("comment title");
        comment.setType(type);
        comment.setTitleId(titleId);
        this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
        return this.activityManager.getActivity(comment.getId());
    }

    private Space createSpace(String spaceName, String creator, String ... members) throws Exception {
        String[] stringArray;
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        space.setRegistration("open");
        space.setPriority("2");
        String[] managers = new String[]{creator};
        if (members == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = creator;
        } else {
            stringArray = members;
        }
        String[] spaceMembers = stringArray;
        space.setManagers(managers);
        space.setMembers(spaceMembers);
        this.spaceService.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        return space;
    }
}

