/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SpaceUtilsWildCardMembershipTest
extends AbstractCoreTest {
    private IdentityStorage identityStorage;
    private SpaceStorage spaceStorage;
    private List<Identity> tearDownIdentityList;
    private List<Space> tearDownSpaceList;
    private List<User> tearDownUserList;
    private UserHandler userHandler;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        SpaceUtilsWildCardMembershipTest.assertNotNull((String)"identityStorage must not be null", (Object)this.identityStorage);
        this.userHandler = SpaceUtils.getOrganizationService().getUserHandler();
        this.tearDownIdentityList = new ArrayList<Identity>();
        this.tearDownSpaceList = new ArrayList<Space>();
        this.tearDownUserList = new ArrayList<User>();
    }

    @Override
    public void tearDown() throws Exception {
        for (Identity identity : this.tearDownIdentityList) {
            this.identityStorage.deleteIdentity(identity);
        }
        for (Space space : this.tearDownSpaceList) {
            this.spaceStorage.deleteSpace(space.getId());
        }
        for (User user : this.tearDownUserList) {
            this.userHandler.removeUser(user.getUserName(), false);
        }
        super.tearDown();
    }

    private void disableUser(String userName) {
        try {
            User user = this.userHandler.findUserByName(userName);
            user = this.userHandler.setEnabled(user.getUserName(), false, false);
            this.userHandler.saveUser(user, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private User populateUser(String name) {
        User user = this.userHandler.createUserInstance(name);
        try {
            this.userHandler.createUser(user, false);
        }
        catch (Exception e) {
            return null;
        }
        this.tearDownUserList.add(user);
        return user;
    }

    private Space populateSpace(String name, String creator) throws Exception {
        Space space = new Space();
        space.setApp("app");
        space.setDisplayName(name);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space ");
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId(SpaceUtils.createGroup((String)space.getPrettyName(), (String)creator));
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{};
        String[] members = new String[]{"user03"};
        String[] invitedUsers = new String[]{};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        this.spaceStorage.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        return space;
    }

    private void populateIdentity(String remoteId) {
        String providerId = "organization";
        Identity identity = new Identity(providerId, remoteId);
        this.identityStorage.saveIdentity(identity);
        Profile profile = new Profile(identity);
        profile.setProperty("firstName", (Object)("FirstName" + remoteId));
        profile.setProperty("lastName", (Object)("LastName" + remoteId));
        profile.setProperty("fullName", (Object)("FirstName" + remoteId + " LastName" + remoteId));
        profile.setProperty("position", (Object)"developer");
        profile.setProperty("gender", (Object)"male");
        identity.setProfile(profile);
        this.tearDownIdentityList.add(identity);
        this.identityStorage.saveProfile(profile);
    }
}

