/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.metadata.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagFilter;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class TagServiceTest
extends AbstractCoreTest {
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private TagService tagService;
    private MetadataService metadataService;
    private MetadataDAO metadataDAO;
    private List<Space> tearDownSpaceList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.metadataService = (MetadataService)this.getContainer().getComponentInstanceOfType(MetadataService.class);
        this.tagService = (TagService)this.getContainer().getComponentInstanceOfType(TagService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.tearDownSpaceList = new ArrayList<Space>();
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.identityManager.deleteIdentity(this.rootIdentity);
        this.identityManager.deleteIdentity(this.johnIdentity);
        this.identityManager.deleteIdentity(this.maryIdentity);
        this.metadataDAO.deleteAll();
        for (Space space : this.tearDownSpaceList) {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityManager.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        super.tearDown();
    }

    public void testDetectTagNames() {
        Set tagNames = this.tagService.detectTagNames(null);
        TagServiceTest.assertNotNull((Object)tagNames);
        TagServiceTest.assertEquals((int)0, (int)tagNames.size());
        String content = "<div>Test tag #NoTagHere test test <a target=\"_blank\" class=\"metadata-tag\" rel=\"noopener\">#ANew'TagHere</a>&nbsp;.</div>";
        tagNames = this.tagService.detectTagNames(content);
        TagServiceTest.assertNotNull((Object)tagNames);
        TagServiceTest.assertEquals((int)1, (int)tagNames.size());
        TagServiceTest.assertEquals(Collections.singleton(new TagName("ANew'TagHere")), (Object)tagNames);
    }

    public void testSaveTags() {
        String objectType = "type";
        String objectId1 = "1";
        String objectId2 = "2";
        String parentObjectId = "2";
        long userIdentityId = Long.parseLong(this.johnIdentity.getId());
        long audienceId = 5000L;
        HashSet<TagName> tagNames1 = new HashSet<TagName>();
        String tagName1 = "tag1";
        String tagName2 = "tag2";
        tagNames1.add(new TagName(tagName1));
        tagNames1.add(new TagName(tagName1.toLowerCase()));
        tagNames1.add(new TagName(tagName2));
        try {
            this.tagService.saveTags(null, tagNames1, audienceId, userIdentityId);
            TagServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tagService.saveTags(new TagObject(null, objectId1, parentObjectId), tagNames1, audienceId, userIdentityId);
            TagServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tagService.saveTags(new TagObject(objectType, null, parentObjectId), tagNames1, audienceId, userIdentityId);
            TagServiceTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TagObject taggedObject1 = new TagObject(objectType, objectId1, parentObjectId);
        Set savedTagNames = this.tagService.saveTags(taggedObject1, tagNames1, audienceId, userIdentityId);
        TagServiceTest.assertNotNull((Object)savedTagNames);
        TagServiceTest.assertEquals((int)2, (int)savedTagNames.size());
        TagServiceTest.assertTrue((boolean)savedTagNames.contains(new TagName(tagName1)));
        TagServiceTest.assertTrue((boolean)savedTagNames.contains(new TagName(tagName2)));
        Metadata metadata = this.metadataService.getMetadataByKey(new MetadataKey(TagService.METADATA_TYPE.getName(), tagName1, audienceId));
        TagServiceTest.assertNotNull((Object)metadata);
        TagServiceTest.assertEquals((String)tagName1, (String)metadata.getName());
        TagServiceTest.assertEquals((String)TagService.METADATA_TYPE.getName(), (String)metadata.getTypeName());
        TagServiceTest.assertEquals((long)audienceId, (long)metadata.getAudienceId());
        List metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject("tags", (MetadataObject)taggedObject1);
        TagServiceTest.assertNotNull((Object)metadataItems);
        TagServiceTest.assertEquals((int)2, (int)metadataItems.size());
        Set storedTagNames = metadataItems.stream().map(MetadataItem::getMetadata).map(Metadata::getName).map(TagName::new).collect(Collectors.toSet());
        TagServiceTest.assertTrue((boolean)storedTagNames.contains(new TagName(tagName1)));
        TagServiceTest.assertTrue((boolean)storedTagNames.contains(new TagName(tagName2)));
        Set<TagName> updatedTagNames = Collections.singleton(new TagName(tagName1));
        savedTagNames = this.tagService.saveTags(taggedObject1, updatedTagNames, audienceId, userIdentityId);
        TagServiceTest.assertNotNull((Object)savedTagNames);
        TagServiceTest.assertEquals((int)1, (int)savedTagNames.size());
        TagServiceTest.assertEquals(updatedTagNames, (Object)savedTagNames);
        metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject("tags", (MetadataObject)taggedObject1);
        TagServiceTest.assertNotNull((Object)metadataItems);
        TagServiceTest.assertEquals((int)1, (int)metadataItems.size());
        TagServiceTest.assertTrue((boolean)storedTagNames.contains(new TagName(tagName1)));
        TagObject taggedObject2 = new TagObject(objectType, objectId2, parentObjectId);
        metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject("tags", (MetadataObject)taggedObject2);
        TagServiceTest.assertNotNull((Object)metadataItems);
        TagServiceTest.assertEquals((int)0, (int)metadataItems.size());
        HashSet<TagName> tagNames2 = new HashSet<TagName>();
        tagNames2.add(new TagName(tagName1.toUpperCase()));
        tagNames2.add(new TagName("tag3"));
        savedTagNames = this.tagService.saveTags(taggedObject2, tagNames2, audienceId, userIdentityId);
        TagServiceTest.assertNotNull((Object)savedTagNames);
        TagServiceTest.assertEquals((int)2, (int)savedTagNames.size());
        metadataItems = this.metadataService.getMetadataItemsByMetadataTypeAndObject("tags", (MetadataObject)taggedObject2);
        TagServiceTest.assertNotNull((Object)metadataItems);
        TagServiceTest.assertEquals((int)2, (int)metadataItems.size());
        storedTagNames = metadataItems.stream().map(MetadataItem::getMetadata).map(Metadata::getName).map(TagName::new).collect(Collectors.toSet());
        TagServiceTest.assertEquals(tagNames2, storedTagNames);
    }

    public void testFindTags() throws Exception {
        ArrayList<Space> spaces = new ArrayList<Space>();
        ArrayList<Long> spaceIdentityIds = new ArrayList<Long>();
        ArrayList<Long> spaceCreators = new ArrayList<Long>();
        Space space = this.createSpace("FindTags1", this.maryIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.maryIdentity.getId()));
        spaceIdentityIds.add(Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId()));
        space = this.createSpace("FindTags2", this.johnIdentity.getRemoteId(), this.johnIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.johnIdentity.getId()));
        spaceIdentityIds.add(Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId()));
        space = this.createSpace("FindTags3", this.maryIdentity.getRemoteId(), this.johnIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(Long.parseLong(this.maryIdentity.getId()));
        spaceIdentityIds.add(Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId()));
        HashSet<TagName> tagNames = new HashSet<TagName>();
        tagNames.add(new TagName("tagMary1"));
        tagNames.add(new TagName("tagMary2"));
        Set savedTags = this.tagService.saveTags(new TagObject("objectType", "objectId1"), tagNames, ((Long)spaceIdentityIds.get(0)).longValue(), ((Long)spaceCreators.get(0)).longValue());
        TagServiceTest.assertEquals((Object)savedTags, tagNames);
        tagNames = new HashSet();
        tagNames.add(new TagName("tagJohn1"));
        tagNames.add(new TagName("tagJohn2"));
        savedTags = this.tagService.saveTags(new TagObject("objectType", "objectId1"), tagNames, ((Long)spaceIdentityIds.get(1)).longValue(), ((Long)spaceCreators.get(1)).longValue());
        TagServiceTest.assertEquals((Object)savedTags, tagNames);
        tagNames = new HashSet();
        tagNames.add(new TagName("tagJohnMary1"));
        tagNames.add(new TagName("tagJohnMary2"));
        savedTags = this.tagService.saveTags(new TagObject("objectType", "objectId1"), tagNames, ((Long)spaceIdentityIds.get(2)).longValue(), ((Long)spaceCreators.get(2)).longValue());
        TagServiceTest.assertEquals((Object)savedTags, tagNames);
        List marySavedTags = this.tagService.findTags(null, Long.parseLong(this.maryIdentity.getId()));
        TagServiceTest.assertNotNull((Object)marySavedTags);
        TagServiceTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2", "tagMary1", "tagMary2"), marySavedTags.stream().map(TagName::getName).sorted().collect(Collectors.toList()));
        marySavedTags = this.tagService.findTags(new TagFilter("mar", 0L), Long.parseLong(this.maryIdentity.getId()));
        TagServiceTest.assertNotNull((Object)marySavedTags);
        TagServiceTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2", "tagMary1", "tagMary2"), marySavedTags.stream().map(TagName::getName).sorted().collect(Collectors.toList()));
        marySavedTags = this.tagService.findTags(new TagFilter("mar", 3L), Long.parseLong(this.maryIdentity.getId()));
        TagServiceTest.assertNotNull((Object)marySavedTags);
        TagServiceTest.assertEquals((int)3, (int)marySavedTags.size());
        List johnSavedTags = this.tagService.findTags(new TagFilter("mar", 0L), Long.parseLong(this.johnIdentity.getId()));
        TagServiceTest.assertNotNull((Object)johnSavedTags);
        TagServiceTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2"), johnSavedTags.stream().map(TagName::getName).sorted().collect(Collectors.toList()));
        johnSavedTags = this.tagService.findTags(new TagFilter("mar", 2L), Long.parseLong(this.johnIdentity.getId()));
        TagServiceTest.assertNotNull((Object)johnSavedTags);
        TagServiceTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2"), johnSavedTags.stream().map(TagName::getName).sorted().collect(Collectors.toList()));
        johnSavedTags = this.tagService.findTags(new TagFilter("joh", 10L), Long.parseLong(this.johnIdentity.getId()));
        TagServiceTest.assertNotNull((Object)johnSavedTags);
        TagServiceTest.assertEquals(Arrays.asList("tagJohn1", "tagJohn2", "tagJohnMary1", "tagJohnMary2"), johnSavedTags.stream().map(TagName::getName).sorted().collect(Collectors.toList()));
    }

    public void testFindTagsCaseInsensitive() throws Exception {
        HashSet<TagName> tagNames = new HashSet<TagName>();
        tagNames.add(new TagName("tagMary1"));
        tagNames.add(new TagName("tagMary2"));
        long maryIdentityId = Long.parseLong(this.maryIdentity.getId());
        TagObject tagObject = new TagObject("objectType", "objectId3");
        Set savedTags = this.tagService.saveTags(tagObject, tagNames, maryIdentityId, maryIdentityId);
        TagServiceTest.assertEquals((Object)savedTags, tagNames);
        HashSet<TagName> tagNamesUpperCase = new HashSet<TagName>();
        tagNamesUpperCase.add(new TagName("tagMary1".toUpperCase()));
        tagNamesUpperCase.add(new TagName("tagMary2".toUpperCase()));
        savedTags = this.tagService.saveTags(tagObject, tagNamesUpperCase, maryIdentityId, maryIdentityId);
        TagServiceTest.assertEquals(tagNamesUpperCase, (Object)savedTags);
        List marySavedTags = this.tagService.findTags(null, maryIdentityId);
        TagServiceTest.assertNotNull((Object)marySavedTags);
        TagServiceTest.assertEquals((int)2, (int)marySavedTags.size());
        TagServiceTest.assertTrue((boolean)marySavedTags.contains(new TagName("tagMary1".toUpperCase())));
        TagServiceTest.assertTrue((boolean)marySavedTags.contains(new TagName("tagMary2".toUpperCase())));
        Set savedTagNames = this.tagService.getTagNames(tagObject);
        TagServiceTest.assertEquals(tagNames, (Object)savedTagNames);
    }

    private Space createSpace(String spaceName, String creator, String ... members) throws Exception {
        String[] stringArray;
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        space.setRegistration("open");
        space.setPriority("2");
        String[] managers = new String[]{creator};
        if (members == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = creator;
        } else {
            stringArray = members;
        }
        String[] spaceMembers = stringArray;
        space.setManagers(managers);
        space.setMembers(spaceMembers);
        this.spaceService.saveSpace(space, true);
        this.tearDownSpaceList.add(space);
        return space;
    }
}

