/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.SpaceStorage;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.cache.SocialStorageCacheService;

public abstract class SpaceStorageTest
extends AbstractCoreTest {
    private SpaceStorage spaceStorage;
    private IdentityStorage identityStorage;
    private SocialStorageCacheService cacheService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.spaceStorage = this.getService(SpaceStorage.class);
        this.identityStorage = this.getService(IdentityStorage.class);
        this.cacheService = this.getService(SocialStorageCacheService.class);
        this.rootIdentity = this.createIdentity("root");
        this.johnIdentity = this.createIdentity("john");
        this.maryIdentity = this.createIdentity("mary");
        this.demoIdentity = this.createIdentity("demo");
    }

    protected Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("my space test " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"demo", "tom", "raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        return space;
    }

    protected Space getSpaceInstance(int number, String visible, String registration, String manager, String ... members) {
        String[] stringArray;
        Space space = new Space();
        space.setDisplayName("my space test " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration(registration);
        space.setDescription("add new space " + number);
        space.setVisibility(visible);
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{manager};
        String[] invitedUsers = new String[]{};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        if (members == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = manager;
        } else {
            stringArray = (String[])ArrayUtils.add((Object[])members, (Object)manager);
        }
        space.setMembers(stringArray);
        space.setUrl(space.getPrettyName());
        return space;
    }

    private Space getSpaceInstanceInvitedMember(int number, String visible, String registration, String[] invitedMember, String manager, String ... members) {
        String[] stringArray;
        Space space = new Space();
        space.setDisplayName("my space test " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration(registration);
        space.setDescription("add new space " + number);
        space.setVisibility(visible);
        space.setGroupId("/spaces/space" + number);
        space.setUrl(space.getPrettyName());
        String[] managers = new String[]{manager};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedMember);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        if (members == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = manager;
        } else {
            stringArray = (String[])ArrayUtils.add((Object[])members, (Object)manager);
        }
        space.setMembers(stringArray);
        return space;
    }

    private List<Space> getSpaceWithRoot(SpaceFilter filter) {
        if (filter == null) {
            return this.spaceStorage.getAllSpaces();
        }
        return this.spaceStorage.getSpacesByFilter(filter, 0L, 200L);
    }

    public void testGetAllSpaces() throws Exception {
        int totalSpaces = 10;
        for (int i = 1; i <= totalSpaces; ++i) {
            Space space = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(space, true);
            this.persist();
        }
        SpaceStorageTest.assertEquals((String)("spaceStorage.getAllSpaces().size() must return: " + totalSpaces), (int)totalSpaces, (int)this.spaceStorage.getAllSpaces().size());
    }

    public void testGetSpaces() throws Exception {
        int totalSpaces = 10;
        for (int i = 1; i <= totalSpaces; ++i) {
            Space space = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(space, true);
            this.persist();
        }
        int offset = 0;
        int limit = 10;
        List spaceListAccess = this.spaceStorage.getSpaces((long)offset, (long)limit);
        SpaceStorageTest.assertNotNull((String)"spaceListAccess must not be  null", (Object)spaceListAccess);
        SpaceStorageTest.assertEquals((String)("spaceListAccess.size() must be: " + totalSpaces), (int)totalSpaces, (int)spaceListAccess.size());
        spaceListAccess = this.spaceStorage.getSpaces((long)offset, 5L);
        SpaceStorageTest.assertNotNull((String)"spaceListAccess must not be  null", (Object)spaceListAccess);
        SpaceStorageTest.assertEquals((String)"spaceListAccess.size() must be: 5", (int)5, (int)spaceListAccess.size());
        spaceListAccess = this.spaceStorage.getSpaces((long)offset, 20L);
        SpaceStorageTest.assertNotNull((String)"spaceListAccess must not be  null", (Object)spaceListAccess);
        SpaceStorageTest.assertEquals((String)("spaceListAccess.size() must be: " + totalSpaces), (int)totalSpaces, (int)spaceListAccess.size());
    }

    public void testGetAllSpacesCount() throws Exception {
        int totalSpaces = 10;
        for (int i = 1; i <= totalSpaces; ++i) {
            Space space = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(space, true);
            this.persist();
        }
        int spacesCount = this.spaceStorage.getAllSpacesCount();
        SpaceStorageTest.assertEquals((String)"spacesCount must be: ", (int)totalSpaces, (int)spacesCount);
    }

    public void testGetSpacesByFilter() throws Exception {
        int totalSpaces = 10;
        for (int i = 1; i <= totalSpaces; ++i) {
            Space space = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(space, true);
            this.persist();
        }
        List foundSpaces = this.spaceStorage.getSpacesByFilter(new SpaceFilter("add"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceStorageTest.assertEquals((String)("foundSpaces.size() must return: " + totalSpaces), (int)totalSpaces, (int)foundSpaces.size());
        foundSpaces = this.spaceStorage.getSpacesByFilter(new SpaceFilter("my"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceStorageTest.assertEquals((String)("foundSpaces.size() must return: " + totalSpaces), (int)totalSpaces, (int)foundSpaces.size());
        foundSpaces = this.spaceStorage.getSpacesByFilter(new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceStorageTest.assertEquals((String)("foundSpaces.size() must return: " + totalSpaces), (int)totalSpaces, (int)foundSpaces.size());
        foundSpaces = this.spaceStorage.getSpacesByFilter(new SpaceFilter("hello"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceStorageTest.assertEquals((String)"foundSpaces.size() must return: 0", (int)0, (int)foundSpaces.size());
        foundSpaces = this.spaceStorage.getSpacesByFilter(new SpaceFilter(), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"foundSpaces must not be null", (Object)foundSpaces);
        SpaceStorageTest.assertEquals((String)("foundSpaces.size() must return: " + totalSpaces), (int)totalSpaces, (int)foundSpaces.size());
    }

    public void testGetAllSpacesByFilterCount() throws Exception {
        int totalSpaces = 10;
        for (int i = 1; i <= totalSpaces; ++i) {
            Space space = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(space, true);
            this.persist();
        }
        int count = this.spaceStorage.getAllSpacesByFilterCount(new SpaceFilter("add"));
        SpaceStorageTest.assertEquals((String)("count must be: " + totalSpaces), (int)totalSpaces, (int)count);
        count = this.spaceStorage.getAllSpacesByFilterCount(new SpaceFilter("my"));
        SpaceStorageTest.assertEquals((String)("count must be: " + totalSpaces), (int)totalSpaces, (int)count);
        count = this.spaceStorage.getAllSpacesByFilterCount(new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)("count must be: " + totalSpaces), (int)totalSpaces, (int)count);
        count = this.spaceStorage.getAllSpacesByFilterCount(new SpaceFilter("hello"));
        SpaceStorageTest.assertEquals((String)"count must be: 0", (int)0, (int)count);
        count = this.spaceStorage.getAllSpacesByFilterCount(new SpaceFilter());
        SpaceStorageTest.assertEquals((String)("count must be: " + totalSpaces), (int)totalSpaces, (int)count);
        count = this.spaceStorage.getAllSpacesByFilterCount(new SpaceFilter());
        SpaceStorageTest.assertEquals((String)("count must be: " + totalSpaces), (int)totalSpaces, (int)count);
    }

    public void testGetAccessibleSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List accessibleSpaces = this.spaceStorage.getAccessibleSpaces("demo");
        SpaceStorageTest.assertNotNull((String)"accessibleSpaces must not be  null", (Object)accessibleSpaces);
        SpaceStorageTest.assertEquals((String)("accessibleSpaces.size() must return: " + countSpace), (int)countSpace, (int)accessibleSpaces.size());
    }

    public void testGetAccessibleSpacesByFilter() throws Exception {
        int countSpace = 20;
        Space[] listSpace = new Space[countSpace];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("demo", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpacesByFilter must not be null", (Object)accessibleSpacesByFilter);
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilter.size() must return: ", (int)10, (int)accessibleSpacesByFilter.size());
        accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("tom", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpacesByFilter must not be null", (Object)accessibleSpacesByFilter);
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilter.size() must return: ", (int)10, (int)accessibleSpacesByFilter.size());
        accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("ghost", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpacesByFilter must not be null", (Object)accessibleSpacesByFilter);
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilter.size() must return: ", (int)10, (int)accessibleSpacesByFilter.size());
        accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("demo", new SpaceFilter("add new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpacesByFilter must not be null", (Object)accessibleSpacesByFilter);
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilter.size() must return: ", (int)10, (int)accessibleSpacesByFilter.size());
        accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("demo", new SpaceFilter(), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpacesByFilter must not be null", (Object)accessibleSpacesByFilter);
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilter.size() must return: ", (int)10, (int)accessibleSpacesByFilter.size());
        accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("demo", new SpaceFilter(), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpacesByFilter must not be null", (Object)accessibleSpacesByFilter);
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilter.size() must return: ", (int)10, (int)accessibleSpacesByFilter.size());
        accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("newperson", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpacesByFilter must not be null", (Object)accessibleSpacesByFilter);
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilter.size() must return: ", (int)0, (int)accessibleSpacesByFilter.size());
    }

    public void testGetAccessibleSpacesByFilterApp() {
        Space space = this.getSpaceInstance(1);
        this.spaceStorage.saveSpace(space, true);
        this.persist();
        SpaceFilter filter = new SpaceFilter("my space test");
        List accessibleSpacesByFilter = this.spaceStorage.getAccessibleSpacesByFilter("demo", filter, 0L, 10L);
        SpaceStorageTest.assertEquals((int)1, (int)accessibleSpacesByFilter.size());
    }

    public void testGetAccessibleSpacesByFilterCount() throws Exception {
        int countSpace = 20;
        Space[] listSpace = new Space[countSpace];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int accessibleSpacesByFilterCount = this.spaceStorage.getAccessibleSpacesByFilterCount("demo", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilterCount must be: ", (int)countSpace, (int)accessibleSpacesByFilterCount);
        accessibleSpacesByFilterCount = this.spaceStorage.getAccessibleSpacesByFilterCount("tom", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilterCount must be: ", (int)countSpace, (int)accessibleSpacesByFilterCount);
        accessibleSpacesByFilterCount = this.spaceStorage.getAccessibleSpacesByFilterCount("tom", new SpaceFilter());
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilterCount must be: ", (int)countSpace, (int)accessibleSpacesByFilterCount);
        accessibleSpacesByFilterCount = this.spaceStorage.getAccessibleSpacesByFilterCount("tom", new SpaceFilter());
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilterCount must be: ", (int)countSpace, (int)accessibleSpacesByFilterCount);
        accessibleSpacesByFilterCount = this.spaceStorage.getAccessibleSpacesByFilterCount("ghost", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilterCount must be: ", (int)countSpace, (int)accessibleSpacesByFilterCount);
        accessibleSpacesByFilterCount = this.spaceStorage.getAccessibleSpacesByFilterCount("demo", new SpaceFilter("add new"));
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilterCount must be: ", (int)countSpace, (int)accessibleSpacesByFilterCount);
        accessibleSpacesByFilterCount = this.spaceStorage.getAccessibleSpacesByFilterCount("newperson", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)"accessibleSpacesByFilterCount must be: ", (int)0, (int)accessibleSpacesByFilterCount);
    }

    public void testgetAccessibleSpacesCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int accessibleSpacesCount = this.spaceStorage.getAccessibleSpacesCount("demo");
        SpaceStorageTest.assertEquals((String)("accessibleSpacesCount mus be: " + countSpace), (int)countSpace, (int)accessibleSpacesCount);
        accessibleSpacesCount = this.spaceStorage.getAccessibleSpacesCount("dragon");
        SpaceStorageTest.assertEquals((String)("accessibleSpacesCount must be: " + countSpace), (int)countSpace, (int)accessibleSpacesCount);
        accessibleSpacesCount = this.spaceStorage.getAccessibleSpacesCount("nobody");
        SpaceStorageTest.assertEquals((String)"accessibleSpacesCount must be: 0", (int)0, (int)accessibleSpacesCount);
    }

    public void testGetAccessibleSpacesWithOffset() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List accessibleSpaces = this.spaceStorage.getAccessibleSpaces("demo", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"accessibleSpaces must not be  null", (Object)accessibleSpaces);
        SpaceStorageTest.assertEquals((String)"accessibleSpaces.size() must return: 5", (int)5, (int)accessibleSpaces.size());
    }

    public void testGetEditableSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List editableSpaces = this.spaceStorage.getEditableSpaces("demo");
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpaces("top");
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)"editableSpaces.size() must return: 0", (int)0, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpaces("dragon");
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)"editableSpaces.size() must return: 0", (int)0, (int)editableSpaces.size());
    }

    public void testGetEditableSpacesByFilter() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List editableSpaces = this.spaceStorage.getEditableSpacesByFilter("demo", new SpaceFilter("add new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpacesByFilter("demo", new SpaceFilter("m"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpacesByFilter("demo", new SpaceFilter("M"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpacesByFilter("demo", new SpaceFilter(), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpacesByFilter("demo", new SpaceFilter(), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpacesByFilter("demo", new SpaceFilter("add new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpacesByFilter("top", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)"editableSpaces.size() must return: 0", (int)0, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpacesByFilter("dragon", new SpaceFilter("m"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)"editableSpaces.size() must return: 0", (int)0, (int)editableSpaces.size());
    }

    public void testGetEditableSpacesByFilterCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int editableSpacesCount = this.spaceStorage.getEditableSpacesByFilterCount("demo", new SpaceFilter("add new"));
        SpaceStorageTest.assertEquals((String)("editableSpacesCount must be: " + countSpace), (int)countSpace, (int)editableSpacesCount);
        editableSpacesCount = this.spaceStorage.getEditableSpacesByFilterCount("demo", new SpaceFilter("m"));
        SpaceStorageTest.assertEquals((String)("editableSpacesCount must be: " + countSpace), (int)countSpace, (int)editableSpacesCount);
        editableSpacesCount = this.spaceStorage.getEditableSpacesByFilterCount("demo", new SpaceFilter("M"));
        SpaceStorageTest.assertEquals((String)("editableSpacesCount must be: " + countSpace), (int)countSpace, (int)editableSpacesCount);
        editableSpacesCount = this.spaceStorage.getEditableSpacesByFilterCount("tom", new SpaceFilter("add new"));
        SpaceStorageTest.assertEquals((String)("editableSpacesCount must be: " + countSpace), (int)countSpace, (int)editableSpacesCount);
        editableSpacesCount = this.spaceStorage.getEditableSpacesByFilterCount("top", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)"editableSpacesCount must be: 0", (int)0, (int)editableSpacesCount);
        editableSpacesCount = this.spaceStorage.getEditableSpacesByFilterCount("dragon", new SpaceFilter("m"));
        SpaceStorageTest.assertEquals((String)"editableSpacesCount must be: 0", (int)0, (int)editableSpacesCount);
    }

    public void testGetEditableSpacesWithListAccess() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List editableSpaces = this.spaceStorage.getEditableSpaces("demo", 0L, (long)countSpace);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)("editableSpaces.size() must return: " + countSpace), (int)countSpace, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpaces("top", 0L, (long)countSpace);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)"editableSpaces.size() must return: 0", (int)0, (int)editableSpaces.size());
        editableSpaces = this.spaceStorage.getEditableSpaces("dragon", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"editableSpaces must not be  null", (Object)editableSpaces);
        SpaceStorageTest.assertEquals((String)"editableSpaces.size() must return: 0", (int)0, (int)editableSpaces.size());
    }

    public void testGetInvitedSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List invitedSpaces = this.spaceStorage.getInvitedSpaces("register1");
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)("invitedSpaces.size() must return: " + countSpace), (int)countSpace, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpaces("register");
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 0", (int)0, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpaces("mary");
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)("invitedSpaces.size() must return: " + countSpace), (int)countSpace, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpaces("demo");
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 0", (int)0, (int)invitedSpaces.size());
    }

    public void testGetInvitedSpacesByFilter() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List invitedSpaces = this.spaceStorage.getInvitedSpacesByFilter("register1", new SpaceFilter("add new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)("invitedSpaces.size() must return: " + countSpace), (int)countSpace, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpacesByFilter("register1", new SpaceFilter("m"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)("invitedSpaces.size() must return: " + countSpace), (int)countSpace, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpacesByFilter("register", new SpaceFilter("my space test "), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 0", (int)0, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpacesByFilter("mary", new SpaceFilter("add"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)("invitedSpaces.size() must return: " + countSpace), (int)countSpace, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpacesByFilter("demo", new SpaceFilter("my"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 0", (int)0, (int)invitedSpaces.size());
    }

    public void testGetInvitedSpacesByFilterCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int invitedSpacesCount = this.spaceStorage.getInvitedSpacesByFilterCount("register1", new SpaceFilter("add new"));
        SpaceStorageTest.assertEquals((String)("invitedSpacesCount must be: " + countSpace), (int)countSpace, (int)invitedSpacesCount);
        invitedSpacesCount = this.spaceStorage.getInvitedSpacesByFilterCount("register1", new SpaceFilter("m"));
        SpaceStorageTest.assertEquals((String)("invitedSpacesCount must be: " + countSpace), (int)countSpace, (int)invitedSpacesCount);
        invitedSpacesCount = this.spaceStorage.getInvitedSpacesByFilterCount("register", new SpaceFilter("my space test "));
        SpaceStorageTest.assertEquals((String)"invitedSpacesCount must be: 0", (int)0, (int)invitedSpacesCount);
        invitedSpacesCount = this.spaceStorage.getInvitedSpacesByFilterCount("mary", new SpaceFilter("add"));
        SpaceStorageTest.assertEquals((String)("invitedSpacesCount must be: " + countSpace), (int)countSpace, (int)invitedSpacesCount);
        invitedSpacesCount = this.spaceStorage.getInvitedSpacesByFilterCount("demo", new SpaceFilter("my"));
        SpaceStorageTest.assertEquals((String)"invitedSpacesCount must be: 0", (int)0, (int)invitedSpacesCount);
    }

    public void testGetInvitedSpacesWithOffset() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List invitedSpaces = this.spaceStorage.getInvitedSpaces("register1", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 5", (int)5, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpaces("register", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 0", (int)0, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpaces("mary", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 5", (int)5, (int)invitedSpaces.size());
        invitedSpaces = this.spaceStorage.getInvitedSpaces("demo", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces);
        SpaceStorageTest.assertEquals((String)"invitedSpaces.size() must return: 0", (int)0, (int)invitedSpaces.size());
    }

    public void testGetInvitedSpacesCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int invitedSpacesCount = this.spaceStorage.getInvitedSpacesCount("register1");
        SpaceStorageTest.assertEquals((String)("invitedSpacesCount must be: " + countSpace), (int)countSpace, (int)invitedSpacesCount);
        invitedSpacesCount = this.spaceStorage.getInvitedSpacesCount("mary");
        SpaceStorageTest.assertEquals((String)("invitedSpacesCount must be: " + countSpace), (int)countSpace, (int)invitedSpacesCount);
        invitedSpacesCount = this.spaceStorage.getInvitedSpacesCount("nobody");
        SpaceStorageTest.assertEquals((String)"invitedSpacesCount must be: 0", (int)0, (int)invitedSpacesCount);
    }

    public void testGetPendingSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List pendingSpaces = this.spaceStorage.getPendingSpaces("hacker");
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)("pendingSpaces.size() must return: " + countSpace), (int)countSpace, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpaces("hack");
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 0", (int)0, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpaces("paul");
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)("pendingSpaces.size() must return: " + countSpace), (int)countSpace, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpaces("jame");
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)("pendingSpaces.size() must return: " + countSpace), (int)countSpace, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpaces("victory");
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 0", (int)0, (int)pendingSpaces.size());
    }

    public void testGetPendingSpacesByFilter() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List pendingSpaces = this.spaceStorage.getPendingSpacesByFilter("hacker", new SpaceFilter("add new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)("pendingSpaces.size() must return: " + countSpace), (int)countSpace, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpacesByFilter("hacker", new SpaceFilter("m"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)("pendingSpaces.size() must return: " + countSpace), (int)countSpace, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpacesByFilter("hack", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 0", (int)0, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpacesByFilter("paul", new SpaceFilter("add"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)("pendingSpaces.size() must return: " + countSpace), (int)countSpace, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpacesByFilter("jame", new SpaceFilter("my"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)("pendingSpaces.size() must return: " + countSpace), (int)countSpace, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpacesByFilter("victory", new SpaceFilter("my space test "), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 0", (int)0, (int)pendingSpaces.size());
    }

    public void testGetPendingSpacesByFilterCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int pendingSpacesCount = this.spaceStorage.getPendingSpacesByFilterCount("hacker", new SpaceFilter("add new"));
        SpaceStorageTest.assertEquals((String)("pendingSpacesCount must be: " + countSpace), (int)countSpace, (int)pendingSpacesCount);
        pendingSpacesCount = this.spaceStorage.getPendingSpacesByFilterCount("hacker", new SpaceFilter("m"));
        SpaceStorageTest.assertEquals((String)("pendingSpacesCount must be: " + countSpace), (int)countSpace, (int)pendingSpacesCount);
        pendingSpacesCount = this.spaceStorage.getPendingSpacesByFilterCount("hack", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)"pendingSpacesCount must be: 0", (int)0, (int)pendingSpacesCount);
        pendingSpacesCount = this.spaceStorage.getPendingSpacesByFilterCount("paul", new SpaceFilter("add"));
        SpaceStorageTest.assertEquals((String)("pendingSpacesCount must be: " + countSpace), (int)countSpace, (int)pendingSpacesCount);
        pendingSpacesCount = this.spaceStorage.getPendingSpacesByFilterCount("jame", new SpaceFilter("my"));
        SpaceStorageTest.assertEquals((String)("pendingSpacesCount must be: " + countSpace), (int)countSpace, (int)pendingSpacesCount);
        pendingSpacesCount = this.spaceStorage.getPendingSpacesByFilterCount("victory", new SpaceFilter("my space test "));
        SpaceStorageTest.assertEquals((String)"pendingSpacesCount must be: 0", (int)0, (int)pendingSpacesCount);
    }

    public void testGetPendingSpacesWithOffset() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List pendingSpaces = this.spaceStorage.getPendingSpaces("hacker", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 5", (int)5, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpaces("paul", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 5", (int)5, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpaces("jame", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 5", (int)5, (int)pendingSpaces.size());
        pendingSpaces = this.spaceStorage.getPendingSpaces("victory", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"pendingSpaces must not be  null", (Object)pendingSpaces);
        SpaceStorageTest.assertEquals((String)"pendingSpaces.size() must return: 0", (int)0, (int)pendingSpaces.size());
    }

    public void testGetPendingSpacesCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int pendingSpaceCount = this.spaceStorage.getPendingSpacesCount("jame");
        SpaceStorageTest.assertEquals((String)("pendingSpaceCount must be: " + countSpace), (int)countSpace, (int)pendingSpaceCount);
        pendingSpaceCount = this.spaceStorage.getPendingSpacesCount("paul");
        SpaceStorageTest.assertEquals((String)("pendingSpaceCount must be: " + countSpace), (int)countSpace, (int)pendingSpaceCount);
        pendingSpaceCount = this.spaceStorage.getPendingSpacesCount("hacker");
        SpaceStorageTest.assertEquals((String)("pendingSpaceCount must be: " + countSpace), (int)countSpace, (int)pendingSpaceCount);
        pendingSpaceCount = this.spaceStorage.getPendingSpacesCount("nobody");
        SpaceStorageTest.assertEquals((String)"pendingSpaceCount must be: 0", (int)0, (int)pendingSpaceCount);
    }

    public void testGetMemberSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List memberSpaces = this.spaceStorage.getMemberSpaces("raul");
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpaces("ghost");
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpaces("dragon");
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpaces("paul");
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)"memberSpaces.size() must return: 0", (int)0, (int)memberSpaces.size());
    }

    public void testGetMemberSpacesByFilter() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List memberSpaces = this.spaceStorage.getMemberSpacesByFilter("raul", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpacesByFilter("ghost", new SpaceFilter("add new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpacesByFilter("ghost", new SpaceFilter("space"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpacesByFilter("ghost", new SpaceFilter("new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpacesByFilter("ghost", new SpaceFilter("m"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpacesByFilter("dragon", new SpaceFilter("add"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpacesByFilter("paul", new SpaceFilter("space"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)"memberSpaces.size() must return: 0", (int)0, (int)memberSpaces.size());
    }

    public void testGetManagerSpacesByFilter() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List managerSpaces = this.spaceStorage.getManagerSpacesByFilter("raul", new SpaceFilter("my space test"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"managerSpaces must not be  null", (Object)managerSpaces);
        SpaceStorageTest.assertEquals((String)"managerSpaces.size() must return: 0", (int)0, (int)managerSpaces.size());
        managerSpaces = this.spaceStorage.getManagerSpacesByFilter("ghost", new SpaceFilter("add new"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"managerSpaces must not be  null", (Object)managerSpaces);
        SpaceStorageTest.assertEquals((String)"managerSpaces.size() must return: 0", (int)0, (int)managerSpaces.size());
        managerSpaces = this.spaceStorage.getManagerSpacesByFilter("dragon", new SpaceFilter("add"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"managerSpaces must not be  null", (Object)managerSpaces);
        SpaceStorageTest.assertEquals((String)"managerSpaces.size() must return: 0", (int)0, (int)managerSpaces.size());
        managerSpaces = this.spaceStorage.getManagerSpacesByFilter("demo", new SpaceFilter("space"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"managerSpaces must not be  null", (Object)managerSpaces);
        SpaceStorageTest.assertEquals((String)("managerSpaces.size() must return: " + countSpace), (int)countSpace, (int)managerSpaces.size());
        managerSpaces = this.spaceStorage.getManagerSpacesByFilter("demo", new SpaceFilter("space2"), 0L, 10L);
        SpaceStorageTest.assertNotNull((String)"managerSpaces must not be  null", (Object)managerSpaces);
        SpaceStorageTest.assertEquals((String)"managerSpaces.size() must return: 0", (int)0, (int)managerSpaces.size());
    }

    public void testGetMemberSpacesByFilterCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int memberSpacesCount = this.spaceStorage.getMemberSpacesByFilterCount("raul", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)("memberSpacesCount must be: " + countSpace), (int)countSpace, (int)memberSpacesCount);
        memberSpacesCount = this.spaceStorage.getMemberSpacesByFilterCount("ghost", new SpaceFilter("add new"));
        SpaceStorageTest.assertEquals((String)("memberSpacesCount must be: " + countSpace), (int)countSpace, (int)memberSpacesCount);
        memberSpacesCount = this.spaceStorage.getMemberSpacesByFilterCount("ghost", new SpaceFilter("space"));
        SpaceStorageTest.assertEquals((String)("memberSpacesCount must be: " + countSpace), (int)countSpace, (int)memberSpacesCount);
        memberSpacesCount = this.spaceStorage.getMemberSpacesByFilterCount("ghost", new SpaceFilter("new"));
        SpaceStorageTest.assertEquals((String)("memberSpacesCount must be: " + countSpace), (int)countSpace, (int)memberSpacesCount);
        memberSpacesCount = this.spaceStorage.getMemberSpacesByFilterCount("ghost", new SpaceFilter("m"));
        SpaceStorageTest.assertEquals((String)("memberSpacesCount must be: " + countSpace), (int)countSpace, (int)memberSpacesCount);
        memberSpacesCount = this.spaceStorage.getMemberSpacesByFilterCount("dragon", new SpaceFilter("add"));
        SpaceStorageTest.assertEquals((String)("memberSpacesCount must be: " + countSpace), (int)countSpace, (int)memberSpacesCount);
        memberSpacesCount = this.spaceStorage.getMemberSpacesByFilterCount("paul", new SpaceFilter("space"));
        SpaceStorageTest.assertEquals((String)"memberSpacesCount must be: 0", (int)0, (int)memberSpacesCount);
    }

    public void testGetManagerSpacesByFilterCount() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int managerSpacesCount = this.spaceStorage.getManagerSpacesByFilterCount("raul", new SpaceFilter("my space test"));
        SpaceStorageTest.assertEquals((String)"managerSpacesCount must be: 0", (int)0, (int)managerSpacesCount);
        managerSpacesCount = this.spaceStorage.getManagerSpacesByFilterCount("ghost", new SpaceFilter("add new"));
        SpaceStorageTest.assertEquals((String)"managerSpacesCount must be: 0", (int)0, (int)managerSpacesCount);
        managerSpacesCount = this.spaceStorage.getManagerSpacesByFilterCount("dragon", new SpaceFilter("space"));
        SpaceStorageTest.assertEquals((String)"managerSpacesCount must be: 0", (int)0, (int)managerSpacesCount);
        managerSpacesCount = this.spaceStorage.getManagerSpacesByFilterCount("demo", new SpaceFilter("space"));
        SpaceStorageTest.assertEquals((String)("managerSpacesCount must be: " + countSpace), (int)countSpace, (int)managerSpacesCount);
        managerSpacesCount = this.spaceStorage.getManagerSpacesByFilterCount("demo", new SpaceFilter("old"));
        SpaceStorageTest.assertEquals((String)"managerSpacesCount must be: 0", (int)0, (int)managerSpacesCount);
    }

    public void testGetMemberSpacesWithListAccess() throws Exception {
        int countSpace = 10;
        for (int i = 0; i < countSpace; ++i) {
            Space space = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(space, true);
            this.persist();
        }
        List memberSpaces = this.spaceStorage.getMemberSpaces("raul", 0L, 5L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)"memberSpaces.size() must return: 5", (int)5, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpaces("ghost", 0L, (long)countSpace);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)("memberSpaces.size() must return: " + countSpace), (int)countSpace, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpaces("dragon", 0L, 6L);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)"memberSpaces.size() must return: 6", (int)6, (int)memberSpaces.size());
        memberSpaces = this.spaceStorage.getMemberSpaces("paul", 0L, (long)countSpace);
        SpaceStorageTest.assertNotNull((String)"memberSpaces must not be  null", (Object)memberSpaces);
        SpaceStorageTest.assertEquals((String)"memberSpaces.size() must return: 0", (int)0, (int)memberSpaces.size());
    }

    public void testGetSpaceById() throws Exception {
        int number = 1;
        Space space = this.getSpaceInstance(number);
        space.setPublicSiteId(3L);
        space.setPublicSiteVisibility("internal");
        this.spaceStorage.saveSpace(space, true);
        this.persist();
        Space savedSpace = this.spaceStorage.getSpaceById(space.getId());
        SpaceStorageTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceStorageTest.assertNotNull((String)"savedSpace.getId() must not be null", (Object)savedSpace.getId());
        SpaceStorageTest.assertEquals((String)("space.getId() must return: " + space.getId()), (String)space.getId(), (String)savedSpace.getId());
        SpaceStorageTest.assertEquals((String)("space.getPrettyName() must return: " + space.getPrettyName()), (String)space.getPrettyName(), (String)savedSpace.getPrettyName());
        SpaceStorageTest.assertEquals((String)("space.getRegistration() must return: " + space.getRegistration()), (String)space.getRegistration(), (String)savedSpace.getRegistration());
        SpaceStorageTest.assertEquals((String)("space.getDescription() must return: " + space.getDescription()), (String)space.getDescription(), (String)savedSpace.getDescription());
        SpaceStorageTest.assertEquals((String)("space.getVisibility() must return: " + space.getVisibility()), (String)space.getVisibility(), (String)savedSpace.getVisibility());
        SpaceStorageTest.assertEquals((String)("space.getPublicSiteId() must return: " + space.getPublicSiteId()), (long)space.getPublicSiteId(), (long)savedSpace.getPublicSiteId());
        SpaceStorageTest.assertEquals((String)("space.getPublicSiteVisibility() must return: " + space.getPublicSiteVisibility()), (String)space.getPublicSiteVisibility(), (String)savedSpace.getPublicSiteVisibility());
    }

    public void testGetSpaceByGroupId() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.spaceStorage.saveSpace(space, true);
        this.persist();
        Space savedSpace = this.spaceStorage.getSpaceByGroupId(space.getGroupId());
        SpaceStorageTest.assertNotNull((String)"savedSpace must not be null", (Object)savedSpace);
        SpaceStorageTest.assertEquals((String)space.getId(), (String)savedSpace.getId());
    }

    public void testGetSpaceByPrettyName() throws Exception {
        int number = 1;
        Space space = this.getSpaceInstance(number);
        this.spaceStorage.saveSpace(space, true);
        this.persist();
        Space foundSpaceList = this.spaceStorage.getSpaceByPrettyName(space.getPrettyName());
        SpaceStorageTest.assertNotNull((String)"foundSpaceList must not be null", (Object)foundSpaceList);
        SpaceStorageTest.assertNotNull((String)"foundSpaceList.getId() must not be null", (Object)foundSpaceList.getId());
        SpaceStorageTest.assertEquals((String)("space.getId() must return: " + space.getId()), (String)space.getId(), (String)foundSpaceList.getId());
        SpaceStorageTest.assertEquals((String)("space.getPrettyName() must return: " + space.getPrettyName()), (String)space.getPrettyName(), (String)foundSpaceList.getPrettyName());
        SpaceStorageTest.assertEquals((String)("space.getRegistration() must return: " + space.getRegistration()), (String)space.getRegistration(), (String)foundSpaceList.getRegistration());
        SpaceStorageTest.assertEquals((String)("space.getDescription() must return: " + space.getDescription()), (String)space.getDescription(), (String)foundSpaceList.getDescription());
        SpaceStorageTest.assertEquals((String)("space.getVisibility() must return: " + space.getVisibility()), (String)space.getVisibility(), (String)foundSpaceList.getVisibility());
    }

    public void testDeleteSpace() throws Exception {
        int number = 1;
        Space space = this.getSpaceInstance(number);
        this.spaceStorage.saveSpace(space, true);
        this.persist();
        this.spaceStorage.deleteSpace(space.getId());
    }

    public void testSaveSpace() throws Exception {
        int number = 1;
        Space space = this.getSpaceInstance(number);
        this.spaceStorage.saveSpace(space, true);
        SpaceStorageTest.assertNotNull((String)"space.getId() must not be null", (Object)space.getId());
        String newName = "newnamespace";
        space.setDisplayName(newName);
        space.setPrettyName(space.getDisplayName());
        this.spaceStorage.saveSpace(space, false);
        this.persist();
        SpaceStorageTest.assertEquals((String)newName, (String)this.spaceStorage.getSpaceById(space.getId()).getPrettyName());
        SpaceStorageTest.assertEquals((String)newName, (String)space.getPrettyName());
        Space got = this.spaceStorage.getSpaceById(space.getId());
        SpaceStorageTest.assertNotNull((Object)got.getAvatarUrl());
    }

    public void testRenameSpace() throws Exception {
        int number = 1;
        Space space = this.getSpaceInstance(number);
        this.spaceStorage.saveSpace(space, true);
        SpaceStorageTest.assertNotNull((String)"space.getId() must not be null", (Object)space.getId());
        String newName = "newnamespace";
        space.setDisplayName(newName);
        space.setPrettyName(space.getDisplayName());
        this.spaceStorage.saveSpace(space, false);
        this.persist();
        SpaceStorageTest.assertEquals((String)("spaceStorage.getSpaceById(space.getId()).getName() must return: " + newName), (String)newName, (String)this.spaceStorage.getSpaceById(space.getId()).getPrettyName());
        SpaceStorageTest.assertEquals((String)("space.getName() must return: " + newName), (String)newName, (String)space.getPrettyName());
        Space got = this.spaceStorage.getSpaceById(space.getId());
        SpaceStorageTest.assertNotNull((Object)got.getAvatarUrl());
        Identity spaceIdentity = new Identity("space", got.getPrettyName());
        this.identityStorage.saveIdentity(spaceIdentity);
        String newDisplayName = "new display name";
        this.spaceStorage.renameSpace(space, newDisplayName);
        got = this.spaceStorage.getSpaceById(space.getId());
        SpaceStorageTest.assertEquals((String)newDisplayName, (String)got.getDisplayName());
    }

    public void testUpdateSpace() throws Exception {
        int number = 1;
        Space space = this.getSpaceInstance(number);
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/eXo-Social.png");
        AvatarAttachment avatarAttachment = new AvatarAttachment(null, "avatar", "png", inputStream, System.currentTimeMillis());
        SpaceStorageTest.assertNotNull((String)"avatar attachment should not be null", (Object)avatarAttachment);
        space.setAvatarAttachment(avatarAttachment);
        this.spaceStorage.saveSpace(space, true);
        this.persist();
        Identity identity = new Identity("space", space.getPrettyName());
        Profile profile = new Profile(identity);
        identity.setProfile(profile);
        profile.setProperty("avatar", (Object)avatarAttachment);
        this.identityStorage.saveIdentity(identity);
        long lastUpdatedTime = space.getLastUpdatedTime();
        Space spaceForUpdate = this.spaceStorage.getSpaceById(space.getId());
        this.spaceStorage.saveSpace(spaceForUpdate, false);
        this.persist();
        Space got = this.spaceStorage.getSpaceById(spaceForUpdate.getId());
        SpaceStorageTest.assertNotNull((String)"avatar URL should not be null", (Object)got.getAvatarUrl());
        SpaceStorageTest.assertTrue((got.getLastUpdatedTime() >= lastUpdatedTime ? 1 : 0) != 0);
    }

    public void testGetVisibleSpaces() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "open", "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "open", "demo", new String[0]);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int countSpace1 = 10;
        List visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace1), (int)countSpace1, (int)visibleAllSpaces.size());
        int privateSpace1 = 6;
        List privateSpaces = this.spaceStorage.getVisibleSpaces("mary", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)privateSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + privateSpace1), (int)privateSpace1, (int)privateSpaces.size());
    }

    public void testGetVisibleSpacesWithValidate() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "validation", "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "validation", "demo", new String[0]);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int countSpace1 = 10;
        List visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace1), (int)countSpace1, (int)visibleAllSpaces.size());
        int countSpace2 = 10;
        visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", new SpaceFilter("M"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace2), (int)countSpace2, (int)visibleAllSpaces.size());
        int privateSpace1 = 6;
        List privateSpaces = this.spaceStorage.getVisibleSpaces("mary", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)privateSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + privateSpace1), (int)privateSpace1, (int)privateSpaces.size());
    }

    public void testGetVisibleSpacesFilterByName() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "open", "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "open", "demo", new String[0]);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int countSpace1 = 10;
        List visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace1), (int)countSpace1, (int)visibleAllSpaces.size());
        int countSpace2 = 10;
        visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", new SpaceFilter("my space test"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace2), (int)countSpace2, (int)visibleAllSpaces.size());
        int countSpace3 = 0;
        visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", new SpaceFilter("your space"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace3), (int)countSpace3, (int)visibleAllSpaces.size());
        int privateSpace1 = 6;
        List privateSpaces = this.spaceStorage.getVisibleSpaces("mary", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)privateSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + privateSpace1), (int)privateSpace1, (int)privateSpaces.size());
        int privateSpace2 = 6;
        privateSpaces = this.spaceStorage.getVisibleSpaces("mary", new SpaceFilter("my space test"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)privateSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + privateSpace2), (int)privateSpace2, (int)privateSpaces.size());
        int privateSpace3 = 0;
        privateSpaces = this.spaceStorage.getVisibleSpaces("mary", new SpaceFilter("your space"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)privateSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + privateSpace3), (int)privateSpace3, (int)privateSpaces.size());
    }

    public void testGetVisibleSpacesCloseRegistration() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "closed", "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "closed", "demo", new String[0]);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace), (int)countSpace, (int)visibleAllSpaces.size());
        int registrationCloseSpaceCount = 6;
        List registrationCloseSpaces = this.spaceStorage.getVisibleSpaces("mary", null);
        SpaceStorageTest.assertNotNull((String)"registrationCloseSpaces must not be  null", (Object)registrationCloseSpaces);
        SpaceStorageTest.assertEquals((String)("registrationCloseSpaces must return: " + registrationCloseSpaceCount), (int)registrationCloseSpaceCount, (int)registrationCloseSpaces.size());
    }

    public void testGetVisibleSpacesCloseRegistrationByFilter() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstance(i, "private", "closed", "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "closed", "demo", new String[0]);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        int countSpace1 = 10;
        List<Space> visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", new SpaceFilter("M"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace1), (int)countSpace1, (int)visibleAllSpaces.size());
        int countSpace3 = 10;
        visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", new SpaceFilter("my space test"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace3), (int)countSpace3, (int)visibleAllSpaces.size());
        int countSpace4 = 10;
        visibleAllSpaces = this.getSpaceWithRoot(new SpaceFilter("my space test"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace4), (int)countSpace4, (int)visibleAllSpaces.size());
        int countSpace5 = 10;
        visibleAllSpaces = this.getSpaceWithRoot(null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace5), (int)countSpace5, (int)visibleAllSpaces.size());
        int countSpace6 = 0;
        visibleAllSpaces = this.getSpaceWithRoot(new SpaceFilter("your space"));
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace6), (int)countSpace6, (int)visibleAllSpaces.size());
        int registrationCloseSpaceCount1 = 6;
        List registrationCloseSpaces = this.spaceStorage.getVisibleSpaces("mary", new SpaceFilter("M"));
        SpaceStorageTest.assertNotNull((String)"registrationCloseSpaces must not be  null", (Object)registrationCloseSpaces);
        SpaceStorageTest.assertEquals((String)("registrationCloseSpaces must return: " + registrationCloseSpaceCount1), (int)registrationCloseSpaceCount1, (int)registrationCloseSpaces.size());
        int registrationCloseSpaceCount2 = 10;
        List registrationCloseSpaces1 = this.spaceStorage.getSpacesByFilter(new SpaceFilter("M"), 0L, 200L);
        SpaceStorageTest.assertNotNull((String)"registrationCloseSpaces must not be  null", (Object)registrationCloseSpaces1);
        SpaceStorageTest.assertEquals((String)("registrationCloseSpaces must return: " + registrationCloseSpaceCount2), (int)registrationCloseSpaceCount2, (int)registrationCloseSpaces1.size());
    }

    public void testGetVisibleSpacesInvitedMember() throws Exception {
        int countSpace = 10;
        Space[] listSpace = new Space[10];
        for (int i = 0; i < countSpace; ++i) {
            listSpace[i] = i < 6 ? this.getSpaceInstanceInvitedMember(i, "private", "closed", new String[]{"mary", "hacker"}, "demo", new String[0]) : this.getSpaceInstance(i, "hidden", "closed", "demo", new String[0]);
            this.spaceStorage.saveSpace(listSpace[i], true);
            this.persist();
        }
        List visibleAllSpaces = this.spaceStorage.getVisibleSpaces("demo", null);
        SpaceStorageTest.assertNotNull((String)"visibleSpaces must not be  null", (Object)visibleAllSpaces);
        SpaceStorageTest.assertEquals((String)("visibleSpaces() must return: " + countSpace), (int)countSpace, (int)visibleAllSpaces.size());
        int invitedSpaceCount1 = 6;
        List invitedSpaces1 = this.spaceStorage.getVisibleSpaces("mary", null);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces1);
        SpaceStorageTest.assertEquals((String)("invitedSpaces must return: " + invitedSpaceCount1), (int)invitedSpaceCount1, (int)invitedSpaces1.size());
        invitedSpaceCount1 = 6;
        invitedSpaces1 = this.spaceStorage.getVisibleSpaces("hacker", null);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces1);
        SpaceStorageTest.assertEquals((String)("invitedSpaces must return: " + invitedSpaceCount1), (int)invitedSpaceCount1, (int)invitedSpaces1.size());
        int invitedSpaceCount2 = 6;
        List invitedSpaces2 = this.spaceStorage.getVisibleSpaces("paul", null);
        SpaceStorageTest.assertNotNull((String)"invitedSpaces must not be  null", (Object)invitedSpaces2);
        SpaceStorageTest.assertEquals((String)("invitedSpaces must return: " + invitedSpaceCount2), (int)invitedSpaceCount2, (int)invitedSpaces2.size());
    }

    public void testVisited() throws Exception {
        Space space0 = this.getSpaceInstance(5);
        this.spaceStorage.saveSpace(space0, true);
        Space space1 = this.getSpaceInstance(6);
        this.spaceStorage.saveSpace(space1, true);
        SpaceFilter filter = new SpaceFilter();
        filter.setRemoteId("ghost");
        List result = this.spaceStorage.getVisitedSpaces(filter, 0, -1);
        SpaceStorageTest.assertEquals((int)2, (int)result.size());
        SpaceStorageTest.assertEquals((String)space0.getId(), (String)((Space)result.get(0)).getId());
        this.restartTransaction();
        this.spaceStorage.updateSpaceAccessed("ghost", space1);
        result = this.spaceStorage.getVisitedSpaces(filter, 0, -1);
        SpaceStorageTest.assertEquals((int)2, (int)result.size());
        SpaceStorageTest.assertEquals((String)space1.getId(), (String)((Space)result.get(0)).getId());
    }

    public void testLastAccess() throws Exception {
        Space space2 = this.getSpaceInstance(7);
        this.spaceStorage.saveSpace(space2, true);
        Space space3 = this.getSpaceInstance(8);
        this.spaceStorage.saveSpace(space3, true);
        SpaceFilter filter = new SpaceFilter();
        filter.setRemoteId("ghost");
        List result = this.spaceStorage.getLastAccessedSpace(filter, 0, -1);
        SpaceStorageTest.assertEquals((int)2, (int)result.size());
        SpaceStorageTest.assertEquals((String)space2.getId(), (String)((Space)result.get(0)).getId());
        this.restartTransaction();
        this.spaceStorage.updateSpaceAccessed("ghost", space3);
        result = this.spaceStorage.getLastAccessedSpace(filter, 0, -1);
        SpaceStorageTest.assertEquals((int)2, (int)result.size());
        SpaceStorageTest.assertEquals((String)space3.getId(), (String)((Space)result.get(0)).getId());
    }

    public void testGetLastAccessedSpace() {
        Space space = this.getSpaceInstance(1);
        this.spaceStorage.saveSpace(space, true);
        this.spaceStorage.updateSpaceAccessed("raul", space);
        this.cacheService.getSpacesCache().clearCache();
        SpaceFilter filter = new SpaceFilter();
        filter.setRemoteId("raul");
        this.spaceStorage.getLastAccessedSpace(filter, 0, 10);
        this.cacheService.getSpaceCache().clearCache();
        this.spaceStorage.getLastAccessedSpace(filter, 0, 10);
        Space spaceFromCache = this.spaceStorage.getSpaceById(space.getId());
        SpaceStorageTest.assertNotNull((Object)spaceFromCache.getMembers());
        SpaceStorageTest.assertEquals((int)5, (int)spaceFromCache.getMembers().length);
        SpaceStorageTest.assertNotNull((Object)spaceFromCache.getManagers());
        SpaceStorageTest.assertEquals((int)2, (int)spaceFromCache.getManagers().length);
    }

    public void testGetLastAccessedPagination() throws Exception {
        SpaceStorageTest.assertEquals((int)0, (int)this.spaceService.getLastAccessedSpace("raul").getSize());
        int numberOfSpaces = 5;
        for (int i = 0; i < numberOfSpaces; ++i) {
            Space s = this.getSpaceInstance(i);
            this.spaceStorage.saveSpace(s, true);
            s = this.spaceStorage.getSpaceByPrettyName(s.getPrettyName());
            SpaceStorageTest.assertNotNull((Object)s);
            this.restartTransaction();
            this.spaceService.updateSpaceAccessed("raul", s);
            this.restartTransaction();
            SpaceFilter filter = new SpaceFilter();
            filter.setRemoteId("raul");
            List spaces = this.spaceStorage.getLastAccessedSpace(filter, 0, 10);
            SpaceStorageTest.assertEquals((String)s.getPrettyName(), (String)((Space)spaces.get(0)).getPrettyName());
            spaces = this.spaceStorage.getLastAccessedSpace(filter, 0, i + 1);
            SpaceStorageTest.assertEquals((String)s.getPrettyName(), (String)((Space)spaces.get(0)).getPrettyName());
        }
        ListAccess spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        Space[] spaces = (Space[])spacesListAccess.load(0, 2);
        SpaceStorageTest.assertEquals((int)2, (int)spaces.length);
        SpaceStorageTest.assertEquals((String)"my_space_test_4", (String)spaces[0].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_3", (String)spaces[1].getPrettyName());
        Space space6 = this.getSpaceInstance(6);
        this.spaceStorage.saveSpace(space6, true);
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(0, 2);
        SpaceStorageTest.assertEquals((int)2, (int)spaces.length);
        SpaceStorageTest.assertEquals((String)"my_space_test_4", (String)spaces[0].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_3", (String)spaces[1].getPrettyName());
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(2, 10);
        SpaceStorageTest.assertEquals((int)4, (int)spaces.length);
        SpaceStorageTest.assertEquals((String)"my_space_test_2", (String)spaces[0].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_1", (String)spaces[1].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_0", (String)spaces[2].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_6", (String)spaces[3].getPrettyName());
        this.spaceService.updateSpaceAccessed("raul", space6);
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(0, 2);
        SpaceStorageTest.assertEquals((int)2, (int)spaces.length);
        SpaceStorageTest.assertEquals((String)"my_space_test_6", (String)spaces[0].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_4", (String)spaces[1].getPrettyName());
        spacesListAccess = this.spaceService.getLastAccessedSpace("raul");
        spaces = (Space[])spacesListAccess.load(2, 10);
        SpaceStorageTest.assertEquals((int)4, (int)spaces.length);
        SpaceStorageTest.assertEquals((String)"my_space_test_3", (String)spaces[0].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_2", (String)spaces[1].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_1", (String)spaces[2].getPrettyName());
        SpaceStorageTest.assertEquals((String)"my_space_test_0", (String)spaces[3].getPrettyName());
    }

    public void testGetCommonSpaces() throws Exception {
        Space space1 = this.getSpaceInstance(11, "public", "open", "demo", "ghost", "dragon");
        Space space2 = this.getSpaceInstance(12, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space3 = this.getSpaceInstance(13, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space4 = this.getSpaceInstance(14, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space5 = this.getSpaceInstance(15, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space6 = this.getSpaceInstance(16, "public", "open", "demo", "ghost", "dragon", "raul");
        this.spaceStorage.saveSpace(space1, true);
        this.spaceStorage.saveSpace(space2, true);
        this.spaceStorage.saveSpace(space3, true);
        this.spaceStorage.saveSpace(space4, true);
        this.spaceStorage.saveSpace(space5, true);
        this.spaceStorage.saveSpace(space6, true);
        List resultListCommonSpaces1 = this.spaceStorage.getCommonSpaces("demo", "raul", 0, 2);
        SpaceStorageTest.assertEquals((int)2, (int)resultListCommonSpaces1.size());
        Space testSpace2 = (Space)resultListCommonSpaces1.get(0);
        SpaceStorageTest.assertEquals((Object)space2, (Object)testSpace2);
        Space testSpace3 = (Space)resultListCommonSpaces1.get(1);
        SpaceStorageTest.assertEquals((Object)space3, (Object)testSpace3);
        List resultListCommonSpaces2 = this.spaceStorage.getCommonSpaces("demo", "raul", 2, 2);
        SpaceStorageTest.assertEquals((int)2, (int)resultListCommonSpaces2.size());
        Space testSpace4 = (Space)resultListCommonSpaces2.get(0);
        SpaceStorageTest.assertEquals((Object)space4, (Object)testSpace4);
        Space testSpace5 = (Space)resultListCommonSpaces2.get(1);
        SpaceStorageTest.assertEquals((Object)space5, (Object)testSpace5);
        List resultListCommonSpaces3 = this.spaceStorage.getCommonSpaces("demo", "raul", 4, 2);
        SpaceStorageTest.assertEquals((int)1, (int)resultListCommonSpaces3.size());
        Space testSpace6 = (Space)resultListCommonSpaces3.get(0);
        SpaceStorageTest.assertEquals((Object)space6, (Object)testSpace6);
    }

    public void testCountCommonSpaces() throws Exception {
        Space space3 = this.getSpaceInstance(11, "public", "open", "demo", "ghost", "dragon");
        Space space1 = this.getSpaceInstance(12, "public", "open", "demo", "ghost", "dragon", "raul");
        Space space2 = this.getSpaceInstance(13, "public", "open", "demo", "ghost", "dragon", "raul");
        this.spaceStorage.saveSpace(space3, true);
        this.spaceStorage.saveSpace(space1, true);
        this.spaceStorage.saveSpace(space2, true);
        int resultListCommonSpaces = this.spaceStorage.countCommonSpaces("demo", "raul");
        SpaceStorageTest.assertEquals((int)2, (int)resultListCommonSpaces);
    }
}

