/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.FileAttachmentObject;
import org.exoplatform.social.attachment.model.FileAttachmentResourceList;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.ObjectAttachmentOperationReport;
import org.exoplatform.social.core.attachment.storage.FileAttachmentStorage;
import org.exoplatform.social.core.mock.MockUploadService;
import org.exoplatform.social.core.test.AbstractCoreTest;
import org.exoplatform.upload.UploadService;
import org.junit.Assert;

public class AttachmentServiceTest
extends AbstractCoreTest {
    private static final String FORMAT = "landscape";
    private static final String ALT_TEXT = "Test alternative text";
    private static final String USERNAME = "demo";
    private static final String MIME_TYPE = "image/png";
    private static final String FILE_NAME = "cover.png";
    private static final String UPLOAD_ID = "1234";
    private static final String OBJECT_TYPE = "objectType";
    private static final String DEST_OBJECT_TYPE = "destinationObjectType";
    private static final Random RANDOM = new Random();
    private Map<String, Long> eventCounts = new HashMap<String, Long>();
    private Listener<?, ?> listener;
    private ListenerService listenerService;
    private MockUploadService uploadService;
    private FileAttachmentStorage attachmentStorage;
    private AttachmentService attachmentService;
    private AtomicBoolean hasEditPermission = new AtomicBoolean();
    private AtomicBoolean hasViewPermission = new AtomicBoolean();
    private long attachmentSpaceId = 0L;
    private long attachmentAudienceId = 0L;
    private String objectId;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.attachmentService = (AttachmentService)this.getContainer().getComponentInstanceOfType(AttachmentService.class);
        this.listenerService = (ListenerService)this.getContainer().getComponentInstanceOfType(ListenerService.class);
        this.uploadService = (MockUploadService)((Object)this.getContainer().getComponentInstanceOfType(UploadService.class));
        this.attachmentStorage = (FileAttachmentStorage)this.getContainer().getComponentInstanceOfType(FileAttachmentStorage.class);
        if (this.listener == null) {
            this.listener = new Listener<Object, Object>(){

                public void onEvent(Event<Object, Object> event) throws Exception {
                    String eventName = event.getEventName();
                    long count = AttachmentServiceTest.this.eventCounts.computeIfAbsent(eventName, key -> 0L);
                    AttachmentServiceTest.this.eventCounts.put(eventName, count + 1L);
                }
            };
            this.listenerService.addListener("attachment.created", this.listener);
            this.listenerService.addListener("attachment.deleted", this.listener);
            this.listenerService.addListener("attachments.updated", this.listener);
            this.listenerService.addListener("attachments.deleted", this.listener);
            AttachmentPlugin attachmentPlugin = new AttachmentPlugin(){

                public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
                    return AttachmentServiceTest.this.hasEditPermission.get();
                }

                public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
                    return AttachmentServiceTest.this.hasViewPermission.get();
                }

                public long getSpaceId(String objectId) throws ObjectNotFoundException {
                    return AttachmentServiceTest.this.attachmentSpaceId;
                }

                public String getObjectType() {
                    return AttachmentServiceTest.OBJECT_TYPE;
                }

                public long getAudienceId(String objectId) throws ObjectNotFoundException {
                    return AttachmentServiceTest.this.attachmentAudienceId;
                }
            };
            this.attachmentService.addPlugin(attachmentPlugin);
        } else {
            this.eventCounts.clear();
        }
        this.objectId = "objectId" + RANDOM.nextInt();
    }

    public void testUpdateAttachments() throws Exception {
        Identity userAcl = this.startSessionAndRegisterAs(USERNAME);
        String fileId = this.createAttachment(USERNAME);
        String identityId = this.identityManager.getOrCreateUserIdentity(USERNAME).getId();
        FileAttachmentResourceList attachmentList = new FileAttachmentResourceList();
        ArrayList<FileAttachmentObject> fileAttachmentObjectList = new ArrayList<FileAttachmentObject>();
        FileAttachmentObject fileAttachmentObject = new FileAttachmentObject();
        fileAttachmentObject.setId(fileId);
        fileAttachmentObjectList.add(fileAttachmentObject);
        attachmentList.setAttachedFiles(fileAttachmentObjectList);
        ArrayList<FileAttachmentObject> fileUploadedObjectList = new ArrayList<FileAttachmentObject>();
        FileAttachmentObject fileUploadedObject = new FileAttachmentObject();
        attachmentList.setUploadedFiles(new ArrayList());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.saveAttachments(null, userAcl));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.saveAttachments(attachmentList, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.saveAttachments(attachmentList, userAcl));
        attachmentList.setUserIdentityId(Long.parseLong(identityId));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.saveAttachments(attachmentList, userAcl));
        attachmentList.setObjectType(OBJECT_TYPE);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.saveAttachments(attachmentList, userAcl));
        attachmentList.setObjectId(this.objectId);
        Assert.assertThrows(IllegalAccessException.class, () -> this.attachmentService.saveAttachments(attachmentList, userAcl));
        this.hasViewPermission.set(true);
        Assert.assertThrows(IllegalAccessException.class, () -> this.attachmentService.saveAttachments(attachmentList, userAcl));
        this.hasEditPermission.set(true);
        this.hasViewPermission.set(false);
        this.assertListenerCount(1L, 0L, 1L, 0L);
        ObjectAttachmentOperationReport report = this.attachmentService.saveAttachments(attachmentList, userAcl);
        AttachmentServiceTest.assertNotNull((Object)report);
        this.assertListenerCount(1L, 0L, 3L, 0L);
        ObjectAttachmentList objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
        AttachmentServiceTest.assertNotNull((Object)objectAttachmentList);
        List attachments = objectAttachmentList.getAttachments();
        AttachmentServiceTest.assertEquals((int)1, (int)attachments.size());
        ObjectAttachmentDetail attachmentDetail = (ObjectAttachmentDetail)attachments.get(0);
        AttachmentServiceTest.assertNotNull((Object)attachmentDetail);
        AttachmentServiceTest.assertEquals((String)FILE_NAME, (String)attachmentDetail.getName());
        AttachmentServiceTest.assertEquals((String)MIME_TYPE, (String)attachmentDetail.getMimetype());
        AttachmentServiceTest.assertEquals((String)fileId, (String)attachmentDetail.getId());
        AttachmentServiceTest.assertTrue((attachmentDetail.getUpdated() > 0L ? 1 : 0) != 0);
        AttachmentServiceTest.assertEquals((String)identityId, (String)attachmentDetail.getUpdater());
        fileUploadedObject.setUploadId(UPLOAD_ID);
        fileUploadedObject.setAltText("");
        fileUploadedObject.setFormat("");
        fileUploadedObjectList.add(fileUploadedObject);
        attachmentList.setUploadedFiles(fileUploadedObjectList);
        attachmentList.setAttachedFiles(fileAttachmentObjectList);
        this.uploadResource();
        report = this.attachmentService.saveAttachments(attachmentList, userAcl);
        AttachmentServiceTest.assertNotNull((Object)report);
        this.assertListenerCount(2L, 0L, 5L, 0L);
        objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
        AttachmentServiceTest.assertNotNull((Object)objectAttachmentList);
        attachments = objectAttachmentList.getAttachments();
        AttachmentServiceTest.assertEquals((int)2, (int)attachments.size());
        attachmentDetail = (ObjectAttachmentDetail)attachments.get(0);
        AttachmentServiceTest.assertNotNull((Object)attachmentDetail);
        AttachmentServiceTest.assertEquals((String)fileId, (String)((ObjectAttachmentDetail)attachments.get(0)).getId());
        AttachmentServiceTest.assertEquals((String)FILE_NAME, (String)attachmentDetail.getName());
        AttachmentServiceTest.assertEquals((String)MIME_TYPE, (String)attachmentDetail.getMimetype());
        AttachmentServiceTest.assertNotNull((Object)attachmentDetail.getId());
        AttachmentServiceTest.assertTrue((attachmentDetail.getUpdated() > 0L ? 1 : 0) != 0);
        AttachmentServiceTest.assertEquals((String)identityId, (String)attachmentDetail.getUpdater());
        attachmentList.setAttachedFiles(Collections.singletonList(fileAttachmentObject));
        attachmentList.setUploadedFiles(new ArrayList());
        report = this.attachmentService.saveAttachments(attachmentList, userAcl);
        AttachmentServiceTest.assertNotNull((Object)report);
        this.assertListenerCount(2L, 1L, 7L, 0L);
        objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
        attachments = objectAttachmentList.getAttachments();
        AttachmentServiceTest.assertEquals((int)1, (int)attachments.size());
        attachmentDetail = (ObjectAttachmentDetail)attachments.get(0);
        AttachmentServiceTest.assertNotNull((Object)attachmentDetail);
        AttachmentServiceTest.assertEquals((String)FILE_NAME, (String)attachmentDetail.getName());
        AttachmentServiceTest.assertEquals((String)MIME_TYPE, (String)attachmentDetail.getMimetype());
        AttachmentServiceTest.assertEquals((String)fileId, (String)attachmentDetail.getId());
        AttachmentServiceTest.assertTrue((attachmentDetail.getUpdated() > 0L ? 1 : 0) != 0);
        AttachmentServiceTest.assertEquals((String)identityId, (String)attachmentDetail.getUpdater());
        ObjectAttachmentDetail attachment = this.attachmentStorage.getAttachment(new ObjectAttachmentId(fileId, OBJECT_TYPE, this.objectId));
        AttachmentServiceTest.assertNotNull((Object)attachment);
        attachmentList.setAttachedFiles(new ArrayList());
        attachmentList.setUploadedFiles(new ArrayList());
        report = this.attachmentService.saveAttachments(attachmentList, userAcl);
        AttachmentServiceTest.assertNull((Object)report);
        this.assertListenerCount(2L, 2L, 8L, 0L);
        objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
        attachments = objectAttachmentList.getAttachments();
        AttachmentServiceTest.assertEquals((int)0, (int)attachments.size());
        attachment = this.attachmentService.getAttachment(OBJECT_TYPE, this.objectId, fileId);
        AttachmentServiceTest.assertNull((Object)attachment);
    }

    public void testGetAttachments() throws Exception {
        Identity userAcl = this.startSessionAndRegisterAs(USERNAME);
        String fileId = this.createAttachment(USERNAME);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachments(null, this.objectId, userAcl));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachments(OBJECT_TYPE, null, userAcl));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId, null));
        this.hasEditPermission.set(true);
        Assert.assertThrows(IllegalAccessException.class, () -> this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId, userAcl));
        this.hasEditPermission.set(false);
        this.hasViewPermission.set(true);
        ObjectAttachmentList objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId, userAcl);
        AttachmentServiceTest.assertNotNull((Object)objectAttachmentList);
        List attachments = objectAttachmentList.getAttachments();
        AttachmentServiceTest.assertEquals((int)1, (int)attachments.size());
        ObjectAttachmentDetail attachmentDetail = (ObjectAttachmentDetail)attachments.get(0);
        AttachmentServiceTest.assertNotNull((Object)attachmentDetail);
        AttachmentServiceTest.assertEquals((String)FILE_NAME, (String)attachmentDetail.getName());
        AttachmentServiceTest.assertEquals((String)MIME_TYPE, (String)attachmentDetail.getMimetype());
        AttachmentServiceTest.assertEquals((String)fileId, (String)attachmentDetail.getId());
        AttachmentServiceTest.assertTrue((attachmentDetail.getUpdated() > 0L ? 1 : 0) != 0);
    }

    public void testGetAttachment() throws Exception {
        String fileId = this.createAttachment(USERNAME);
        Identity userAcl = this.startSessionAndRegisterAs(USERNAME);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachment(null, this.objectId, fileId, userAcl));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachment(OBJECT_TYPE, null, fileId, userAcl));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachment(OBJECT_TYPE, this.objectId, fileId, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachment(OBJECT_TYPE, this.objectId, null, userAcl));
        this.hasEditPermission.set(true);
        Assert.assertThrows(IllegalAccessException.class, () -> this.attachmentService.getAttachment(OBJECT_TYPE, this.objectId, fileId, userAcl));
        this.hasEditPermission.set(false);
        this.hasViewPermission.set(true);
        ObjectAttachmentDetail attachmentDetail = this.attachmentService.getAttachment(OBJECT_TYPE, this.objectId, fileId, userAcl);
        AttachmentServiceTest.assertNotNull((Object)attachmentDetail);
        AttachmentServiceTest.assertEquals((String)FILE_NAME, (String)attachmentDetail.getName());
        AttachmentServiceTest.assertEquals((String)MIME_TYPE, (String)attachmentDetail.getMimetype());
        AttachmentServiceTest.assertEquals((String)fileId, (String)attachmentDetail.getId());
        AttachmentServiceTest.assertTrue((attachmentDetail.getUpdated() > 0L ? 1 : 0) != 0);
    }

    public void testGetAttachmentInputStream() throws Exception {
        String fileId = this.createAttachment(USERNAME);
        Identity userAclIdentity = this.startSessionAndRegisterAs(USERNAME);
        Assert.assertThrows(IllegalAccessException.class, () -> this.attachmentService.getAttachmentInputStream(OBJECT_TYPE, this.objectId, fileId, "0x0", userAclIdentity));
        this.hasViewPermission.set(true);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachmentInputStream(null, this.objectId, fileId, "0x0", userAclIdentity));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachmentInputStream(OBJECT_TYPE, null, fileId, "0x0", userAclIdentity));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.attachmentService.getAttachmentInputStream(OBJECT_TYPE, this.objectId, null, "0x0", userAclIdentity));
        this.hasEditPermission.set(false);
        this.hasViewPermission.set(true);
        try (InputStream inputStream = this.attachmentService.getAttachmentInputStream(OBJECT_TYPE, this.objectId, fileId, "0x0", userAclIdentity);){
            AttachmentServiceTest.assertNotNull((Object)inputStream);
        }
        inputStream = this.attachmentService.getAttachmentInputStream(OBJECT_TYPE, this.objectId, fileId, null, userAclIdentity);
        try {
            AttachmentServiceTest.assertNotNull((Object)inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void testDeleteAttachments() throws Exception {
        String fileId = this.createAttachment(USERNAME);
        ObjectAttachmentList objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
        AttachmentServiceTest.assertNotNull((Object)objectAttachmentList);
        List attachments = objectAttachmentList.getAttachments();
        AttachmentServiceTest.assertEquals((int)1, (int)attachments.size());
        this.assertListenerCount(1L, 0L, 1L, 0L);
        AttachmentServiceTest.assertEquals((String)ALT_TEXT, (String)((ObjectAttachmentDetail)attachments.get(0)).getAltText());
        AttachmentServiceTest.assertEquals((String)FORMAT, (String)((ObjectAttachmentDetail)attachments.get(0)).getFormat());
        this.attachmentService.deleteAttachments(OBJECT_TYPE, this.objectId);
        objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
        AttachmentServiceTest.assertNotNull((Object)objectAttachmentList);
        attachments = objectAttachmentList.getAttachments();
        AttachmentServiceTest.assertEquals((int)0, (int)attachments.size());
        this.assertListenerCount(1L, 1L, 1L, 1L);
        ObjectAttachmentDetail attachment = this.attachmentService.getAttachment(OBJECT_TYPE, this.objectId, fileId);
        AttachmentServiceTest.assertNull((Object)attachment);
    }

    private void uploadResource() throws IOException, Exception {
        File tempFile = File.createTempFile("image", "temp");
        this.uploadService.createUploadResource(UPLOAD_ID, tempFile.getPath(), FILE_NAME, MIME_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createAttachment(String username) throws IOException, Exception {
        try {
            String identityId = this.identityManager.getOrCreateUserIdentity(username).getId();
            FileAttachmentResourceList attachmentList = new FileAttachmentResourceList();
            attachmentList.setAttachedFiles(null);
            attachmentList.setUserIdentityId(Long.parseLong(identityId));
            attachmentList.setObjectType(OBJECT_TYPE);
            attachmentList.setObjectId(this.objectId);
            this.hasEditPermission.set(true);
            FileAttachmentObject fileAttachmentObject = new FileAttachmentObject();
            fileAttachmentObject.setUploadId(UPLOAD_ID);
            fileAttachmentObject.setAltText(ALT_TEXT);
            fileAttachmentObject.setFormat(FORMAT);
            attachmentList.setUploadedFiles(Collections.singletonList(fileAttachmentObject));
            this.uploadResource();
            this.attachmentService.saveAttachments(attachmentList);
            ObjectAttachmentList objectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
            String string = ((ObjectAttachmentDetail)objectAttachmentList.getAttachments().get(0)).getId();
            return string;
        }
        finally {
            this.hasEditPermission.set(false);
        }
    }

    private void assertListenerCount(long createdCount, long deletedCount, long updatedListCount, long deletedListCount) {
        AttachmentServiceTest.assertEquals((long)createdCount, (long)this.eventCounts.getOrDefault("attachment.created", 0L));
        AttachmentServiceTest.assertEquals((long)deletedCount, (long)this.eventCounts.getOrDefault("attachment.deleted", 0L));
        AttachmentServiceTest.assertEquals((long)updatedListCount, (long)this.eventCounts.getOrDefault("attachments.updated", 0L));
        AttachmentServiceTest.assertEquals((long)deletedListCount, (long)this.eventCounts.getOrDefault("attachments.deleted", 0L));
    }

    public void testMoveAttachments() throws Exception {
        this.startSessionAndRegisterAs(USERNAME);
        String identityId = this.identityManager.getOrCreateUserIdentity(USERNAME).getId();
        String fileId = this.createAttachment(USERNAME);
        String destinationObjectId = "destinationObjectId" + System.currentTimeMillis();
        String destinationParentObjectId = null;
        this.attachmentService.moveAttachments(OBJECT_TYPE, this.objectId, DEST_OBJECT_TYPE, destinationObjectId, destinationParentObjectId, Long.parseLong(identityId));
        ObjectAttachmentList destinationObjectAttachmentList = this.attachmentService.getAttachments(DEST_OBJECT_TYPE, destinationObjectId);
        AttachmentServiceTest.assertNotNull((Object)destinationObjectAttachmentList);
        AttachmentServiceTest.assertEquals((int)1, (int)destinationObjectAttachmentList.getAttachments().size());
        AttachmentServiceTest.assertEquals((String)fileId, (String)((ObjectAttachmentDetail)destinationObjectAttachmentList.getAttachments().get(0)).getId());
        ObjectAttachmentList sourceObjectAttachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, this.objectId);
        AttachmentServiceTest.assertNotNull((Object)sourceObjectAttachmentList);
        AttachmentServiceTest.assertEquals((int)0, (int)sourceObjectAttachmentList.getAttachments().size());
    }
}

