/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation;

import io.meeds.kernel.test.AbstractSpringTest;
import io.meeds.social.navigation.plugin.LinkSidebarPlugin;
import io.meeds.social.navigation.plugin.PageSidebarPlugin;
import io.meeds.social.navigation.plugin.SiteSidebarPlugin;
import io.meeds.social.navigation.plugin.SpaceListSidebarPlugin;
import io.meeds.social.navigation.plugin.SpaceTemplateSidebarPlugin;
import io.meeds.social.navigation.service.NavigationConfigurationImportService;
import io.meeds.social.navigation.service.NavigationConfigurationService;
import io.meeds.social.space.template.entity.SpaceTemplateEntity;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.space.template.storage.SpaceTemplateStorage;
import io.meeds.social.space.template.utils.EntityMapper;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootApplication(scanBasePackages={"io.meeds.social.navigation", "io.meeds.social.common", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa"}, exclude={LiquibaseAutoConfiguration.class})
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/exo.social.component.core-local-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.social.component.core-local-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/social.component.core-local-navigation-portal-configuration.xml")})
@RunWith(value=SpringRunner.class)
public abstract class AbstractNavigationConfigurationTest
extends AbstractCoreTest {
    public static final String MODULE_NAME = "io.meeds.social.navigation";
    protected static final String SITE_NAME = "contribute";
    private SpaceTemplateDAO spaceTemplateDao = new SpaceTemplateDAO();
    @Autowired
    protected LayoutService layoutService;
    @Autowired
    protected NavigationService navigationService;
    @Autowired
    protected SpaceTemplateService spaceTemplateService;
    @Autowired
    protected SpaceTemplateStorage spaceTemplateStorage;
    @Autowired
    protected UserACL userAcl;
    @Autowired
    protected LinkSidebarPlugin linkSidebarPlugin;
    @Autowired
    protected PageSidebarPlugin pageSidebarPlugin;
    @Autowired
    protected SiteSidebarPlugin siteSidebarPlugin;
    @Autowired
    protected SpaceListSidebarPlugin spaceListSidebarPlugin;
    @Autowired
    protected SpaceTemplateSidebarPlugin spaceTemplateSidebarPlugin;
    @Autowired
    protected NavigationConfigurationService navigationConfigurationService;
    @Autowired
    protected NavigationConfigurationImportService navigationConfigurationImportService;
    protected SpaceTemplate spaceTemplate;

    public AbstractNavigationConfigurationTest() {
        AbstractSpringTest.setTestClass(((Object)((Object)this)).getClass());
    }

    @Before
    public void beforeEach() throws Exception {
        this.setUp();
        this.begin();
        this.navigationConfigurationImportService.start();
    }

    @After
    public void afterEach() throws Exception {
        this.end();
        this.tearDown();
    }

    public SpaceTemplate mockSpaceTemplate() {
        this.spaceTemplate = (SpaceTemplate)this.spaceTemplateService.getSpaceTemplates().getFirst();
        if (this.spaceTemplateDao.find(Long.valueOf(this.spaceTemplate.getId())) == null) {
            SpaceTemplateEntity spaceTemplateEntity = EntityMapper.toEntity((SpaceTemplate)this.spaceTemplate);
            spaceTemplateEntity.setId(null);
            spaceTemplateEntity = (SpaceTemplateEntity)this.spaceTemplateDao.create(spaceTemplateEntity);
            if (this.spaceTemplate.getId() != spaceTemplateEntity.getId().longValue()) {
                this.spaceTemplate.setId(spaceTemplateEntity.getId().longValue());
                this.spaceTemplateStorage.updateSpaceTemplate(this.spaceTemplate);
            }
        }
        return this.spaceTemplate;
    }

    public static class SpaceTemplateDAO
    extends GenericDAOJPAImpl<SpaceTemplateEntity, Long> {
    }
}

