/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.image.plugin;

import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import io.meeds.social.image.plugin.ImageAttachmentPlugin;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ImageAttachmentPluginTest {
    private static final String CMS_SETTING_NAME = "cmsSettingName";
    private ImageAttachmentPlugin imageAttachmentPlugin;
    @Mock
    private CMSService cmsService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;

    @Before
    public void setUp() {
        this.imageAttachmentPlugin = new ImageAttachmentPlugin(this.cmsService, this.spaceService, this.identityManager);
    }

    @Test
    public void testHasAccessPermission() throws ObjectNotFoundException {
        org.exoplatform.services.security.Identity userIdentity = (org.exoplatform.services.security.Identity)Mockito.mock(org.exoplatform.services.security.Identity.class);
        Mockito.when((Object)this.cmsService.hasAccessPermission(userIdentity, "imagePortlet", CMS_SETTING_NAME)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.imageAttachmentPlugin.hasAccessPermission(userIdentity, CMS_SETTING_NAME));
        Mockito.when((Object)this.cmsService.hasAccessPermission(userIdentity, "imagePortlet", CMS_SETTING_NAME)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.imageAttachmentPlugin.hasAccessPermission(userIdentity, CMS_SETTING_NAME));
    }

    @Test
    public void testHasEditPermission() throws ObjectNotFoundException {
        org.exoplatform.services.security.Identity userIdentity = (org.exoplatform.services.security.Identity)Mockito.mock(org.exoplatform.services.security.Identity.class);
        Mockito.when((Object)this.cmsService.hasEditPermission(userIdentity, "imagePortlet", CMS_SETTING_NAME)).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.imageAttachmentPlugin.hasEditPermission(userIdentity, CMS_SETTING_NAME));
        Mockito.when((Object)this.cmsService.hasEditPermission(userIdentity, "imagePortlet", CMS_SETTING_NAME)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.imageAttachmentPlugin.hasEditPermission(userIdentity, CMS_SETTING_NAME));
    }

    @Test
    public void testGetSpaceId() throws ObjectNotFoundException {
        CMSSetting setting = (CMSSetting)Mockito.mock(CMSSetting.class);
        Mockito.when((Object)setting.getSpaceId()).thenReturn((Object)2L);
        Mockito.when((Object)this.cmsService.getSetting("imagePortlet", CMS_SETTING_NAME)).thenReturn((Object)setting);
        Assert.assertEquals((long)setting.getSpaceId(), (long)this.imageAttachmentPlugin.getSpaceId(CMS_SETTING_NAME));
    }

    @Test
    public void testGetAudienceId() throws ObjectNotFoundException {
        CMSSetting setting = (CMSSetting)Mockito.mock(CMSSetting.class);
        Space space = (Space)Mockito.mock(Space.class);
        Identity spaceIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)space.getPrettyName()).thenReturn((Object)"spacePrettyName");
        Mockito.when((Object)setting.getSpaceId()).thenReturn((Object)2L);
        Mockito.when((Object)spaceIdentity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)this.spaceService.getSpaceById(String.valueOf(setting.getSpaceId()))).thenReturn((Object)space);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName())).thenReturn((Object)spaceIdentity);
        Mockito.when((Object)this.cmsService.getSetting("imagePortlet", CMS_SETTING_NAME)).thenReturn((Object)setting);
        Assert.assertEquals((long)Long.parseLong(spaceIdentity.getId()), (long)this.imageAttachmentPlugin.getAudienceId(CMS_SETTING_NAME));
    }
}

