/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.core.metadata.MetadataServiceImpl$AjcClosure1;
import org.exoplatform.social.core.metadata.storage.MetadataStorage;
import org.exoplatform.social.metadata.MetadataFilter;
import org.exoplatform.social.metadata.MetadataInitPlugin;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.MetadataTypePlugin;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.picocontainer.Startable;

public class MetadataServiceImpl
implements MetadataService,
Startable {
    private static final String METADATA_TYPE_IS_MANDATORY_MESSAGE = "Metadata Type is mandatory";
    private static final Log LOG;
    private MetadataStorage metadataStorage;
    private ListenerService listenerService;
    private Map<String, MetadataTypePlugin> metadataTypePlugins = new HashMap<String, MetadataTypePlugin>();
    private List<MetadataInitPlugin> metadataPlugins = new ArrayList<MetadataInitPlugin>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public MetadataServiceImpl(MetadataStorage metadataStorage, ListenerService listenerService) {
        this.metadataStorage = metadataStorage;
        this.listenerService = listenerService;
    }

    public Metadata createMetadata(Metadata metadata, long userIdentityId) {
        this.validateMetadata(metadata);
        this.validateAndGetMetadataType(metadata.getType().getName());
        this.validateUserIdentityId(userIdentityId);
        metadata.setCreatorId(userIdentityId);
        return this.createMetadataAndBroadcast(metadata, userIdentityId);
    }

    public Metadata updateMetadata(Metadata metadata, long userIdentityId) {
        this.validateMetadata(metadata);
        this.validateUserIdentityId(userIdentityId);
        metadata = this.metadataStorage.updateMetadata(metadata);
        try {
            this.listenerService.broadcast("social.metadata.updated", (Object)userIdentityId, (Object)metadata);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata update", (Throwable)e);
        }
        return metadata;
    }

    public Metadata deleteMetadataById(long metadataId) {
        if (metadataId <= 0L) {
            throw new IllegalArgumentException("Metadata Technical Identifier is mandatory");
        }
        return this.metadataStorage.deleteMetadataById(metadataId);
    }

    public int deleteMetadataBySpaceId(long spaceId) {
        this.validateSpaceId(spaceId);
        return this.metadataStorage.deleteMetadataItemsBySpaceId(spaceId);
    }

    public int deleteMetadataBySpaceIdAndAudienceId(long spaceId, long audienceId) {
        this.validateSpaceId(spaceId);
        this.validateUserIdentityId(audienceId);
        return this.metadataStorage.deleteMetadataItemsBySpaceIdAndAudienceId(spaceId, audienceId);
    }

    public Metadata getMetadataByKey(MetadataKey metadataKey) {
        if (metadataKey == null) {
            throw new IllegalArgumentException("Metadata Key is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)metadataKey.getType())) {
            throw new IllegalArgumentException(METADATA_TYPE_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((CharSequence)metadataKey.getName())) {
            throw new IllegalArgumentException("Metadata Name is mandatory");
        }
        return this.metadataStorage.getMetadataByKey(metadataKey);
    }

    public Metadata getMetadataById(long id) {
        return this.metadataStorage.getMetadataById(id);
    }

    public MetadataItem createMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, long userIdentityId) throws ObjectAlreadyExistsException {
        return this.createMetadataItem(metadataObject, metadataKey, null, userIdentityId);
    }

    public MetadataItem createMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, Map<String, String> properties, long userIdentityId, boolean broadcast) throws ObjectAlreadyExistsException {
        this.validateUserIdentityId(userIdentityId);
        Metadata metadata = this.checkAndCreateMetadata(metadataObject, metadataKey, userIdentityId);
        MetadataItem metadataItem = new MetadataItem(0L, metadata, metadataObject, userIdentityId, System.currentTimeMillis(), properties);
        return this.createMetadataItem(metadataItem, userIdentityId, broadcast);
    }

    public MetadataItem createMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, Map<String, String> properties, long userIdentityId) throws ObjectAlreadyExistsException {
        return this.createMetadataItem(metadataObject, metadataKey, properties, userIdentityId, true);
    }

    public MetadataItem createMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, Map<String, String> properties, boolean broadcast) throws ObjectAlreadyExistsException {
        Metadata metadata = this.checkAndCreateMetadata(metadataObject, metadataKey, 0L);
        MetadataItem metadataItem = new MetadataItem(0L, metadata, metadataObject, 0L, System.currentTimeMillis(), properties);
        return this.createMetadataItem(metadataItem, 0L, broadcast);
    }

    public MetadataItem createMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, Map<String, String> properties) throws ObjectAlreadyExistsException {
        return this.createMetadataItem(metadataObject, metadataKey, properties, true);
    }

    public MetadataItem updateMetadataItem(MetadataItem metadataItem, long userIdentityId, boolean broadcast) {
        if (metadataItem == null) {
            throw new IllegalArgumentException("MetadataItem is mandatory");
        }
        this.validateMetadataItemId(metadataItem.getId());
        this.validateUserIdentityId(userIdentityId);
        metadataItem = this.metadataStorage.updateMetadataItem(metadataItem);
        if (broadcast) {
            try {
                this.listenerService.broadcast("social.metadataItem.updated", (Object)userIdentityId, (Object)metadataItem);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while broadcasting event for metadataItem update", (Throwable)e);
            }
        }
        return metadataItem;
    }

    public MetadataItem updateMetadataItem(MetadataItem metadataItem, long userIdentityId) {
        return this.updateMetadataItem(metadataItem, userIdentityId, true);
    }

    public MetadataItem deleteMetadataItem(long itemId, boolean broadcast) throws ObjectNotFoundException {
        this.validateMetadataItemId(itemId);
        MetadataItem metadataItem = this.metadataStorage.getMetadataItemById(itemId);
        if (metadataItem == null) {
            throw new ObjectNotFoundException("Metadata Item with identifier " + itemId + " wasn't found");
        }
        metadataItem = this.metadataStorage.deleteMetadataItemById(itemId);
        if (broadcast) {
            try {
                this.listenerService.broadcast("social.metadataItem.deleted", (Object)0L, (Object)metadataItem);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while broadcasting event for metadata item deleted", (Throwable)e);
            }
        }
        return metadataItem;
    }

    public MetadataItem deleteMetadataItem(long itemId, long userIdentityId) throws ObjectNotFoundException {
        this.validateMetadataItemId(itemId);
        this.validateUserIdentityId(userIdentityId);
        MetadataItem metadataItem = this.metadataStorage.getMetadataItemById(itemId);
        if (metadataItem == null) {
            throw new ObjectNotFoundException("Metadata Item with identifier " + itemId + " wasn't found");
        }
        metadataItem = this.metadataStorage.deleteMetadataItemById(itemId);
        this.broadcastDeleted(metadataItem, userIdentityId);
        return metadataItem;
    }

    public void deleteMetadataItemsByObject(MetadataObject object) {
        List<MetadataItem> metadataItems = this.metadataStorage.getMetadataItemsByObject(object);
        this.metadataStorage.deleteMetadataItemsByObject(object);
        if (CollectionUtils.isNotEmpty(metadataItems)) {
            for (MetadataItem metadataItem : metadataItems) {
                this.broadcastDeleted(metadataItem, 0L);
            }
        }
    }

    public void deleteByMetadataTypeAndSpaceIdAndCreatorId(String metadataTypeName, long spaceId, long userIdentityId) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        this.validateSpaceId(spaceId);
        this.validateUserIdentityId(userIdentityId);
        List<MetadataItem> deletedMetadataItems = this.metadataStorage.deleteByMetadataTypeAndSpaceIdAndCreatorId(metadataType.getId(), spaceId, userIdentityId);
        if (CollectionUtils.isNotEmpty(deletedMetadataItems)) {
            for (MetadataItem metadataItem : deletedMetadataItems) {
                this.broadcastDeleted(metadataItem, userIdentityId);
            }
        }
    }

    public void deleteByMetadataTypeAndCreatorId(String metadataTypeName, long userIdentityId) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        this.validateUserIdentityId(userIdentityId);
        List<MetadataItem> deletedMetadataItems = this.metadataStorage.deleteByMetadataTypeAndCreatorId(metadataType.getId(), userIdentityId);
        if (CollectionUtils.isNotEmpty(deletedMetadataItems)) {
            for (MetadataItem metadataItem : deletedMetadataItems) {
                this.broadcastDeleted(metadataItem, userIdentityId);
            }
        }
    }

    public void deleteMetadataItemsByMetadataTypeAndObject(String metadataType, MetadataObject object) {
        this.metadataStorage.deleteMetadataItemsByMetadataTypeAndObject(metadataType, object);
    }

    public void deleteMetadataItemsByParentObject(MetadataObject object) {
        this.metadataStorage.deleteMetadataItemsByParentObject(object);
    }

    public int deleteByMetadataItemsTypeAndUntilCreationDate(String metadataTypeName, long untilDate) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        return this.metadataStorage.deleteByMetadataItemsTypeAndUntilCreationDate(metadataType.getId(), untilDate);
    }

    public List<MetadataItem> shareMetadataItemsByObject(MetadataObject sourceObject, String targetObjectId, long audienceId, long creatorId) {
        ArrayList<MetadataItem> sharedMetadataItems = new ArrayList<MetadataItem>();
        List<MetadataItem> metadataItems = this.getMetadataItemsByObject(sourceObject);
        for (MetadataItem metadataItem : metadataItems) {
            MetadataItem sharedMetadataItem = this.shareMetadataItem(metadataItem.getObject(), metadataItem.getMetadata().key(), targetObjectId, audienceId, creatorId);
            if (sharedMetadataItem == null) continue;
            sharedMetadataItems.add(sharedMetadataItem);
        }
        try {
            this.listenerService.broadcast("social.metadataItem.shared", (Object)sourceObject, (Object)targetObjectId);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata item shared", (Throwable)e);
        }
        return sharedMetadataItems;
    }

    public List<MetadataItem> getMetadataItemsByObject(MetadataObject object) {
        return this.metadataStorage.getMetadataItemsByObject(object);
    }

    public List<MetadataItem> getMetadataItemsByMetadataTypeAndObject(String metadataType, MetadataObject object) {
        return this.metadataStorage.getMetadataItemsByMetadataTypeAndObject(metadataType, object);
    }

    public List<MetadataItem> getMetadataItemsByMetadataTypeAndObjectType(String metadataType, String objectType) {
        return this.metadataStorage.getMetadataItemsByMetadataTypeAndObjectType(metadataType, objectType);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObject(String metadataName, String metadataTypeName, String objectType, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndObject(metadataName, metadataTypeName, objectType, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObject(String metadataName, String metadataTypeName, String objectType, String objectId, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndObject(metadataName, metadataTypeName, objectType, objectId, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceId(String metadataName, String metadataTypeName, String objectType, long spaceId, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds(metadataName, metadataTypeName, objectType, Collections.singletonList(spaceId), offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndSpaceIds(String metadataName, String metadataTypeName, List<Long> spaceIds, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndSpaceIds(metadataName, metadataTypeName, spaceIds, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByFilter(MetadataFilter filter, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByFilter(filter, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds(String metadataName, String metadataTypeName, String objectType, List<Long> spaceIds, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndObjectAndSpaceIds(metadataName, metadataTypeName, objectType, spaceIds, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(String metadataName, String metadataTypeName, String objectType, String propertyKey, String propertyValue, long offset, long limit) {
        return this.metadataStorage.getMetadataItemsByMetadataNameAndTypeAndObjectAndMetadataItemProperty(metadataName, metadataTypeName, objectType, propertyKey, propertyValue, offset, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataTypeAndCreator(String metadataTypeName, long creatorId, long offset, long limit) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        this.validateUserIdentityId(creatorId);
        return this.metadataStorage.getMetadataItemsByMetaDataTypeAndCreator(metadataType.getId(), creatorId, offset, limit);
    }

    public int countMetadataItemsByMetadataTypeAndCreator(String metadataTypeName, long creatorId) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        this.validateUserIdentityId(creatorId);
        return this.metadataStorage.countMetadataItemsByMetadataTypeAndCreator(metadataType.getId(), creatorId);
    }

    public Map<String, Long> countMetadataItemsByMetadataTypeAndAudienceId(String metadataTypeName, long creatorId, long spaceId) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        this.validateUserIdentityId(creatorId);
        return this.metadataStorage.countMetadataItemsByMetadataTypeAndAudienceId(metadataType.getId(), creatorId, spaceId);
    }

    public Map<Long, Long> countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(String metadataTypeName, long creatorId, List<Long> spacesId) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        return this.metadataStorage.countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(metadataType.getId(), creatorId, spacesId);
    }

    public Set<String> getMetadataNamesByObject(MetadataObject object) {
        return this.metadataStorage.getMetadataNamesByObject(object);
    }

    public List<String> getMetadataNamesByMetadataTypeAndObject(String metadataTypeName, String objectType, String objectId) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        List<MetadataItem> metadataItems = this.metadataStorage.getMetadataItemsByMetadataTypeAndObject(metadataType.getId(), new MetadataObject(objectType, objectId));
        return metadataItems.stream().map(MetadataItem::getMetadata).map(Metadata::getName).distinct().toList();
    }

    public List<String> getMetadataNamesByMetadataTypeAndObject(String metadataTypeName, String objectType, String objectId, int offset, int limit) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        List<MetadataItem> metadataItems = this.metadataStorage.getMetadataItemsByMetadataTypeAndObject(metadataType.getId(), new MetadataObject(objectType, objectId), offset, limit);
        return metadataItems.stream().map(MetadataItem::getMetadata).map(Metadata::getName).distinct().toList();
    }

    public List<String> findMetadataNamesByCreator(String term, String metadataTypeName, long creatorId, long limit) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        if (StringUtils.isBlank((CharSequence)term)) {
            return this.metadataStorage.getMetadataNamesByCreator(metadataType.getId(), creatorId, limit);
        }
        return this.metadataStorage.findMetadataNameByCreatorAndQuery(term, metadataType.getId(), creatorId, limit);
    }

    public List<String> findMetadataNamesByUserAndQuery(String term, String metadataTypeName, Set<Long> audienceIds, long creatorId, long limit) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        if (StringUtils.isBlank((CharSequence)term)) {
            return this.metadataStorage.getMetadataNamesByUser(metadataType.getId(), creatorId, audienceIds, limit);
        }
        return this.metadataStorage.findMetadataNamesByUserAndQuery(term, metadataType.getId(), creatorId, audienceIds, limit);
    }

    public List<String> findMetadataNamesByAudiences(String term, String metadataTypeName, Set<Long> audienceIds, long limit) {
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        if (StringUtils.isBlank((CharSequence)term)) {
            return this.metadataStorage.getMetadataNamesByAudiences(metadataType.getId(), audienceIds, limit);
        }
        return this.metadataStorage.findMetadataNameByAudiencesAndQuery(term, metadataType.getId(), audienceIds, limit);
    }

    public List<MetadataItem> getMetadataItemsByMetadataAndObject(MetadataKey metadataKey, MetadataObject object) {
        Metadata metadata = this.getMetadataByKey(metadataKey);
        if (metadata == null) {
            return Collections.emptyList();
        }
        return this.metadataStorage.getMetadataItemsByMetadataAndObject(metadata.getId(), object);
    }

    public List<String> getMetadataObjectIds(String metadataType, String metadataName, String objectType, long offset, long limit) {
        return this.metadataStorage.getMetadataObjectIds(metadataType, metadataName, objectType, offset, limit);
    }

    public void addMetadataTypePlugin(MetadataTypePlugin metadataTypePlugin) {
        if (this.metadataTypePlugins.values().stream().anyMatch(registeredPlugin -> {
            boolean sameIdWithdifferentName = !StringUtils.equals((CharSequence)registeredPlugin.getName(), (CharSequence)metadataTypePlugin.getName()) && registeredPlugin.getId() == metadataTypePlugin.getId();
            boolean sameNameWithDifferentId = StringUtils.equals((CharSequence)registeredPlugin.getName(), (CharSequence)metadataTypePlugin.getName()) && registeredPlugin.getId() != metadataTypePlugin.getId();
            return sameIdWithdifferentName || sameNameWithDifferentId;
        })) {
            throw new UnsupportedOperationException("Overriding existing Metadata Type with different ID or Name is not allowed. Please verify the unicity of Metadata Type id and name.");
        }
        this.metadataStorage.addMetadataType(metadataTypePlugin.getMetadataType());
        this.metadataTypePlugins.put(metadataTypePlugin.getName(), metadataTypePlugin);
    }

    public MetadataTypePlugin getMetadataTypePluginByName(String name) {
        return this.metadataTypePlugins.get(name);
    }

    public MetadataType getMetadataTypeByName(String name) {
        MetadataTypePlugin plugin = this.getMetadataTypePluginByName(name);
        return plugin == null ? null : plugin.getMetadataType();
    }

    public List<MetadataType> getMetadataTypes() {
        return this.metadataStorage.getMetadataTypes();
    }

    public void addMetadataPlugin(MetadataInitPlugin metadataInitPlugin) {
        this.metadataPlugins.add(metadataInitPlugin);
    }

    public List<Metadata> getMetadatas(String metadataTypeName, long limit) {
        return this.metadataStorage.getMetadatas(metadataTypeName, limit);
    }

    public List<Long> getMetadataIds(String metadataTypeName, int offset, int limit) {
        return this.metadataStorage.getMetadataIds(metadataTypeName, offset, limit);
    }

    public List<Metadata> getMetadatasByProperty(String propertyKey, String propertyValue, long limit) {
        List<Long> ids = this.metadataStorage.getMetadataIdsByProperty(propertyKey, propertyValue, 0L, limit, true);
        return ids.stream().map(this::getMetadataById).toList();
    }

    public long countMetadataIdsByProperty(String propertyKey, String propertyValue) {
        return this.metadataStorage.countMetadataIdsByProperty(propertyKey, propertyValue);
    }

    public List<Long> getMetadataIdsByProperty(String propertyKey, String propertyValue, long offset, long limit) {
        return this.metadataStorage.getMetadataIdsByProperty(propertyKey, propertyValue, offset, limit, false);
    }

    @ExoTransactional
    public void start() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MetadataServiceImpl$AjcClosure1 metadataServiceImpl$AjcClosure1 = new MetadataServiceImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(metadataServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void stop() {
    }

    private Metadata checkAndCreateMetadata(MetadataObject metadataObject, MetadataKey metadataKey, long userIdentityId) throws ObjectAlreadyExistsException {
        List<MetadataItem> storedMetadataItems;
        if (metadataObject == null) {
            throw new IllegalArgumentException("Metadata Item Object is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)metadataObject.getType())) {
            throw new IllegalArgumentException("Metadata Item Object Type is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)metadataObject.getId())) {
            throw new IllegalArgumentException("Metadata Item Object Id is mandatory");
        }
        if (metadataKey == null) {
            throw new IllegalArgumentException("Metadata Key is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)metadataKey.getName())) {
            throw new IllegalArgumentException("Metadata Name is mandatory");
        }
        String metadataTypeName = metadataKey.getType();
        MetadataType metadataType = this.validateAndGetMetadataType(metadataTypeName);
        Metadata metadata = this.getMetadataByKey(metadataKey);
        if (metadata == null) {
            metadata = new Metadata();
            metadata.setName(metadataKey.getName());
            metadata.setType(metadataType);
            metadata.setAudienceId(metadataKey.getAudienceId());
            metadata.setCreatorId(userIdentityId);
            metadata = this.createMetadataAndBroadcast(metadata, userIdentityId);
        }
        if (!this.isAllowMultipleItemsPerObject(metadata.getTypeName()) && !(storedMetadataItems = this.metadataStorage.getMetadataItemsByMetadataAndObject(metadata.getId(), metadataObject)).isEmpty()) {
            throw new ObjectAlreadyExistsException((Object)storedMetadataItems.get(0));
        }
        return metadata;
    }

    private Metadata createMetadataAndBroadcast(Metadata metadata, long userIdentityId) {
        metadata = this.metadataStorage.createMetadata(metadata);
        try {
            this.listenerService.broadcast("social.metadata.created", (Object)userIdentityId, (Object)metadata);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata creation", (Throwable)e);
        }
        return metadata;
    }

    private MetadataItem createMetadataItem(MetadataItem metadataItem, long userIdentityId, boolean broadcast) {
        metadataItem = this.metadataStorage.createMetadataItem(metadataItem);
        if (broadcast) {
            try {
                this.listenerService.broadcast("social.metadataItem.created", (Object)userIdentityId, (Object)metadataItem);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while broadcasting event for metadata item creation", (Throwable)e);
            }
        }
        return metadataItem;
    }

    private MetadataItem shareMetadataItem(MetadataObject metadataObject, MetadataKey metadataKey, String targetObjectId, long audienceId, long creatorId) {
        if (this.isShareable(metadataKey.getType())) {
            MetadataObject metadataObjectToShare = metadataObject.clone();
            metadataObjectToShare.setId(targetObjectId);
            MetadataKey metadataKeyToShare = metadataKey.clone();
            metadataKeyToShare.setAudienceId(audienceId);
            try {
                return this.createMetadataItem(metadataObjectToShare, metadataKeyToShare, creatorId);
            }
            catch (ObjectAlreadyExistsException e) {
                LOG.warn("The metadata object {} is already associated to Metadata with unique key {}. This doesn't affect the expected result, so continue processing.", new Object[]{metadataObjectToShare, metadataKeyToShare, e});
            }
        }
        return null;
    }

    private boolean isShareable(String metadataTypeName) {
        MetadataTypePlugin metadataTypePlugin = this.getMetadataTypePluginByName(metadataTypeName);
        return metadataTypePlugin != null && metadataTypePlugin.isShareable();
    }

    private boolean isAllowMultipleItemsPerObject(String metadataType) {
        MetadataTypePlugin plugin = this.getMetadataTypePluginByName(metadataType);
        return plugin.isAllowMultipleItemsPerObject();
    }

    private void validateMetadata(Metadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata is mandatory");
        }
        if (metadata.getType() == null) {
            throw new IllegalArgumentException(METADATA_TYPE_IS_MANDATORY_MESSAGE);
        }
    }

    private void validateMetadataItemId(long itemId) {
        if (itemId <= 0L) {
            throw new IllegalArgumentException("Metadata Item Technical Identifier is mandatory");
        }
    }

    private void validateUserIdentityId(long userIdentityId) {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
    }

    private void validateSpaceId(long spaceId) {
        if (spaceId <= 0L) {
            throw new IllegalArgumentException("spaceId is mandatory");
        }
    }

    private MetadataType validateAndGetMetadataType(String metadataTypeName) {
        MetadataType type = this.getMetadataTypeByName(metadataTypeName);
        if (type == null) {
            throw new IllegalArgumentException("Metadata Type " + metadataTypeName + " is not registered as a plugin");
        }
        return type;
    }

    private void broadcastDeleted(MetadataItem metadataItem, long userIdentityId) {
        try {
            this.listenerService.broadcast("social.metadataItem.deleted", (Object)userIdentityId, (Object)metadataItem);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while broadcasting event for metadata item deleted", (Throwable)e);
        }
    }

    static {
        MetadataServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(MetadataServiceImpl.class);
    }

    static final /* synthetic */ void start_aroundBody0(MetadataServiceImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.metadataPlugins.forEach(plugin -> {
            Metadata metadata = plugin.getMetadata();
            try {
                MetadataKey metadataKey = new MetadataKey(metadata.getTypeName(), metadata.getName(), metadata.getAudienceId());
                Metadata storedMetadata = this.metadataStorage.getMetadataByKey(metadataKey);
                if (storedMetadata == null) {
                    metadata.setId(0L);
                    metadata.setCreatorId(0L);
                    this.metadataStorage.createMetadata(metadata);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Can't process initialization of metadata : " + String.valueOf(metadata)), (Throwable)e);
            }
        });
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MetadataServiceImpl.java", MetadataServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.exoplatform.social.core.metadata.MetadataServiceImpl", "", "", "", "void"), 616);
    }
}

