/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.service.GettingStartedService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class GettingStartedServiceTest {
    private static final String USERNAME_TEST = "test";
    private static GettingStartedService gettingStartedService;
    private static IdentityManager identityManager;
    private static SpaceService spaceService;
    private static RelationshipManager relationshipManager;
    private static ActivityManager activityService;
    private static SettingService settingService;

    @BeforeClass
    public static void beforeClass() {
        identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        relationshipManager = (RelationshipManager)Mockito.mock(RelationshipManager.class);
        activityService = (ActivityManager)Mockito.mock(ActivityManager.class);
        settingService = (SettingService)Mockito.mock(SettingService.class);
        gettingStartedService = new GettingStartedService(identityManager, spaceService, relationshipManager, activityService, settingService);
    }

    @Before
    public void setup() {
        Mockito.reset((Object[])new Object[]{identityManager, spaceService, relationshipManager, activityService});
    }

    @Test
    public void testGetUserStepsWithNullUserName() {
        try {
            gettingStartedService.getUserSteps(null);
            Assert.fail((String)"Should throw exception with null username");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetUserStepsWithNotExistUserName() {
        List gettingStartedUserSteps = gettingStartedService.getUserSteps(USERNAME_TEST);
        Assert.assertNotNull((Object)gettingStartedUserSteps);
        Assert.assertEquals((long)4L, (long)gettingStartedUserSteps.size());
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts") && userStep.getStatus() == false));
    }

    @Test
    public void testGetUserStepsWithExistUserNameHasAvatar() {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Profile profile = new Profile(identity);
        Mockito.when((Object)identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"organization"), (String)Mockito.eq((Object)USERNAME_TEST))).thenReturn((Object)identity);
        profile.setAvatarLastUpdated(Long.valueOf(1234567L));
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        List gettingStartedUserSteps = gettingStartedService.getUserSteps(USERNAME_TEST);
        Assert.assertNotNull((Object)gettingStartedUserSteps);
        Assert.assertEquals((long)4L, (long)gettingStartedUserSteps.size());
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar") && userStep.getStatus() != false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts") && userStep.getStatus() == false));
    }

    @Test
    public void testGetUserStepsWithExistUserNameHasContacts() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"organization"), (String)Mockito.eq((Object)USERNAME_TEST))).thenReturn((Object)identity);
        ListAccess listConnections = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)listConnections.getSize()).thenReturn((Object)1);
        Mockito.when((Object)relationshipManager.getConnections(identity)).thenReturn((Object)listConnections);
        List gettingStartedUserSteps = gettingStartedService.getUserSteps(USERNAME_TEST);
        Assert.assertNotNull((Object)gettingStartedUserSteps);
        Assert.assertEquals((long)4L, (long)gettingStartedUserSteps.size());
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts") && userStep.getStatus() != false));
    }

    @Test
    public void testGetUserStepsWithExistUserNameHasSpaces() throws Exception {
        ListAccess accessibleSpaces = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)accessibleSpaces.getSize()).thenReturn((Object)1);
        Mockito.when((Object)spaceService.getAccessibleSpacesWithListAccess(USERNAME_TEST)).thenReturn((Object)accessibleSpaces);
        List gettingStartedUserSteps = gettingStartedService.getUserSteps(USERNAME_TEST);
        Assert.assertNotNull((Object)gettingStartedUserSteps);
        Assert.assertEquals((long)4L, (long)gettingStartedUserSteps.size());
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces") && userStep.getStatus() != false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts") && userStep.getStatus() == false));
    }

    @Test
    public void testGetUserStepsWithExistUserNameHasActivities() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"organization"), (String)Mockito.eq((Object)USERNAME_TEST))).thenReturn((Object)identity);
        Profile profile = new Profile(identity);
        profile.setAvatarLastUpdated(Long.valueOf(1234567L));
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        ListAccess listConnections = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)listConnections.getSize()).thenReturn((Object)1);
        Mockito.when((Object)relationshipManager.getConnections(identity)).thenReturn((Object)listConnections);
        ListAccess accessibleSpaces = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)accessibleSpaces.getSize()).thenReturn((Object)1);
        Mockito.when((Object)spaceService.getAccessibleSpacesWithListAccess(USERNAME_TEST)).thenReturn((Object)accessibleSpaces);
        RealtimeListAccess activities = (RealtimeListAccess)Mockito.mock(RealtimeListAccess.class);
        Mockito.when((Object)activities.getSize()).thenReturn((Object)1);
        Mockito.when((Object)activityService.getActivitiesWithListAccess(identity)).thenReturn((Object)activities);
        List gettingStartedUserSteps = gettingStartedService.getUserSteps(USERNAME_TEST);
        Assert.assertNotNull((Object)gettingStartedUserSteps);
        Assert.assertEquals((long)4L, (long)gettingStartedUserSteps.size());
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar") && userStep.getStatus() != false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces") && userStep.getStatus() != false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities") && userStep.getStatus() != false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts") && userStep.getStatus() != false));
    }

    @Test
    public void testGetUserStepsWithExistUserNameAllStepsAreFalse() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"organization"), (String)Mockito.eq((Object)USERNAME_TEST))).thenReturn((Object)identity);
        Profile profile = new Profile(identity);
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        ListAccess listConnections = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)listConnections.getSize()).thenReturn((Object)0);
        Mockito.when((Object)relationshipManager.getConnections(identity)).thenReturn((Object)listConnections);
        ListAccess accessibleSpaces = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)accessibleSpaces.getSize()).thenReturn((Object)0);
        Mockito.when((Object)spaceService.getAccessibleSpacesWithListAccess(USERNAME_TEST)).thenReturn((Object)accessibleSpaces);
        RealtimeListAccess activities = (RealtimeListAccess)Mockito.mock(RealtimeListAccess.class);
        Mockito.when((Object)activities.getSize()).thenReturn((Object)0);
        Mockito.when((Object)activityService.getActivitiesWithListAccess(identity)).thenReturn((Object)activities);
        List gettingStartedUserSteps = gettingStartedService.getUserSteps(USERNAME_TEST);
        Assert.assertNotNull((Object)gettingStartedUserSteps);
        Assert.assertEquals((long)4L, (long)gettingStartedUserSteps.size());
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"avatar") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"spaces") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"activities") && userStep.getStatus() == false));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts")));
        Assert.assertTrue((boolean)gettingStartedUserSteps.stream().anyMatch(userStep -> StringUtils.equals((CharSequence)userStep.getName(), (CharSequence)"contacts") && userStep.getStatus() == false));
    }
}

