/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.cms.service;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.social.cms.model.ContentLink;
import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkIdentifier;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.security.Identity;
import org.springframework.stereotype.Service;

@Service
public class ContentLinkPluginServiceImpl
implements ContentLinkPluginService {
    private PermanentLinkService permanentLinkService;
    private Map<String, ContentLinkPlugin> plugins = new HashMap<String, ContentLinkPlugin>();

    public ContentLinkPluginServiceImpl(PermanentLinkService permanentLinkService) {
        this.permanentLinkService = permanentLinkService;
    }

    public void addPlugin(ContentLinkPlugin plugin) {
        this.plugins.put(plugin.getObjectType(), plugin);
    }

    public ContentLinkPlugin getPlugin(String objectType) {
        ContentLinkPlugin contentLinkPlugin = this.plugins.get(objectType);
        if (contentLinkPlugin == null) {
            throw new IllegalStateException(String.format("Content Link Plugin %s wasn't found", objectType));
        }
        return contentLinkPlugin;
    }

    public List<ContentLinkExtension> getExtensions() {
        return this.plugins.values().stream().map(ContentLinkPlugin::getExtension).toList();
    }

    public ContentLink getLink(ContentLinkIdentifier linkIdentifier) {
        String title = this.getPlugin(linkIdentifier.getObjectType()).getContentTitle(linkIdentifier.getObjectId(), linkIdentifier.getLocale());
        if (StringUtils.isBlank((CharSequence)title)) {
            return null;
        }
        ContentLink contentLink = new ContentLink(linkIdentifier);
        contentLink.setTitle(title);
        this.computeUri(contentLink);
        this.computePluginProperties(contentLink);
        return contentLink;
    }

    public List<ContentLinkSearchResult> searchLinks(String objectType, String keyword, Identity identity, Locale locale, int offset, int limit) {
        List links = this.getPlugin(objectType).search(keyword, identity, locale, offset, limit);
        links.forEach(this::computeUri);
        return links;
    }

    private void computePluginProperties(ContentLink contentLink) {
        ContentLinkExtension extension = this.getPlugin(contentLink.getObjectType()).getExtension();
        contentLink.setIcon(extension.getIcon());
        contentLink.setDrawer(extension.isDrawer());
    }

    private void computeUri(ContentLink contentLink) {
        String url = this.permanentLinkService.getLink(new PermanentLinkObject(contentLink.getObjectType(), contentLink.getObjectId()));
        contentLink.setUri(url);
    }
}

