/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity;

import java.util.Locale;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ActivityIndexingServiceConnector;
import org.exoplatform.social.core.jpa.search.ActivitySearchProcessor;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.metadata.MetadataService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActivityIndexingServiceConnectorTest {
    ActivityIndexingServiceConnector activityIndexingServiceConnector = null;
    @Mock
    ActivitySearchProcessor activitySearchProcessor;
    @Mock
    I18NActivityProcessor i18nActivityProcessor;
    @Mock
    IdentityManager identityManager;
    @Mock
    ActivityManager activityManager;
    @Mock
    MetadataService metadataService;

    @Test
    public void testGetAllIds() {
        this.activityIndexingServiceConnector = new ActivityIndexingServiceConnector(this.activitySearchProcessor, this.i18nActivityProcessor, this.identityManager, this.activityManager, this.metadataService, this.getParams());
        try {
            this.activityIndexingServiceConnector.getAllIds(0, 10);
            Assert.fail((String)"getAllIds shouldn't be supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testCreate() {
        this.activityIndexingServiceConnector = new ActivityIndexingServiceConnector(this.activitySearchProcessor, this.i18nActivityProcessor, this.identityManager, this.activityManager, this.metadataService, this.getParams());
        try {
            this.activityIndexingServiceConnector.create(null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.activityIndexingServiceConnector.create("1");
            Assert.fail((String)"IllegalStateException should be thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId("1");
        activity.setParentId("2");
        activity.setParentCommentId("3");
        activity.setType("type");
        activity.setPosterId("posterId");
        activity.setPostedTime(Long.valueOf(1234L));
        activity.setUpdated(Long.valueOf(4321L));
        ActivityStreamImpl activityStream = new ActivityStreamImpl();
        activity.setActivityStream((ActivityStream)activityStream);
        activityStream.setId("id");
        activityStream.setPrettyId("prettyId");
        activityStream.setType(ActivityStream.Type.USER);
        Identity streamOwner = new Identity("streamOwner");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity(ActivityStream.Type.USER.getProviderId(), "prettyId")).thenReturn((Object)streamOwner);
        Identity posterIdentity = new Identity("posterId");
        Profile posterProfile = new Profile(posterIdentity);
        posterProfile.setProperty("fullName", (Object)"Poster FullName");
        posterIdentity.setProfile(posterProfile);
        Mockito.when((Object)this.identityManager.getIdentity("posterId")).thenReturn((Object)posterIdentity);
        Mockito.when((Object)this.activityManager.getActivity("1")).thenReturn((Object)activity);
        activity.setTitleId("titleId");
        Mockito.when((Object)this.i18nActivityProcessor.process((ExoSocialActivity)ArgumentMatchers.eq((Object)activity), (Locale)ArgumentMatchers.any(Locale.class))).thenAnswer(invocation -> {
            ExoSocialActivity exoSocialActivity = (ExoSocialActivity)invocation.getArgument(0, ExoSocialActivity.class);
            exoSocialActivity.setTitle("<div><h2>What is Lorem Ipsum?</h2>");
            return exoSocialActivity;
        });
        Document document = this.activityIndexingServiceConnector.create("1");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"1", (Object)document.getId());
        Assert.assertEquals((Object)"2", document.getFields().get("parentId"));
        Assert.assertEquals((Object)"3", document.getFields().get("parentCommentId"));
        Assert.assertEquals((Object)"posterId", document.getFields().get("posterId"));
        Assert.assertEquals((Object)"Poster FullName", document.getFields().get("posterName"));
        Assert.assertEquals((Object)"1234", document.getFields().get("postedTime"));
        Assert.assertNotNull((Object)document.getLastUpdatedDate());
        Assert.assertEquals((long)4321L, (long)document.getLastUpdatedDate().getTime());
        Assert.assertNotNull((Object)document.getPermissions());
        Assert.assertEquals((long)2L, (long)document.getPermissions().size());
        Assert.assertEquals((Object)"streamOwner", document.getPermissions().iterator().next());
    }

    @Test
    public void testUpdate() {
        this.activityIndexingServiceConnector = new ActivityIndexingServiceConnector(this.activitySearchProcessor, this.i18nActivityProcessor, this.identityManager, this.activityManager, this.metadataService, this.getParams());
        try {
            this.activityIndexingServiceConnector.update(null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.activityIndexingServiceConnector.update("1");
            Assert.fail((String)"IllegalStateException should be thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setId("1");
        activity.setParentId("2");
        activity.setParentCommentId("3");
        activity.setType("type");
        activity.setPosterId("posterId");
        activity.setPostedTime(Long.valueOf(1234L));
        activity.setUpdated(Long.valueOf(4321L));
        ActivityStreamImpl activityStream = new ActivityStreamImpl();
        activity.setActivityStream((ActivityStream)activityStream);
        activityStream.setId("id");
        activityStream.setPrettyId("prettyId");
        activityStream.setType(ActivityStream.Type.USER);
        Identity streamOwner = new Identity("streamOwner");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity(ActivityStream.Type.USER.getProviderId(), "prettyId")).thenReturn((Object)streamOwner);
        Identity posterIdentity = new Identity("posterId");
        Profile posterProfile = new Profile(posterIdentity);
        posterProfile.setProperty("fullName", (Object)"PosterUpdated FullName");
        posterIdentity.setProfile(posterProfile);
        Mockito.when((Object)this.identityManager.getIdentity("posterId")).thenReturn((Object)posterIdentity);
        Mockito.when((Object)this.activityManager.getActivity("1")).thenReturn((Object)activity);
        activity.setTitleId("titleId");
        Mockito.when((Object)this.i18nActivityProcessor.process((ExoSocialActivity)ArgumentMatchers.eq((Object)activity), (Locale)ArgumentMatchers.any(Locale.class))).thenAnswer(invocation -> {
            ExoSocialActivity exoSocialActivity = (ExoSocialActivity)invocation.getArgument(0, ExoSocialActivity.class);
            exoSocialActivity.setTitle("<div><h2>What is Lorem Ipsum?</h2>");
            return exoSocialActivity;
        });
        Document document = this.activityIndexingServiceConnector.update("1");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"1", (Object)document.getId());
        Assert.assertEquals((Object)"2", document.getFields().get("parentId"));
        Assert.assertEquals((Object)"3", document.getFields().get("parentCommentId"));
        Assert.assertEquals((Object)"type", document.getFields().get("type"));
        Assert.assertEquals((Object)"posterId", document.getFields().get("posterId"));
        Assert.assertEquals((Object)"PosterUpdated FullName", document.getFields().get("posterName"));
        Assert.assertEquals((Object)"1234", document.getFields().get("postedTime"));
        Assert.assertNotNull((Object)document.getLastUpdatedDate());
        Assert.assertEquals((long)4321L, (long)document.getLastUpdatedDate().getTime());
        Assert.assertNotNull((Object)document.getPermissions());
        Assert.assertEquals((long)2L, (long)document.getPermissions().size());
        Assert.assertEquals((Object)"streamOwner", document.getPermissions().iterator().next());
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        params.addParameter((Parameter)propertiesParam);
        propertiesParam.setProperty("index_current", "index_name");
        return params;
    }
}

