/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category;

import io.meeds.social.AbstractSpringConfigurationTest;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.service.CategoryLinkService;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.social.core.identity.model.Identity;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCategoryConfigurationTest
extends AbstractSpringConfigurationTest {
    public static final String MODULE_NAME = "io.meeds.social.category";
    public static final String ROOT_USER = "root";
    public static final String JOHN_USER = "john";
    public static final String MARY_USER = "mary";
    @Autowired
    protected CategoryService categoryService;
    @Autowired
    protected CategoryLinkService categoryLinkService;
    @Autowired
    protected TranslationService translationService;
    protected long usersGroupIdentityId;

    @Before
    public void beforeEach() {
        this.setUp();
        this.begin();
        this.usersGroupIdentityId = Long.parseLong(this.identityManager.getOrCreateGroupIdentity("/platform/users").getId());
    }

    @After
    public void afterEach() {
        Category rootCategory = this.categoryService.getRootCategory(this.getAdminGroupIdentityId());
        this.categoryService.deleteCategory(rootCategory.getId(), ROOT_USER);
        this.end();
        this.tearDown();
    }

    protected Category buildCategoryTree() {
        long ownerIdentityId = this.getAdminGroupIdentityId();
        Category rootCategory = this.categoryService.getRootCategory(ownerIdentityId);
        this.createTree(ownerIdentityId, rootCategory.getId(), 0L, 5L);
        return rootCategory;
    }

    private void createTree(long ownerId, long parentId, long depth, long depthLimit) {
        if (depth < depthLimit) {
            for (int i = 0; i < 2; ++i) {
                Category category = new Category();
                category.setOwnerId(ownerId);
                category.setParentId(parentId);
                category.setIcon("test-icon");
                category.setAccessPermissionIds(Collections.singletonList(this.usersGroupIdentityId));
                category = this.categoryService.createCategory(category, ROOT_USER);
                this.translationService.saveTranslationLabels("category", category.getId(), "name", Collections.singletonMap(Locale.ENGLISH, "category-" + parentId + "-" + category.getId()), ROOT_USER);
                this.createTree(ownerId, category.getId(), depth + 1L, depthLimit);
            }
        }
    }

    protected long getAdminGroupIdentityId() {
        Identity adminGroupIdentity = this.identityManager.getOrCreateGroupIdentity("/platform/administrators");
        return Long.parseLong(adminGroupIdentity.getId());
    }

    protected long getUsersGroupIdentityId() {
        Identity adminGroupIdentity = this.identityManager.getOrCreateGroupIdentity("/platform/users");
        return Long.parseLong(adminGroupIdentity.getId());
    }
}

