/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import io.meeds.social.space.constant.PublicSiteVisibility;
import io.meeds.social.space.constant.SpaceRegistration;
import io.meeds.social.space.constant.SpaceVisibility;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.commons.utils.StringListConverter;
import org.exoplatform.social.core.jpa.storage.entity.GroupSpaceBindingEntity;
import org.exoplatform.social.core.jpa.storage.entity.GroupSpaceBindingReportActionEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceCategoryEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;

@Entity(name="SocSpaceEntity")
@Table(name="SOC_SPACES")
@NamedQueries(value={@NamedQuery(name="SpaceEntity.getLastSpaces", query="SELECT sp.id, sp.createdDate FROM SocSpaceEntity sp ORDER BY sp.createdDate DESC"), @NamedQuery(name="SpaceEntity.getSpaceByGroupId", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.groupId = :groupId"), @NamedQuery(name="SpaceEntity.getSpaceByPrettyName", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.prettyName = :prettyName"), @NamedQuery(name="SpaceEntity.getCommonSpacesBetweenTwoUsers", query="SELECT spaces FROM SocSpaceEntity spaces WHERE spaces.id IN ( SELECT distinct (t1.space.id) FROM SocSpaceMember t1, SocSpaceMember t2  WHERE t1.userId = :userId  AND t2.userId = :otherUserId  AND t1.space.id = t2.space.id )"), @NamedQuery(name="SpaceEntity.countCommonSpacesBetweenTwoUsers", query="SELECT COUNT(*) FROM SocSpaceEntity spaces WHERE spaces.id IN ( SELECT distinct (t1.space.id) FROM SocSpaceMember t1, SocSpaceMember t2  WHERE t1.userId = :userId  AND t2.userId = :otherUserId  AND t1.space.id = t2.space.id )"), @NamedQuery(name="SpaceEntity.countSpacesByTemplate", query="  SELECT s.templateId, COUNT(s.id) FROM SocSpaceEntity s\n  WHERE s.templateId > 0\n  GROUP BY s.templateId\n"), @NamedQuery(name="SpaceEntity.getSpaceCategoryIds", query="  SELECT DISTINCT c.categoryId FROM SocSpaceEntity s\n  INNER JOIN s.categories c\n")})
public class SpaceEntity
implements Serializable {
    private static final long serialVersionUID = 3223615477747436986L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_SPACES_ID", sequenceName="SEQ_SOC_SPACES_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_SPACES_ID")
    @Column(name="SPACE_ID")
    private Long id;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="space", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<SpaceMemberEntity> members = new HashSet<SpaceMemberEntity>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="space", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<GroupSpaceBindingEntity> spaceBindingEntities = new HashSet<GroupSpaceBindingEntity>();
    @OneToMany(fetch=FetchType.LAZY, mappedBy="space", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<GroupSpaceBindingReportActionEntity> spaceBindingReportEntities = new HashSet<GroupSpaceBindingReportActionEntity>();
    @Column(name="PRETTY_NAME")
    private String prettyName;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Column(name="REGISTRATION")
    private SpaceRegistration registration;
    @Column(name="DESCRIPTION")
    private String description;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="AVATAR_LAST_UPDATED")
    private Date avatarLastUpdated;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="BANNER_LAST_UPDATED")
    private Date bannerLastUpdated;
    @Column(name="VISIBILITY")
    public SpaceVisibility visibility;
    @Column(name="GROUP_ID")
    public String groupId;
    @Column(name="URL")
    public String url;
    @Column(name="TEMPLATE_ID")
    private Long templateId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate = new Date();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPDATED_DATE", nullable=false)
    private Date updatedDate = new Date();
    @Column(name="PUBLIC_SITE_ID", nullable=false)
    private long publicSiteId;
    @Column(name="PUBLIC_SITE_VISIBILITY", nullable=false)
    private PublicSiteVisibility publicSiteVisibility = PublicSiteVisibility.MANAGER;
    @Convert(converter=StringListConverter.class)
    @Column(name="LAYOUT_PERMISSIONS")
    private List<String> layoutPermissions;
    @Convert(converter=StringListConverter.class)
    @Column(name="DELETE_PERMISSIONS")
    private List<String> deletePermissions;
    @Convert(converter=StringListConverter.class)
    @Column(name="PUBLIC_SITE_PERMISSIONS")
    private List<String> publicSitePermissions;
    @ElementCollection
    @CollectionTable(name="SOC_SPACE_CATEGORIES", joinColumns={@JoinColumn(name="SPACE_ID")})
    @OrderBy(value="createdDate asc")
    private List<SpaceCategoryEntity> categories = new ArrayList<SpaceCategoryEntity>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setPrettyName(String prettyName) {
        this.prettyName = prettyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public SpaceRegistration getRegistration() {
        return this.registration;
    }

    public void setRegistration(SpaceRegistration registration) {
        this.registration = registration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getAvatarLastUpdated() {
        return this.avatarLastUpdated;
    }

    public void setAvatarLastUpdated(Date avatarLastUpdated) {
        this.avatarLastUpdated = avatarLastUpdated;
    }

    public Date getBannerLastUpdated() {
        return this.bannerLastUpdated;
    }

    public void setBannerLastUpdated(Date bannerLastUpdated) {
        this.bannerLastUpdated = bannerLastUpdated;
    }

    public SpaceVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(SpaceVisibility visibility) {
        this.visibility = visibility;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public Set<SpaceMemberEntity> getMembers() {
        return this.members;
    }

    public void setMembers(Set<SpaceMemberEntity> members) {
        this.members = members;
    }

    public Set<GroupSpaceBindingEntity> getSpaceBindingEntities() {
        return this.spaceBindingEntities;
    }

    public void setSpaceBindingEntities(Set<GroupSpaceBindingEntity> spaceBindingEntities) {
        this.spaceBindingEntities = spaceBindingEntities;
    }

    public Set<GroupSpaceBindingReportActionEntity> getSpaceBindingReportEntities() {
        return this.spaceBindingReportEntities;
    }

    public void setSpaceBindingReportEntities(Set<GroupSpaceBindingReportActionEntity> spaceBindingReportEntities) {
        this.spaceBindingReportEntities = spaceBindingReportEntities;
    }

    public List<SpaceCategoryEntity> getCategories() {
        return this.categories;
    }

    public void setCategories(List<SpaceCategoryEntity> categories) {
        this.categories = categories;
    }

    public List<Long> getCategoryIds() {
        return this.getCategories().stream().map(SpaceCategoryEntity::getCategoryId).toList();
    }

    public void setCategoryIds(List<Long> categoryIds) {
        if (categoryIds == null || categoryIds.isEmpty()) {
            this.getCategories().clear();
        } else {
            Iterator<SpaceCategoryEntity> iterator = this.getCategories().iterator();
            while (iterator.hasNext()) {
                SpaceCategoryEntity category = iterator.next();
                if (categoryIds.contains(category.getCategoryId())) continue;
                iterator.remove();
            }
            for (Long categoryId : categoryIds) {
                this.addCategory(categoryId);
            }
        }
    }

    public void addCategory(long categoryId) {
        SpaceCategoryEntity category = new SpaceCategoryEntity(categoryId);
        if (!this.categories.contains(category)) {
            this.categories.add(0, category);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpaceEntity that = (SpaceEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.intValue();
    }

    @Generated
    public Long getTemplateId() {
        return this.templateId;
    }

    @Generated
    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    @Generated
    public long getPublicSiteId() {
        return this.publicSiteId;
    }

    @Generated
    public void setPublicSiteId(long publicSiteId) {
        this.publicSiteId = publicSiteId;
    }

    @Generated
    public PublicSiteVisibility getPublicSiteVisibility() {
        return this.publicSiteVisibility;
    }

    @Generated
    public void setPublicSiteVisibility(PublicSiteVisibility publicSiteVisibility) {
        this.publicSiteVisibility = publicSiteVisibility;
    }

    @Generated
    public List<String> getLayoutPermissions() {
        return this.layoutPermissions;
    }

    @Generated
    public void setLayoutPermissions(List<String> layoutPermissions) {
        this.layoutPermissions = layoutPermissions;
    }

    @Generated
    public List<String> getDeletePermissions() {
        return this.deletePermissions;
    }

    @Generated
    public void setDeletePermissions(List<String> deletePermissions) {
        this.deletePermissions = deletePermissions;
    }

    @Generated
    public List<String> getPublicSitePermissions() {
        return this.publicSitePermissions;
    }

    @Generated
    public void setPublicSitePermissions(List<String> publicSitePermissions) {
        this.publicSitePermissions = publicSitePermissions;
    }
}

