/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.service;

import io.meeds.social.space.category.service.SpaceCategoryService;
import io.meeds.social.space.model.SpacePermissions;
import io.meeds.social.space.model.SpaceTemplatePatch;
import io.meeds.social.space.service.SpaceAdministrationService;
import io.meeds.social.space.service.SpaceLayoutService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpaceAdministrationServiceImpl
implements SpaceAdministrationService {
    private static final String SPACE_NOT_FOUND_MESSAGE = "Space with id %s not found";
    private static final String SPACE_TEMPLATE_NOT_FOUND_MESSAGE = "Space Template with id %s not found";
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private SpaceTemplateService spaceTemplateService;
    @Autowired
    private SpaceLayoutService spaceLayoutService;
    @Autowired
    private SpaceCategoryService spaceCategoryService;

    public SpacePermissions getSpacePermissions(long spaceId) throws ObjectNotFoundException {
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ObjectNotFoundException(String.format(SPACE_NOT_FOUND_MESSAGE, spaceId));
        }
        List<String> layoutPermissions = space.getLayoutPermissions();
        List<String> publicSitePermissions = space.getPublicSitePermissions();
        List<String> deletePermissions = space.getDeletePermissions();
        if (space.getTemplateId() == 0L) {
            List<String> spaceAdminsPermission = Collections.singletonList(String.format("manager:%s", space.getGroupId()));
            if (CollectionUtils.isEmpty((Collection)layoutPermissions)) {
                layoutPermissions = spaceAdminsPermission;
            }
            if (CollectionUtils.isEmpty((Collection)publicSitePermissions)) {
                publicSitePermissions = spaceAdminsPermission;
            }
            if (CollectionUtils.isEmpty((Collection)deletePermissions)) {
                deletePermissions = spaceAdminsPermission;
            }
        }
        return new SpacePermissions((List)layoutPermissions, (List)publicSitePermissions, (List)deletePermissions);
    }

    public void updateSpacePermissions(long spaceId, SpacePermissions permissions) throws ObjectNotFoundException {
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ObjectNotFoundException(String.format(SPACE_NOT_FOUND_MESSAGE, spaceId));
        }
        space.setLayoutPermissions(permissions.getLayoutPermissions());
        space.setPublicSitePermissions(permissions.getPublicSitePermissions());
        space.setDeletePermissions(permissions.getDeletePermissions());
        this.spaceService.updateSpace(space);
    }

    public void applySpaceTemplate(long spaceId, SpaceTemplatePatch templatePatch) throws ObjectNotFoundException {
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new ObjectNotFoundException(String.format(SPACE_NOT_FOUND_MESSAGE, spaceId));
        }
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(templatePatch.getTemplateId());
        if (spaceTemplate == null || spaceTemplate.isDeleted() || !spaceTemplate.isEnabled()) {
            throw new ObjectNotFoundException(String.format(SPACE_TEMPLATE_NOT_FOUND_MESSAGE, templatePatch.getTemplateId()));
        }
        space.setTemplateId(templatePatch.getTemplateId());
        if (templatePatch.isAccessRules()) {
            space.setRegistration(spaceTemplate.getSpaceDefaultRegistration().name().toLowerCase());
            space.setVisibility(spaceTemplate.getSpaceDefaultVisibility().name().toLowerCase());
        }
        if (templatePatch.isDeletePermissions()) {
            SpaceUtils.setPermissionsFromTemplate(spaceTemplate::getSpaceDeletePermissions, arg_0 -> ((Space)space).setDeletePermissions(arg_0), space.getGroupId());
        }
        if (templatePatch.isLayoutPermissions()) {
            SpaceUtils.setPermissionsFromTemplate(spaceTemplate::getSpaceLayoutPermissions, arg_0 -> ((Space)space).setLayoutPermissions(arg_0), space.getGroupId());
        }
        if (templatePatch.isPublicSitePermissions()) {
            SpaceUtils.setPermissionsFromTemplate(spaceTemplate::getSpacePublicSitePermissions, arg_0 -> ((Space)space).setPublicSitePermissions(arg_0), space.getGroupId());
        }
        this.spaceService.updateSpace(space);
        if (templatePatch.isUpdateCategories()) {
            this.spaceCategoryService.updateSpaceCategories(spaceId, spaceTemplate.getSpaceDefaultCategoryIds(), templatePatch.isRemoveExistingCategories());
        }
        if (templatePatch.isEditorialMode()) {
            if (spaceTemplate.isSpaceAllowContentCreation() && ArrayUtils.isEmpty((Object[])space.getRedactors())) {
                Arrays.stream(space.getManagers()).forEach(m -> this.spaceService.addRedactor(space, m));
            } else if (!spaceTemplate.isSpaceAllowContentCreation() && ArrayUtils.isNotEmpty((Object[])space.getRedactors())) {
                Arrays.stream(space.getRedactors()).forEach(m -> this.spaceService.removeRedactor(space, m));
            }
        }
        if (templatePatch.isUpdateSite()) {
            this.spaceLayoutService.updateSpaceSite(space);
        }
    }

    @Generated
    public void setSpaceService(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @Generated
    public void setSpaceTemplateService(SpaceTemplateService spaceTemplateService) {
        this.spaceTemplateService = spaceTemplateService;
    }

    @Generated
    public void setSpaceLayoutService(SpaceLayoutService spaceLayoutService) {
        this.spaceLayoutService = spaceLayoutService;
    }

    @Generated
    public void setSpaceCategoryService(SpaceCategoryService spaceCategoryService) {
        this.spaceCategoryService = spaceCategoryService;
    }
}

