/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class ProfileFilterListAccess
implements ListAccess<Identity> {
    private IdentityStorage identityStorage;
    private ProfileFilter profileFilter;
    String providerId;
    boolean forceLoadProfile;
    Type type;

    public ProfileFilterListAccess(IdentityStorage identityStorage, String providerId, ProfileFilter profileFilter, boolean forceLoadProfile) {
        this.identityStorage = identityStorage;
        this.profileFilter = profileFilter;
        this.providerId = providerId;
        this.forceLoadProfile = forceLoadProfile;
    }

    public ProfileFilterListAccess(IdentityStorage identityStorage, String providerId, ProfileFilter profileFilter, boolean forceLoadProfile, Type type) {
        this.identityStorage = identityStorage;
        this.profileFilter = profileFilter;
        this.providerId = providerId;
        this.forceLoadProfile = forceLoadProfile;
        this.type = type;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        List identities;
        int usedLimit = limit;
        if (this.profileFilter != null && this.profileFilter.getViewerIdentity() != null) {
            ++usedLimit;
        }
        if (this.type != null && this.type == Type.UNIFIED_SEARCH) {
            identities = this.identityStorage.getIdentitiesForUnifiedSearch(this.providerId, this.profileFilter, (long)offset, (long)usedLimit);
        } else if (this.profileFilter == null || this.profileFilter.isEmpty()) {
            if (this.profileFilter == null || this.profileFilter.getViewerIdentity() == null) {
                if (this.profileFilter == null) {
                    identities = this.identityStorage.getIdentities(this.providerId, (long)offset, (long)usedLimit);
                } else {
                    sorting = this.profileFilter.getSorting();
                    boolean isEnabled = this.profileFilter.isEnabled();
                    String userType = this.profileFilter.getUserType();
                    Boolean isConnected = this.profileFilter.isConnected();
                    String enrollmentStatus = this.profileFilter.getEnrollmentStatus();
                    ArrayList remoteIds = this.profileFilter.getRemoteIds();
                    String sortFieldName = sorting == null || sorting.sortBy == null ? null : sorting.sortBy.getFieldName();
                    String sortDirection = sorting == null || sorting.sortBy == null ? null : sorting.orderBy.name();
                    List groupIds = this.profileFilter.getGroupIds();
                    if (CollectionUtils.isNotEmpty((Collection)groupIds)) {
                        HashSet userNames = new HashSet();
                        for (String groupId : groupIds) {
                            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
                            Group group = organizationService.getGroupHandler().findGroupById(groupId);
                            ListAccess membershipsListAccess = organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
                            int membershipSize = membershipsListAccess.getSize();
                            if (membershipSize <= 0) continue;
                            Membership[] memberships = (Membership[])membershipsListAccess.load(0, membershipSize);
                            Arrays.stream(memberships).filter(Objects::nonNull).map(Membership::getUserName).forEach(userNames::add);
                        }
                        if (CollectionUtils.isEmpty((Collection)remoteIds)) {
                            remoteIds = new ArrayList(userNames);
                        } else {
                            remoteIds.retainAll(userNames);
                        }
                    }
                    this.profileFilter.setRemoteIds((List)remoteIds);
                    identities = this.identityStorage.getIdentities(this.providerId, sortFieldName, sortDirection, isEnabled, userType, isConnected, enrollmentStatus, remoteIds, (long)offset, (long)usedLimit);
                }
            } else {
                sorting = this.profileFilter.getSorting();
                String sortFieldName = sorting == null || sorting.sortBy == null ? null : sorting.sortBy.getFieldName();
                String sortDirection = sorting == null || sorting.sortBy == null ? null : sorting.orderBy.name();
                identities = this.identityStorage.getIdentitiesWithRelationships(this.profileFilter.getViewerIdentity().getId(), sortFieldName, sortDirection, offset, usedLimit);
            }
        } else {
            List groupIds = this.profileFilter.getGroupIds();
            if (CollectionUtils.isNotEmpty((Collection)groupIds)) {
                SpaceUtils spaceUtils = (SpaceUtils)ExoContainerContext.getService(SpaceUtils.class);
                Set<String> groupIdentityIds = SpaceUtils.getUserPermissionsIdentityIds(groupIds);
                List spaceIdentityIds = this.profileFilter.getSpaceIdentityIds();
                if (CollectionUtils.isEmpty((Collection)spaceIdentityIds)) {
                    this.profileFilter.setSpaceIdentityIds(new ArrayList<String>(groupIdentityIds));
                } else {
                    spaceIdentityIds.retainAll(groupIdentityIds);
                    this.profileFilter.setSpaceIdentityIds(spaceIdentityIds);
                }
            }
            identities = this.identityStorage.getIdentitiesForMentions(this.providerId, this.profileFilter, null, (long)offset, (long)usedLimit, this.forceLoadProfile);
        }
        if (this.profileFilter != null && this.profileFilter.getViewerIdentity() != null) {
            identities = new ArrayList(identities);
            Iterator iterator = identities.iterator();
            while (iterator.hasNext()) {
                Identity identity = (Identity)iterator.next();
                if (identity != null && (this.profileFilter.getViewerIdentity() == null || !identity.getId().equals(this.profileFilter.getViewerIdentity().getId()))) continue;
                iterator.remove();
            }
            if (identities.size() > limit) {
                identities = new ArrayList(identities);
                identities.remove(identities.size() - 1);
            }
        }
        return identities.toArray(new Identity[0]);
    }

    public int getSize() throws Exception {
        int size = 0;
        if (this.profileFilter.isEmpty()) {
            if (this.profileFilter.getViewerIdentity() == null) {
                size = this.identityStorage.getIdentitiesByProfileFilterCount(this.providerId, this.profileFilter);
            } else {
                size = this.identityStorage.countIdentitiesWithRelationships(this.profileFilter.getViewerIdentity().getId());
                --size;
            }
        } else {
            size = this.identityStorage.getIdentitiesForMentionsCount(this.providerId, this.profileFilter, null);
        }
        return size;
    }

    public static enum Type {
        ALL,
        BY_FIRST_CHARACTER_OF_NAME,
        MENTION,
        UNIFIED_SEARCH;

    }
}

