/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.test.AbstractCoreTest;

public class SocialMembershipListenerImplTest
extends AbstractCoreTest {
    private final Log LOG = ExoLogger.getLogger(SocialMembershipListenerImplTest.class);
    private OrganizationService organizationService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        Identity root = identityManager.getOrCreateIdentity("organization", "root", false);
        identityManager.getOrCreateIdentity("organization", "john", false);
        identityManager.getOrCreateIdentity("organization", "mary", false);
        identityManager.getOrCreateIdentity("organization", "demo", false);
        identityManager.getOrCreateIdentity("organization", "ghost", false);
        ConversationState.setCurrent((ConversationState)new ConversationState(new org.exoplatform.services.security.Identity("root")));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPostSave() {
        Space sFoo = new Space();
        sFoo.setDisplayName("postsave");
        sFoo.setPrettyName("postsave");
        sFoo.setDescription("postsave description");
        sFoo.setManagers(new String[]{"root"});
        sFoo.setRegistration("open");
        sFoo = this.createSpaceNonInitApps(sFoo, "root", null);
        sFoo.setEditor("mary");
        this.addUserToGroupWithMembership("demo", sFoo.getGroupId(), "manager");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((String)sFoo.getEditor(), (String)"mary");
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getMembers().length);
        this.addUserToGroupWithMembership("john", sFoo.getGroupId(), "member");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)3, (int)sFoo.getMembers().length);
        this.addUserToGroupWithMembership("mary", sFoo.getGroupId(), "*");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)3, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)4, (int)sFoo.getMembers().length);
        this.addUserToGroupWithMembership("ghost", sFoo.getGroupId(), "validator");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)3, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)4, (int)sFoo.getMembers().length);
        this.addUserToGroupWithMembership("demo", sFoo.getGroupId(), "redactor");
        SocialMembershipListenerImplTest.assertTrue((boolean)this.spaceService.isRedactor(sFoo, "demo"));
        sFoo.setEditor(null);
        this.addUserToGroupWithMembership("john", sFoo.getGroupId(), "manager");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((String)sFoo.getEditor(), (String)"root");
    }

    public void testPostDelete() throws Exception {
        Space sFoo = new Space();
        sFoo.setDisplayName("postdelete");
        sFoo.setPrettyName("postdelete");
        sFoo.setDescription("postdelete description");
        sFoo.setManagers(new String[]{"root"});
        sFoo.setRegistration("open");
        sFoo = this.createSpaceNonInitApps(sFoo, "root", null);
        this.addUserToGroupWithMembership("mary", sFoo.getGroupId(), "*");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getMembers().length);
        MembershipHandler membershipHandler = this.organizationService.getMembershipHandler();
        membershipHandler.removeMembershipByUser("mary", true);
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)1, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)1, (int)sFoo.getMembers().length);
        this.addUserToGroupWithMembership("john", sFoo.getGroupId(), "member");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)1, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getMembers().length);
        sFoo.setEditor("mary");
        membershipHandler.removeMembershipByUser("john", true);
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((String)sFoo.getEditor(), (String)"mary");
        SocialMembershipListenerImplTest.assertEquals((int)1, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)1, (int)sFoo.getMembers().length);
        this.addUserToGroupWithMembership("john", sFoo.getGroupId(), "manager");
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)2, (int)sFoo.getMembers().length);
        membershipHandler.removeMembershipByUser("john", true);
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((int)1, (int)sFoo.getManagers().length);
        SocialMembershipListenerImplTest.assertEquals((int)1, (int)sFoo.getMembers().length);
        this.addUserToGroupWithMembership("john", sFoo.getGroupId(), "manager");
        sFoo.setEditor(null);
        membershipHandler.removeMembershipByUser("john", true);
        sFoo = this.spaceService.getSpaceById(sFoo.getId());
        SocialMembershipListenerImplTest.assertEquals((String)sFoo.getEditor(), (String)"root");
    }
}

