/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreImportService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.listeners.SynchronizedUserProfileListener;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SynchronizedUserProfileListenerTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS_UTIL = Mockito.mockStatic(CommonsUtils.class);
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ProfilePropertyService profilePropertyService;
    @Mock
    private IDMExternalStoreImportService idmExternalStoreImportService;

    @Test
    public void onEventTest() throws Exception {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        String userName = "john";
        COMMONS_UTILS_UTIL.when(() -> CommonsUtils.getService(IdentityManager.class)).thenReturn((Object)this.identityManager);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", userName)).thenReturn((Object)userIdentity);
        Profile profile = new Profile();
        profile.setProperty("username", (Object)userName);
        HashMap<String, String> externalUserProfileProperties = new HashMap<String, String>();
        externalUserProfileProperties.put("username", userName);
        externalUserProfileProperties.put("phones.home", "12345678");
        externalUserProfileProperties.put("phones.work", "12131415");
        externalUserProfileProperties.put("ims.facebook", "testImsProperty");
        Mockito.when((Object)userIdentity.getProfile()).thenReturn((Object)profile);
        COMMONS_UTILS_UTIL.when(() -> CommonsUtils.getService(ProfilePropertyService.class)).thenReturn((Object)this.profilePropertyService);
        String[] propertySettingNames = new String[]{"firstName", "lastName", "email", "skills", "external", "phones", "phones.work", "phones.home", "urls", "ims", "ims.facebook", "ims.other"};
        Mockito.when((Object)this.profilePropertyService.getPropertySettingNames()).thenReturn(Arrays.asList(propertySettingNames));
        ProfilePropertySetting phonesPropertySetting = (ProfilePropertySetting)Mockito.mock(ProfilePropertySetting.class);
        ProfilePropertySetting imsPropertySetting = (ProfilePropertySetting)Mockito.mock(ProfilePropertySetting.class);
        Mockito.when((Object)phonesPropertySetting.getPropertyName()).thenReturn((Object)"phones");
        Mockito.when((Object)imsPropertySetting.getPropertyName()).thenReturn((Object)"ims");
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName(phonesPropertySetting.getPropertyName())).thenReturn((Object)phonesPropertySetting);
        Mockito.when((Object)this.profilePropertyService.getProfileSettingByName(imsPropertySetting.getPropertyName())).thenReturn((Object)imsPropertySetting);
        Event importUserProfile = new Event("exo.idm.externalStore.user.profile.new", (Object)this.idmExternalStoreImportService, externalUserProfileProperties);
        SynchronizedUserProfileListener synchronizedUserProfileListener = new SynchronizedUserProfileListener();
        synchronizedUserProfileListener.onEvent(importUserProfile);
        Assert.assertEquals((long)3L, (long)profile.getProperties().size());
        ArrayList expectedPhonesProperty = new ArrayList();
        HashMap<String, String> homePhonesMap = new HashMap<String, String>();
        homePhonesMap.put("key", "phones.home");
        homePhonesMap.put("value", (String)externalUserProfileProperties.get("phones.home"));
        HashMap<String, String> workPhonesMap = new HashMap<String, String>();
        workPhonesMap.put("key", "phones.work");
        workPhonesMap.put("value", (String)externalUserProfileProperties.get("phones.work"));
        expectedPhonesProperty.add(homePhonesMap);
        expectedPhonesProperty.add(workPhonesMap);
        Assert.assertEquals((Object)profile.getProperty("phones"), expectedPhonesProperty);
        ArrayList expectedImsProperty = new ArrayList();
        HashMap<String, String> facebookImsMap = new HashMap<String, String>();
        facebookImsMap.put("key", "ims.facebook");
        facebookImsMap.put("value", (String)externalUserProfileProperties.get("ims.facebook"));
        expectedImsProperty.add(facebookImsMap);
        Assert.assertEquals((Object)profile.getProperty("ims"), expectedImsProperty);
        ((IdentityManager)Mockito.verify((Object)this.identityManager, (VerificationMode)Mockito.times((int)1))).updateProfile(profile, true);
    }
}

