/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.model;

import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;

public class ExoSocialActivityImplTest
extends TestCase {
    public void testOpenSocialCompatibility() {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setPriority(null);
        ExoSocialActivityImplTest.assertNull((Object)activity.getPriority());
        activity.setPriority(Float.valueOf(0.5f));
        ExoSocialActivityImplTest.assertEquals((String)"activity.getPriority() must be: 0.5", (Object)Float.valueOf(0.5f), (Object)activity.getPriority());
        activity.setPriority(Float.valueOf(0.3f));
        activity.setType("opensocial:foo");
        ExoSocialActivityImplTest.assertEquals((String)"opensocial:foo", (String)activity.getType());
        activity.setAppId("bar");
        ExoSocialActivityImplTest.assertEquals((String)"bar", (String)activity.getAppId());
        Date date = new GregorianCalendar(2010, 4, 6, 21, 55).getTime();
        activity.setUpdated(Long.valueOf(date.getTime()));
        ExoSocialActivityImplTest.assertEquals((Object)date, (Object)activity.getUpdated());
        activity.setUpdated(Long.valueOf(date.getTime()));
        ExoSocialActivityImplTest.assertEquals((long)activity.getUpdated().getTime(), (long)date.getTime());
        ExoSocialActivityImplTest.assertNull((Object)activity.getStreamFaviconUrl());
        ExoSocialActivityImplTest.assertNull((Object)activity.getStreamSourceUrl());
        ExoSocialActivityImplTest.assertNull((Object)activity.getStreamTitle());
        ExoSocialActivityImplTest.assertNull((Object)activity.getStreamUrl());
        ActivityStreamImpl activityStream = new ActivityStreamImpl();
        activityStream.setFaviconUrl("favicon");
        activityStream.setPermaLink("source");
        activityStream.setTitle("title");
        activity.setActivityStream((ActivityStream)activityStream);
        ExoSocialActivityImplTest.assertEquals((String)activityStream.getFaviconUrl(), (String)activity.getStreamFaviconUrl());
        ExoSocialActivityImplTest.assertEquals((String)activityStream.getPermaLink(), (String)activity.getStreamSourceUrl());
        ExoSocialActivityImplTest.assertEquals((String)activityStream.getTitle(), (String)activity.getStreamTitle());
        ExoSocialActivityImplTest.assertNull((Object)activity.getTitle());
        ExoSocialActivityImplTest.assertNull((Object)activity.getTitleId());
        activity.setTitle("foo bar");
        ExoSocialActivityImplTest.assertEquals((String)"foo bar", (String)activity.getTitle());
        activity.setTitleId("FOO_BAR");
        ExoSocialActivityImplTest.assertEquals((String)"FOO_BAR", (String)activity.getTitleId());
    }
}

