/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.plugin;

import io.meeds.portal.navigation.constant.SidebarItemType;
import io.meeds.portal.navigation.model.SidebarItem;
import io.meeds.social.category.AbstractCategoryConfigurationTest;
import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategoryTree;
import io.meeds.social.navigation.plugin.SpaceCategorySidebarPlugin;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class SpaceCategorySidebarPluginTest
extends AbstractCategoryConfigurationTest {
    @Autowired
    protected SpaceCategorySidebarPlugin spaceCategorySidebarPlugin;

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)SidebarItemType.SPACE_CATEGORY, (Object)this.spaceCategorySidebarPlugin.getType());
    }

    @Test
    public void testGetDefaultItems() {
        List defaultItems = this.spaceCategorySidebarPlugin.getDefaultItems();
        Assert.assertNotNull((Object)defaultItems);
        Assert.assertTrue((boolean)defaultItems.isEmpty());
    }

    @Test
    public void testItemExists() {
        Assert.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(null, null));
        Assert.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(new SidebarItem(), null));
        Assert.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(new SidebarItem(), "root"));
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", "1265488"));
        Assert.assertFalse((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "root"));
        this.buildCategoryTree();
        CategoryFilter filter = new CategoryFilter(null, 0L, 0L, 5L, 0L, 2L, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "john", Locale.ENGLISH);
        CategoryTree subCategory1 = (CategoryTree)categoryTree.getCategories().getFirst();
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        Assert.assertTrue((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "root"));
        Assert.assertTrue((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "mary"));
        this.categoryService.updateCategory((Category)subCategory1, "john");
        Assert.assertTrue((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "root"));
        Assert.assertTrue((boolean)this.spaceCategorySidebarPlugin.itemExists(item, "mary"));
    }

    @Test
    public void testResolveProperties() {
        this.buildCategoryTree();
        CategoryFilter filter = new CategoryFilter(null, 0L, 0L, 5L, 0L, 2L, false, false);
        CategoryTree categoryTree = this.categoryService.getCategoryTree(filter, "john", Locale.ENGLISH);
        CategoryTree subCategory1 = (CategoryTree)categoryTree.getCategories().get(0);
        CategoryTree subCategory2 = (CategoryTree)categoryTree.getCategories().get(1);
        SidebarItem item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        Assert.assertNotNull((Object)item.getName());
        Assert.assertEquals((Object)subCategory1.getName(), (Object)item.getName());
        Assert.assertNotNull((Object)item.getIcon());
        Assert.assertEquals((Object)subCategory1.getIcon(), (Object)item.getIcon());
        Assert.assertNull((Object)item.getUrl());
        Assert.assertNull((Object)item.getTarget());
        Assert.assertNull((Object)item.getAvatar());
        Assert.assertFalse((boolean)item.isDefaultPath());
        Assert.assertNotNull((Object)item.getItems());
        Assert.assertEquals((long)0L, (long)item.getItems().size());
        for (int i = 0; i < 5; ++i) {
            Space space = new Space();
            space.setRegistration("open");
            space.setVisibility("public");
            space = this.spaceService.createSpace(space, "root");
            space.setCategoryIds(Collections.singletonList(subCategory1.getId()));
            this.spaceService.updateSpace(space);
        }
        item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(categoryTree.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        Assert.assertNotNull((Object)item.getItems());
        Assert.assertEquals((long)4L, (long)item.getItems().size());
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        Assert.assertNotNull((Object)item.getItems());
        Assert.assertEquals((long)4L, (long)item.getItems().size());
        Assert.assertTrue((boolean)((SidebarItem)item.getItems().get(0)).isDefaultPath());
        item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory1.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "mary", Locale.ENGLISH);
        Assert.assertNotNull((Object)item.getItems());
        Assert.assertEquals((long)0L, (long)item.getItems().size());
        item = new SidebarItem(SidebarItemType.SPACE_CATEGORY);
        item.setProperties(Collections.singletonMap("spaceCategoryId", String.valueOf(subCategory2.getId())));
        this.spaceCategorySidebarPlugin.resolveProperties(item, "root", Locale.ENGLISH);
        Assert.assertNotNull((Object)item.getItems());
        Assert.assertEquals((long)0L, (long)item.getItems().size());
    }
}

