/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.social.core.processor.ActivityResourceBundlePlugin;

public class ActivityResourceBundlePluginTest
extends TestCase {
    private static final String ACTIVITY_TYPE = "activity:fake";
    private static final String RESOURCE_BUNDLE_KEY_FILE = "FakeResourceBundle";
    private Map<String, String> activityKeyTypeMapping;

    public void setUp() throws Exception {
        super.setUp();
        this.activityKeyTypeMapping = new HashMap<String, String>();
        this.activityKeyTypeMapping.put("hello", "FakeResourceBundle.hello");
    }

    public void testGetActivityKeyType() throws Exception {
        ObjectParameter objectParameter = this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, this.activityKeyTypeMapping);
        InitParams initParams = new InitParams();
        initParams.addParam((Object)objectParameter);
        ActivityResourceBundlePlugin activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(ACTIVITY_TYPE);
        ActivityResourceBundlePluginTest.assertEquals((String)ACTIVITY_TYPE, (String)activityResourceBundlePlugin.getActivityType());
    }

    public void testGetActivityKeyTypeMapping() throws Exception {
        ObjectParameter objectParameter = this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, this.activityKeyTypeMapping);
        InitParams initParams = new InitParams();
        initParams.addParam((Object)objectParameter);
        ActivityResourceBundlePlugin activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(ACTIVITY_TYPE);
        ActivityResourceBundlePluginTest.assertEquals(this.activityKeyTypeMapping, (Object)activityResourceBundlePlugin.getActivityKeyTypeMapping());
    }

    public void testGetResourceBundleKeyFile() throws Exception {
        ObjectParameter objectParameter = this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, this.activityKeyTypeMapping);
        InitParams initParams = new InitParams();
        initParams.addParam((Object)objectParameter);
        ActivityResourceBundlePlugin activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(ACTIVITY_TYPE);
        ActivityResourceBundlePluginTest.assertEquals((String)RESOURCE_BUNDLE_KEY_FILE, (String)activityResourceBundlePlugin.getResourceBundleKeyFile());
    }

    public void testHasMessageBundleKey() throws Exception {
        ObjectParameter objectParameter = this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, this.activityKeyTypeMapping);
        InitParams initParams = new InitParams();
        initParams.addParam((Object)objectParameter);
        ActivityResourceBundlePlugin activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(ACTIVITY_TYPE);
        ActivityResourceBundlePluginTest.assertFalse((boolean)activityResourceBundlePlugin.hasMessageBundleKey("hell"));
        ActivityResourceBundlePluginTest.assertTrue((boolean)activityResourceBundlePlugin.hasMessageBundleKey("hello"));
    }

    public void testGetMessageBundleKey() throws Exception {
        ObjectParameter objectParameter = this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, this.activityKeyTypeMapping);
        InitParams initParams = new InitParams();
        initParams.addParam((Object)objectParameter);
        ActivityResourceBundlePlugin activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(ACTIVITY_TYPE);
        ActivityResourceBundlePluginTest.assertNull((Object)activityResourceBundlePlugin.getMessageBundleKey("hell"));
        ActivityResourceBundlePluginTest.assertEquals((String)"FakeResourceBundle.hello", (String)activityResourceBundlePlugin.getMessageBundleKey("hello"));
    }

    public void testIsValid() throws Exception {
        ActivityResourceBundlePlugin activityResourceBundlePlugin = new ActivityResourceBundlePlugin(null);
        ActivityResourceBundlePluginTest.assertFalse((boolean)activityResourceBundlePlugin.isValid());
        activityResourceBundlePlugin = new ActivityResourceBundlePlugin(new InitParams());
        ActivityResourceBundlePluginTest.assertFalse((boolean)activityResourceBundlePlugin.isValid());
        InitParams initParams = new InitParams();
        initParams.addParam((Object)this.getObjectParameter(null, null));
        activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(null);
        ActivityResourceBundlePluginTest.assertFalse((boolean)activityResourceBundlePlugin.isValid());
        initParams = new InitParams();
        initParams.addParam((Object)this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, null));
        activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(null);
        ActivityResourceBundlePluginTest.assertFalse((boolean)activityResourceBundlePlugin.isValid());
        initParams = new InitParams();
        initParams.addParam((Object)this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, this.activityKeyTypeMapping));
        activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(null);
        ActivityResourceBundlePluginTest.assertFalse((boolean)activityResourceBundlePlugin.isValid());
        initParams = new InitParams();
        initParams.addParam((Object)this.getObjectParameter(RESOURCE_BUNDLE_KEY_FILE, this.activityKeyTypeMapping));
        activityResourceBundlePlugin = new ActivityResourceBundlePlugin(initParams);
        activityResourceBundlePlugin.setActivityType(ACTIVITY_TYPE);
        ActivityResourceBundlePluginTest.assertTrue((boolean)activityResourceBundlePlugin.isValid());
    }

    private ObjectParameter getObjectParameter(String resourceBundleKeyFile, Map<String, String> activityKeyTypeMapping) {
        ObjectParameter objectParameter = new ObjectParameter();
        objectParameter.setName(resourceBundleKeyFile);
        ActivityResourceBundlePlugin pluginConfig = new ActivityResourceBundlePlugin();
        pluginConfig.setActivityKeyTypeMapping(activityKeyTypeMapping);
        objectParameter.setObject((Object)pluginConfig);
        return objectParameter;
    }
}

