/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.notification.AbstractCoreTest;
import org.exoplatform.social.notification.impl.SpaceWebNotificationServiceImpl;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.plugin.SpaceWebNotificationPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceWebNotificationServiceTest
extends AbstractCoreTest {
    private static final String ACTIVITY_ID_PROP = "activityId";
    private static final String METADATA_TYPE_NAME = "unread";
    private static final String activityId = "5556";
    private static final String METADATA_OBJECT_TYPE = "activity";
    private static final long userIdentityId = 15L;
    private static final long spaceId = 12L;
    @Mock
    private MetadataService metadataService;
    @Mock
    private ListenerService listenerService;
    @Mock
    private PluginSettingService pluginSettingService;
    @Mock
    IdentityManager identityManager;
    @Mock
    SpaceService spaceService;
    private static SpaceWebNotificationServiceImpl spaceWebNotificationService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        spaceWebNotificationService = new SpaceWebNotificationServiceImpl(this.getContainer(), this.metadataService, this.pluginSettingService, this.listenerService, this.identityManager, this.spaceService);
    }

    @Test
    public void testMarkAsUnread() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(null));
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        spaceWebNotificationService = new SpaceWebNotificationServiceImpl(this.getContainer(), this.metadataService, this.pluginSettingService, this.listenerService, this.identityManager, this.spaceService);
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(null));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem(null, "itemId", 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem("appName", null, 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem("appName", "itemId", 0L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem("appName", "itemId", 15L, 0L)));
        spaceWebNotificationService.markAsUnread(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.eq((Object)metadataObject), (MetadataKey)ArgumentMatchers.eq((Object)metadataKey), (Map)ArgumentMatchers.any(), ArgumentMatchers.eq((long)15L));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    @Test
    public void testDispatchNotification() throws Exception {
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 0L);
        SpaceWebNotificationPlugin spaceWebNotificationPlugin = (SpaceWebNotificationPlugin)Mockito.mock(SpaceWebNotificationPlugin.class);
        spaceWebNotificationService.addPlugin(spaceWebNotificationPlugin);
        String username = "testuser";
        NotificationInfo notificationInfo = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        BaseNotificationPlugin notificationPlugin = (BaseNotificationPlugin)Mockito.mock(BaseNotificationPlugin.class);
        Mockito.when((Object)notificationPlugin.getId()).thenReturn((Object)"notificationPlugin");
        PluginKey pluginKey = new PluginKey(notificationPlugin);
        Mockito.when((Object)notificationInfo.getKey()).thenReturn((Object)pluginKey);
        Mockito.when((Object)spaceWebNotificationPlugin.getSpaceApplicationItem(notificationInfo, username)).thenReturn((Object)spaceWebNotificationItem);
        Mockito.when((Object)spaceWebNotificationPlugin.isManagedPlugin(pluginKey)).thenReturn((Object)true);
        spaceWebNotificationService.dispatch(notificationInfo, username);
        ((SpaceWebNotificationPlugin)Mockito.verify((Object)spaceWebNotificationPlugin, (VerificationMode)Mockito.times((int)1))).getSpaceApplicationItem(notificationInfo, username);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadataService, this.listenerService});
        spaceWebNotificationItem.setSpaceId(12L);
        spaceWebNotificationService.dispatch(notificationInfo, username);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.any(), (MetadataKey)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    @Test
    public void testMarkAsUnreadWithSubItems() throws Exception {
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        String itemId1 = "subItem1";
        spaceWebNotificationItem.setActivityId(activityId);
        spaceWebNotificationItem.addApplicationSubItem(itemId1);
        spaceWebNotificationItem.setActivityActionType("Like");
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        spaceWebNotificationService.markAsUnread(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.eq((Object)metadataObject), (MetadataKey)ArgumentMatchers.eq((Object)metadataKey), (Map)ArgumentMatchers.argThat(props -> props != null && props.size() == 3 && itemId1.equals(props.get("applicationSubItemIds")) && spaceWebNotificationItem.getActivityId().equals(props.get(ACTIVITY_ID_PROP))), ArgumentMatchers.eq((long)15L));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    @Test
    public void testMarkAsUnreadWithExistingSubItems() throws Exception {
        String itemId1 = "subItem1";
        Map<String, String> properties = Collections.singletonMap("applicationSubItemIds", itemId1);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        MetadataItem metadataItem = new MetadataItem(1L, this.newMetadata(), metadataObject, 15L, 12L, properties);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject)).thenReturn(Collections.singletonList(metadataItem));
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        String itemId2 = "subItem2";
        spaceWebNotificationItem.addApplicationSubItem(itemId2);
        spaceWebNotificationItem.setActivityId(activityId);
        spaceWebNotificationItem.setActivityActionType("Like");
        spaceWebNotificationService.markAsUnread(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.eq((Object)metadataObject), (MetadataKey)ArgumentMatchers.eq((Object)metadataKey), (Map)ArgumentMatchers.argThat(props -> props != null && props.size() == 3 && (itemId1 + "," + itemId2).equals(props.get("applicationSubItemIds")) && spaceWebNotificationItem.getActivityId().equals(props.get(ACTIVITY_ID_PROP))), ArgumentMatchers.eq((long)15L));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    private Metadata newMetadata() {
        return new Metadata(7L, new MetadataType(6L, METADATA_TYPE_NAME), METADATA_OBJECT_TYPE, 12L, 15L, System.currentTimeMillis(), null);
    }

    @Test
    public void testMarkAllAsRead() throws Exception {
        spaceWebNotificationService.markAllAsRead(15L, 12L);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).deleteByMetadataTypeAndSpaceIdAndCreatorId(METADATA_TYPE_NAME, 12L, 15L);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.read.allItems", (Object)new SpaceWebNotificationItem(null, null, 15L, 12L), (Object)15L);
    }

    @Test
    public void testCountUnreadItemsByApplication() throws Exception {
        Map<String, Long> expectedResult = Collections.singletonMap(METADATA_OBJECT_TYPE, 5L);
        Mockito.when((Object)this.metadataService.countMetadataItemsByMetadataTypeAndAudienceId(METADATA_TYPE_NAME, 15L, 12L)).thenReturn(expectedResult);
        Map result = spaceWebNotificationService.countUnreadItemsByApplication(15L, 12L);
        SpaceWebNotificationServiceTest.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void testCountUnreadActivities() {
        Map<Long, Long> expectedResult = Collections.singletonMap(12L, 5L);
        String username = "test";
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)String.valueOf(15L));
        Mockito.when((Object)this.spaceService.getMemberSpacesIds(username, 0, -1)).thenReturn(Collections.singletonList(String.valueOf(12L)));
        Mockito.when((Object)this.metadataService.countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(METADATA_TYPE_NAME, 15L, Collections.singletonList(12L))).thenReturn(expectedResult);
        long result = spaceWebNotificationService.countUnreadActivities(username);
        SpaceWebNotificationServiceTest.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testCountUnreadActivitiesBySpace() throws IllegalAccessException, ObjectNotFoundException {
        Map<Long, Long> expectedResult = Collections.singletonMap(12L, 5L);
        Mockito.when((Object)this.metadataService.countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(METADATA_TYPE_NAME, 15L, Collections.singletonList(12L))).thenReturn(expectedResult);
        String username = "test";
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)String.valueOf(15L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> spaceWebNotificationService.countUnreadActivitiesBySpace(username, 12L));
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceById(String.valueOf(12L))).thenReturn((Object)space);
        Assert.assertThrows(IllegalAccessException.class, () -> spaceWebNotificationService.countUnreadActivitiesBySpace(username, 12L));
        Mockito.when((Object)this.spaceService.canViewSpace(space, username)).thenReturn((Object)true);
        long result = spaceWebNotificationService.countUnreadActivitiesBySpace(username, 12L);
        SpaceWebNotificationServiceTest.assertEquals((long)5L, (long)result);
    }

    @Test
    public void testGetUnreadActivityIds() {
        String username = "test";
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)String.valueOf(15L));
        List<String> spaceIds = Collections.singletonList(String.valueOf(12L));
        Mockito.when((Object)this.spaceService.getMemberSpacesIds(username, 0, -1)).thenReturn(spaceIds);
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getProperties()).thenReturn(Collections.singletonMap(ACTIVITY_ID_PROP, activityId));
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataNameAndTypeAndSpaceIds(String.valueOf(15L), METADATA_TYPE_NAME, spaceIds.stream().map(Long::parseLong).toList(), 0L, 10L)).thenReturn(Collections.singletonList(metadataItem));
        List result = spaceWebNotificationService.getUnreadActivityIds(username, 0L, 10L);
        SpaceWebNotificationServiceTest.assertEquals(Collections.singletonList(Long.parseLong(activityId)), (Object)result);
    }

    @Test
    public void testGetUnreadActivityIdsBySpace() throws IllegalAccessException, ObjectNotFoundException {
        List<String> spaceIds = Collections.singletonList(String.valueOf(12L));
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getProperties()).thenReturn(Collections.singletonMap(ACTIVITY_ID_PROP, activityId));
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataNameAndTypeAndSpaceIds(String.valueOf(15L), METADATA_TYPE_NAME, spaceIds.stream().map(Long::parseLong).toList(), 0L, 10L)).thenReturn(Collections.singletonList(metadataItem));
        String username = "test";
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)String.valueOf(15L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> spaceWebNotificationService.getUnreadActivityIdsBySpace(username, 12L, 0L, 10L));
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceById(String.valueOf(12L))).thenReturn((Object)space);
        Assert.assertThrows(IllegalAccessException.class, () -> spaceWebNotificationService.getUnreadActivityIdsBySpace(username, 12L, 0L, 10L));
        Mockito.when((Object)this.spaceService.canViewSpace(space, username)).thenReturn((Object)true);
        List result = spaceWebNotificationService.getUnreadActivityIdsBySpace(username, 12L, 0L, 10L);
        SpaceWebNotificationServiceTest.assertEquals(Collections.singletonList(Long.parseLong(activityId)), (Object)result);
    }

    @Test
    public void testCountUnreadItemsBySpace() throws Exception {
        List spaceIds = new ArrayList();
        Identity rootIdentity = new Identity();
        rootIdentity.setId("1");
        rootIdentity.setProviderId("organization");
        rootIdentity.setRemoteId("root");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("root")).thenReturn((Object)rootIdentity);
        Space space = new Space();
        space.setId("1");
        this.spaceService.addMember(space, rootIdentity.getRemoteId());
        spaceIds = this.spaceService.getMemberSpacesIds("root", 0, -1);
        List spacesId = spaceIds.stream().map(e -> Long.parseLong(e)).collect(Collectors.toList());
        Map<Long, Long> expectedResult = Collections.singletonMap(Long.parseLong(space.getId()), 5L);
        Mockito.when((Object)this.metadataService.countMetadataItemsByMetadataTypeAndSpacesIdAndCreatorId(METADATA_TYPE_NAME, Long.parseLong(rootIdentity.getId()), spacesId)).thenReturn(expectedResult);
        Map result = spaceWebNotificationService.countUnreadItemsBySpace(rootIdentity.getRemoteId());
        SpaceWebNotificationServiceTest.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void testMarkAsRead() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(null));
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        Metadata metadata = this.newMetadata();
        long metadataItemId = 5L;
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject)).thenReturn(Arrays.asList(new MetadataItem(metadataItemId, metadata, metadataObject, 15L, System.currentTimeMillis(), null)));
        spaceWebNotificationService = new SpaceWebNotificationServiceImpl(this.getContainer(), this.metadataService, this.pluginSettingService, this.listenerService, this.identityManager, this.spaceService);
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(null));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem(null, "itemId", 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem("appName", null, 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem("appName", "itemId", 0L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem("appName", "itemId", 15L, 0L)));
        spaceWebNotificationService.markAsRead(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).deleteMetadataItem(metadataItemId, true);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.read.item", (Object)spaceWebNotificationItem, (Object)15L);
    }
}

