/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.security.plugin;

import io.meeds.social.security.plugin.EmailOtpPlugin;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.security.security.SecureRandomService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class EmailOtpPluginTest {
    private static final String OTP_CODE = "123456";
    @Mock
    private CacheService cacheService;
    @Mock
    private SecureRandomService secureRandomService;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private BrandingService brandingService;
    @Mock
    private MailService mailService;
    @Mock
    private SecureRandom secureRandom;
    @Mock
    private ExoCache<String, String> otpCache;
    @Mock
    private UserHandler userHandler;
    @Mock
    private UserProfileHandler userProfileHandler;
    @Mock
    private User user;
    @Mock
    private UserProfile userProfile;
    @InjectMocks
    private EmailOtpPlugin plugin;

    @Before
    public void setUp() throws Exception {
        this.plugin.setOtpTtl(5L);
        this.plugin.setOtpLength(6L);
        this.plugin.setEmailBodyPath("fake-path.html");
        this.plugin.setEmailBodyTemplate("Hello $USER_FULL_NAME, code: ####");
        Mockito.when((Object)this.cacheService.getCacheInstance("otp.email")).thenReturn(this.otpCache);
        Mockito.when((Object)this.secureRandomService.getSecureRandom()).thenReturn((Object)this.secureRandom);
        Mockito.when((Object)this.secureRandom.nextLong(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)123456L);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)this.userProfileHandler);
        Mockito.when((Object)this.userHandler.findUserByName("john")).thenReturn((Object)this.user);
        Mockito.when((Object)this.user.getEmail()).thenReturn((Object)"john@example.com");
        Mockito.when((Object)this.user.getDisplayName()).thenReturn((Object)"John Doe");
        Mockito.when((Object)this.userProfileHandler.findUserProfileByName("john")).thenReturn((Object)this.userProfile);
        Mockito.when((Object)this.userProfile.getAttribute("user.language")).thenReturn((Object)"en");
        Mockito.when((Object)this.resourceBundleService.getSharedString(ArgumentMatchers.anyString(), (Locale)ArgumentMatchers.any())).thenReturn((Object)"TranslatedText");
        Mockito.when((Object)this.brandingService.getCompanyName()).thenReturn((Object)"MyCompany");
        Mockito.when((Object)this.brandingService.getThemeStyle()).thenReturn(Collections.singletonMap("primaryColor", "#123456"));
        Session mockSession = Session.getInstance((Properties)new Properties());
        Mockito.when((Object)this.mailService.getMailSession()).thenReturn((Object)mockSession);
        ((MailService)Mockito.doNothing().when((Object)this.mailService)).sendMessage((MimeMessage)ArgumentMatchers.any(MimeMessage.class));
    }

    @Test
    public void testGetNameAndCanUse() {
        Assert.assertEquals((Object)"email", (Object)this.plugin.getName());
        Assert.assertTrue((boolean)this.plugin.canUse("anyUser"));
    }

    @Test
    public void testValidateOtpValid() {
        Mockito.when((Object)((String)this.otpCache.get((Serializable)((Object)"john")))).thenReturn((Object)OTP_CODE);
        Assert.assertTrue((boolean)this.plugin.validateOtp("john", OTP_CODE));
    }

    @Test
    public void testValidateOtpInvalid() {
        Mockito.when((Object)((String)this.otpCache.get((Serializable)((Object)"john")))).thenReturn((Object)"999999");
        Assert.assertFalse((boolean)this.plugin.validateOtp("john", OTP_CODE));
    }

    @Test
    public void testGenerateOtpCodeSuccess() throws Exception {
        this.plugin.generateOtpCode("john");
        ((ExoCache)Mockito.verify(this.otpCache)).put((Serializable)((Object)((String)ArgumentMatchers.eq((Object)"john"))), (Object)((String)ArgumentMatchers.eq((Object)OTP_CODE)));
        ((MailService)Mockito.verify((Object)this.mailService)).sendMessage((MimeMessage)ArgumentMatchers.any(MimeMessage.class));
    }
}

