/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.data;

import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import io.meeds.oauth.spi.SocialNetworkService;
import java.util.HashMap;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;

public class UniqueOAuthProviderUsernameListener
extends UserProfileEventListener {
    private final SocialNetworkService socialNetworkService;
    private final OAuthProviderTypeRegistry oauthProviderTypeRegistry;

    public UniqueOAuthProviderUsernameListener(SocialNetworkService socialNetworkService, OAuthProviderTypeRegistry oauthProviderTypeRegistry) {
        this.socialNetworkService = socialNetworkService;
        this.oauthProviderTypeRegistry = oauthProviderTypeRegistry;
    }

    public void preSave(UserProfile user, boolean isNew) throws Exception {
        for (OAuthProviderType opt : this.oauthProviderTypeRegistry.getEnabledOAuthProviders()) {
            User foundUser;
            String oauthProviderUsername = user.getAttribute(opt.getUserNameAttrName());
            if (oauthProviderUsername == null || (foundUser = this.socialNetworkService.findUserByOAuthProviderUsername(opt, oauthProviderUsername)) == null || user.getUserName().equals(foundUser.getUserName())) continue;
            String message = "Attempt to save " + opt.getUserNameAttrName() + " with value " + oauthProviderUsername + " but it already exists. currentUser=" + user.getUserName() + ", userWithThisOAuthUsername=" + foundUser.getUserName();
            HashMap<String, Object> exceptionAttribs = new HashMap<String, Object>();
            exceptionAttribs.put("OAuthProviderUsernameAttributeName", opt.getUserNameAttrName());
            exceptionAttribs.put("OAuthProviderUsername", oauthProviderUsername);
            exceptionAttribs.put("OAuthProviderName", opt.getFriendlyName());
            throw new OAuthException(OAuthExceptionCode.DUPLICATE_OAUTH_PROVIDER_USERNAME, exceptionAttribs, message);
        }
    }
}

