/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.openid;

import io.meeds.oauth.openid.OpenIdAccessTokenContext;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.spi.OAuthProviderTypeRegistry;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public class OpenIdAuthenticationFilter
extends AbstractSSOInterceptor {
    private static Log log = ExoLogger.getLogger(OpenIdAuthenticationFilter.class);
    private AuthenticationRegistry authenticationRegistry;
    private OAuthProviderTypeRegistry oAuthProviderTypeRegistry;
    private OAuthProviderType oAuthProviderType;
    private boolean openIdEnabled;

    protected void initImpl() {
        this.openIdEnabled = Boolean.parseBoolean(System.getProperty("exo.oauth.openid.enabled"));
        if (this.openIdEnabled) {
            this.authenticationRegistry = (AuthenticationRegistry)this.getExoContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
            this.oAuthProviderTypeRegistry = (OAuthProviderTypeRegistry)this.getExoContainer().getComponentInstanceOfType(OAuthProviderTypeRegistry.class);
            this.oAuthProviderType = this.oAuthProviderTypeRegistry.getOAuthProvider("OPENID", OpenIdAccessTokenContext.class);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.openIdEnabled || request.getRemoteUser() != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        User oauthAuthenticatedUser = (User)this.authenticationRegistry.getAttributeOfClient(request, "_authenticatedPortalUser");
        if (oauthAuthenticatedUser != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        User jaasAuthenticatedUser = (User)this.authenticationRegistry.getAttributeOfClient(request, "_authenticatedPortalUserForJaas");
        if (jaasAuthenticatedUser != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        OAuthPrincipal principal = (OAuthPrincipal)this.authenticationRegistry.getAttributeOfClient(request, "_authenticatedOAuthPrincipal");
        if (principal != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!this.checkAccessTokenInCookies(request, response)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean checkAccessTokenInCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("OPENID_ACCESS_TOKEN")) continue;
                try {
                    this.saveInitialURI(request);
                    String contextPath = request.getContextPath();
                    String initialUri = request.getParameter("initialURI");
                    if (StringUtils.isBlank((CharSequence)initialUri)) {
                        initialUri = contextPath;
                    }
                    String initOauthURI = this.oAuthProviderType.getInitOAuthURL(contextPath, initialUri);
                    response.sendRedirect(initOauthURI);
                    return true;
                }
                catch (IOException ex) {
                    log.error((Object)("Error when initializing OAuth flow with: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        return false;
    }

    private void saveInitialURI(HttpServletRequest request) {
        String initialURI = request.getParameter("initialURI");
        if (initialURI != null) {
            request.getSession().setAttribute("_urlToRedirectAfterLinkSocialAccount", (Object)initialURI);
        }
    }
}

