/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.entity;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ExperienceEntity;
import org.exoplatform.social.rest.entity.IMEntity;
import org.exoplatform.social.rest.entity.PhoneEntity;
import org.exoplatform.social.rest.entity.ProfilePropertySettingEntity;
import org.exoplatform.social.rest.entity.URLEntity;

public class ProfileEntity
extends BaseEntity {
    public static final String IMS = "ims";
    public static final String EXPERIENCES = "experiences";
    public static final String PHONES = "phones";
    public static final String ABOUT_ME = "aboutMe";
    public static final String TIME_ZONE = "timeZone";
    public static final String TIME_ZONE_DST = "timeZoneDSTSavings";
    public static final String BANNER = "banner";
    public static final String AVATAR = "avatar";
    public static final String DEFAULT_AVATAR = "isDefaultAvatar";
    public static final String POSITION = "position";
    public static final String EMAIL = "email";
    public static final String GENDER = "gender";
    public static final String FULLNAME = "fullname";
    public static final String LASTNAME = "lastname";
    public static final String FIRSTNAME = "firstname";
    public static final String USERNAME = "username";
    public static final long serialVersionUID = -3241490307391015454L;
    public static final String IDENTITY = "identity";
    public static final String URLS = "urls";
    public static final String DELETED = "deleted";
    public static final String ENABLED = "enabled";
    public static final String IS_INTERNAL = "isInternal";
    public static final String COMPANY = "company";
    public static final String LOCATION = "location";
    public static final String DEPARTMENT = "department";
    public static final String TEAM = "team";
    public static final String PROFESSION = "profession";
    public static final String COUNTRY = "country";
    public static final String CITY = "city";
    public static final String EXTERNAL = "external";
    public static final String LAST_LOGIN_TIME = "lastLoginTime";
    public static final String ENROLLMENT_DATE = "enrollmentDate";
    public static final String SYNCHRONIZED_DATE = "synchronizedDate";
    public static final String CREATED_DATE = "createdDate";
    public static final String IS_ADMIN = "isAdmin";
    public static final String MANAGERS = "managers";
    public static final String MANAGED_USERS_COUNT = "managedUsersCount";
    public static final String PRIMARY_PROPERTY = "primaryProperty";
    public static final String SECONDARY_PROPERTY = "secondaryProperty";
    public static final String TERTIARY_PROPERTY = "tertiaryProperty";

    public ProfileEntity() {
    }

    public ProfileEntity(String id) {
        super(id);
    }

    public ProfileEntity setIdentity(String identity) {
        this.setProperty(IDENTITY, identity);
        return this;
    }

    public String getIdentity() {
        return this.getString(IDENTITY);
    }

    public ProfileEntity setUsername(String username) {
        this.setProperty(USERNAME, username);
        return this;
    }

    public String getUsername() {
        return this.getString(USERNAME);
    }

    public ProfileEntity setFirstname(String firstname) {
        this.setProperty(FIRSTNAME, firstname);
        return this;
    }

    public String getFirstname() {
        return this.getString(FIRSTNAME);
    }

    public ProfileEntity setCompany(String company) {
        DataEntity dataEntity = this.getDataEntity();
        dataEntity.put(COMPANY, company);
        this.setDataEntity(dataEntity);
        return this;
    }

    public String getCompany() {
        return this.getString(COMPANY);
    }

    public ProfileEntity setLocation(String location) {
        DataEntity dataEntity = this.getDataEntity();
        dataEntity.put(LOCATION, location);
        this.setDataEntity(dataEntity);
        return this;
    }

    public String getLocation() {
        return this.getString(LOCATION);
    }

    public ProfileEntity setDepartment(String department) {
        DataEntity dataEntity = this.getDataEntity();
        dataEntity.put(DEPARTMENT, department);
        this.setDataEntity(dataEntity);
        return this;
    }

    public String getDepartment() {
        return this.getString(DEPARTMENT);
    }

    public ProfileEntity setTeam(String team) {
        DataEntity dataEntity = this.getDataEntity();
        dataEntity.put(TEAM, team);
        this.setDataEntity(dataEntity);
        return this;
    }

    public String getTeam() {
        return this.getString(TEAM);
    }

    public ProfileEntity setProfession(String profession) {
        DataEntity dataEntity = this.getDataEntity();
        dataEntity.put(PROFESSION, profession);
        this.setDataEntity(dataEntity);
        return this;
    }

    public String getProfession() {
        return this.getString(PROFESSION);
    }

    public ProfileEntity setCountry(String country) {
        DataEntity dataEntity = this.getDataEntity();
        dataEntity.put(COUNTRY, country);
        this.setDataEntity(dataEntity);
        return this;
    }

    public String getCountry() {
        return this.getString(COUNTRY);
    }

    public ProfileEntity setCity(String city) {
        DataEntity dataEntity = this.getDataEntity();
        dataEntity.put(CITY, city);
        this.setDataEntity(dataEntity);
        return this;
    }

    public String getCity() {
        return this.getString(CITY);
    }

    public ProfileEntity setLastname(String lastname) {
        this.setProperty(LASTNAME, lastname);
        return this;
    }

    public String getLastname() {
        return this.getString(LASTNAME);
    }

    public ProfileEntity setIsInvited(boolean isInvited) {
        this.setProperty("isInvited", isInvited);
        return this;
    }

    public Boolean getIsInvited() {
        return (Boolean)this.getProperty("isInvited");
    }

    public ProfileEntity setIsPending(boolean isPending) {
        this.setProperty("isPending", isPending);
        return this;
    }

    public Boolean getIsPending() {
        return (Boolean)this.getProperty("isPending");
    }

    public ProfileEntity setIsMember(boolean isMember) {
        this.setProperty("isMember", isMember);
        return this;
    }

    public ProfileEntity setIsInternal(boolean isInternal) {
        this.setProperty(IS_INTERNAL, isInternal);
        return this;
    }

    public Boolean getIsInternal() {
        return (Boolean)this.getProperty(IS_INTERNAL);
    }

    public Boolean getIsMember() {
        return (Boolean)this.getProperty("isMember");
    }

    public ProfileEntity setIsManager(boolean isManager) {
        this.setProperty("isManager", isManager);
        return this;
    }

    public Boolean getIsManager() {
        return (Boolean)this.getProperty("isManager");
    }

    public ProfileEntity setIsSpaceRedactor(boolean isSpaceRedactor) {
        this.setProperty("isSpaceRedactor", isSpaceRedactor);
        return this;
    }

    public Boolean getIsSpaceRedactor() {
        return (Boolean)this.getProperty("isSpaceRedactor");
    }

    public ProfileEntity setIsSpacePublisher(boolean isSpacePublisher) {
        this.setProperty("isSpacePublisher", isSpacePublisher);
        return this;
    }

    public Boolean getIsSpacePublisher() {
        return (Boolean)this.getProperty("isSpacePublisher");
    }

    public ProfileEntity setIsGroupBound(boolean isSpaceRedactor) {
        this.setProperty("isGroupBound", isSpaceRedactor);
        return this;
    }

    public Boolean getIsGroupBound() {
        return (Boolean)this.getProperty("isGroupBound");
    }

    public ProfileEntity setFullname(String fullname) {
        this.setProperty(FULLNAME, fullname);
        return this;
    }

    public String getFullname() {
        return this.getString(FULLNAME);
    }

    public ProfileEntity setGender(String gender) {
        this.setProperty(GENDER, gender);
        return this;
    }

    public String getGender() {
        return this.getString(GENDER);
    }

    public ProfileEntity setEmail(String email) {
        this.setProperty(EMAIL, email);
        return this;
    }

    public String getEmail() {
        return this.getString(EMAIL);
    }

    public ProfileEntity setPosition(String position) {
        this.setProperty(POSITION, position);
        return this;
    }

    public String getPosition() {
        return this.getString(POSITION);
    }

    public ProfileEntity setAvatar(String avatar) {
        this.setProperty(AVATAR, avatar);
        return this;
    }

    public boolean isDefaultAvatar() {
        return StringUtils.equals((CharSequence)"true", (CharSequence)this.getString(DEFAULT_AVATAR));
    }

    public ProfileEntity setDefaultAvatar(Boolean defaultAvatar) {
        this.setProperty(DEFAULT_AVATAR, defaultAvatar);
        return this;
    }

    public String getAvatar() {
        return this.getString(AVATAR);
    }

    public ProfileEntity setBanner(String banner) {
        this.setProperty(BANNER, banner);
        return this;
    }

    public String getBanner() {
        return this.getString(BANNER);
    }

    public ProfileEntity setAboutMe(String aboutMe) {
        this.setProperty(ABOUT_ME, aboutMe);
        return this;
    }

    public String getAboutMe() {
        return this.getString(ABOUT_ME);
    }

    public String getTimeZone() {
        return (String)this.getProperty(TIME_ZONE);
    }

    public void setTimeZone(String timeZone) {
        this.setProperty(TIME_ZONE, timeZone);
    }

    public String getTimeZoneDSTSavings() {
        return (String)this.getProperty(TIME_ZONE_DST);
    }

    public void setTimeZoneDSTSavings(String timeZoneDayLightSaving) {
        this.setProperty(TIME_ZONE_DST, timeZoneDayLightSaving);
    }

    public ProfileEntity setConnectionsCount(String connectionsCount) {
        this.setProperty("connectionsCount", connectionsCount);
        return this;
    }

    public String getConnectionsCount() {
        return this.getString("connectionsCount");
    }

    public ProfileEntity setSpacesCount(String spacesCount) {
        this.setProperty("spacesCount", spacesCount);
        return this;
    }

    public String getSpacesCount() {
        return this.getString("spacesCount");
    }

    public ProfileEntity setRelationshipStatus(String relationshipStatus) {
        this.setProperty("relationshipStatus", relationshipStatus);
        return this;
    }

    public String getRelationshipStatus() {
        return this.getString("relationshipStatus");
    }

    public ProfileEntity setConnectionsInCommonCount(String connectionsInCommonCount) {
        this.setProperty("connectionsInCommonCount", connectionsInCommonCount);
        return this;
    }

    public String getConnectionsInCommonCount() {
        return this.getString("connectionsInCommonCount");
    }

    public List<ProfilePropertySettingEntity> getProperties() {
        return (List)this.getProperty("properties");
    }

    public ProfileEntity setProperties(List<ProfilePropertySettingEntity> properties) {
        this.setProperty("properties", properties);
        return this;
    }

    public void setPhones(List<PhoneEntity> phones) {
        this.setProperty(PHONES, phones);
    }

    public List<PhoneEntity> getPhones() {
        return (List)this.getProperty(PHONES);
    }

    public ProfileEntity setExperiences(List<ExperienceEntity> experiences) {
        this.setProperty(EXPERIENCES, experiences);
        return this;
    }

    public List<ExperienceEntity> getExperiences() {
        return (List)this.getProperty(EXPERIENCES);
    }

    public ProfileEntity setIms(List<IMEntity> ims) {
        this.setProperty(IMS, ims);
        return this;
    }

    public List<IMEntity> getIms() {
        return (List)this.getProperty(IMS);
    }

    public ProfileEntity setUrls(List<URLEntity> urls) {
        this.setProperty(URLS, urls);
        return this;
    }

    public List<URLEntity> getUrls() {
        return (List)this.getProperty(URLS);
    }

    public ProfileEntity setDeleted(Boolean deleted) {
        this.setProperty(DELETED, deleted);
        return this;
    }

    public String getDeleted() {
        return this.getString(DELETED);
    }

    public boolean isNotValid() {
        return this.isEmpty(this.getUsername()) || this.isEmpty(this.getEmail()) || this.isEmpty(this.getFirstname()) || this.isEmpty(this.getLastname());
    }

    private boolean isEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public ProfileEntity setEnabled(boolean enable) {
        this.setProperty(ENABLED, enable);
        return this;
    }

    public String isEnabled() {
        return this.getString(ENABLED);
    }

    public ProfileEntity setIsExternal(String isExternal) {
        this.setProperty(EXTERNAL, isExternal);
        return this;
    }

    public String isExternal() {
        return this.getString(EXTERNAL);
    }

    public ProfileEntity setLastLoginTime(String lastLoginTime) {
        this.setProperty(LAST_LOGIN_TIME, lastLoginTime);
        return this;
    }

    public String getLastLoginTime() {
        return this.getString(LAST_LOGIN_TIME);
    }

    public ProfileEntity setCreatedDate(String createdDate) {
        this.setProperty(CREATED_DATE, createdDate);
        return this;
    }

    public String getCreatedDate() {
        return this.getString(CREATED_DATE);
    }

    public ProfileEntity setEnrollmentDate(String enrollmentDate) {
        this.setProperty(ENROLLMENT_DATE, enrollmentDate);
        return this;
    }

    public String getEnrollmentDate() {
        return this.getString(ENROLLMENT_DATE);
    }

    public ProfileEntity setSynchronizedDate(String synchronizedDate) {
        this.setProperty(SYNCHRONIZED_DATE, synchronizedDate);
        return this;
    }

    public String getIsAdmin() {
        return this.getString(IS_ADMIN);
    }

    public ProfileEntity setIsAdmin(boolean isAdmin) {
        this.setProperty(IS_ADMIN, isAdmin);
        return this;
    }

    public List<DataEntity> getManagers() {
        return (List)this.getProperty(MANAGERS);
    }

    public ProfileEntity setManagers(List<DataEntity> managers) {
        this.setProperty(MANAGERS, managers);
        return this;
    }

    public String getManagedUsersCount() {
        return this.getString(MANAGED_USERS_COUNT);
    }

    public ProfileEntity setManagedUsersCount(int managedUsersCount) {
        this.setProperty(MANAGED_USERS_COUNT, managedUsersCount);
        return this;
    }

    public String getPrimaryProperty() {
        return this.getString(PRIMARY_PROPERTY);
    }

    public ProfileEntity setPrimaryProperty(String primaryProperty) {
        this.setProperty(PRIMARY_PROPERTY, primaryProperty);
        return this;
    }

    public String getSecondaryCardProperty() {
        return this.getString(SECONDARY_PROPERTY);
    }

    public ProfileEntity setSecondaryProperty(String secondaryProperty) {
        this.setProperty(SECONDARY_PROPERTY, secondaryProperty);
        return this;
    }

    public String getTertiaryCardProperty() {
        return this.getString(TERTIARY_PROPERTY);
    }

    public ProfileEntity setTertiaryProperty(String tertiaryProperty) {
        this.setProperty(TERTIARY_PROPERTY, tertiaryProperty);
        return this;
    }

    public String getSynchronizedDate() {
        return this.getString(SYNCHRONIZED_DATE);
    }

    public static String getFieldName(String name) {
        if (StringUtils.equals((CharSequence)FIRSTNAME, (CharSequence)name)) {
            return "firstName";
        }
        if (StringUtils.equals((CharSequence)LASTNAME, (CharSequence)name)) {
            return "lastName";
        }
        if (StringUtils.equals((CharSequence)FULLNAME, (CharSequence)name)) {
            return "fullName";
        }
        if (StringUtils.equals((CharSequence)EMAIL, (CharSequence)name)) {
            return EMAIL;
        }
        if (StringUtils.equals((CharSequence)GENDER, (CharSequence)name)) {
            return GENDER;
        }
        if (StringUtils.equals((CharSequence)POSITION, (CharSequence)name)) {
            return POSITION;
        }
        if (StringUtils.equals((CharSequence)AVATAR, (CharSequence)name)) {
            return AVATAR;
        }
        if (StringUtils.equals((CharSequence)BANNER, (CharSequence)name)) {
            return BANNER;
        }
        if (StringUtils.equals((CharSequence)ABOUT_ME, (CharSequence)name)) {
            return ABOUT_ME;
        }
        if (StringUtils.equals((CharSequence)PHONES, (CharSequence)name)) {
            return PHONES;
        }
        if (StringUtils.equals((CharSequence)IMS, (CharSequence)name)) {
            return IMS;
        }
        if (StringUtils.equals((CharSequence)URLS, (CharSequence)name)) {
            return URLS;
        }
        if (StringUtils.equals((CharSequence)EXPERIENCES, (CharSequence)name)) {
            return EXPERIENCES;
        }
        if (StringUtils.equals((CharSequence)COMPANY, (CharSequence)name)) {
            return COMPANY;
        }
        if (StringUtils.equals((CharSequence)LOCATION, (CharSequence)name)) {
            return LOCATION;
        }
        if (StringUtils.equals((CharSequence)DEPARTMENT, (CharSequence)name)) {
            return DEPARTMENT;
        }
        if (StringUtils.equals((CharSequence)TEAM, (CharSequence)name)) {
            return TEAM;
        }
        if (StringUtils.equals((CharSequence)PROFESSION, (CharSequence)name)) {
            return PROFESSION;
        }
        if (StringUtils.equals((CharSequence)COUNTRY, (CharSequence)name)) {
            return COUNTRY;
        }
        if (StringUtils.equals((CharSequence)CITY, (CharSequence)name)) {
            return CITY;
        }
        return name;
    }
}

