/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.service.rest.Util;

public class RestUtils {
    public static final int DEFAULT_LIMIT = 20;
    public static final int DEFAULT_OFFSET = 0;
    public static final int HARD_LIMIT = 50;
    public static final String USERS_TYPE = "users";
    public static final String USERS_RELATIONSHIP_TYPE = "usersRelationships";
    public static final String USER_ACTIVITY_TYPE = "user";
    public static final String IDENTITIES_TYPE = "identities";
    public static final String SPACES_TYPE = "spaces";
    public static final String SPACES_MEMBERSHIP_TYPE = "spacesMemberships";
    public static final String SPACE_ACTIVITY_TYPE = "space";
    public static final String ACTIVITIES_TYPE = "activities";
    public static final String LIKES_TYPE = "likes";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String SUPPORT_TYPE = "json";
    public static final String ADMIN_GROUP = "/platform/administrators";

    public static Map<String, Object> buildSpaceIdentity(org.exoplatform.social.core.identity.model.Identity identity, String restPath, String expand) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Profile profile = identity.getProfile();
        map.put("id", identity.getId());
        map.put("userName", identity.getRemoteId());
        map.put("identity", Util.getRestUrl(IDENTITIES_TYPE, identity.getId(), restPath));
        RestUtils.updateCachedEtagValue(RestUtils.getEtagValue(profile.getFullName(), profile.getAvatarUrl()));
        return map;
    }

    public static Map<String, Object> buildEntityFromSpace(Space space, String userId, String restPath, String expand) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) || RestUtils.isMemberOfAdminGroup()) {
            map.put("id", space.getId());
            map.put("href", expand != null && "href".equals(expand) ? RestUtils.buildEntityFromSpace(space, userId, restPath, null) : Util.getRestUrl(SPACES_TYPE, space.getId(), restPath));
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity(SPACE_ACTIVITY_TYPE, space.getPrettyName(), true);
            map.put("identity", expand != null && "identity".equals(expand) ? RestUtils.buildSpaceIdentity(spaceIdentity, restPath, null) : Util.getRestUrl(IDENTITIES_TYPE, spaceIdentity.getId(), restPath));
            map.put("groupId", space.getGroupId());
            map.put("avatarUrl", space.getAvatarUrl());
            map.put("applications", RestUtils.getSpaceApplications(space));
            map.put("managers", Util.getMembersSpaceRestUrl(space.getId(), "manager", restPath));
            map.put("members", Util.getMembersSpaceRestUrl(space.getId(), null, restPath));
        }
        map.put("displayName", space.getDisplayName());
        map.put("url", LinkProvider.getSpaceUri((String)space.getPrettyName()));
        map.put("visibility", space.getVisibility());
        map.put("subscription", space.getRegistration());
        RestUtils.updateCachedEtagValue(RestUtils.getEtagValue(space.getDisplayName(), space.getDescription(), space.getPrettyName(), space.getVisibility(), space.getRegistration(), space.getAvatarUrl()));
        return map;
    }

    public static Map<String, Object> buildEntityFromSpaceMembership(Space space, String userId, String type, String restPath, String expand) {
        RestUtils.updateCachedEtagValue(RestUtils.getEtagValue(type));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String id = space.getPrettyName() + ":" + userId + ":" + type;
        map.put("id", id);
        map.put("href", expand != null && "href".equals(expand) ? RestUtils.buildEntityFromSpaceMembership(space, userId, type, restPath, null) : Util.getRestUrl(SPACES_MEMBERSHIP_TYPE, id, restPath));
        map.put(USERS_TYPE, Util.getRestUrl(USERS_TYPE, userId, restPath));
        map.put(SPACES_TYPE, Util.getRestUrl(SPACES_TYPE, space.getId(), restPath));
        map.put("role", type);
        map.put("status", "approved");
        return map;
    }

    public static Map<String, Object> buildEntityFromActivity(ExoSocialActivity activity, String restPath, String expand) {
        org.exoplatform.social.core.identity.model.Identity poster = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentity(activity.getPosterId(), true);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", activity.getId());
        map.put("href", expand != null && "href".equals(expand) ? RestUtils.buildEntityFromActivity(activity, restPath, null) : Util.getRestUrl(ACTIVITIES_TYPE, activity.getId(), restPath));
        map.put("identity", expand != null && "identity".equals(expand) ? EntityBuilder.buildEntityProfile(poster.getProfile(), restPath, null) : Util.getRestUrl(IDENTITIES_TYPE, activity.getPosterId(), restPath));
        map.put("mentions", RestUtils.getActivityMentions(activity, restPath));
        if (activity.isComment()) {
            map.put("body", activity.getTitle());
            map.put("poster", poster.getRemoteId());
            map.put("activity", Util.getRestUrl(ACTIVITIES_TYPE, ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getParentActivity(activity).getId(), restPath));
        } else {
            map.put("body", activity.getBody());
            map.put("title", activity.getTitle());
            map.put("owner", RestUtils.getActivityOwner(poster, restPath));
            map.put("link", activity.getPermaLink());
            map.put("attachments", new ArrayList());
            map.put("type", activity.getType());
            map.put("comments", Util.getCommentsActivityRestUrl(activity.getId(), restPath));
        }
        map.put("createDate", RestUtils.formatDateToISO8601(new Date(activity.getPostedTime())));
        map.put("updateDate", RestUtils.formatDateToISO8601(activity.getUpdated()));
        RestUtils.updateCachedLastModifiedValue(activity.getUpdated());
        return map;
    }

    public static Map<String, Object> buildEntityFromRelationship(Relationship relationship, String restPath, String expand, boolean isSymetric) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", relationship.getId());
        map.put("href", expand != null && "href".equals(expand) ? RestUtils.buildEntityFromRelationship(relationship, restPath, null, isSymetric) : Util.getRestUrl(USERS_RELATIONSHIP_TYPE, relationship.getId(), restPath));
        map.put("status", relationship.getStatus().name());
        map.put("receiver", expand != null && "receiver".equals(expand) ? EntityBuilder.buildEntityProfile(relationship.getSender().getProfile(), restPath, null) : Util.getRestUrl(USERS_TYPE, relationship.getSender().getRemoteId(), restPath));
        map.put("sender", expand != null && "sender".equals(expand) ? EntityBuilder.buildEntityProfile(relationship.getReceiver().getProfile(), restPath, null) : Util.getRestUrl(USERS_TYPE, relationship.getReceiver().getRemoteId(), restPath));
        if (isSymetric) {
            map.put("symetric", relationship.isSymetric());
        }
        RestUtils.updateCachedEtagValue(RestUtils.getEtagValue(relationship.getId()));
        return map;
    }

    private static Map<String, String> getActivityOwner(org.exoplatform.social.core.identity.model.Identity owner, String restPath) {
        LinkedHashMap<String, String> mention = new LinkedHashMap<String, String>();
        mention.put("id", owner.getId());
        mention.put("href", Util.getRestUrl(USERS_TYPE, owner.getRemoteId(), restPath));
        return mention;
    }

    private static List<Map<String, String>> getActivityMentions(ExoSocialActivity activity, String restPath) {
        ArrayList<Map<String, String>> mentions = new ArrayList<Map<String, String>>();
        for (String mentionner : activity.getMentionedIds()) {
            String mentionnerId = mentionner.split("@")[0];
            org.exoplatform.social.core.identity.model.Identity userIdentity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentity(mentionnerId, false);
            mentions.add(RestUtils.getActivityOwner(userIdentity, restPath));
        }
        return mentions;
    }

    public static Map<String, String> getActivityStream(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity authentiatedUsed) {
        LinkedHashMap<String, String> as = new LinkedHashMap<String, String>();
        org.exoplatform.social.core.identity.model.Identity owner = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", activity.getStreamOwner(), true);
        if (owner != null) {
            Relationship relationship = ((RelationshipManager)CommonsUtils.getService(RelationshipManager.class)).get(authentiatedUsed, owner);
            if (!(authentiatedUsed.getId().equals(activity.getPosterId()) || authentiatedUsed.getRemoteId().equals(activity.getStreamOwner()) || relationship != null && relationship.getStatus().equals((Object)Relationship.Type.CONFIRMED) || RestUtils.isMemberOfAdminGroup())) {
                return null;
            }
            as.put("type", USER_ACTIVITY_TYPE);
        } else {
            owner = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity(SPACE_ACTIVITY_TYPE, activity.getStreamOwner(), true);
            Space space = ((SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceByPrettyName(owner.getRemoteId());
            if (!((SpaceService)CommonsUtils.getService(SpaceService.class)).isMember(space, authentiatedUsed.getRemoteId())) {
                return null;
            }
            as.put("type", SPACE_ACTIVITY_TYPE);
        }
        as.put("id", owner.getRemoteId());
        return as;
    }

    private static List<Map<String, String>> getSpaceApplications(Space space) {
        ArrayList<Map<String, String>> spaceApplications = new ArrayList<Map<String, String>>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            String[] appStatuses;
            for (String appStatus : appStatuses = installedApps.split(",")) {
                LinkedHashMap<String, String> app = new LinkedHashMap<String, String>();
                String[] apps = appStatus.split(":");
                app.put("id", apps[0]);
                app.put("displayName", apps.length > 1 ? apps[1] : "");
                spaceApplications.add(app);
            }
        }
        return spaceApplications;
    }

    private static List<Map<String, Object>> getSubListByProperties(List<Map<String, String>> sources, Map<String, String> properties) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (sources == null || sources.size() == 0) {
            return results;
        }
        for (Map<String, String> map : sources) {
            if (map.isEmpty()) continue;
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> property : properties.entrySet()) {
                result.put(property.getKey(), map.get(property.getValue()));
            }
            results.add(result);
        }
        return results;
    }

    private static Map<String, String> getPhoneProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("phoneType", KEY);
        properties.put("phoneNumber", VALUE);
        return properties;
    }

    private static Map<String, String> getImsProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("imType", KEY);
        properties.put("imId", VALUE);
        return properties;
    }

    private static Map<String, String> getUrlProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("url", VALUE);
        return properties;
    }

    private static Map<String, String> getExperiencesProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("company", "company");
        properties.put("description", "description");
        properties.put("position", "position");
        properties.put("skills", "skills");
        properties.put("isCurrent", "isCurrent");
        properties.put("startDate", "startDate");
        properties.put("endDate", "endDate");
        return properties;
    }

    private static String formatDateToISO8601(Date date) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        df.setTimeZone(tz);
        return df.format(date);
    }

    private static void updateCachedEtagValue(int etagValue) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        ac.setProperty("ETag", String.valueOf(etagValue));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static void updateCachedLastModifiedValue(Date lastModifiedDate) {
        ApplicationContext ac = ApplicationContextImpl.getCurrent();
        Map properties = ac.getProperties();
        ConcurrentHashMap props = new ConcurrentHashMap(properties);
        if (props.containsKey("updateDate")) {
            props.remove("updateDate");
        }
        if (props.containsKey("ETag")) {
            props.remove("ETag");
        }
        ac.setProperty("updateDate", String.valueOf(lastModifiedDate.getTime()));
        ApplicationContextImpl.setCurrent((ApplicationContext)ac);
    }

    private static int getEtagValue(String ... properties) {
        int prime = 31;
        int result = 0;
        for (String prop : properties) {
            if (prop == null) continue;
            result = 31 * result + prop.hashCode();
        }
        return result;
    }

    public static MediaType getJsonMediaType() {
        return Util.getMediaType(SUPPORT_TYPE, new String[]{SUPPORT_TYPE});
    }

    public static boolean isMemberOfAdminGroup() {
        return ConversationState.getCurrent().getIdentity().isMemberOf(ADMIN_GROUP);
    }

    public static String getCurrentUsername() {
        Identity currentIdentity;
        Identity identity = currentIdentity = ConversationState.getCurrent() == null ? null : ConversationState.getCurrent().getIdentity();
        if (currentIdentity == null) {
            return null;
        }
        return currentIdentity.getUserId();
    }

    public static org.exoplatform.social.core.identity.model.Identity getCurrentIdentity() {
        String currentUsername = RestUtils.getCurrentUsername();
        if (StringUtils.isEmpty((CharSequence)currentUsername)) {
            return null;
        }
        return ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", currentUsername, true);
    }
}

