/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacesadministration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.rest.entity.SpacesAdministrationMembershipsEntity;
import org.exoplatform.social.rest.impl.spacesadministration.SpacesAdministrationRest;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class SpacesAdministrationRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private UserACL userACL;
    private SpacesAdministrationService spacesAdministrationService;
    private SpacesAdministrationRest spacesAdministrationRestResourcesV1;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.userACL = (UserACL)this.getContainer().getComponentInstanceOfType(UserACL.class);
        this.spacesAdministrationService = (SpacesAdministrationService)this.getContainer().getComponentInstanceOfType(SpacesAdministrationService.class);
        this.identityManager.getOrCreateIdentity("organization", "root", true);
        this.identityManager.getOrCreateIdentity("organization", "john", true);
        this.identityManager.getOrCreateIdentity("organization", "mary", true);
        this.identityManager.getOrCreateIdentity("organization", "demo", true);
        this.spacesAdministrationRestResourcesV1 = new SpacesAdministrationRest(this.spacesAdministrationService, this.userACL);
        this.registry(this.spacesAdministrationRestResourcesV1);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(this.spacesAdministrationRestResourcesV1.getClass());
    }

    public void testShouldReturnAllSpacesAdministratorsSettings() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(Arrays.asList(new MembershipEntry("/platform/administrators", "*"), new MembershipEntry("/platform/users", "member")));
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions"), "", null, null, "root");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        List membershipsEntities = (List)response.getEntity();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)membershipsEntities);
        SpacesAdministrationRestResourcesTest.assertEquals((int)2, (int)membershipsEntities.size());
        List spacesAdministrators = membershipsEntities.stream().filter(m -> m.getId().equals("spacesAdministrators")).collect(Collectors.toList());
        SpacesAdministrationRestResourcesTest.assertNotNull(spacesAdministrators);
        SpacesAdministrationRestResourcesTest.assertEquals((int)1, (int)spacesAdministrators.size());
        List spacesAdministratorsMemberships = ((SpacesAdministrationMembershipsEntity)spacesAdministrators.get(0)).getMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)spacesAdministratorsMemberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)2, (int)spacesAdministratorsMemberships.size());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)spacesAdministratorsMemberships.contains(new MembershipEntry("/platform/users", "manager")));
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)spacesAdministratorsMemberships.contains(new MembershipEntry("/platform/administrators", "*")));
        List spacesCreators = membershipsEntities.stream().filter(m -> m.getId().equals("spacesCreators")).collect(Collectors.toList());
        SpacesAdministrationRestResourcesTest.assertNotNull(spacesCreators);
        SpacesAdministrationRestResourcesTest.assertEquals((int)1, (int)spacesCreators.size());
        List spacesCreatorsMemberships = ((SpacesAdministrationMembershipsEntity)spacesCreators.get(0)).getMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)spacesCreatorsMemberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)2, (int)spacesCreatorsMemberships.size());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)spacesCreatorsMemberships.contains(new MembershipEntry("/platform/administrators", "*")));
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)spacesCreatorsMemberships.contains(new MembershipEntry("/platform/users", "member")));
    }

    public void testShouldNotAuthorizedWhenGettingAllSettingsAsNotPlatformAdministrator() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(Arrays.asList(new MembershipEntry("/platform/administrators", "*"), new MembershipEntry("/platform/users", "member")));
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions"), "", null, null, "mary");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testShouldReturnTrueWhenAuthorizedCanCreateSpaces() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/canCreatespaces/mary"), "", null, null, "mary");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)response.getEntity().equals("true"));
    }

    public void testShouldReturnFalseWhenUserAuthorizedCanCreateSpaces() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/canCreatespaces/__anonim"), "", null, null, "mary");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)response.getEntity().equals("false"));
    }

    public void testShouldReturnEmptySpacesAdministratorsWhenSettingIsEmpty() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Collections.EMPTY_LIST);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/spacesAdministrators"), "", null, null, "root");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpacesAdministrationMembershipsEntity membershipsEntity = (SpacesAdministrationMembershipsEntity)response.getEntity();
        List memberships = membershipsEntity.getMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)memberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)0, (int)memberships.size());
    }

    public void testShouldReturnSpacesAdministratorsWhenSettingIsNotNull() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/spacesAdministrators"), "", null, null, "root");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpacesAdministrationMembershipsEntity membershipsEntity = (SpacesAdministrationMembershipsEntity)response.getEntity();
        List memberships = membershipsEntity.getMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)memberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)2, (int)memberships.size());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)memberships.contains(new MembershipEntry("/platform/users", "manager")));
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)memberships.contains(new MembershipEntry("/platform/administrators", "*")));
    }

    public void testShouldReturnNotAuthorizedWhenGettingSpacesAdministratorsAsNotSpacesAdministrator() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/spacesAdministrators"), "", null, null, "mary");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testShouldUpdateSpacesAdministratorsWhenSpacesAdministrator() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        String newMemberships = "[ {   \"membershipType\": \"member\",   \"group\": \"/platform/users\" }]";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        this.startSessionAs("root");
        ContainerResponse response = this.service("PUT", this.getURLResource("spacesAdministration/permissions/spacesAdministrators"), "", (MultivaluedMap<String, String>)headers, newMemberships.getBytes(), "root");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        List spacesAdministratorsMemberships = this.spacesAdministrationService.getSpacesAdministratorsMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)spacesAdministratorsMemberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)1, (int)spacesAdministratorsMemberships.size());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)spacesAdministratorsMemberships.contains(new MembershipEntry("/platform/users", "member")));
    }

    public void testShouldNotAuthorizedWhenUpdatingSpacesAdministratorsAsNotPlatformAdministrator() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        String newMemberships = "[ {   \"membershipType\": \"member\",   \"group\": \"/platform/users\" }]";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        this.startSessionAs("mary");
        ContainerResponse response = this.service("PUT", this.getURLResource("spacesAdministration/permissions/spacesAdministrators"), "", (MultivaluedMap<String, String>)headers, newMemberships.getBytes(), "mary");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testShouldReturnEmptySpacesCreatorsWhenSettingIsEmpty() throws Exception {
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(Collections.EMPTY_LIST);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/spacesCreators"), "", null, null, "root");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpacesAdministrationMembershipsEntity membershipsEntity = (SpacesAdministrationMembershipsEntity)response.getEntity();
        List memberships = membershipsEntity.getMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)memberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)0, (int)memberships.size());
    }

    public void testShouldReturnSpacesCreatorsWhenSettingIsNotNull() throws Exception {
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/spacesCreators"), "", null, null, "root");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpacesAdministrationMembershipsEntity membershipsEntity = (SpacesAdministrationMembershipsEntity)response.getEntity();
        List memberships = membershipsEntity.getMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)memberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)2, (int)memberships.size());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)memberships.contains(new MembershipEntry("/platform/users", "manager")));
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)memberships.contains(new MembershipEntry("/platform/administrators", "*")));
    }

    public void testShouldReturnNotAuthorizedWhenGettingSpacesCreatorsAsNotPlatformAdministrator() throws Exception {
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesAdministration/permissions/spacesCreators"), "", null, null, "mary");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testShouldUpdateSpacesCreatorsWhenSpacesAdministrator() throws Exception {
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        String newMemberships = "[ {   \"membershipType\": \"member\",   \"group\": \"/platform/users\" }]";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        this.startSessionAs("root");
        ContainerResponse response = this.service("PUT", this.getURLResource("spacesAdministration/permissions/spacesCreators"), "", (MultivaluedMap<String, String>)headers, newMemberships.getBytes(), "root");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        List spacesCreatorsMemberships = this.spacesAdministrationService.getSpacesAdministratorsMemberships();
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)spacesCreatorsMemberships);
        SpacesAdministrationRestResourcesTest.assertEquals((int)1, (int)spacesCreatorsMemberships.size());
        SpacesAdministrationRestResourcesTest.assertTrue((boolean)spacesCreatorsMemberships.contains(new MembershipEntry("/platform/users", "member")));
    }

    public void testShouldNotAuthorizedWhenUpdatingSpacesCreatorsAsNotPlatformAdministrator() throws Exception {
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(Arrays.asList(new MembershipEntry("/platform/users", "manager"), new MembershipEntry("/platform/administrators", "*")));
        String newMemberships = "[ {   \"membershipType\": \"member\",   \"group\": \"/platform/users\" }]";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"content-type", (Object)"application/json");
        this.startSessionAs("mary");
        ContainerResponse response = this.service("PUT", this.getURLResource("spacesAdministration/permissions/spacesCreators"), "", (MultivaluedMap<String, String>)headers, newMemberships.getBytes(), "mary");
        SpacesAdministrationRestResourcesTest.assertNotNull((Object)response);
        SpacesAdministrationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }
}

