/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacemembership;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.impl.spacemembership.SpaceMembershipRest;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class SpaceMembershipRestResourcesTest
extends AbstractResourceTest {
    private static final String INVITED = "invited";
    private static final String SPACE6 = "space6";
    private static final String SPACE5 = "space5";
    private static final String SPACE4 = "space4";
    private static final String SPACE3 = "space3";
    private static final String SPACE2 = "space2";
    private static final String IGNORED = "ignored";
    private static final String SPACES_MEMBERSHIPS_SPACE_URL = "spacesMemberships?space=";
    private static final String SPACES_MEMBERSHIPS_URL = "spacesMemberships";
    private static final String SPACE1 = "space1";
    private SpaceService spaceService;
    private SpaceMembershipRest membershipRestResources;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        Identity rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        Identity johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        Identity maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        Identity demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        Stream.of(rootIdentity, johnIdentity, maryIdentity, demoIdentity).filter(Objects::nonNull).forEach(identity -> {
            identity.setDeleted(false);
            identity.setEnable(true);
            this.identityManager.updateIdentity(identity);
        });
        this.createSpaceIfNotExist(1, "root", "closed");
        this.createSpaceIfNotExist(2, "root", "validation", "hidden");
        this.createSpaceIfNotExist(3, "john");
        this.createSpaceIfNotExist(4, "mary");
        this.createSpaceIfNotExist(5, "mary");
        this.createSpaceIfNotExist(6, "mary");
        this.membershipRestResources = new SpaceMembershipRest(this.spaceService, this.identityManager);
        this.registry(this.membershipRestResources);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(this.membershipRestResources.getClass());
    }

    public void testGetSpacesMembershipsOfCurrentUser() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_URL), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?limit=1"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?user=root&offset=1"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.startSessionAs("john");
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(5) + "&user=john"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(5)), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(5) + "&status=manager"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testGetSpaceMembershipsOfAnotherUserAsANonSpacesAdministrator() throws Exception {
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?user=john"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testGetSpaceMembershipsOfAnotherUserAsASpacesAdministrator() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?user=mary&status=member"), "", null, null, "root");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?user=mary&status=manager"), "", null, null, "root");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
    }

    public void testGetSpaceMembershipsOfASpaceAsANonMember() throws Exception {
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(2)), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(1)), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(3)), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSpaceMembershipsOfASpaceAsAPendingUser() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonStatusInput(this.getSpaceId(1), "demo", INVITED));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        Space space = this.spaceService.getSpaceByPrettyName(SPACE1);
        this.spaceService.addPendingUser(space, "mary");
        this.startSessionAs("mary");
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(1) + "&user=mary"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity spacesMemberships = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships.getEntities());
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)spacesMemberships.getEntities().size());
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(1) + "&user=mary&status=pending"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        spacesMemberships = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships.getEntities());
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)spacesMemberships.getEntities().size());
        DataEntity data = (DataEntity)spacesMemberships.getEntities().get(0);
        SpaceMembershipRestResourcesTest.assertEquals((Object)"space1:mary:pending", (Object)data.get((Object)"id"));
    }

    public void testGetSpaceMembershipsOfASpaceAsAnInvitedUser() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "demo", "member"));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        Space space = this.spaceService.getSpaceByPrettyName(SPACE1);
        this.spaceService.addInvitedUser(space, "mary");
        this.startSessionAs("mary");
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(1) + "&user=mary"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity spacesMemberships = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships.getEntities());
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)spacesMemberships.getEntities().size());
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(1) + "&user=mary&status=invited"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        spacesMemberships = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)spacesMemberships.getEntities());
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)spacesMemberships.getEntities().size());
        DataEntity data = (DataEntity)spacesMemberships.getEntities().get(0);
        SpaceMembershipRestResourcesTest.assertEquals((Object)"space1:mary:invited", (Object)data.get((Object)"id"));
    }

    public void testGetSpaceMembershipsOfASpaceAsManager() throws Exception {
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(4) + "&user=mary"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(4)), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testAddSpaceMembership() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), "{\"user\":demo}");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), "{\"space\":15523, \"user\":demo}");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), "{\"space\":" + this.getSpaceId(1) + ", \"user\":demoxx}");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonStatusInput(this.getSpaceId(1), "john", "pending"));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "john", IGNORED));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonStatusInput(this.getSpaceId(1), "root", IGNORED));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)409, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonStatusInput(this.getSpaceId(1), "root", INVITED));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)409, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "demo", "member"));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        Space space = this.spaceService.getSpaceByPrettyName(SPACE1);
        SpaceMembershipRestResourcesTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getMembers(), (Object)"demo"));
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "john", "redactor"));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        space = this.spaceService.getSpaceByPrettyName(SPACE1);
        SpaceMembershipRestResourcesTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getRedactors(), (Object)"john"));
        SpaceMembershipRestResourcesTest.assertFalse((boolean)ArrayUtils.contains((Object[])space.getRedactors(), (Object)"demo"));
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)space.getRedactors().length);
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "demo", "publisher"));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        space = this.spaceService.getSpaceByPrettyName(SPACE1);
        SpaceMembershipRestResourcesTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getPublishers(), (Object)"demo"));
        SpaceMembershipRestResourcesTest.assertFalse((boolean)ArrayUtils.contains((Object[])space.getPublishers(), (Object)"john"));
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)space.getPublishers().length);
        this.startSessionAs("demo");
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "mary", "member"));
        SpaceMembershipRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonStatusInput(this.getSpaceId(1), "demo", IGNORED));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)409, (int)response.getStatus());
        this.startSessionAs("mary");
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonStatusInput(this.getSpaceId(1), "mary", IGNORED));
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testGetUpdateDeleteSpaceMembership() throws Exception {
        this.spaceService.addMember(this.spaceService.getSpaceByPrettyName(SPACE1), "demo");
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource(SPACES_MEMBERSHIPS_SPACE_URL + this.getSpaceId(1) + "&user=demo&status=member"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("POST", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "demo", "manager"));
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        Space space1 = this.spaceService.getSpaceByPrettyName(SPACE1);
        SpaceMembershipRestResourcesTest.assertTrue((boolean)this.spaceService.isManager(space1, "demo"));
        response = this.getResponse("DELETE", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "demo", "member"));
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        SpaceMembershipRestResourcesTest.assertFalse((boolean)this.spaceService.isMember(this.spaceService.getSpaceByPrettyName(SPACE1), "demo"));
        SpaceMembershipRestResourcesTest.assertFalse((boolean)this.spaceService.isManager(this.spaceService.getSpaceByPrettyName(SPACE1), "demo"));
        this.spaceService.addRedactor(this.spaceService.getSpaceByPrettyName(SPACE1), "demo");
        response = this.getResponse("DELETE", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "demo", "redactor"));
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        SpaceMembershipRestResourcesTest.assertFalse((boolean)this.spaceService.isRedactor(this.spaceService.getSpaceByPrettyName(SPACE1), "demo"));
        this.spaceService.addPublisher(this.spaceService.getSpaceByPrettyName(SPACE1), "demo");
        response = this.getResponse("DELETE", this.getURLResource(SPACES_MEMBERSHIPS_URL), this.getJsonRoleInput(this.getSpaceId(1), "demo", "publisher"));
        SpaceMembershipRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        SpaceMembershipRestResourcesTest.assertFalse((boolean)this.spaceService.isPublisher(this.spaceService.getSpaceByPrettyName(SPACE1), "demo"));
    }

    public void testGetMemberSpaceMemberships() throws Exception {
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE1), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE2), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE3), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE4), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName(SPACE5), "demo");
        this.spaceService.addMember(this.spaceService.getSpaceByPrettyName(SPACE6), "demo");
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?status=approved&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=approved&space=" + this.getSpaceId(2) + "&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=approved&space=" + this.getSpaceId(2) + "&user=demo&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=invited&space=" + this.getSpaceId(4) + "&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=approved&space=" + this.getSpaceId(4) + "&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=approved&space=" + this.getSpaceId(6) + "&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=approved&space=" + this.getSpaceId(6) + "&offset=3&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=approved&space=" + this.getSpaceId(6) + "&user=demo&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testGetInvitedSpaceMemberships() throws Exception {
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE1), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE2), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE3), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE4), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName(SPACE5), "demo");
        this.spaceService.addMember(this.spaceService.getSpaceByPrettyName(SPACE6), "demo");
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?status=invited&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=invited&space=" + this.getSpaceId(5) + "&user=demo&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=invited&space=" + this.getSpaceId(4) + "&user=demo&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=invited&space=" + this.getSpaceId(6) + "&user=demo&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
    }

    public void testGetPendingSpaceMemberships() throws Exception {
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName(SPACE1), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName(SPACE2), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName(SPACE3), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName(SPACE4), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName(SPACE5), "demo");
        this.spaceService.addMember(this.spaceService.getSpaceByPrettyName(SPACE6), "demo");
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?status=pending&user=demo&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=pending&user=demo&space=" + this.getSpaceId(5) + "&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=pending&user=demo&space=" + this.getSpaceId(4) + "&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?status=pending&user=demo&space=" + this.getSpaceId(6) + "&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
    }

    private void createSpaceIfNotExist(int index, String creator) throws Exception {
        this.createSpaceIfNotExist(index, creator, "open");
    }

    private void createSpaceIfNotExist(int index, String creator, String registration) throws Exception {
        this.createSpaceIfNotExist(index, creator, "open", "private");
    }

    private void createSpaceIfNotExist(int index, String creator, String registration, String visibility) throws Exception {
        String spaceName = "space" + index;
        if (this.spaceService.getSpaceByPrettyName(spaceName) == null) {
            Space space = new Space();
            space.setDisplayName(spaceName);
            space.setPrettyName(space.getDisplayName());
            space.setRegistration(registration);
            space.setDescription("add new space " + index);
            space.setVisibility(visibility);
            space.setRegistration("validation");
            space.setPriority("2");
            this.spaceService.createSpace(space, creator);
        }
    }

    private String getJsonRoleInput(String spaceId, String username, String role) {
        return String.format("{\"space\":\"%s\", \"user\":\"%s\", \"role\":\"%s\"}", spaceId, username, role);
    }

    private String getJsonStatusInput(String spaceId, String username, String status) {
        return String.format("{\"space\":\"%s\", \"user\":\"%s\", \"status\":\"%s\"}", spaceId, username, status);
    }

    private String getSpaceId(int index) {
        return this.spaceService.getSpaceByPrettyName("space" + index).getId();
    }
}

