/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.observer.rest;

import io.meeds.social.observe.model.ObserverObject;
import io.meeds.social.observe.plugin.ObserverPlugin;
import io.meeds.social.observe.service.ObserverService;
import io.meeds.social.observer.rest.ObserverRest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ObserverRestTest
extends AbstractResourceTest {
    private static final String BASE_URL = "/social/observers";
    private static MockedStatic<RestUtils> REST_UTILS;
    private static final String NOT_FOUND_OBJECT_ID = "notFound";
    private static final String OBJECT_TYPE = "fake";
    protected String objectType = "fake";
    protected String objectId;
    protected List<String> allowedObjectId;
    protected long[] allowedIdentityIds;
    protected long spaceId = Math.round(Math.random() * 10000.0);
    protected long audienceId = Math.round(Math.random() * 20000.0);
    protected long identityId = Math.round(Math.random() * 30000.0);
    private ObserverRest observerRest;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ObserverService observerService = (ObserverService)this.getContainer().getComponentInstanceOfType(ObserverService.class);
        observerService.removePlugin(OBJECT_TYPE);
        observerService.addPlugin((ObserverPlugin)new TestObserverPlugin());
        ++this.spaceId;
        ++this.audienceId;
        ++this.identityId;
        this.objectType = OBJECT_TYPE;
        this.objectId = this.spaceId + "-" + this.audienceId;
        this.allowedObjectId = new ArrayList<String>();
        this.allowedObjectId.add(this.objectId);
        this.allowedIdentityIds = new long[0];
        this.observerRest = new ObserverRest(observerService);
        this.registry(this.observerRest);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.restartTransaction();
        this.begin();
        REST_UTILS = Mockito.mockStatic(RestUtils.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.removeResource(this.observerRest.getClass());
        this.end();
        super.tearDown();
        REST_UTILS.close();
    }

    @Test
    public void testCreateObserver() {
        ObserverRestTest.assertFalse((boolean)this.isObserved(this.identityId, this.objectType, this.objectId));
        ContainerResponse response = this.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertEquals((int)401, (int)response.getStatus());
        this.allowedIdentityIds = new long[]{this.identityId};
        response = this.createObserver(this.identityId, OBJECT_TYPE, NOT_FOUND_OBJECT_ID);
        ObserverRestTest.assertEquals((int)404, (int)response.getStatus());
        response = this.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertEquals((int)204, (int)response.getStatus());
        ObserverRestTest.assertTrue((boolean)this.isObserved(this.identityId, this.objectType, this.objectId));
        response = this.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertEquals((int)204, (int)response.getStatus());
        response = this.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testDeleteObserver() {
        ContainerResponse response = this.deleteObserver(this.identityId, OBJECT_TYPE, NOT_FOUND_OBJECT_ID);
        ObserverRestTest.assertEquals((int)404, (int)response.getStatus());
        ObserverRestTest.assertFalse((boolean)this.isObserved(this.identityId, this.objectType, this.objectId));
        this.allowedIdentityIds = new long[]{this.identityId};
        this.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertTrue((boolean)this.isObserved(this.identityId, this.objectType, this.objectId));
        response = this.deleteObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertEquals((int)204, (int)response.getStatus());
        ObserverRestTest.assertFalse((boolean)this.isObserved(this.identityId, this.objectType, this.objectId));
        this.createObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertTrue((boolean)this.isObserved(this.identityId, this.objectType, this.objectId));
        response = this.deleteObserver(this.identityId, OBJECT_TYPE, this.objectId);
        ObserverRestTest.assertEquals((int)204, (int)response.getStatus());
        ObserverRestTest.assertFalse((boolean)this.isObserved(this.identityId, this.objectType, this.objectId));
    }

    public void testGetObservedObjects() {
        ++this.identityId;
        long identityId1 = this.identityId++;
        long identityId2 = this.identityId;
        this.allowedIdentityIds = new long[]{identityId1, identityId2};
        List<ObserverObject> observedObjects = this.getObservedObjects(identityId1);
        ObserverRestTest.assertNotNull(observedObjects);
        ObserverRestTest.assertTrue((boolean)observedObjects.isEmpty());
        String[] objectId1s = new String[]{"obj1" + identityId1, "obj2" + identityId1};
        Arrays.stream(objectId1s).forEach(id -> {
            this.allowedObjectId.add((String)id);
            try {
                this.createObserver(identityId1, OBJECT_TYPE, (String)id);
                this.createObserver(identityId2, OBJECT_TYPE, (String)id);
            }
            catch (Exception e) {
                ObserverRestTest.fail((Throwable)e);
            }
        });
        String[] objectId2s = new String[]{"obj1" + identityId2, "obj2" + identityId2};
        Arrays.stream(objectId2s).forEach(id -> {
            this.allowedObjectId.add((String)id);
            try {
                this.createObserver(identityId2, OBJECT_TYPE, (String)id);
            }
            catch (Exception e) {
                ObserverRestTest.fail((Throwable)e);
            }
        });
        observedObjects = this.getObservedObjects(identityId1);
        ObserverRestTest.assertNotNull(observedObjects);
        ObserverRestTest.assertEquals((int)2, (int)observedObjects.size());
        observedObjects = this.getObservedObjects(identityId2);
        ObserverRestTest.assertNotNull(observedObjects);
        ObserverRestTest.assertEquals((int)4, (int)observedObjects.size());
    }

    private String getUrl() {
        return BASE_URL;
    }

    private String getUrl(String objectType, String objectId) {
        return this.getUrl() + "/" + objectType + "/" + objectId;
    }

    private List<ObserverObject> getObservedObjects(long identityId) {
        this.startSessionAs("testuser");
        REST_UTILS.reset();
        REST_UTILS.when(RestUtils::getCurrentUserIdentityId).thenReturn((Object)identityId);
        try {
            ContainerResponse response = this.getResponse("GET", this.getUrl(), null);
            return (List)response.getEntity();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while checking observer", e);
        }
    }

    private boolean isObserved(long identityId, String objectType, String objectId) {
        this.startSessionAs("testuser");
        REST_UTILS.reset();
        REST_UTILS.when(RestUtils::getCurrentUserIdentityId).thenReturn((Object)identityId);
        try {
            ContainerResponse response = this.getResponse("GET", this.getUrl(objectType, objectId), null);
            return response != null && response.getStatus() < 300 && response.getEntity() != null && StringUtils.equals((CharSequence)response.getEntity().toString(), (CharSequence)"true");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while checking observer", e);
        }
    }

    private ContainerResponse createObserver(long identityId, String objectType, String objectId) {
        this.startSessionAs("testuser");
        REST_UTILS.reset();
        REST_UTILS.when(RestUtils::getCurrentUserIdentityId).thenReturn((Object)identityId);
        try {
            return this.getResponse("POST", this.getUrl(objectType, objectId), null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while creating observer", e);
        }
    }

    private ContainerResponse deleteObserver(long identityId, String objectType, String objectId) {
        this.startSessionAs("testuser");
        REST_UTILS.reset();
        REST_UTILS.when(RestUtils::getCurrentUserIdentityId).thenReturn((Object)identityId);
        try {
            return this.getResponse("DELETE", this.getUrl(objectType, objectId), null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while deleting observer", e);
        }
    }

    public class TestObserverPlugin
    extends ObserverPlugin {
        public boolean canObserve(long identityId, String id) throws ObjectNotFoundException {
            if (!ObserverRestTest.this.allowedObjectId.contains(id)) {
                throw new ObjectNotFoundException("Not viewable");
            }
            return Arrays.binarySearch(ObserverRestTest.this.allowedIdentityIds, identityId) >= 0;
        }

        public long getAudienceId(String id) throws ObjectNotFoundException {
            if (!ObserverRestTest.this.allowedObjectId.contains(id)) {
                throw new ObjectNotFoundException("No audience");
            }
            return ObserverRestTest.this.audienceId;
        }

        public long getSpaceId(String id) throws ObjectNotFoundException {
            if (!ObserverRestTest.this.allowedObjectId.contains(id)) {
                throw new ObjectNotFoundException("No space");
            }
            return ObserverRestTest.this.spaceId;
        }

        public String getObjectType() {
            return ObserverRestTest.this.objectType;
        }
    }
}

