/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacetemplates;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.space.SpaceApplication;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceTemplateConfigPlugin;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.rest.impl.spacetemplates.SpaceTemplatesRest;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class SpaceTemplatesRestResourcesTest
extends AbstractResourceTest {
    private SpaceTemplateService spaceTemplateService;
    private ConfigurationManager configurationManager;
    private SpaceTemplatesRest spaceTemplatesRestResourcesV1;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.spaceTemplateService = (SpaceTemplateService)this.getContainer().getComponentInstanceOfType(SpaceTemplateService.class);
        this.configurationManager = (ConfigurationManager)this.getContainer().getComponentInstanceOfType(ConfigurationManager.class);
        this.spaceTemplatesRestResourcesV1 = new SpaceTemplatesRest(this.spaceTemplateService, this.configurationManager);
        this.registry(this.spaceTemplatesRestResourcesV1);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(this.spaceTemplatesRestResourcesV1.getClass());
    }

    public void testShouldReturnAllSpaceTemplatesDetails() throws Exception {
        SpaceApplication homeApplication = new SpaceApplication();
        homeApplication.setAppTitle("fakeHome");
        homeApplication.setPortletApp("fakeHomeApp");
        homeApplication.setPortletName("fakeHomeName");
        ArrayList<SpaceApplication> applicationList = new ArrayList<SpaceApplication>();
        for (int i = 0; i < 3; ++i) {
            SpaceApplication app = new SpaceApplication();
            app.setAppTitle("fakeTitle" + i);
            app.setPortletApp("fakeApp" + i);
            app.setPortletName("fakeName" + i);
            applicationList.add(app);
        }
        SpaceTemplate spaceTemplate = new SpaceTemplate();
        spaceTemplate.setName("custom");
        spaceTemplate.setVisibility("private");
        spaceTemplate.setRegistration("open");
        spaceTemplate.setPermissions("*:/platform/administrators");
        spaceTemplate.setHomeApplication(homeApplication);
        spaceTemplate.setSpaceApplicationList(applicationList);
        InitParams params = new InitParams();
        ObjectParameter objParam = new ObjectParameter();
        objParam.setName("template");
        objParam.setObject((Object)spaceTemplate);
        params.addParameter((Parameter)objParam);
        SpaceTemplateConfigPlugin spaceTemplateConfigPlugin = new SpaceTemplateConfigPlugin(params);
        this.spaceTemplateService.registerSpaceTemplatePlugin(spaceTemplateConfigPlugin);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spaceTemplates/templates"), "", null, null, "root");
        SpaceTemplatesRestResourcesTest.assertNotNull((Object)response);
        SpaceTemplatesRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        List templates = (List)response.getEntity();
        SpaceTemplatesRestResourcesTest.assertNotNull((Object)templates);
        SpaceTemplatesRestResourcesTest.assertEquals((int)2, (int)templates.size());
        List classicTemplate = templates.stream().filter(t -> t.getName().equals("classic")).collect(Collectors.toList());
        SpaceTemplatesRestResourcesTest.assertNotNull(classicTemplate);
        SpaceTemplatesRestResourcesTest.assertEquals((int)1, (int)classicTemplate.size());
        List customTemplate = templates.stream().filter(t -> t.getName().equals("custom")).collect(Collectors.toList());
        SpaceTemplatesRestResourcesTest.assertNotNull(customTemplate);
        SpaceTemplatesRestResourcesTest.assertEquals((int)1, (int)customTemplate.size());
        List customApps = ((SpaceTemplate)customTemplate.get(0)).getSpaceApplicationList();
        SpaceTemplatesRestResourcesTest.assertNotNull((Object)customApps);
        SpaceTemplatesRestResourcesTest.assertEquals((int)3, (int)customApps.size());
    }

    public void testShouldReturnSpaceTemplateBanner() throws Exception {
        SpaceApplication homeApplication = new SpaceApplication();
        homeApplication.setAppTitle("fakeHome");
        homeApplication.setPortletApp("fakeHomeApp");
        homeApplication.setPortletName("fakeHomeName");
        SpaceTemplate spaceTemplate = new SpaceTemplate();
        spaceTemplate.setName("custom");
        spaceTemplate.setVisibility("private");
        spaceTemplate.setRegistration("open");
        spaceTemplate.setBannerPath("classpath:/conf/social-extension/social/space-template/custom/banner.png");
        spaceTemplate.setHomeApplication(homeApplication);
        InitParams params = new InitParams();
        ObjectParameter objParam = new ObjectParameter();
        objParam.setName("template");
        objParam.setObject((Object)spaceTemplate);
        params.addParameter((Parameter)objParam);
        SpaceTemplateConfigPlugin spaceTemplateConfigPlugin = new SpaceTemplateConfigPlugin(params);
        this.spaceTemplateService.registerSpaceTemplatePlugin(spaceTemplateConfigPlugin);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spaceTemplates/custom/banner"), "", null, null, "root");
        SpaceTemplatesRestResourcesTest.assertNotNull((Object)response);
        SpaceTemplatesRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceTemplatesRestResourcesTest.assertEquals((String)"image", (String)response.getContentType().getType());
        SpaceTemplatesRestResourcesTest.assertEquals((String)"png", (String)response.getContentType().getSubtype());
    }
}

