/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacemembership;

import io.meeds.social.space.constant.SpaceMembershipStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.SpaceMembershipUpdateEntity;

@Path(value="v1/social/spacesMemberships")
@Tag(name="v1/social/spacesMemberships", description="Managing memberships of users in a space")
public class SpaceMembershipRest
implements ResourceContainer {
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public SpaceMembershipRest(SpaceService spaceService, IdentityManager identityManager) {
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets space memberships", method="GET", description="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getSpacesMemberships(@Context UriInfo uriInfo, @Parameter(description="Space technical identifier to include to get membership") @QueryParam(value="space") String spaceId, @Parameter(description="User name to filter only memberships of the given user") @QueryParam(value="user") String user, @Parameter(description="Type of membership to get (All, Pending, Approved, Invited)") @QueryParam(value="status") String status, @Parameter(description="Search query") @QueryParam(value="query") String query, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Asking for a full representation of a specific subresource if any") @QueryParam(value="expand") String expand, @Parameter(description="Returning the number of memberships or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        List<DataEntity> spaceMemberships;
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        MembershipType membershipType = this.getMembershipType(status);
        Space space = null;
        if (StringUtils.isNotBlank((CharSequence)spaceId)) {
            space = this.spaceService.getSpaceById(spaceId);
        } else if (StringUtils.isBlank((CharSequence)user)) {
            user = authenticatedUser;
        }
        if (!this.canRetrieveSpaceMemberships(space, user, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        int size = 0;
        if (space != null) {
            SpaceMemberFilterListAccess.Type type = SpaceMemberFilterListAccess.Type.valueOf((String)membershipType.name());
            ProfileFilter profileFilter = new ProfileFilter(query);
            if (StringUtils.isNotBlank((CharSequence)user)) {
                profileFilter.setRemoteIds(Collections.singletonList(user));
            }
            ListAccess listAccess = this.identityManager.getSpaceIdentityByProfileFilter(space, profileFilter, type, true);
            Identity[] identities = (Identity[])listAccess.load(offset, limit);
            spaceMemberships = EntityBuilder.buildSpaceMemberships(this.spaceService, space, Arrays.asList(identities), membershipType, uriInfo, expand);
            if (returnSize) {
                size = listAccess.getSize();
            }
        } else {
            SpaceFilter spaceFilter = new SpaceFilter();
            spaceFilter.setRemoteId(user);
            spaceFilter.setStatus(membershipType.getStatus());
            spaceFilter.setSpaceNameSearchCondition(query);
            ListAccess listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
            Space[] spaces = (Space[])listAccess.load(0, limit);
            spaceMemberships = EntityBuilder.buildSpaceMemberships(this.spaceService, Arrays.asList(spaces), user, membershipType, offset, uriInfo.getPath(), expand);
            if (returnSize) {
                size = listAccess.getSize();
            }
        }
        CollectionEntity spacesMemberships = new CollectionEntity(spaceMemberships.stream().limit(limit).toList(), "spacesMemberships", offset, limit);
        spacesMemberships.setSize(size);
        return EntityBuilder.getResponseBuilder(spacesMemberships, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a space membership for a specific user", method="POST", description="This creates the space membership in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user and the space subscription is open</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response addSpacesMemberships(@RequestBody(description="Space membership object to be created, ex:<br />{<br />\"role\": \"manager\",<br />\"user\": \"john\",<br />\"space\": \"1552\"<br />}", required=true) SpaceMembershipUpdateEntity model) {
        if (model == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (model.getSpace() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Space is null").build();
        }
        if (model.getUser() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"User is null").build();
        }
        if (model.getRole() == null && model.getStatus() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Role and Status are null").build();
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        String user = model.getUser();
        String spaceId = model.getSpace();
        String status = StringUtils.lowerCase((String)model.getStatus());
        String role = StringUtils.lowerCase((String)model.getRole());
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (this.identityManager.getOrCreateUserIdentity(user) == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        boolean canManageSpace = this.spaceService.canManageSpace(space, authenticatedUser);
        boolean selfMembership = authenticatedUser.equals(user);
        if (MembershipType.IGNORED.name().equalsIgnoreCase(status)) {
            if (!canManageSpace && !selfMembership) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            if (this.spaceService.isMember(space, user)) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
            if (this.spaceService.isPendingUser(space, user)) {
                this.spaceService.removePendingUser(space, user);
            } else if (this.spaceService.isInvitedUser(space, user)) {
                this.spaceService.removeInvitedUser(space, user);
            }
            if (!selfMembership) return Response.noContent().build();
            this.spaceService.setIgnored(space.getId(), user);
            return Response.noContent().build();
        } else if (MembershipType.APPROVED.name().equalsIgnoreCase(status)) {
            if (!canManageSpace && !selfMembership) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            if (this.spaceService.isMember(space, user)) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
            if (this.spaceService.isInvitedUser(space, user) && selfMembership) {
                this.spaceService.addMember(space, authenticatedUser);
                return Response.noContent().build();
            } else {
                if (!this.spaceService.isPendingUser(space, user) || !canManageSpace) throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                this.spaceService.addMember(space, authenticatedUser);
            }
            return Response.noContent().build();
        } else if (MembershipType.PENDING.name().equalsIgnoreCase(status)) {
            if (!selfMembership) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            if (this.spaceService.isInvitedUser(space, user)) {
                this.spaceService.addMember(space, authenticatedUser);
                return Response.noContent().build();
            } else {
                if (this.spaceService.isMember(space, user) || this.spaceService.isPendingUser(space, user)) {
                    throw new WebApplicationException(Response.Status.CONFLICT);
                }
                if (space.getRegistration().equals("open")) {
                    this.spaceService.addMember(space, user);
                    return Response.noContent().build();
                } else {
                    if (space.getVisibility().equals("hidden") || space.getRegistration().equals("closed")) {
                        throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                    }
                    this.spaceService.addPendingUser(space, user);
                }
            }
            return Response.noContent().build();
        } else if (MembershipType.INVITED.name().equalsIgnoreCase(status)) {
            if (!canManageSpace) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            if (this.spaceService.isMember(space, user) || this.spaceService.isInvitedUser(space, user)) {
                throw new WebApplicationException(Response.Status.CONFLICT);
            }
            if (this.spaceService.isInvitedUser(space, user)) {
                this.spaceService.addMember(space, authenticatedUser);
                return Response.noContent().build();
            } else {
                this.spaceService.addInvitedUser(space, authenticatedUser);
            }
            return Response.noContent().build();
        } else {
            if (StringUtils.isNotBlank((CharSequence)status)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Status is not managed").build();
            }
            if (this.isAddSelfToSpace(space, user, role, authenticatedUser)) {
                this.spaceService.addMember(space, user);
                return Response.noContent().build();
            } else {
                if (!canManageSpace) throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                if ("manager".equalsIgnoreCase(role)) {
                    this.spaceService.addMember(space, user);
                    this.spaceService.setManager(space, user, true);
                    return Response.noContent().build();
                } else if ("redactor".equalsIgnoreCase(role)) {
                    this.spaceService.addMember(space, user);
                    this.spaceService.addRedactor(space, user);
                    return Response.noContent().build();
                } else if ("publisher".equalsIgnoreCase(role)) {
                    this.spaceService.addMember(space, user);
                    this.spaceService.addPublisher(space, user);
                    return Response.noContent().build();
                } else {
                    if (!"member".equalsIgnoreCase(role) && !StringUtils.isBlank((CharSequence)role)) return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Role is not managed").build();
                    this.spaceService.addMember(space, user);
                }
            }
        }
        return Response.noContent().build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @Operation(summary="Deletes a specific space membership by id", method="DELETE", description="This deletes the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="412", description="Precondition is not acceptable. For instance, the last manager membership could not be removed."), @ApiResponse(responseCode="500", description="Internal server error due to data encoding")})
    public Response deleteSpaceMembershipById(@RequestBody(description="Space membership object to be created, ex:<br />{<br />\"role\": \"manager\",<br />\"user\": \"john\",<br />\"space\": \"1552\"<br />}", required=true) SpaceMembershipUpdateEntity model) {
        if (model == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (StringUtils.isBlank((CharSequence)model.getUser())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"User is null").build();
        }
        if (StringUtils.isBlank((CharSequence)model.getSpace())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Space is null").build();
        }
        if (StringUtils.isBlank((CharSequence)model.getRole())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Role is null").build();
        }
        String user = model.getUser();
        Space space = this.spaceService.getSpaceById(model.getSpace());
        if (space == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        boolean canManageSpace = this.spaceService.canManageSpace(space, authenticatedUser);
        boolean selfMembership = authenticatedUser.equals(user);
        if (!selfMembership && !canManageSpace) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String role = model.getRole();
        if ((role.equals("member") || role.equals("manager")) && this.spaceService.isOnlyManager(space, user)) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        space.setEditor(authenticatedUser);
        if (selfMembership && role.equalsIgnoreCase("member")) {
            this.spaceService.removeMember(space, user);
            return Response.noContent().build();
        } else {
            if (!canManageSpace) throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            if (role.equalsIgnoreCase("redactor")) {
                this.spaceService.removeRedactor(space, user);
                return Response.noContent().build();
            } else if (role.equalsIgnoreCase("publisher")) {
                this.spaceService.removePublisher(space, user);
                return Response.noContent().build();
            } else if (role.equalsIgnoreCase("manager")) {
                this.spaceService.setManager(space, user, false);
                return Response.noContent().build();
            } else {
                if (!role.equalsIgnoreCase("member")) return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Role is not managed").build();
                this.spaceService.removeMember(space, user);
            }
        }
        return Response.noContent().build();
    }

    private boolean canRetrieveSpaceMemberships(Space space, String targetUser, String authenticatedUser) {
        if (this.spaceService.isSuperManager(authenticatedUser) || space == null && StringUtils.equals((CharSequence)targetUser, (CharSequence)authenticatedUser)) {
            return true;
        }
        if (space == null) {
            return StringUtils.equals((CharSequence)targetUser, (CharSequence)authenticatedUser);
        }
        return !"hidden".equals(space.getVisibility()) || this.spaceService.canViewSpace(space, authenticatedUser) || this.spaceService.isInvitedUser(space, authenticatedUser);
    }

    private boolean isAddSelfToSpace(Space space, String targetUser, String role, String authenticatedUser) {
        return "member".equalsIgnoreCase(role) && authenticatedUser.equals(targetUser) && this.canAddSelfToSpace(space, authenticatedUser);
    }

    private boolean canAddSelfToSpace(Space space, String authenticatedUser) {
        return space.getRegistration().equals("open") || this.spaceService.isInvitedUser(space, authenticatedUser);
    }

    private MembershipType getMembershipType(String status) {
        if (StringUtils.isBlank((CharSequence)status)) {
            return MembershipType.MEMBER;
        }
        try {
            MembershipType membershipType = MembershipType.valueOf(status.toUpperCase());
            if (membershipType == MembershipType.APPROVED) {
                membershipType = MembershipType.MEMBER;
            }
            return membershipType;
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    public static enum MembershipType {
        PENDING("pending", SpaceMembershipStatus.PENDING),
        APPROVED("member", SpaceMembershipStatus.MEMBER),
        IGNORED("ignored", SpaceMembershipStatus.IGNORED),
        INVITED("invited", SpaceMembershipStatus.INVITED),
        MEMBER("member", SpaceMembershipStatus.MEMBER),
        MANAGER("manager", SpaceMembershipStatus.MANAGER),
        PUBLISHER("publisher", SpaceMembershipStatus.PUBLISHER),
        REDACTOR("redactor", SpaceMembershipStatus.REDACTOR);

        private final SpaceMembershipStatus status;
        private final String role;

        private MembershipType(String role, SpaceMembershipStatus status) {
            this.role = role;
            this.status = status;
        }

        @Generated
        public SpaceMembershipStatus getStatus() {
            return this.status;
        }

        @Generated
        public String getRole() {
            return this.role;
        }
    }
}

