/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.link.rest;

import io.meeds.social.link.constant.LinkDisplayType;
import io.meeds.social.link.dao.LinkDAO;
import io.meeds.social.link.dao.LinkSettingDAO;
import io.meeds.social.link.model.LinkSetting;
import io.meeds.social.link.rest.LinkRest;
import io.meeds.social.link.rest.model.LinkRestEntity;
import io.meeds.social.link.rest.model.LinkSettingRestEntity;
import io.meeds.social.link.service.LinkService;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.mock.MockUploadService;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.exoplatform.upload.UploadService;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class LinkRestTest
extends AbstractResourceTest {
    private static final String BASE_URL = "/social/links";
    private static MockedStatic<RestUtils> REST_UTILS;
    private static final String USERS_GROUP = "*:/platform/users";
    private static final String ADMINISTRATORS_GROUP = "*:/platform/administrators";
    private static final String USERNAME = "testuser";
    private static final String LINK_SETTING_NAME = "linkSettingName";
    private static final String MIME_TYPE = "image/png";
    private static final String FILE_NAME = "cover.png";
    private static final String UPLOAD_ID = "1234";
    private LayoutService layoutService;
    private LinkService linkService;
    private IdentityRegistry identityRegistry;
    private MockUploadService uploadService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.linkService = (LinkService)this.getContainer().getComponentInstanceOfType(LinkService.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        this.uploadService = (MockUploadService)this.getContainer().getComponentInstanceOfType(UploadService.class);
        this.registry(new LinkRest(this.linkService));
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.restartTransaction();
        this.begin();
        REST_UTILS = Mockito.mockStatic(RestUtils.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.restartTransaction();
        ((LinkDAO)this.getContainer().getComponentInstanceOfType(LinkDAO.class)).deleteAll();
        this.restartTransaction();
        ((LinkSettingDAO)this.getContainer().getComponentInstanceOfType(LinkSettingDAO.class)).deleteAll();
        ((CacheService)this.getContainer().getComponentInstanceOfType(CacheService.class)).getCacheInstance("social.linkSettings").clearCache();
        this.restartTransaction();
        this.removeResource(LinkRest.class);
        this.end();
        super.tearDown();
        REST_UTILS.close();
    }

    @Test
    public void testSaveLink() {
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, "testSaveLink", true);
        LinkRestTest.assertNotNull((Object)linkSetting);
        ContainerResponse response = this.saveLink();
        LinkRestTest.assertEquals((int)403, (int)response.getStatus());
        this.registerInternalUser(USERNAME);
        response = this.saveLink();
        LinkRestTest.assertEquals((int)401, (int)response.getStatus());
        this.registerAdministratorUser(USERNAME);
        response = this.saveLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetLinkResponseCode() throws InterruptedException {
        String pageName = "testGetLink";
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, pageName, true);
        LinkRestTest.assertNotNull((Object)linkSetting);
        this.registerAdministratorUser(USERNAME);
        ContainerResponse response = this.saveLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        this.registerAnonymousUser();
        response = this.getLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        linkSetting = this.initLinkSetting(LINK_SETTING_NAME, pageName, false);
        response = this.getLink();
        LinkRestTest.assertEquals((int)401, (int)response.getStatus());
        this.registerInternalUser(USERNAME);
        response = this.getLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        String eTagValue = this.getETagValue(response);
        response = this.getLinkWithETag(eTagValue);
        LinkRestTest.assertEquals((int)304, (int)response.getStatus());
        Thread.sleep(2L);
        this.registerAdministratorUser(USERNAME);
        response = this.saveLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        LinkSetting modifiedLinkSetting = this.initLinkSetting(LINK_SETTING_NAME, pageName, true);
        LinkRestTest.assertTrue((modifiedLinkSetting.getLastModified() > linkSetting.getLastModified() ? 1 : 0) != 0);
        this.registerInternalUser(USERNAME);
        response = this.getLinkWithETag(eTagValue);
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        this.registerAnonymousUser();
        response = this.getLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetLinkResponseEntity() throws Exception {
        String pageName = "testGetLinkResponseEntity";
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, pageName, true);
        LinkRestTest.assertNotNull((Object)linkSetting);
        this.registerAdministratorUser(USERNAME);
        ContainerResponse response = this.saveLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        this.registerAnonymousUser();
        response = this.getLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        LinkSettingRestEntity linkSettingRestEntity = (LinkSettingRestEntity)response.getEntity();
        LinkRestTest.assertTrue((linkSettingRestEntity.getId() > 0L ? 1 : 0) != 0);
        LinkRestTest.assertEquals((String)LINK_SETTING_NAME, (String)linkSettingRestEntity.getName());
        LinkSettingRestEntity newLinkSettingRestEntity = this.newLinkSettingRestEntity();
        LinkRestTest.assertEquals((String)newLinkSettingRestEntity.getName(), (String)linkSettingRestEntity.getName());
        LinkRestTest.assertEquals((Object)newLinkSettingRestEntity.getHeader(), (Object)linkSettingRestEntity.getHeader());
        LinkRestTest.assertEquals((String)newLinkSettingRestEntity.getSeeMore(), (String)linkSettingRestEntity.getSeeMore());
        LinkRestTest.assertEquals((Object)newLinkSettingRestEntity.getType(), (Object)linkSettingRestEntity.getType());
        LinkRestTest.assertEquals((boolean)newLinkSettingRestEntity.isLargeIcon(), (boolean)linkSettingRestEntity.isLargeIcon());
        LinkRestTest.assertEquals((boolean)newLinkSettingRestEntity.isShowName(), (boolean)linkSettingRestEntity.isShowName());
        LinkRestTest.assertEquals((boolean)newLinkSettingRestEntity.isShowDescription(), (boolean)linkSettingRestEntity.isShowDescription());
        List newLinks = newLinkSettingRestEntity.getLinks();
        List links = linkSettingRestEntity.getLinks();
        LinkRestTest.assertNotNull((Object)links);
        LinkRestTest.assertEquals((int)2, (int)links.size());
        LinkRestEntity savedLink1 = (LinkRestEntity)links.get(0);
        LinkRestTest.assertNotNull((Object)savedLink1);
        LinkRestTest.assertTrue((savedLink1.getId() > 0L ? 1 : 0) != 0);
        LinkRestTest.assertEquals((long)0L, (long)savedLink1.getIconFileId());
        LinkRestTest.assertNull((Object)savedLink1.getIconUrl());
        LinkRestEntity newLink1 = (LinkRestEntity)newLinks.get(1);
        LinkRestTest.assertEquals((int)newLink1.getOrder(), (int)savedLink1.getOrder());
        LinkRestTest.assertEquals((Object)newLink1.getName(), (Object)savedLink1.getName());
        LinkRestTest.assertEquals((Object)newLink1.getDescription(), (Object)savedLink1.getDescription());
        LinkRestTest.assertEquals((String)newLink1.getUrl(), (String)savedLink1.getUrl());
        LinkRestTest.assertEquals((boolean)newLink1.isSameTab(), (boolean)savedLink1.isSameTab());
        LinkRestEntity savedLink2 = (LinkRestEntity)links.get(1);
        LinkRestTest.assertNotNull((Object)savedLink2);
        LinkRestTest.assertTrue((savedLink2.getId() > 0L ? 1 : 0) != 0);
        LinkRestTest.assertTrue((savedLink2.getIconFileId() > 0L ? 1 : 0) != 0);
        LinkRestTest.assertNotNull((Object)savedLink2.getIconUrl());
        LinkRestEntity newLink2 = (LinkRestEntity)newLinks.get(0);
        LinkRestTest.assertEquals((int)newLink2.getOrder(), (int)savedLink2.getOrder());
        LinkRestTest.assertEquals((Object)newLink2.getName(), (Object)savedLink2.getName());
        LinkRestTest.assertEquals((Object)newLink2.getDescription(), (Object)savedLink2.getDescription());
        LinkRestTest.assertEquals((String)newLink2.getUrl(), (String)savedLink2.getUrl());
        LinkRestTest.assertEquals((boolean)newLink2.isSameTab(), (boolean)savedLink2.isSameTab());
        response = this.getLinkWithLang("fr");
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        linkSettingRestEntity = (LinkSettingRestEntity)response.getEntity();
        LinkRestTest.assertEquals(Collections.singletonMap("fr", (String)newLinkSettingRestEntity.getHeader().get("fr")), (Object)linkSettingRestEntity.getHeader());
        links = linkSettingRestEntity.getLinks();
        savedLink1 = (LinkRestEntity)links.get(0);
        LinkRestTest.assertEquals(Collections.singletonMap("fr", (String)newLink1.getName().get("fr")), (Object)savedLink1.getName());
        LinkRestTest.assertEquals(Collections.singletonMap("fr", (String)newLink1.getDescription().get("fr")), (Object)savedLink1.getDescription());
        savedLink2 = (LinkRestEntity)links.get(1);
        LinkRestTest.assertEquals(Collections.singletonMap("fr", (String)newLink2.getName().get("fr")), (Object)savedLink2.getName());
        LinkRestTest.assertEquals(Collections.singletonMap("fr", (String)newLink2.getDescription().get("fr")), (Object)savedLink2.getDescription());
    }

    @Test
    public void testGetLinkIconStream() {
        String pageName = "testGetLinkResponseEntity";
        LinkSetting linkSetting = this.initLinkSetting(LINK_SETTING_NAME, pageName, true);
        LinkRestTest.assertNotNull((Object)linkSetting);
        this.registerAdministratorUser(USERNAME);
        ContainerResponse response = this.saveLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        this.registerAnonymousUser();
        response = this.getLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        LinkSettingRestEntity linkSettingRestEntity = (LinkSettingRestEntity)response.getEntity();
        List links = linkSettingRestEntity.getLinks();
        LinkRestTest.assertNotNull((Object)links);
        LinkRestTest.assertEquals((int)2, (int)links.size());
        LinkRestEntity link = (LinkRestEntity)links.get(1);
        LinkRestTest.assertNotNull((Object)link);
        LinkRestTest.assertNotNull((Object)link.getIconUrl());
        response = this.getByUrl(link.getIconUrl());
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        InputStream inputStream = (InputStream)response.getEntity();
        LinkRestTest.assertNotNull((Object)inputStream);
        String eTagValue = this.getETagValue(response);
        response = this.getByUrlWithETag(link.getIconUrl(), eTagValue);
        LinkRestTest.assertEquals((int)304, (int)response.getStatus());
        this.registerAdministratorUser(USERNAME);
        response = this.saveLink();
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
        linkSettingRestEntity = (LinkSettingRestEntity)response.getEntity();
        link = (LinkRestEntity)linkSettingRestEntity.getLinks().get(1);
        this.registerAnonymousUser();
        response = this.getByUrlWithETag(link.getIconUrl(), eTagValue);
        LinkRestTest.assertEquals((int)200, (int)response.getStatus());
    }

    private String getUrl() {
        return "/social/links/linkSettingName";
    }

    private ContainerResponse getLink() {
        try {
            return this.getResponse("GET", this.getUrl(), null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ContainerResponse getByUrl(String url) {
        try {
            return this.getResponse("GET", url, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ContainerResponse getLinkWithETag(String eTagValue) {
        try {
            MultivaluedMapImpl h = new MultivaluedMapImpl();
            h.putSingle((Object)"If-None-Match", (Object)eTagValue);
            return this.service("GET", this.getUrl(), "", (MultivaluedMap<String, String>)h, new byte[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ContainerResponse getByUrlWithETag(String url, String eTagValue) {
        try {
            MultivaluedMapImpl h = new MultivaluedMapImpl();
            h.putSingle((Object)"If-None-Match", (Object)eTagValue);
            return this.service("GET", url, "", (MultivaluedMap<String, String>)h, new byte[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ContainerResponse getLinkWithLang(String lang) {
        try {
            return this.getResponse("GET", this.getUrl() + "?lang=" + lang, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String getETagValue(ContainerResponse responseWithEtag) {
        List eTag = (List)responseWithEtag.getHttpHeaders().get((Object)"Etag");
        LinkRestTest.assertNotNull((Object)eTag);
        LinkRestTest.assertEquals((int)1, (int)eTag.size());
        return eTag.get(0).toString();
    }

    private ContainerResponse saveLink() {
        try {
            LinkSettingRestEntity linkSettingEntity = this.newLinkSettingRestEntity();
            return this.getResponse("PUT", this.getUrl(), this.toJsonString(linkSettingEntity));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private LinkSettingRestEntity newLinkSettingRestEntity() throws Exception {
        HashMap<String, String> linkNames = new HashMap<String, String>();
        linkNames.put("en", "Name-en");
        linkNames.put("fr", "Name-fr");
        HashMap<String, String> linkDescriptions = new HashMap<String, String>();
        linkDescriptions.put("en", "Description-en");
        linkDescriptions.put("fr", "Description-fr");
        ArrayList<LinkRestEntity> links = new ArrayList<LinkRestEntity>();
        links.add(new LinkRestEntity(0L, linkNames, linkDescriptions, "url1", true, 2, null, 0L, UPLOAD_ID));
        this.uploadResource();
        links.add(new LinkRestEntity(0L, linkNames, linkDescriptions, "url2", false, 1, null, 0L, null));
        HashMap<String, String> linkHeaders = new HashMap<String, String>();
        linkHeaders.put("en", "Header-en");
        linkHeaders.put("fr", "Header-fr");
        return new LinkSettingRestEntity(0L, LINK_SETTING_NAME, linkHeaders, LinkDisplayType.CARD, true, true, true, "#SeeMore", links);
    }

    private LinkSetting initLinkSetting(String linkSettingName, String pageName, boolean anonymous) {
        String pageId = this.createPage(pageName, anonymous ? "Everyone" : USERS_GROUP, ADMINISTRATORS_GROUP);
        return this.linkService.initLinkSetting(linkSettingName, pageId, 0L);
    }

    private String createPage(String pageName, String accessPermission, String editPermission) {
        String siteType = "portal";
        String siteName = "test";
        if (this.layoutService.getPortalConfig(siteName) == null) {
            PortalConfig portal = new PortalConfig();
            portal.setType(siteType);
            portal.setName(siteName);
            portal.setLocale("en");
            portal.setLabel("Test");
            portal.setDescription("Test");
            portal.setAccessPermissions(new String[]{"Everyone"});
            this.layoutService.create(portal);
        }
        PageKey pageKey = new PageKey(siteType, siteName, pageName);
        PageState pageState = new PageState(pageName, null, false, null, Collections.singletonList(accessPermission), editPermission);
        this.layoutService.save(new PageContext(pageKey, pageState));
        return pageKey.format();
    }

    private void uploadResource() throws Exception {
        File tempFile = File.createTempFile("image", "temp");
        this.uploadService.createUploadResource(UPLOAD_ID, tempFile.getPath(), FILE_NAME, MIME_TYPE);
    }

    private void registerAnonymousUser() {
        this.resetRestUtils();
    }

    private Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Arrays.asList(MembershipEntry.parse((String)ADMINISTRATORS_GROUP), MembershipEntry.parse((String)USERS_GROUP)));
        this.identityRegistry.register(identity);
        ConversationState.setCurrent((ConversationState)new ConversationState(identity));
        this.resetRestUtils();
        REST_UTILS.when(RestUtils::getCurrentUser).thenReturn((Object)USERNAME);
        REST_UTILS.when(RestUtils::getCurrentUserAclIdentity).thenReturn((Object)identity);
        return identity;
    }

    private Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(MembershipEntry.parse((String)USERS_GROUP)));
        this.identityRegistry.register(identity);
        ConversationState.setCurrent((ConversationState)new ConversationState(identity));
        this.resetRestUtils();
        REST_UTILS.when(RestUtils::getCurrentUser).thenReturn((Object)USERNAME);
        REST_UTILS.when(RestUtils::getCurrentUserAclIdentity).thenReturn((Object)identity);
        return identity;
    }

    private void resetRestUtils() {
        REST_UTILS.reset();
        REST_UTILS.when(RestUtils::getBaseRestUrl).thenReturn((Object)"");
    }
}

