/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.navigation.rest;

import io.meeds.social.navigation.constant.SidebarMode;
import io.meeds.social.navigation.model.NavigationConfiguration;
import io.meeds.social.navigation.model.SidebarConfiguration;
import io.meeds.social.navigation.model.TopbarConfiguration;
import io.meeds.social.navigation.service.NavigationConfigurationService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/navigation/settings"})
@Tag(name="/social/rest/navigation/settings", description="Managing Topbar and Sidebar Navigation Configuration")
public class NavigationConfigurationRest {
    @Autowired
    private NavigationConfigurationService navigationConfigurationService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieve Topbar and Sidebar settings", method="GET", description="This retrieves the complete configuration of Topbar and Sidebar")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public NavigationConfiguration getNavigationConfiguration(HttpServletRequest request) {
        return this.navigationConfigurationService.getConfiguration(request.getRemoteUser(), request.getLocale(), true);
    }

    @GetMapping(value={"/topbar"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve Topbar settings", method="GET", description="This retrieves the configuration of Topbar switch user roles")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public TopbarConfiguration getTopbarConfiguration(HttpServletRequest request) {
        return this.navigationConfigurationService.getTopbarConfiguration(request.getRemoteUser(), request.getLocale());
    }

    @GetMapping(value={"/sidebar"})
    @Operation(summary="Retrieve Sidebar settings", method="GET", description="This retrieves the configuration of Sidebar switch user roles")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public SidebarConfiguration getSidebarConfiguration(HttpServletRequest request) {
        return this.navigationConfigurationService.getSidebarConfiguration(request.getRemoteUser(), request.getLocale());
    }

    @PutMapping(path={"/sidebar/mode"}, consumes={"application/x-www-form-urlencoded"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve Sidebar settings", method="GET", description="This retrieves the configuration of Sidebar switch user roles")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public void updateSidebarUserMode(HttpServletRequest request, @Parameter(description="User preferred Sidebar Mode") @RequestParam(value="mode") SidebarMode mode) {
        this.navigationConfigurationService.updateSidebarUserMode(request.getRemoteUser(), mode);
    }

    @PutMapping(consumes={"application/json"})
    @Secured(value={"administrators"})
    @Operation(summary="Updates Topbar and Sidebar settings", method="PUT", description="This updates the Topbar and Sidebar Menu settings")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled")})
    public void updateNavigationConfiguration(HttpServletRequest request, @RequestBody NavigationConfiguration navigationConfiguration) {
        this.navigationConfigurationService.updateConfiguration(navigationConfiguration);
    }
}

