/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.rest;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryFilter;
import io.meeds.social.category.model.CategorySearchFilter;
import io.meeds.social.category.model.CategoryTree;
import io.meeds.social.category.rest.CategoryRest;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.space.service.SpaceDirectoryService;
import io.meeds.social.util.JsonUtils;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={CategoryRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@RunWith(value=SpringRunner.class)
public class CategoryRestTest {
    private static final String CAN_EDIT_CATEGORY_PATH = "/categories/canEdit/5";
    private static final String CAN_LINK_CATEGORY_PATH = "/categories/canLink/1";
    private static final String CATEGORIES_PATH = "/categories";
    private static final String DELETE_CATEGORY_PATH = "/categories/1";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private CategoryService categoryService;
    @MockBean
    private SpaceDirectoryService spaceDirectoryService;
    private MockMvc mockMvc;

    @Before
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void getCategoryTree() throws Exception {
        CategoryTree categoryTree = (CategoryTree)Mockito.mock(CategoryTree.class);
        Mockito.when((Object)this.categoryService.getCategoryTree((CategoryFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any())).thenReturn((Object)categoryTree);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/categories?ownerId=1&parentId=2&depth=3&offset=4&limit=5", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).getCategoryTree(new CategoryFilter(1L, 2L, 3L, 4L, 5L, false, true), SIMPLE_USER, Locale.ENGLISH);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/categories?ownerId=1&parentId=2&depth=3&offset=4&limit=5", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void findCategories() throws Exception {
        Mockito.when((Object)this.categoryService.findCategories((CategorySearchFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/categories/search?query=query&ownerId=1&parentId=2&offset=3&limit=4&linkPermission=true&sortByName=true", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).findCategories(new CategorySearchFilter("query", 1L, 2L, 3L, 4L, true, true), SIMPLE_USER, Locale.ENGLISH);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/categories/search?query=query&ownerId=1&parentId=2&offset=3&limit=4&linkPermission=true&sortByName=true", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void canEditIsTrue() throws Exception {
        Mockito.when((Object)this.categoryService.canEdit(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenReturn((Object)true);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)CAN_EDIT_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void canEditIsFalse() throws Exception {
        Mockito.when((Object)this.categoryService.canEdit(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenReturn((Object)false);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)CAN_EDIT_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void canLinkIsTrue() throws Exception {
        Mockito.when((Object)this.categoryService.canManageLink(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenReturn((Object)true);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)CAN_LINK_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    public void canLinkIsFalse() throws Exception {
        Mockito.when((Object)this.categoryService.canManageLink(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenReturn((Object)false);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)CAN_LINK_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string("false"));
    }

    @Test
    public void createCategory() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.createCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenReturn((Object)category);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).createCategory(category, SIMPLE_USER);
    }

    @Test
    public void createCategoryThrowsIllegalArgumentException() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.createCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(IllegalArgumentException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).createCategory(category, SIMPLE_USER);
    }

    @Test
    public void createCategoryThrowsObjectNotFoundException() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.createCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).createCategory(category, SIMPLE_USER);
    }

    @Test
    public void createCategoryThrowsIllegalAccessException() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.createCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).createCategory(category, SIMPLE_USER);
    }

    @Test
    public void createCategoryThrowsObjectAlreadyExistsException() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.createCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(ObjectAlreadyExistsException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)CATEGORIES_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isConflict());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).createCategory(category, SIMPLE_USER);
    }

    @Test
    public void updateCategory() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.updateCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenReturn((Object)category);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).updateCategory(category, SIMPLE_USER);
    }

    @Test
    public void updateCategoryThrowsIllegalArgumentException() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.updateCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(IllegalArgumentException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).updateCategory(category, SIMPLE_USER);
    }

    @Test
    public void updateCategoryThrowsObjectNotFoundException() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.updateCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).updateCategory(category, SIMPLE_USER);
    }

    @Test
    public void updateCategoryThrowsIllegalAccessException() throws Exception {
        Category category = new Category();
        Mockito.when((Object)this.categoryService.updateCategory((Category)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)category)).contentType(MediaType.APPLICATION_JSON).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).updateCategory(category, SIMPLE_USER);
    }

    @Test
    public void deleteCategory() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).deleteCategory(1L, SIMPLE_USER);
    }

    @Test
    public void deleteCategoryThrowsIllegalArgumentException() throws Exception {
        Mockito.when((Object)this.categoryService.deleteCategory(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(IllegalArgumentException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).deleteCategory(1L, SIMPLE_USER);
    }

    @Test
    public void deleteCategoryThrowsObjectNotFoundException() throws Exception {
        Mockito.when((Object)this.categoryService.deleteCategory(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).deleteCategory(1L, SIMPLE_USER);
    }

    @Test
    public void deleteCategoryThrowsIllegalAccessException() throws Exception {
        Mockito.when((Object)this.categoryService.deleteCategory(ArgumentMatchers.anyLong(), (String)ArgumentMatchers.eq((Object)SIMPLE_USER))).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)DELETE_CATEGORY_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((CategoryService)Mockito.verify((Object)this.categoryService)).deleteCategory(1L, SIMPLE_USER);
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

