/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.relationship;

import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;
import org.exoplatform.social.rest.impl.relationship.RelationshipsRestResources;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class RelationshipsRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        this.demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        RelationshipsRestResourcesTest.assertNotNull((Object)this.rootIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)this.johnIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)this.maryIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)this.demoIdentity);
        this.addResource(RelationshipsRestResources.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(RelationshipsRestResources.class);
    }

    public void testGetRelationships() throws Exception {
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship relationship1 = this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        Relationship relationship2 = this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        Relationship relationship3 = this.relationshipManager.confirm(this.rootIdentity, this.maryIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/v1/social/relationships", "", null, null);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        List relationships = collections.getEntities();
        RelationshipsRestResourcesTest.assertEquals((int)3, (int)relationships.size());
        RelationshipsRestResourcesTest.assertTrue((boolean)relationships.stream().anyMatch(relationship -> StringUtils.equals((CharSequence)relationship1.getId(), (CharSequence)String.valueOf(relationship.get((Object)"id")))));
        RelationshipsRestResourcesTest.assertTrue((boolean)relationships.stream().anyMatch(relationship -> StringUtils.equals((CharSequence)relationship2.getId(), (CharSequence)String.valueOf(relationship.get((Object)"id")))));
        RelationshipsRestResourcesTest.assertTrue((boolean)relationships.stream().anyMatch(relationship -> StringUtils.equals((CharSequence)relationship3.getId(), (CharSequence)String.valueOf(relationship.get((Object)"id")))));
    }

    public void testCreateRelationship() throws Exception {
        this.startSessionAs("root");
        String input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        ContainerResponse response = this.getResponse("POST", "/v1/social/relationships/", input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"IGNORED\"}";
        response = this.getResponse("POST", "/v1/social/relationships/", input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"PENDING\"}";
        response = this.getResponse("POST", "/v1/social/relationships/", input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        this.startSessionAs("demo");
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"PENDING\"}";
        response = this.getResponse("POST", "/v1/social/relationships/", input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/", input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        RelationshipEntity result = this.getBaseEntity(response.getEntity(), RelationshipEntity.class);
        RelationshipsRestResourcesTest.assertEquals((String)"/portal/rest/v1/social/users/root", (String)result.getSender());
        RelationshipsRestResourcesTest.assertEquals((String)"/portal/rest/v1/social/users/demo", (String)result.getReceiver());
        RelationshipsRestResourcesTest.assertEquals((String)"CONFIRMED", (String)result.getStatus());
        Relationship relationship = this.relationshipManager.get(result.getId());
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((String)"root", (String)relationship.getSender().getRemoteId());
        RelationshipsRestResourcesTest.assertEquals((String)"demo", (String)relationship.getReceiver().getRemoteId());
        RelationshipsRestResourcesTest.assertEquals((String)"CONFIRMED", (String)relationship.getStatus().name());
    }

    public void testGetRelationshipById() throws Exception {
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship relationship = this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/v1/social/relationships/" + relationship.getId(), "", null, null);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        RelationshipEntity result = this.getBaseEntity(response.getEntity(), RelationshipEntity.class);
        RelationshipsRestResourcesTest.assertEquals((String)Relationship.Type.CONFIRMED.name(), (String)result.getStatus());
    }

    public void testDeleteRelationshipById() throws Exception {
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        Relationship relationship = this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("DELETE", "/v1/social/relationships/" + relationship.getId(), "", null, null);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testUpdateRelationshipById() throws Exception {
        Relationship relationship = this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.startSessionAs("root");
        String input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        String relationshipId = relationship.getId();
        ContainerResponse response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"IGNORED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(relationshipId);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"IGNORED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/", input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        relationshipId = relationship.getId();
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"PENDING\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        this.startSessionAs("demo");
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"PENDING\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.PENDING, (Object)relationship.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.CONFIRMED, (Object)relationship.getStatus());
        input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"IGNORED\"}";
        response = this.getResponse("PUT", "/v1/social/relationships/" + relationshipId, input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        relationship = this.relationshipManager.get(this.rootIdentity, this.demoIdentity);
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((Object)Relationship.Type.IGNORED, (Object)relationship.getStatus());
    }
}

