/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.jpa.MetadataDAO;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.exoplatform.social.rest.impl.tag.TagRest;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class TagRestTest
extends AbstractResourceTest {
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private TagService tagService;
    protected SpaceService spaceService;
    protected IdentityManager identityManager;
    private MetadataDAO metadataDAO;
    private List<Space> tearDownSpaceList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.tagService = (TagService)this.getContainer().getComponentInstanceOfType(TagService.class);
        this.metadataDAO = (MetadataDAO)this.getContainer().getComponentInstanceOfType(MetadataDAO.class);
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.tearDownSpaceList = new ArrayList<Space>();
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        TagRest tagRest = new TagRest(this.tagService);
        this.registry(tagRest);
    }

    @Override
    public void tearDown() throws Exception {
        this.restartTransaction();
        this.identityManager.hardDeleteIdentity(this.rootIdentity);
        this.identityManager.hardDeleteIdentity(this.johnIdentity);
        this.identityManager.hardDeleteIdentity(this.maryIdentity);
        this.metadataDAO.deleteAll();
        for (Space space : this.tearDownSpaceList) {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityManager.deleteIdentity(spaceIdentity);
            }
            this.spaceService.deleteSpace(space);
        }
        super.tearDown();
    }

    public void testFindTags() throws Exception {
        long maryIdentityId = Long.parseLong(this.maryIdentity.getId());
        long johnIdentityId = Long.parseLong(this.johnIdentity.getId());
        ArrayList<Space> spaces = new ArrayList<Space>();
        ArrayList<Long> spaceIdentityIds = new ArrayList<Long>();
        ArrayList<Long> spaceCreators = new ArrayList<Long>();
        Space space = this.createSpace("FindTags1", this.maryIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(maryIdentityId);
        spaceIdentityIds.add(Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId()));
        space = this.createSpace("FindTags2", this.johnIdentity.getRemoteId(), this.johnIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(johnIdentityId);
        spaceIdentityIds.add(Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId()));
        space = this.createSpace("FindTags3", this.maryIdentity.getRemoteId(), this.johnIdentity.getRemoteId(), this.maryIdentity.getRemoteId());
        spaces.add(space);
        spaceCreators.add(maryIdentityId);
        spaceIdentityIds.add(Long.parseLong(this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getId()));
        HashSet<TagName> tagNames = new HashSet<TagName>();
        tagNames.add(new TagName("tagMary1"));
        tagNames.add(new TagName("tagMary2"));
        Set savedTags = this.tagService.saveTags(new TagObject("objectType", "objectId1"), tagNames, ((Long)spaceIdentityIds.get(0)).longValue(), ((Long)spaceCreators.get(0)).longValue());
        TagRestTest.assertEquals((Object)savedTags, tagNames);
        tagNames = new HashSet();
        tagNames.add(new TagName("tagJohn1"));
        tagNames.add(new TagName("tagJohn2"));
        int limit3 = 1;
        savedTags = this.tagService.saveTags(new TagObject("objectType", "objectId1"), tagNames, ((Long)spaceIdentityIds.get(limit3)).longValue(), ((Long)spaceCreators.get(limit3)).longValue());
        TagRestTest.assertEquals((Object)savedTags, tagNames);
        tagNames = new HashSet();
        tagNames.add(new TagName("tagJohnMary1"));
        tagNames.add(new TagName("tagJohnMary2"));
        savedTags = this.tagService.saveTags(new TagObject("objectType", "objectId1"), tagNames, ((Long)spaceIdentityIds.get(2)).longValue(), ((Long)spaceCreators.get(2)).longValue());
        TagRestTest.assertEquals((Object)savedTags, tagNames);
        List<TagName> marySavedTags = this.tagService.findTags(null, maryIdentityId);
        TagRestTest.assertNotNull((Object)marySavedTags);
        TagRestTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2", "tagMary1", "tagMary2"), marySavedTags.stream().map(TagName::getName).collect(Collectors.toList()));
        String term = "mar";
        marySavedTags = this.findTags(this.maryIdentity.getRemoteId(), term, 0);
        TagRestTest.assertNotNull(marySavedTags);
        TagRestTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2", "tagMary1", "tagMary2"), marySavedTags.stream().map(TagName::getName).collect(Collectors.toList()));
        marySavedTags = this.findTags(this.maryIdentity.getRemoteId(), term, 3);
        TagRestTest.assertNotNull(marySavedTags);
        TagRestTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2", "tagMary1"), marySavedTags.stream().map(TagName::getName).collect(Collectors.toList()));
        List<TagName> johnSavedTags = this.findTags(this.johnIdentity.getRemoteId(), term, 0);
        TagRestTest.assertNotNull(johnSavedTags);
        TagRestTest.assertEquals(Arrays.asList("tagJohnMary1", "tagJohnMary2"), johnSavedTags.stream().map(TagName::getName).collect(Collectors.toList()));
        johnSavedTags = this.findTags(this.johnIdentity.getRemoteId(), term, 1);
        TagRestTest.assertNotNull(johnSavedTags);
        TagRestTest.assertEquals(Arrays.asList("tagJohnMary1"), johnSavedTags.stream().map(TagName::getName).collect(Collectors.toList()));
        johnSavedTags = this.findTags(this.johnIdentity.getRemoteId(), "joh", 10);
        TagRestTest.assertNotNull(johnSavedTags);
        TagRestTest.assertEquals(Arrays.asList("tagJohn1", "tagJohn2", "tagJohnMary1", "tagJohnMary2"), johnSavedTags.stream().map(TagName::getName).collect(Collectors.toList()));
    }

    private List<TagName> findTags(String remoteId, String term, int limit) throws Exception {
        this.startSessionAs(remoteId);
        ContainerResponse response = this.getResponse("GET", this.getURLResource("tags") + "?q=" + (term == null ? "" : term) + "&limit=" + limit, null);
        TagRestTest.assertEquals((int)200, (int)response.getStatus());
        List tagNames = (List)response.getEntity();
        return tagNames;
    }

    private Space createSpace(String spaceName, String creator, String ... members) throws Exception {
        String[] stringArray;
        Space space = new Space();
        space.setDisplayName(spaceName);
        space.setPrettyName(spaceName);
        space.setGroupId("/spaces/" + space.getPrettyName());
        space.setRegistration("open");
        space.setDescription("description of space" + spaceName);
        space.setVisibility("private");
        space.setRegistration("open");
        space.setPriority("2");
        String[] managers = new String[]{creator};
        if (members == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = creator;
        } else {
            stringArray = members;
        }
        String[] spaceMembers = stringArray;
        space.setManagers(managers);
        space.setMembers(spaceMembers);
        this.spaceService.createSpace(space);
        this.tearDownSpaceList.add(space);
        return space;
    }
}

