/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.notification;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.impl.SpaceServiceImpl;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.service.rest.IntranetNotificationRestService;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class IntranetNotificationsRestServiceTest
extends AbstractResourceTest {
    private IdentityStorage identityStorage;
    private SpaceServiceImpl spaceService;
    private RelationshipManager relationshipManager;
    private WebNotificationStorage notificationStorage;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.spaceService = (SpaceServiceImpl)this.getContainer().getComponentInstanceOfType(SpaceServiceImpl.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.notificationStorage = (WebNotificationStorage)this.getContainer().getComponentInstanceOfType(WebNotificationStorage.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        this.addResource(IntranetNotificationRestService.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        this.notificationStorage.remove(null);
        super.tearDown();
        this.removeResource(IntranetNotificationRestService.class);
    }

    public void testIgnoreInvitationToConnect() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/intranet-notification/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertNotNull((Object)response);
        IntranetNotificationsRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        Map map = (Map)response.getEntity();
        IntranetNotificationsRestServiceTest.assertFalse((boolean)((Boolean)map.get("showViewAll")));
        this.createNotif();
        response = this.service("GET", "/social/intranet-notification/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertNotNull((Object)response);
        IntranetNotificationsRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        map = (Map)response.getEntity();
        IntranetNotificationsRestServiceTest.assertTrue((boolean)((Boolean)map.get("showViewAll")));
    }

    public void testSecurityRestService() throws Exception {
        ContainerResponse response = this.service("GET", "/social/intranet-notification/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)403, (int)response.getStatus());
        this.startSessionAs("demo");
        response = this.service("GET", "/social/intranet-notification/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("root", true);
        response = this.service("GET", "/social/intranet-notification/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testShouldConfirmInvitationToConnectWhenReceiverConfirmsTheInvitation() throws Exception {
        this.end();
        this.begin();
        Relationship invitation = this.relationshipManager.inviteToConnect(this.johnIdentity, this.maryIdentity);
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", "/social/intranet-notification/confirmInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.maryIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertNotNull((Object)response);
        IntranetNotificationsRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        this.relationshipManager.delete(invitation);
    }

    public void testShouldNotConfirmInvitationToConnectWhenSenderConfirmsTheInvitation() throws Exception {
        this.end();
        this.begin();
        Relationship invitation = this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", "/social/intranet-notification/confirmInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.maryIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertNotNull((Object)response);
        IntranetNotificationsRestServiceTest.assertEquals((int)403, (int)response.getStatus());
        this.relationshipManager.delete(invitation);
    }

    public void testIgnoreInvitationToJoinSpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.end();
        this.begin();
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/intranet-notification/ignoreInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertNotNull((Object)response);
        IntranetNotificationsRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        Map map = (Map)response.getEntity();
        IntranetNotificationsRestServiceTest.assertFalse((boolean)((Boolean)map.get("showViewAll")));
        this.end();
        this.begin();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testUnauthorizedUserAcceptInvitation() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.end();
        this.begin();
        this.startSessionAs("mary");
        List<String> listInvited = Arrays.asList(space.getInvitedUsers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listInvited.contains("mary"));
        ContainerResponse response = this.service("GET", "/social/intranet-notification/acceptInvitationToJoinSpace/" + space.getId() + "/" + this.maryIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)403, (int)response.getStatus());
        this.spaceService.deleteSpace(space.getId());
    }

    public void testAuthorizedUserAcceptInvitation() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.end();
        this.begin();
        this.startSessionAs("root");
        List<String> listInvited = Arrays.asList(space.getInvitedUsers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listInvited.contains("root"));
        ContainerResponse response = this.service("GET", "/social/intranet-notification/acceptInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        listInvited = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listInvited.contains("root"));
        List<String> listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listMembers.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testUnauthorizedUserRequestValidationByManagerWithNonInvitedUser() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.end();
        this.begin();
        this.startSessionAs("john");
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listPendings.contains("mary"));
        List<String> listManager = Arrays.asList(space.getManagers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listManager.contains("john"));
        ContainerResponse response = this.service("GET", "/social/intranet-notification/validateRequestToJoinSpace/" + space.getId() + "/" + this.maryIdentity.getRemoteId() + "/" + this.johnIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)403, (int)response.getStatus());
        this.spaceService.deleteSpace(space.getId());
    }

    public void testUnauthorizedUserRequestValidationByNonManagerWithNotInvitedTargetUser() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.end();
        this.begin();
        this.startSessionAs("mary");
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listPendings.contains("mary"));
        List<String> listManager = Arrays.asList(space.getManagers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listManager.contains("mary"));
        ContainerResponse response = this.service("GET", "/social/intranet-notification/validateRequestToJoinSpace/" + space.getId() + "/" + this.maryIdentity.getRemoteId() + "/" + this.maryIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.spaceService.deleteSpace(space.getId());
    }

    public void testUnauthorizedUserRequestValidationByNonManagerWithInvitedTargetUser() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.end();
        this.begin();
        this.startSessionAs("mary");
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("root"));
        List<String> listManager = Arrays.asList(space.getManagers());
        IntranetNotificationsRestServiceTest.assertFalse((boolean)listManager.contains("mary"));
        ContainerResponse response = this.service("GET", "/social/intranet-notification/validateRequestToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.maryIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.spaceService.deleteSpace(space.getId());
    }

    public void testAuthorizedUserRequestValidationByManager() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.end();
        this.begin();
        this.startSessionAs("john");
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("root"));
        List<String> listManager = Arrays.asList(space.getManagers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listManager.contains("john"));
        ContainerResponse response = this.service("GET", "/social/intranet-notification/validateRequestToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId() + "/" + this.johnIdentity.getRemoteId() + "/" + this.createNotif() + "/message.json", "", null, null);
        IntranetNotificationsRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        List<String> listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        IntranetNotificationsRestServiceTest.assertTrue((boolean)listMembers.contains("root"));
    }

    private Space getSpaceInstance(int number) throws Exception {
        Space space = new Space();
        space.setDisplayName("my_space_" + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId("/spaces/my_space_" + number);
        String[] managers = new String[]{"john"};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{"root"};
        String[] pendingUsers = new String[]{"root"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        this.spaceService.createSpace(space, "john");
        return space;
    }

    private String createNotif() {
        NotificationInfo info = NotificationInfo.instance();
        this.notificationStorage.save(info);
        return info.getId();
    }
}

