/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.test.AbstractServiceTest;

public class RestCheckerTest
extends AbstractServiceTest {
    public void testCheckAuthenticatedRequest() {
        try {
            RestChecker.checkAuthenticatedRequest();
            RestCheckerTest.fail((String)"Expecting WebApplicationException");
        }
        catch (WebApplicationException wae) {
            RestCheckerTest.assertEquals((String)("wae.getResponse().getStatus() must return: " + Response.Status.UNAUTHORIZED.getStatusCode()), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)wae.getResponse().getStatus());
        }
        this.startSessionAs("demo");
        RestChecker.checkAuthenticatedRequest();
    }

    public void testCheckValidPortalContainerName() {
        try {
            RestChecker.checkValidPortalContainerName((String)"wrong");
            RestCheckerTest.fail((String)"Expecting WebApplicationException");
        }
        catch (WebApplicationException wae) {
            RestCheckerTest.assertEquals((String)("wae.getResponse().getStatus() must return: " + Response.Status.BAD_REQUEST.getStatusCode()), (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)wae.getResponse().getStatus());
        }
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName((String)"portal");
        RestCheckerTest.assertNotNull((String)"portalContainer must not be null", (Object)portalContainer);
    }

    public void testCheckSupportedFormat() {
        String[] supportedFormats = new String[]{"json", "xml"};
        try {
            RestChecker.checkSupportedFormat((String)"atom", (String[])supportedFormats);
            RestCheckerTest.fail((String)"Expecting WebApplicationException");
        }
        catch (WebApplicationException wae) {
            RestCheckerTest.assertEquals((String)("wae.getResponse().getStatus() must return: " + Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode()), (int)Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), (int)wae.getResponse().getStatus());
        }
        MediaType jsonMediaType = RestChecker.checkSupportedFormat((String)"json", (String[])supportedFormats);
        RestCheckerTest.assertNotNull((String)"jsonMediaType must not be null", (Object)jsonMediaType);
        RestCheckerTest.assertEquals((String)("jsonMediaType.getType() must return: " + MediaType.APPLICATION_JSON_TYPE.getType()), (String)MediaType.APPLICATION_JSON_TYPE.getType(), (String)jsonMediaType.getType());
        RestCheckerTest.assertEquals((String)("jsonMediaType.getSubtype() must return: " + MediaType.APPLICATION_JSON_TYPE.getSubtype()), (String)MediaType.APPLICATION_JSON_TYPE.getSubtype(), (String)jsonMediaType.getSubtype());
        MediaType xmlMediaType = RestChecker.checkSupportedFormat((String)"xml", (String[])supportedFormats);
        RestCheckerTest.assertNotNull((String)"xmlMediaType must not be null", (Object)xmlMediaType);
        RestCheckerTest.assertEquals((String)("xmlMediaType.getType() must return: " + MediaType.APPLICATION_XML_TYPE.getType()), (String)MediaType.APPLICATION_XML_TYPE.getType(), (String)xmlMediaType.getType());
        RestCheckerTest.assertEquals((String)("xmlMediaType.getSubtype() must return: " + MediaType.APPLICATION_XML_TYPE.getSubtype()), (String)MediaType.APPLICATION_XML_TYPE.getSubtype(), (String)xmlMediaType.getSubtype());
    }
}

