/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.space.template.rest;

import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.model.SpaceTemplateFilter;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/space/templates"})
@Tag(name="/social/rest/space/templates", description="Managing space templates")
public class SpaceTemplateRest {
    @Autowired
    private SpaceTemplateService spaceTemplateService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieve space templates", method="GET", description="This retrieves space templates")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<SpaceTemplate> getSpaceTemplates(HttpServletRequest request, Pageable pageable, @Parameter(description="Whether include disabled templates or not") @RequestParam(value="includeDisabled") boolean includeDisabled) {
        SpaceTemplateFilter spaceTemplateFilter = new SpaceTemplateFilter(request.getRemoteUser(), request.getLocale(), includeDisabled);
        return this.spaceTemplateService.getSpaceTemplates(spaceTemplateFilter, pageable, true);
    }

    @GetMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve a Space template designated by its id", method="GET", description="This will retrieve a Space template designated by its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public SpaceTemplate getSpaceTemplate(HttpServletRequest request, @Parameter(description="Space template identifier") @PathVariable(value="id") long id) {
        try {
            SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplate(id, request.getRemoteUser(), request.getLocale(), true);
            if (spaceTemplate == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            return spaceTemplate;
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @GetMapping(value={"{id}/canCreateSpace"})
    @Secured(value={"users"})
    @Operation(summary="Check if the current user can create a space with this template", method="GET", description="Returns whether the currently authenticated user is allowed to create a space using the given template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Permission check successful"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="404", description="Template not found")})
    public ResponseEntity<Map<String, Boolean>> canCreateSpaceWithTemplate(HttpServletRequest request, @Parameter(description="Space template identifier") @PathVariable(value="id") long id) {
        try {
            String username = request.getRemoteUser();
            SpaceTemplate template = this.spaceTemplateService.getSpaceTemplate(id);
            if (template == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            boolean canCreate = this.spaceTemplateService.canCreateSpace(id, username);
            return ResponseEntity.ok(Collections.singletonMap("canCreate", canCreate));
        }
        catch (Exception e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a Space template", method="POST", description="This creates a new Space template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Referenced Layout Not found")})
    public SpaceTemplate createSpaceTemplate(HttpServletRequest request, @RequestBody SpaceTemplate spaceTemplate) {
        try {
            spaceTemplate = this.spaceTemplateService.createSpaceTemplate(spaceTemplate, request.getRemoteUser());
            return this.getSpaceTemplate(request, spaceTemplate.getId());
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PutMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Update a Space template", method="PUT", description="This updates an existing Space template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void updateSpaceTemplate(HttpServletRequest request, @Parameter(description="Space template identifier") @PathVariable(value="id") long id, @RequestBody SpaceTemplate spaceTemplate) {
        try {
            spaceTemplate.setId(id);
            this.spaceTemplateService.updateSpaceTemplate(spaceTemplate, request.getRemoteUser());
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @DeleteMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Deletes a Space template", method="DELETE", description="This deletes an existing Space template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void deleteSpaceTemplate(HttpServletRequest request, @Parameter(description="Space template identifier") @PathVariable(value="id") long id) {
        try {
            this.spaceTemplateService.deleteSpaceTemplate(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

