/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.websocket.listener;

import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.websocket.ActivityStreamWebSocketService;
import org.exoplatform.social.websocket.entity.ActivityStreamModification;

public class ActivityStreamUpdateBroadcast
extends ActivityListenerPlugin {
    private ActivityStreamWebSocketService activityStreamWebSocketService;
    private ActivityManager activityManager;
    private SpaceService spaceService;

    public ActivityStreamUpdateBroadcast(ActivityStreamWebSocketService activityStreamWebSocketService, ActivityManager activityManager, SpaceService spaceService) {
        this.activityStreamWebSocketService = activityStreamWebSocketService;
        this.activityManager = activityManager;
        this.spaceService = spaceService;
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "createActivity", this.getSpaceId(event));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "updateActivity", this.getSpaceId(event));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void pinActivity(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "pinActivity", this.getSpaceId(event));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void deleteActivity(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "deleteActivity", this.getSpaceId(event));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        String commentId = this.getCommentId(event);
        String parentCommentId = this.getParentCommentId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, commentId, parentCommentId, "createComment", this.getSpaceId(activityId));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void deleteComment(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        String commentId = this.getCommentId(event);
        String parentCommentId = this.getParentCommentId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, commentId, parentCommentId, "deleteComment", this.getSpaceId(activityId));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        String commentId = this.getCommentId(event);
        String parentCommentId = this.getParentCommentId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, commentId, parentCommentId, "updateComment", this.getSpaceId(activityId));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "likeActivity", this.getSpaceId(event));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        if (event.getActivity() == null || event.getActivity().isHidden()) {
            return;
        }
        String activityId = this.getActivityId(event);
        String commentId = this.getCommentId(event);
        String parentCommentId = this.getParentCommentId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, commentId, parentCommentId, "likeComment", this.getSpaceId(activityId));
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    private String getActivityId(ActivityLifeCycleEvent event) {
        return event.getActivity().isComment() ? event.getActivity().getParentId() : event.getActivity().getId();
    }

    private String getSpaceId(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = event.getActivity();
        return this.getSpaceId(activity);
    }

    private String getSpaceId(String activityId) {
        return this.getSpaceId(this.activityManager.getActivity(activityId));
    }

    private String getSpaceId(ExoSocialActivity activity) {
        Space space;
        if (activity != null && activity.getActivityStream().getType() == ActivityStream.Type.SPACE && (space = this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId())) != null) {
            return space.getId();
        }
        return null;
    }

    private String getCommentId(ActivityLifeCycleEvent event) {
        return event.getActivity().getParentId() == null ? null : event.getActivity().getId();
    }

    private String getParentCommentId(ActivityLifeCycleEvent event) {
        return event.getActivity().getParentCommentId();
    }
}

