/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.filter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.Filter;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.impl.ApplicationContextImpl;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;

@Filter
@Path(value="v1/social/{x:.*}")
public class SocialResponseFilter
implements ResponseFilter {
    private static final String FIELDS_QUERY_PARAM = "fields";
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String DOUBLE_QUOTE = "^\"|\"$";
    private static final Log LOG = ExoLogger.getExoLogger(SocialResponseFilter.class);
    private static final String JSONP = "jsonp";

    public void doFilter(GenericContainerResponse response) {
        String callbackFunction;
        boolean hasOutputFieldsFilter;
        Object entity = response.getEntity();
        if (entity == null) {
            return;
        }
        int status = response.getStatus();
        ApplicationContext acx = ApplicationContextImpl.getCurrent();
        Response.ResponseBuilder responseBuilder = Response.fromResponse((Response)response.getResponse());
        MultivaluedMap reqHeaders = acx.getContainerRequest().getRequestHeaders();
        List ifModifiedSince = (List)reqHeaders.get((Object)"If-Modified-Since");
        List ifNoneMatch = (List)reqHeaders.get((Object)"If-None-Match");
        String etag = acx.getProperty("ETag");
        String updateDate = acx.getProperty("updateDate");
        Date ifModifiedSinceDate = null;
        if (updateDate != null) {
            long lastModified = Long.parseLong(updateDate);
            SimpleDateFormat df = new SimpleDateFormat(PATTERN_RFC1123);
            try {
                if (ifModifiedSince != null && lastModified == (ifModifiedSinceDate = df.parse((String)ifModifiedSince.get(0))).getTime()) {
                    status = Response.Status.NOT_MODIFIED.getStatusCode();
                }
            }
            catch (ParseException e) {
                LOG.debug((Object)("Could not parse date time input: " + e.getMessage()));
            }
            responseBuilder.lastModified(new Date(lastModified));
        } else if (etag != null) {
            String inmVal;
            if (ifNoneMatch != null && (inmVal = ((String)ifNoneMatch.get(0)).replaceAll(DOUBLE_QUOTE, "")).equals(etag)) {
                status = Response.Status.NOT_MODIFIED.getStatusCode();
            }
            responseBuilder.tag(new EntityTag(etag));
        }
        String outputFields = (String)ApplicationContextImpl.getCurrent().getQueryParameters().getFirst((Object)FIELDS_QUERY_PARAM);
        boolean bl = hasOutputFieldsFilter = outputFields != null && outputFields.length() > 0;
        if (hasOutputFieldsFilter) {
            entity = this.filterProperties(response.getEntity(), outputFields);
        }
        if ((callbackFunction = this.getQueryParam(JSONP)) != null) {
            StringBuffer theStringBuffer = new StringBuffer();
            theStringBuffer.append(callbackFunction);
            theStringBuffer.append("(");
            String theResponseString = this.serializeToJson(entity);
            theStringBuffer.append(theResponseString);
            theStringBuffer.append(")");
            responseBuilder.entity((Object)theStringBuffer.toString());
            responseBuilder.type("text/javascript");
        } else {
            responseBuilder.entity(entity);
        }
        if (response.getHttpHeaders() != null && !response.getHttpHeaders().containsKey((Object)"cache-control")) {
            CacheControl cc = new CacheControl();
            cc.setMaxAge(86400);
            cc.setPrivate(true);
            cc.setNoCache(false);
            response.setResponse(responseBuilder.cacheControl(cc).status(status).build());
        } else {
            response.setResponse(responseBuilder.status(status).build());
        }
    }

    private String serializeToJson(Object entity) {
        return entity.toString();
    }

    private Object filterProperties(Object entity, String outputFields) {
        ArrayList<String> returnedProperties = new ArrayList<String>();
        returnedProperties.addAll(Arrays.asList(outputFields.split(",")));
        if (entity instanceof CollectionEntity) {
            return ((CollectionEntity)entity).extractInfo(returnedProperties);
        }
        if (entity instanceof DataEntity) {
            return RestUtils.extractInfo((DataEntity)entity, returnedProperties);
        }
        return new Object();
    }

    private String getQueryParam(String queryParamName) {
        ApplicationContext acx = ApplicationContextImpl.getCurrent();
        return (String)acx.getQueryParameters().getFirst((Object)queryParamName);
    }
}

