/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.databind.rest;

import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.rest.model.DatabindRestEntity;
import io.meeds.social.databind.service.DatabindService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/databind"})
@Tag(name="/social/rest/databind", description="Export & Import Objects")
public class DatabindRest {
    @Autowired
    private DatabindService databindService;

    @GetMapping(value={"serialize"})
    @Secured(value={"administrators"})
    @Operation(summary="Export objects by object type and object id", method="GET", description="Export objects by object type and object id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public ResponseEntity<InputStreamResource> serialize(HttpServletRequest request, @Parameter(description="Object Type.") @RequestParam(name="objectType") String objectType, @Parameter(description="Object Ids") @RequestParam(name="objectId") List<String> objectIds) throws IOException {
        try {
            File zipFile = this.databindService.serialize(objectType, objectIds, request.getRemoteUser());
            InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(zipFile));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{String.format("attachment; filename=%s.zip", objectType)})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PostMapping(value={"deserialize"})
    @Secured(value={"administrators"})
    @Operation(summary="Import Multiple Objects", method="POST", description="Imports multiple objects from a ZIP file")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Bad Request")})
    public CompletableFuture<ResponseEntity<DatabindReport>> deserialize(HttpServletRequest request, @RequestBody DatabindRestEntity databindRestEntity) {
        try {
            return this.databindService.deserialize(databindRestEntity.getObjectType(), databindRestEntity.getUploadId(), databindRestEntity.getParams(), request.getRemoteUser()).thenApply(ResponseEntity::ok);
        }
        catch (IllegalStateException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }
}

