/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.security.rest;

import io.meeds.portal.security.service.SecuritySettingService;
import io.meeds.social.security.rest.LoginRest;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Locale;
import nl.captcha.Captcha;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.register.RegisterUIParamsExtension;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={LoginRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@RunWith(value=SpringRunner.class)
public class LoginRestTest {
    private MockMvc mockMvc;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private PasswordRecoveryService passwordRecoveryService;
    @MockBean
    private OrganizationService organizationService;
    @MockBean
    private UserDAOImpl userHandler;
    @MockBean
    private RegisterUIParamsExtension registerUIParamsExtension;
    @MockBean
    private SecuritySettingService securitySettingService;
    @MockBean
    private RemindPasswordTokenService remindPasswordTokenService;
    @MockBean
    private Captcha captcha;

    @Before
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void testVerifyWorkingToken() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/login/verify?token=123456789", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("username", (Object)"john").toString()));
    }

    @Test
    public void testVerifyNotWorkingToken() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/login/verifyToken?token=123456789", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testRequestResetPasswordSuccess() {
        UserImpl user = new UserImpl("john");
        user.setUserName("john");
        user.setEnabled(Boolean.valueOf(true));
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)user);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any())).thenReturn((Object)true);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestResetPassword", (Object[])new Object[0]).content("username=john").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("success", (Object)"gatein.forgotPassword.emailSendSuccessful").toString()));
    }

    @Test
    public void testRequestResetPasswordEmptyUsername() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestResetPassword", (Object[])new Object[0]).content("username=").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.emptyUserOrEmail").toString()));
    }

    @Test
    public void testRequestResetPasswordProblemSendingEmail() {
        UserImpl user = new UserImpl("john");
        user.setUserName("john");
        user.setEnabled(Boolean.valueOf(true));
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)user);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.sendRecoverPasswordEmail((User)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (HttpServletRequest)ArgumentMatchers.any())).thenReturn((Object)false);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestResetPassword", (Object[])new Object[0]).content("username=john").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.emailSendFailure").toString()));
    }

    @Test
    public void testResetPasswordTokenNotValid() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/resetPassword", (Object[])new Object[0]).content("username=john&password=test&password2=test&token=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testResetPasswordUsernameDifferent() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"mary");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/resetPassword", (Object[])new Object[0]).content("username=john&password=test&password2=test&token=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.usernameChanged").toString()));
    }

    @Test
    public void testResetPasswordPasswordDifferent() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/resetPassword", (Object[])new Object[0]).content("username=john&password=test1&password2=test2&token=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.confirmPasswordNotMatch").toString()));
    }

    @Test
    public void testResetPasswordNotValid() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/resetPassword", (Object[])new Object[0]).content("username=john&password=test&password2=test&token=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testResetPasswordErrorOnChange() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        Mockito.when((Object)this.passwordRecoveryService.changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)false);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/resetPassword", (Object[])new Object[0]).content("username=john&password=Test1234@&password2=Test1234@&token=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.resetPasswordFailure").toString()));
    }

    @Test
    public void testResetPasswordSuccess() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        Mockito.when((Object)this.passwordRecoveryService.changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/resetPassword", (Object[])new Object[0]).content("username=john&password=Test1234@&password2=Test1234@&token=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", "/portal/login"));
    }

    @Test
    public void testSetPasswordTokenNotValid() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/setPassword", (Object[])new Object[0]).content("username=john&password=test&password2=test&token=123456&captcha=abcde").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testSetPasswordCaptchNotValid() {
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)false);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("on-boarding", this.captcha);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/setPassword", (Object[])new Object[0]).sessionAttrs(sessionattr).content("username=john&password=test&password2=test&token=123456&captcha=abcde").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.captchaError").toString()));
    }

    @Test
    public void testSetPasswordUsernameDifferent() {
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("on-boarding", this.captcha);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"mary");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/setPassword", (Object[])new Object[0]).sessionAttrs(sessionattr).content("username=john&password=test&password2=test&token=123456&captcha=abcde").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.usernameChanged").toString()));
    }

    @Test
    public void testSetPasswordPasswordDifferent() {
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("on-boarding", this.captcha);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/setPassword", (Object[])new Object[0]).sessionAttrs(sessionattr).content("username=john&password=test1&password2=test2&token=123456&captcha=abcde").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.confirmPasswordNotMatch").toString()));
    }

    @Test
    public void testSetPasswordNotValid() {
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("on-boarding", this.captcha);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/setPassword", (Object[])new Object[0]).sessionAttrs(sessionattr).content("username=john&password=test&password2=test&token=123456&captcha=abcde").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testSetPasswordErrorOnChange() {
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("on-boarding", this.captcha);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        Mockito.when((Object)this.passwordRecoveryService.changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)false);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/setPassword", (Object[])new Object[0]).sessionAttrs(sessionattr).content("username=john&password=Test1234@&password2=Test1234@&token=123456&captcha=abcde").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.resetPasswordFailure").toString()));
    }

    @Test
    public void testSetPasswordSuccess() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        Mockito.when((Object)this.passwordRecoveryService.changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("on-boarding", this.captcha);
        UserImpl user = new UserImpl("john");
        user.setUserName("john");
        user.setEnabled(Boolean.valueOf(true));
        user.setEmail("jsmith@acme.com");
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)user);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/setPassword", (Object[])new Object[0]).sessionAttrs(sessionattr).content("username=john&password=Test1234@&password2=Test1234@&token=123456&captcha=abcde").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", "/portal/login"));
    }

    @Test
    public void testServeCaptcha() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/login/captcha?name=register", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.header().string("Content-Type", "image/png"));
    }

    @Test
    public void testRequestRegisterAlreadyConnected() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestRegister", (Object[])new Object[0]).content("email=john@acme.com&captcha=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", "/portal"));
    }

    @Test
    public void testRequestRegisterWithRegisterDisabled() {
        Mockito.when((Object)this.registerUIParamsExtension.isRegisterEnabled()).thenReturn((Object)false);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestRegister", (Object[])new Object[0]).content("email=john@acme.com&captcha=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    public void testRequestRegisterWithNotValidCaptcha() {
        Mockito.when((Object)this.registerUIParamsExtension.isRegisterEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)false);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("register", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestRegister", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=john&captcha=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.captchaError").toString()));
    }

    @Test
    public void testRequestRegisterWithNotValidEmail() {
        Mockito.when((Object)this.registerUIParamsExtension.isRegisterEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("register", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestRegister", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=john&captcha=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testRequestRegisterWithExistingEmail() {
        Mockito.when((Object)this.registerUIParamsExtension.isRegisterEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        ListAccess<User> users = new ListAccess<User>(this){

            public User[] load(int i, int i1) throws Exception, IllegalArgumentException {
                return null;
            }

            public int getSize() throws Exception {
                return 1;
            }
        };
        Mockito.when((Object)this.userHandler.findUsersByQuery((Query)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)users);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("register", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestRegister", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=john@acme.com&captcha=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("success", (Object)"onboardingEmailSent").toString()));
    }

    @Test
    public void testRequestRegisterSuccessSendOnboardingEmail() {
        Mockito.when((Object)this.registerUIParamsExtension.isRegisterEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.passwordRecoveryService.sendExternalRegisterEmail((String)ArgumentMatchers.eq(null), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.eq(null), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)"ok");
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        ListAccess<User> users = new ListAccess<User>(this){

            public User[] load(int i, int i1) throws Exception, IllegalArgumentException {
                return null;
            }

            public int getSize() throws Exception {
                return 0;
            }
        };
        Mockito.when((Object)this.userHandler.findUsersByQuery((Query)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)users);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("register", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestRegister", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=john@acme.com&captcha=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("success", (Object)"onboardingEmailSent").toString()));
    }

    @Test
    public void testRequestRegisterFailedSendOnboardingEmail() {
        Mockito.when((Object)this.registerUIParamsExtension.isRegisterEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.passwordRecoveryService.sendExternalRegisterEmail((String)ArgumentMatchers.eq(null), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.eq(null), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new Exception("Error")});
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        ListAccess<User> users = new ListAccess<User>(this){

            public User[] load(int i, int i1) throws Exception, IllegalArgumentException {
                return null;
            }

            public int getSize() throws Exception {
                return 0;
            }
        };
        Mockito.when((Object)this.userHandler.findUsersByQuery((Query)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)users);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("register", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/requestRegister", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=john@acme.com&captcha=123456").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.emailSendFailure").toString()));
    }

    @Test
    public void testFinishRegistrationTokenNotValid() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/finishRegistration", (Object[])new Object[0]).content("token=123456798&tokenType=email-validation").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testFinishRegistrationTokenSuccess() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john::John::Smith::jsmith@acme.com::Password1234");
        Mockito.when((Object)this.securitySettingService.isRegistrationExternalUser()).thenReturn((Object)false);
        UserImpl user = new UserImpl();
        user.setUserName("john");
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenReturn((Object)user);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/finishRegistration", (Object[])new Object[0]).content("token=123456798&tokenType=email-validation").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", "/portal/login"));
    }

    @Test
    public void testRegisterAlreadyConnected() {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/register", (Object[])new Object[0]).content("email=jsmith@acme.com&username=&password=Password1234&password2=Password1234&firstName=John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", "/portal"));
    }

    @Test
    public void testRegisterTokenNotValid() {
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/register", (Object[])new Object[0]).content("email=jsmith@acme.com&username=&password=Password1234&password2=Password1234&firstName=John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    public void testRegisterExistingUser() {
        UserImpl user = new UserImpl();
        user.setUserName("john");
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)user);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("external-registration", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/register", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=jsmith@acme.com&username=&password=Password1234&password2=Password1234&firstName=John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", "/portal"));
    }

    @Test
    public void testRegisterExistingNotValidCaptcha() {
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"jsmith@acme.com");
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)false);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("external-registration", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/register", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=jsmith@acme.com&username=&password=Password1234&password2=Password1234&firstName=John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("error", (Object)"gatein.forgotPassword.captchaError").toString()));
    }

    @Test
    public void testRegisterNotValidPassword() {
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"jsmith@acme.com");
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("external-registration", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/register", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=jsmith@acme.com&username=&password=pass&password2=pass&firstName=John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testRegisterNotFirstName() {
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"jsmith@acme.com");
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("external-registration", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/register", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=jsmith@acme.com&username=&password=Password1234&password2=Password1234&firstName=123John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    public void testRegisterSuccessAccountVerificationEmail() {
        UserImpl john = new UserImpl();
        john.setUserName("john");
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenReturn((Object)john);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"john");
        Mockito.when((Object)this.passwordRecoveryService.sendAccountVerificationEmail((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("external-registration", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/verifyEmail", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=jsmith@acme.com&username=john&password=Password1234&password2=Password1234&firstName=John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.content().string(new JSONObject().put("success", (Object)"emailVerificationSent").toString()));
    }

    @Test
    public void testRegisterSuccess() {
        UserImpl john = new UserImpl();
        john.setUserName("john");
        Mockito.when((Object)this.userHandler.findUserByName((String)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn(null);
        Mockito.when((Object)this.userHandler.createUserInstance((String)ArgumentMatchers.any())).thenReturn((Object)john);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"jsmith@acme.com");
        Mockito.when((Object)this.passwordRecoveryService.sendAccountCreatedConfirmationEmail((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.captcha.isCorrect((String)ArgumentMatchers.any())).thenReturn((Object)true);
        HashMap<String, Captcha> sessionattr = new HashMap<String, Captcha>();
        sessionattr.put("external-registration", this.captcha);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/login/register", (Object[])new Object[0]).sessionAttrs(sessionattr).content("email=jsmith@acme.com&password=Password1234&password2=Password1234&firstName=John&lastName=Smith&captcha=abcde&token=123456789").contentType("application/x-www-form-urlencoded").accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isFound()).andExpect(MockMvcResultMatchers.header().string("Location", "/portal/login"));
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)"john").password("password").authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

