/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.lifecycle;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;

public class PublicSpaceSiteLifecycle
extends BaseComponentPlugin
implements ApplicationLifecycle<PortalRequestContext> {
    private LayoutService layoutService;
    private SpaceService spaceService;
    private ResourceBundleService resourceBundleService;

    public void onInit(Application app) throws Exception {
        this.layoutService = (LayoutService)ExoContainerContext.getService(LayoutService.class);
        this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        this.resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
    }

    public void onStartRequest(Application app, PortalRequestContext context) {
        if (!(app instanceof PortalApplication)) {
            return;
        }
        SiteKey siteKey = context.getSiteKey();
        if (siteKey == null || siteKey.getType() != SiteType.PORTAL) {
            return;
        }
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null || StringUtils.isBlank((CharSequence)portalConfig.getProperty("SPACE_ID"))) {
            return;
        }
        String spaceId = portalConfig.getProperty("SPACE_ID");
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            return;
        }
        SpaceUtils.setSpaceByContext((PortalRequestContext)context, (Object)space);
        String browserTabTitle = this.resourceBundleService.getSharedString("UISpaceMenu.browser.publicSiteTitle", context.getLocale());
        context.getRequest().setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)browserTabTitle.replace("{0}", space.getDisplayName()));
    }
}

