/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class SpaceCreationPortlet
extends GenericDispatchedViewPortlet {
    private UserACL userAcl;

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (!this.canModifySettings()) {
            throw new PortletException("User is not allowed to save settings");
        }
        PortletPreferences preferences = request.getPreferences();
        String settings = request.getParameter("settings");
        preferences.setValue("settings", settings);
        preferences.store();
    }

    private Identity getCurrentIdentity() {
        return ConversationState.getCurrent() == null ? null : ConversationState.getCurrent().getIdentity();
    }

    private boolean canModifySettings() {
        Page currentPage = this.getCurrentPage();
        return currentPage != null && this.getUserAcl().hasEditPermission(currentPage, this.getCurrentIdentity());
    }

    private UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        }
        return this.userAcl;
    }

    private Page getCurrentPage() {
        PortalRequestContext requestContext = PortalRequestContext.getCurrentInstance();
        return requestContext == null ? null : requestContext.getPage();
    }
}

