/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.portlet;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;

public class ActivityStreamPortlet
extends GenericDispatchedViewPortlet {
    private static final String SETTING_NAME = "name";
    private UserACL userAcl;

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        boolean canModifySettings = this.canModifySettings();
        request.setAttribute("canEdit", (Object)canModifySettings);
        super.doView(request, response);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletPreferences preferences = request.getPreferences();
        String settingName = preferences.getValue(SETTING_NAME, "");
        response.getWriter().write(settingName);
        response.setContentType("text/plain");
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (!this.canModifySettings()) {
            throw new PortletException("User is not allowed to save settings");
        }
        PortletPreferences preferences = request.getPreferences();
        String settings = request.getParameter("settings");
        preferences.setValue("settings", settings);
        preferences.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    private boolean canModifySettings() {
        Space space = SpaceUtils.getSpaceByContext();
        Identity identity = this.getCurrentIdentity();
        if (this.getUserAcl().isAnonymousUser(identity)) {
            return false;
        }
        if (space == null) {
            Page currentPage = this.getCurrentPage();
            return currentPage != null && this.getUserAcl().hasEditPermission(currentPage, identity);
        }
        return this.getUserAcl().hasEditPermission("space", space.getId(), identity);
    }

    private Page getCurrentPage() {
        PortalRequestContext requestContext = PortalRequestContext.getCurrentInstance();
        return requestContext == null ? null : requestContext.getPage();
    }

    private Identity getCurrentIdentity() {
        return ConversationState.getCurrent() == null ? null : ConversationState.getCurrent().getIdentity();
    }

    private UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        }
        return this.userAcl;
    }
}

