/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.dto.TasksList;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.TaskServiceImpl$AjcClosure9;
import org.exoplatform.task.storage.TaskStorage;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.StorageUtil;
import org.exoplatform.task.util.TaskUtil;

@Singleton
public class TaskServiceImpl
implements TaskService {
    private static final Log LOG;
    @Inject
    private TaskStorage taskStorage;
    @Inject
    private DAOHandler daoHandler;
    private ListenerService listenerService;
    private ProjectService projectService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public TaskServiceImpl(TaskStorage taskStorage, DAOHandler daoHandler, ListenerService listenerService) {
        this.taskStorage = taskStorage;
        this.daoHandler = daoHandler;
        this.listenerService = listenerService;
        this.projectService = this.projectService;
    }

    @Override
    @ExoTransactional
    public TaskDto createTask(TaskDto task) {
        TaskDto taskDto = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskDto);
        Object[] objectArray = new Object[]{this, taskDto, joinPoint};
        TaskServiceImpl$AjcClosure1 taskServiceImpl$AjcClosure1 = new TaskServiceImpl$AjcClosure1(objectArray);
        return (TaskDto)ExoTransactionalAspect.aspectOf().around(taskServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public TaskDto updateTask(TaskDto task) {
        TaskDto taskDto = task;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskDto);
        Object[] objectArray = new Object[]{this, taskDto, joinPoint};
        TaskServiceImpl$AjcClosure3 taskServiceImpl$AjcClosure3 = new TaskServiceImpl$AjcClosure3(objectArray);
        return (TaskDto)ExoTransactionalAspect.aspectOf().around(taskServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void updateTaskOrder(long currentTaskId, Status newStatus, long[] orders) {
        long l = currentTaskId;
        Status status = newStatus;
        long[] lArray = orders;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), status, lArray};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), status, lArray, joinPoint};
        TaskServiceImpl$AjcClosure5 taskServiceImpl$AjcClosure5 = new TaskServiceImpl$AjcClosure5(objectArray2);
        ExoTransactionalAspect.aspectOf().around(taskServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeTask(long id) throws EntityNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        TaskServiceImpl$AjcClosure7 taskServiceImpl$AjcClosure7 = new TaskServiceImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(taskServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public TaskDto cloneTask(long id) throws EntityNotFoundException {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        TaskServiceImpl$AjcClosure9 taskServiceImpl$AjcClosure9 = new TaskServiceImpl$AjcClosure9(objectArray);
        return (TaskDto)ExoTransactionalAspect.aspectOf().around(taskServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @Override
    public TaskDto getTask(long id) throws EntityNotFoundException {
        TaskDto task = this.taskStorage.getTaskById(id);
        if (task == null) {
            LOG.info((Object)("Can not find task with ID: " + id));
            throw new EntityNotFoundException(id, (Class<?>)Task.class);
        }
        return task;
    }

    @Override
    public Set<String> getMentionedUsers(long taskId) {
        return this.daoHandler.getCommentHandler().findMentionedUsersOfTask(taskId);
    }

    @Override
    @ExoTransactional
    public ChangeLogEntry addTaskLog(long id, String username, String actionName, String target) throws EntityNotFoundException {
        long l = id;
        String string = username;
        String string2 = actionName;
        String string3 = target;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l), string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.longObject((long)l), string, string2, string3, joinPoint};
        TaskServiceImpl$AjcClosure11 taskServiceImpl$AjcClosure11 = new TaskServiceImpl$AjcClosure11(objectArray2);
        return (ChangeLogEntry)ExoTransactionalAspect.aspectOf().around(taskServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @Override
    public List<ChangeLogEntry> getTaskLogs(long taskId, int offset, int limit) throws Exception {
        return this.taskStorage.getTaskLogs(taskId, offset, limit);
    }

    @Override
    public List<TaskDto> findTasks(TaskQuery query, int offset, int limit) throws Exception {
        return this.taskStorage.findTasks(query, offset, limit);
    }

    @Override
    public int countTasks(TaskQuery query) throws Exception {
        return this.taskStorage.countTasks(query);
    }

    @Override
    public <T> List<T> selectTaskField(TaskQuery query, String fieldName) {
        return this.taskStorage.selectTaskField(query, fieldName);
    }

    @Override
    public List<TaskDto> findTasksByLabel(LabelDto label, List<Long> projectIds, String username, OrderBy orderBy, int offset, int limit) throws Exception {
        return this.taskStorage.findTasksByLabel(label, projectIds, username, orderBy, offset, limit);
    }

    @Override
    public int countTasksByLabel(LabelDto label, List<Long> projectIds, String username, OrderBy orderBy) throws Exception {
        return this.taskStorage.countTasksByLabel(label, projectIds, username, orderBy);
    }

    @Override
    public TaskDto findTaskByActivityId(String id) {
        return this.taskStorage.findTaskByActivityId(id);
    }

    @Override
    public Set<String> getCoworker(long taskId) {
        return this.taskStorage.getCoworker(taskId);
    }

    @Override
    public List<TaskDto> getUncompletedTasks(String user, int limit) {
        return this.taskStorage.getUncompletedTasks(user, limit);
    }

    @Override
    public Long countUncompletedTasks(String user) {
        return this.taskStorage.countUncompletedTasks(user);
    }

    @Override
    public List<TaskDto> getWatchedTasks(String user, int limit) {
        return this.taskStorage.getWatchedTasks(user, limit);
    }

    @Override
    public Long countWatchedTasks(String user) {
        return this.taskStorage.countWatchedTasks(user);
    }

    @Override
    public List<TaskDto> getAssignedTasks(String user, int limit) {
        return this.taskStorage.getAssignedTasks(user, limit);
    }

    @Override
    public Long countAssignedTasks(String user) {
        return this.taskStorage.countWatchedTasks(user);
    }

    @Override
    public List<TaskDto> getCollaboratedTasks(String user, int limit) {
        return this.taskStorage.getCollaboratedTasks(user, limit);
    }

    @Override
    public Long countCollaboratedTasks(String user) {
        return this.taskStorage.countCollaboratedTasks(user);
    }

    @Override
    public List<TaskDto> findTasksByMemberShips(String user, List<String> memberships, String query, int limit) {
        if (StringUtils.isBlank((CharSequence)user)) {
            throw new IllegalArgumentException("user parameter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new IllegalArgumentException("query parameter is mandatory");
        }
        return this.taskStorage.findTasks(user, memberships, query, limit);
    }

    @Override
    public List<TaskDto> findTasks(String user, String query, int limit) {
        return this.findTasksByMemberShips(user, new ArrayList<String>(), query, limit);
    }

    @Override
    public long countTasks(String user, String query, List<String> memberships) {
        if (StringUtils.isBlank((CharSequence)user)) {
            throw new IllegalArgumentException("user parameter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new IllegalArgumentException("query parameter is mandatory");
        }
        return this.taskStorage.countTasks(user, query, memberships);
    }

    @Override
    public List<TaskDto> getIncomingTasks(String user, int offset, int limit) throws Exception {
        return this.taskStorage.getIncomingTasks(user, offset, limit);
    }

    @Override
    public int countIncomingTasks(String user) throws Exception {
        return this.taskStorage.countIncomingTasks(user);
    }

    @Override
    public List<TaskDto> getOverdueTasks(String user, int limit) {
        return this.taskStorage.getOverdueTasks(user, limit);
    }

    @Override
    public Long countOverdueTasks(String user) {
        return this.taskStorage.countOverdueTasks(user);
    }

    @Override
    public void addWatcherToTask(String user, TaskDto task) throws Exception {
        this.taskStorage.addWatcherToTask(user, task);
    }

    @Override
    public void deleteWatcherOfTask(String user, TaskDto task) throws Exception {
        this.taskStorage.deleteWatcherOfTask(user, task);
    }

    @Override
    public Set<String> getWatchersOfTask(TaskDto task) {
        return this.taskStorage.getWatchersOfTask(task);
    }

    @Override
    public List<Object[]> countTaskStatusByProject(long projectId) {
        return this.taskStorage.countTaskStatusByProject(projectId);
    }

    @Override
    public TasksList filterTasks(String query, long projectId, String keyword, List<Long> labels, TaskUtil.DUE dueDate, Priority priority, List<String> assignees, List<String> coworker, List<String> watchers, Long labelId, Long statusId, Identity currIdentity, String dueCategory, String space_group_id, TimeZone userTimezone, boolean isShowCompleted, boolean advanceSearch, boolean noProjPermission, boolean noLblPermission, String orderBy, String groupBy, int offset, int limit) throws Exception {
        LinkedList<Long> spaceProjectIds = null;
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            List<ProjectDto> projects = ProjectUtil.flattenTree(ProjectUtil.getProjectTree(space_group_id, this.projectService, offset, limit), this.projectService, offset, limit);
            for (ProjectDto projectDto : projects) {
                if (!projectDto.canView(currIdentity)) continue;
                spaceProjectIds.add(projectDto.getId());
            }
        }
        LinkedList<Long> allProjectIds = null;
        if (projectId == 0L) {
            allProjectIds = new LinkedList<Long>();
            List<ProjectDto> projects = ProjectUtil.flattenTree(ProjectUtil.getProjectTree(null, this.projectService, offset, limit), this.projectService, offset, limit);
            for (ProjectDto p : projects) {
                if (!p.canView(currIdentity)) continue;
                allProjectIds.add(p.getId());
            }
        }
        OrderBy order = null;
        if (orderBy != null && !orderBy.trim().isEmpty()) {
            order = "title".equals(orderBy) || "dueDate".equals(orderBy) ? new OrderBy.ASC(orderBy) : new OrderBy.DESC(orderBy);
        }
        TaskQuery taskQuery = new TaskQuery();
        if (advanceSearch) {
            Status status = statusId != null ? (Status)this.daoHandler.getStatusHandler().find(statusId) : null;
            TaskUtil.buildTaskQuery(taskQuery, keyword, labels, status, dueDate, priority, assignees, coworker, watchers, isShowCompleted, userTimezone);
        } else {
            taskQuery.setKeyword(query);
            taskQuery.setCompleted(false);
        }
        if (projectId == -1L) {
            if (orderBy == null || orderBy.isEmpty()) {
                orderBy = "createdTime";
            }
            order = new OrderBy.DESC(orderBy);
            taskQuery.setIsIncomingOf(currIdentity.getUserId());
            taskQuery.setOrderBy(Arrays.asList(order));
        } else if (projectId == -2L) {
            List<String> defGroupBys = Arrays.asList("none", "project", "label", "dueDate", "assignee");
            List<String> defOrders = Arrays.asList("title", "status", "dueDate", "priority", "rank");
            if (dueDate != null || !dueCategory.equals("")) {
                taskQuery.setAssigneeIsTodoOf(currIdentity.getUserId());
            } else {
                taskQuery.setIsTodoOf(currIdentity.getUserId());
            }
            if ("overDue".equalsIgnoreCase(dueCategory)) {
                defGroupBys = Arrays.asList("none", "project", "label");
                defOrders = Arrays.asList("title", "priority", "dueDate");
                groupBy = groupBy == null || !defGroupBys.contains(groupBy) ? "project" : groupBy;
            } else if ("today".equalsIgnoreCase(dueCategory)) {
                defGroupBys = Arrays.asList("none", "project", "label");
                defOrders = Arrays.asList("title", "priority", "rank");
                if (orderBy == null) {
                    order = new OrderBy.DESC("priority");
                    orderBy = "priority";
                }
                groupBy = groupBy == null || !defGroupBys.contains(groupBy) ? "none" : groupBy;
            } else if ("tomorrow".equalsIgnoreCase(dueCategory)) {
                defGroupBys = Arrays.asList("none", "project", "label");
                defOrders = Arrays.asList("title", "priority", "rank");
                if (orderBy == null || !defOrders.contains(orderBy)) {
                    order = new OrderBy.DESC("priority");
                    orderBy = "priority";
                }
                groupBy = groupBy == null || !defGroupBys.contains(groupBy) ? "none" : groupBy;
            } else if ("upcoming".equalsIgnoreCase(dueCategory)) {
                defGroupBys = Arrays.asList("none", "project", "label");
                defOrders = Arrays.asList("title", "priority", "dueDate", "rank");
                String string = groupBy = groupBy == null || !defGroupBys.contains(groupBy) ? "none" : groupBy;
            }
            if (orderBy == null || !defOrders.contains(orderBy)) {
                orderBy = "dueDate";
                order = new OrderBy.ASC("dueDate");
            }
            if (groupBy == null || !defGroupBys.contains(groupBy)) {
                groupBy = "dueDate";
            }
            Date[] filterDate = TaskUtil.convertDueDate(dueCategory, userTimezone);
            taskQuery.setDueDateFrom(filterDate[0]);
            taskQuery.setDueDateTo(filterDate[1]);
            taskQuery.setOrderBy(Arrays.asList(order));
        } else if (projectId >= 0L) {
            if (projectId == 0L) {
                List<String> defGroupBys = Arrays.asList("none", "assignee", "project", "label", "dueDate", "status");
                if (orderBy == null || orderBy.isEmpty()) {
                    orderBy = "dueDate";
                    order = new OrderBy.ASC(orderBy);
                }
                if (spaceProjectIds != null) {
                    taskQuery.setProjectIds(spaceProjectIds);
                } else {
                    taskQuery.setProjectIds(allProjectIds);
                }
            } else {
                if (orderBy == null || orderBy.isEmpty()) {
                    orderBy = "dueDate";
                    order = new OrderBy.ASC(orderBy);
                }
                if (!noProjPermission) {
                    taskQuery.setProjectIds(Arrays.asList(projectId));
                }
            }
            taskQuery.setOrderBy(Arrays.asList(order));
        } else if (labelId != null && labelId >= 0L) {
            List<String> defOrders = Arrays.asList("title", "createdTime", "dueDate", "priority");
            if (orderBy == null || orderBy.isEmpty() || !defOrders.contains(orderBy)) {
                orderBy = "dueDate";
                order = new OrderBy.ASC("dueDate");
            }
            if (labelId > 0L) {
                List<String> defGroupBys = Arrays.asList("none", "project", "dueDate", "status");
                if (groupBy == null || groupBy.isEmpty() || !defGroupBys.contains(groupBy)) {
                    groupBy = "none";
                }
                if (!noLblPermission) {
                    taskQuery.setLabelIds(Arrays.asList(labelId));
                }
            } else {
                List<String> defGroupBys = Arrays.asList("none", "project", "label", "dueDate", "status");
                if (groupBy == null || groupBy.isEmpty() || !defGroupBys.contains(groupBy)) {
                    groupBy = "label";
                }
                taskQuery.setIsLabelOf(currIdentity.getUserId());
            }
            if (spaceProjectIds != null) {
                taskQuery.setProjectIds(spaceProjectIds);
            }
            taskQuery.setOrderBy(Arrays.asList(order));
        }
        List<TaskDto> listTasks = null;
        long tasksSize = 0L;
        if (spaceProjectIds != null && spaceProjectIds.isEmpty() || projectId == 0L && allProjectIds.isEmpty() || noLblPermission && labelId != null && labelId > 0L || noProjPermission && projectId > 0L) {
            listTasks = new ArrayList<TaskDto>();
        } else {
            listTasks = this.findTasks(taskQuery, offset, limit);
            tasksSize = this.countTasks(taskQuery);
        }
        return new TasksList(listTasks, tasksSize);
    }

    @Override
    public boolean isExternal(String userId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", userId);
        return userIdentity.getProfile() != null && userIdentity.getProfile().getProperty("external") != null && userIdentity.getProfile().getProperty("external").equals("true");
    }

    @Override
    public List<Long> getAllIds(int offset, int limit) {
        return this.taskStorage.getAllIds(offset, limit);
    }

    static {
        TaskServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(TaskServiceImpl.class);
    }

    static final /* synthetic */ TaskDto createTask_aroundBody0(TaskServiceImpl ajc$this, TaskDto task, JoinPoint joinPoint) {
        TaskDto result = ajc$this.taskStorage.createTask(task);
        TaskPayload event = new TaskPayload(null, result);
        TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.task.taskCreation", null, event);
        if (result.getStatus() != null && result.getStatus().getProject() != null) {
            TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.project.projectModified", null, result.getStatus().getProject());
        }
        return result;
    }

    static final /* synthetic */ TaskDto updateTask_aroundBody2(TaskServiceImpl ajc$this, TaskDto task, JoinPoint joinPoint) {
        if (task == null) {
            throw new IllegalArgumentException("TaskDto must not be NULL");
        }
        TaskDto oldTaskEntity = ajc$this.taskStorage.getTaskWithCoworkers(task.getId());
        TaskDto newTaskEntity = ajc$this.taskStorage.update(task);
        TaskPayload event = new TaskPayload(oldTaskEntity, newTaskEntity);
        TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.task.taskUpdate", null, event);
        if (task.getStatus() != null && task.getStatus().getProject() != null) {
            TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.project.projectModified", null, task.getStatus().getProject());
        }
        return newTaskEntity;
    }

    static final /* synthetic */ void updateTaskOrder_aroundBody4(TaskServiceImpl ajc$this, long currentTaskId, Status newStatus, long[] orders, JoinPoint joinPoint) {
        ajc$this.taskStorage.updateTaskOrder(currentTaskId, newStatus, orders);
    }

    static final /* synthetic */ void removeTask_aroundBody6(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        TaskDto task = ajc$this.getTask(id);
        ajc$this.taskStorage.delete(task);
        TaskUtil.broadcastEvent(ajc$this.listenerService, "exo.task.taskDeleted", null, new TaskPayload(null, task));
    }

    static final /* synthetic */ TaskDto cloneTask_aroundBody8(TaskServiceImpl ajc$this, long id, JoinPoint joinPoint) {
        TaskDto task = ajc$this.getTask(id);
        TaskDto newTask = task.clone();
        newTask.setId(0L);
        newTask.setCoworker(ajc$this.getCoworker(id));
        newTask.setTitle("Copy of " + newTask.getTitle());
        return ajc$this.createTask(newTask);
    }

    static final /* synthetic */ ChangeLogEntry addTaskLog_aroundBody10(TaskServiceImpl ajc$this, long id, String username, String actionName, String target, JoinPoint joinPoint) {
        ChangeLogEntry log = new ChangeLogEntry();
        log.setTask(StorageUtil.taskToEntity(ajc$this.getTask(id)));
        log.setAuthor(username);
        log.setActionName(actionName);
        log.setTarget(target);
        return ajc$this.taskStorage.addTaskLog(log);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TaskServiceImpl.java", TaskServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.dto.TaskDto", "task", "", "org.exoplatform.task.dto.TaskDto"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "org.exoplatform.task.dto.TaskDto", "task", "", "org.exoplatform.task.dto.TaskDto"), 90);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTaskOrder", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:org.exoplatform.task.domain.Status:[J", "currentTaskId:newStatus:orders", "", "void"), 106);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.EntityNotFoundException", "void"), 112);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cloneTask", "org.exoplatform.task.service.impl.TaskServiceImpl", "long", "id", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.TaskDto"), 120);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTaskLog", "org.exoplatform.task.service.impl.TaskServiceImpl", "long:java.lang.String:java.lang.String:java.lang.String", "id:username:actionName:target", "org.exoplatform.task.exception.EntityNotFoundException", "org.exoplatform.task.dto.ChangeLogEntry"), 147);
    }
}

