/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.task.domain.Task;

@Entity(name="TaskComment")
@Table(name="TASK_COMMENTS")
@NamedQueries(value={@NamedQuery(name="Comment.countCommentOfTask", query="SELECT count(c) FROM TaskComment c WHERE c.task.id = :taskId AND c.parentComment IS NULL"), @NamedQuery(name="Comment.countCommentsWithSubs", query="SELECT count(c) FROM TaskComment c WHERE c.task.id = :taskId"), @NamedQuery(name="Comment.findCommentsOfTask", query="SELECT c FROM TaskComment c WHERE c.task.id = :taskId AND c.parentComment IS NULL ORDER BY c.createdTime DESC"), @NamedQuery(name="Comment.findSubCommentsOfComments", query="SELECT c FROM TaskComment c WHERE c.parentComment IN (:comments) ORDER BY c.createdTime ASC"), @NamedQuery(name="Comment.deleteCommentOfTask", query="DELETE FROM TaskComment c WHERE c.task.id = :taskId"), @NamedQuery(name="Comment.findMentionedUsersOfTask", query="SELECT m FROM TaskComment c INNER JOIN c.mentionedUsers m WHERE c.task.id = :taskId")})
public class Comment {
    @Id
    @SequenceGenerator(name="SEQ_TASK_COMMENTS_COMMENT_ID", sequenceName="SEQ_TASK_COMMENTS_COMMENT_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TASK_COMMENTS_COMMENT_ID")
    @Column(name="COMMENT_ID")
    private Long id;
    @Column(name="AUTHOR")
    private String author;
    @Column(name="CMT")
    private String comment;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_TIME")
    private Date createdTime;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TASK_ID")
    private Task task;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="PARENT_COMMENT_ID")
    private Comment parentComment;
    @OneToMany(mappedBy="parentComment", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<Comment> subComments = new ArrayList<Comment>();
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="TASK_COMMENT_MENTIONED_USERS", joinColumns={@JoinColumn(name="COMMENT_ID")})
    @Column(name="MENTIONED_USERS")
    private Set<String> mentionedUsers = new HashSet<String>();

    public void setParentComment(Comment parentComment) {
        this.parentComment = parentComment;
        this.parentComment.addSubComment(this);
    }

    public void addSubComment(Comment subComment) {
        this.subComments.add(subComment);
    }

    public Comment clone() {
        Comment c = new Comment();
        c.setId(this.getId());
        c.setAuthor(this.getAuthor());
        c.setComment(this.getComment());
        c.setMentionedUsers(new HashSet<String>(this.getMentionedUsers()));
        c.setCreatedTime(this.getCreatedTime());
        c.setTask(this.getTask().clone());
        return c;
    }

    @Generated
    public Comment() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Task getTask() {
        return this.task;
    }

    @Generated
    public Comment getParentComment() {
        return this.parentComment;
    }

    @Generated
    public List<Comment> getSubComments() {
        return this.subComments;
    }

    @Generated
    public Set<String> getMentionedUsers() {
        return this.mentionedUsers;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setTask(Task task) {
        this.task = task;
    }

    @Generated
    public void setSubComments(List<Comment> subComments) {
        this.subComments = subComments;
    }

    @Generated
    public void setMentionedUsers(Set<String> mentionedUsers) {
        this.mentionedUsers = mentionedUsers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Date this$createdTime = this.getCreatedTime();
        Date other$createdTime = other.getCreatedTime();
        return !(this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Comment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Date $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Comment(id=" + this.getId() + ", author=" + this.getAuthor() + ", comment=" + this.getComment() + ", createdTime=" + String.valueOf(this.getCreatedTime()) + ", task=" + String.valueOf(this.getTask()) + ", parentComment=" + String.valueOf(this.getParentComment()) + ", subComments=" + String.valueOf(this.getSubComments()) + ", mentionedUsers=" + String.valueOf(this.getMentionedUsers()) + ")";
    }
}

