/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.model.CommentModel;
import org.exoplatform.task.model.User;
import org.exoplatform.task.rest.model.SpaceEntity;
import org.exoplatform.task.util.UserUtil;

public class TaskEntity {
    long Id;
    Date dueDate;
    private StatusDto status;
    private TaskDto task;
    private boolean readOnly;
    private boolean isWatched;
    private String breadcumbs;
    private User assignee;
    private User createdBy;
    private List<User> coworker;
    private List<User> watcher;
    private int numberCoworkers;
    private long commentCount;
    private List<CommentModel> comments;
    private User currentUser;
    private SpaceEntity space;
    private List<LabelDto> labels = new ArrayList<LabelDto>();
    private boolean completed;

    public TaskEntity() {
    }

    public TaskEntity(TaskDto task, long commentCount) {
        this.Id = task.getId();
        this.dueDate = task.getDueDate();
        this.status = task.getStatus();
        this.task = task;
        this.completed = task.isCompleted();
        this.commentCount = commentCount;
        this.assignee = UserUtil.getUser(task.getAssignee());
        this.createdBy = UserUtil.getUser(task.getCreatedBy());
        if (task.getCoworker() != null) {
            this.coworker = task.getCoworker().stream().map(UserUtil::getUser).collect(Collectors.toList());
        }
        if (task.getWatcher() != null) {
            this.watcher = task.getWatcher().stream().map(UserUtil::getUser).collect(Collectors.toList());
        }
    }

    @Generated
    public long getId() {
        return this.Id;
    }

    @Generated
    public Date getDueDate() {
        return this.dueDate;
    }

    @Generated
    public StatusDto getStatus() {
        return this.status;
    }

    @Generated
    public TaskDto getTask() {
        return this.task;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public boolean isWatched() {
        return this.isWatched;
    }

    @Generated
    public String getBreadcumbs() {
        return this.breadcumbs;
    }

    @Generated
    public User getAssignee() {
        return this.assignee;
    }

    @Generated
    public User getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public List<User> getCoworker() {
        return this.coworker;
    }

    @Generated
    public List<User> getWatcher() {
        return this.watcher;
    }

    @Generated
    public int getNumberCoworkers() {
        return this.numberCoworkers;
    }

    @Generated
    public long getCommentCount() {
        return this.commentCount;
    }

    @Generated
    public List<CommentModel> getComments() {
        return this.comments;
    }

    @Generated
    public User getCurrentUser() {
        return this.currentUser;
    }

    @Generated
    public SpaceEntity getSpace() {
        return this.space;
    }

    @Generated
    public List<LabelDto> getLabels() {
        return this.labels;
    }

    @Generated
    public boolean isCompleted() {
        return this.completed;
    }

    @Generated
    public void setId(long Id2) {
        this.Id = Id2;
    }

    @Generated
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setStatus(StatusDto status) {
        this.status = status;
    }

    @Generated
    public void setTask(TaskDto task) {
        this.task = task;
    }

    @Generated
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public void setWatched(boolean isWatched) {
        this.isWatched = isWatched;
    }

    @Generated
    public void setBreadcumbs(String breadcumbs) {
        this.breadcumbs = breadcumbs;
    }

    @Generated
    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    @Generated
    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCoworker(List<User> coworker) {
        this.coworker = coworker;
    }

    @Generated
    public void setWatcher(List<User> watcher) {
        this.watcher = watcher;
    }

    @Generated
    public void setNumberCoworkers(int numberCoworkers) {
        this.numberCoworkers = numberCoworkers;
    }

    @Generated
    public void setCommentCount(long commentCount) {
        this.commentCount = commentCount;
    }

    @Generated
    public void setComments(List<CommentModel> comments) {
        this.comments = comments;
    }

    @Generated
    public void setCurrentUser(User currentUser) {
        this.currentUser = currentUser;
    }

    @Generated
    public void setSpace(SpaceEntity space) {
        this.space = space;
    }

    @Generated
    public void setLabels(List<LabelDto> labels) {
        this.labels = labels;
    }

    @Generated
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskEntity)) {
            return false;
        }
        TaskEntity other = (TaskEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        if (this.isWatched() != other.isWatched()) {
            return false;
        }
        if (this.getNumberCoworkers() != other.getNumberCoworkers()) {
            return false;
        }
        if (this.getCommentCount() != other.getCommentCount()) {
            return false;
        }
        if (this.isCompleted() != other.isCompleted()) {
            return false;
        }
        Date this$dueDate = this.getDueDate();
        Date other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        StatusDto this$status = this.getStatus();
        StatusDto other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        TaskDto this$task = this.getTask();
        TaskDto other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        String this$breadcumbs = this.getBreadcumbs();
        String other$breadcumbs = other.getBreadcumbs();
        if (this$breadcumbs == null ? other$breadcumbs != null : !this$breadcumbs.equals(other$breadcumbs)) {
            return false;
        }
        User this$assignee = this.getAssignee();
        User other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        User this$createdBy = this.getCreatedBy();
        User other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        List<User> this$coworker = this.getCoworker();
        List<User> other$coworker = other.getCoworker();
        if (this$coworker == null ? other$coworker != null : !((Object)this$coworker).equals(other$coworker)) {
            return false;
        }
        List<User> this$watcher = this.getWatcher();
        List<User> other$watcher = other.getWatcher();
        if (this$watcher == null ? other$watcher != null : !((Object)this$watcher).equals(other$watcher)) {
            return false;
        }
        List<CommentModel> this$comments = this.getComments();
        List<CommentModel> other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !((Object)this$comments).equals(other$comments)) {
            return false;
        }
        User this$currentUser = this.getCurrentUser();
        User other$currentUser = other.getCurrentUser();
        if (this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser)) {
            return false;
        }
        SpaceEntity this$space = this.getSpace();
        SpaceEntity other$space = other.getSpace();
        if (this$space == null ? other$space != null : !((Object)this$space).equals(other$space)) {
            return false;
        }
        List<LabelDto> this$labels = this.getLabels();
        List<LabelDto> other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $Id = this.getId();
        result = result * 59 + (int)($Id >>> 32 ^ $Id);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        result = result * 59 + (this.isWatched() ? 79 : 97);
        result = result * 59 + this.getNumberCoworkers();
        long $commentCount = this.getCommentCount();
        result = result * 59 + (int)($commentCount >>> 32 ^ $commentCount);
        result = result * 59 + (this.isCompleted() ? 79 : 97);
        Date $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        StatusDto $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        TaskDto $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        String $breadcumbs = this.getBreadcumbs();
        result = result * 59 + ($breadcumbs == null ? 43 : $breadcumbs.hashCode());
        User $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        User $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        List<User> $coworker = this.getCoworker();
        result = result * 59 + ($coworker == null ? 43 : ((Object)$coworker).hashCode());
        List<User> $watcher = this.getWatcher();
        result = result * 59 + ($watcher == null ? 43 : ((Object)$watcher).hashCode());
        List<CommentModel> $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : ((Object)$comments).hashCode());
        User $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        SpaceEntity $space = this.getSpace();
        result = result * 59 + ($space == null ? 43 : ((Object)$space).hashCode());
        List<LabelDto> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskEntity(Id=" + this.getId() + ", dueDate=" + String.valueOf(this.getDueDate()) + ", status=" + String.valueOf(this.getStatus()) + ", task=" + String.valueOf(this.getTask()) + ", readOnly=" + this.isReadOnly() + ", isWatched=" + this.isWatched() + ", breadcumbs=" + this.getBreadcumbs() + ", assignee=" + String.valueOf(this.getAssignee()) + ", createdBy=" + String.valueOf(this.getCreatedBy()) + ", coworker=" + String.valueOf(this.getCoworker()) + ", watcher=" + String.valueOf(this.getWatcher()) + ", numberCoworkers=" + this.getNumberCoworkers() + ", commentCount=" + this.getCommentCount() + ", comments=" + String.valueOf(this.getComments()) + ", currentUser=" + String.valueOf(this.getCurrentUser()) + ", space=" + String.valueOf(this.getSpace()) + ", labels=" + String.valueOf(this.getLabels()) + ", completed=" + this.isCompleted() + ")";
    }
}

